/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.pci.ids.model;

import java.util.Collections;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import org.glavo.pci.ids.internal.ArgumentValidator;
import org.glavo.pci.ids.model.Device;

public final class Vendor
implements Comparable<Vendor> {
    private final int id;
    private final String name;
    private final String comment;
    private final SortedMap<Integer, Device> devices;

    public Vendor(int id, String name, String comment) {
        ArgumentValidator.requireUnsignedShort(id, "Vendor ID");
        ArgumentValidator.requireNonBlank(name, "Vendor name");
        this.id = id;
        this.name = name;
        this.comment = comment;
        this.devices = new TreeMap<Integer, Device>();
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getComment() {
        return this.comment;
    }

    public void addDevice(Device device) {
        ArgumentValidator.requireNonNull(device, "Vendor device");
        this.devices.put(device.getId(), device);
    }

    public SortedMap<Integer, Device> getDevices() {
        return Collections.unmodifiableSortedMap(this.devices);
    }

    @Override
    public int compareTo(Vendor t) {
        return Integer.compare(this.id, t.id);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Vendor)) {
            return false;
        }
        Vendor vendor = (Vendor)o;
        return Objects.equals(this.id, vendor.id) && Objects.equals(this.name, vendor.name);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name);
    }

    public String toString() {
        return String.format("Vendor[id=%04x, name='%s']", this.id, this.name);
    }
}

