/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.setting;

import java.io.IOException;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import javafx.beans.InvalidationListener;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.logging.Logger;

public final class ProxyManager {
    private static final ProxySelector NO_PROXY = new SimpleProxySelector(Proxy.NO_PROXY);
    private static final ProxySelector SYSTEM_DEFAULT = Lang.requireNonNullElse(ProxySelector.getDefault(), NO_PROXY);

    private static ProxySelector getProxySelector() {
        if (ConfigHolder.config().hasProxy()) {
            Proxy.Type proxyType = ConfigHolder.config().getProxyType();
            String host = ConfigHolder.config().getProxyHost();
            int port = ConfigHolder.config().getProxyPort();
            if (proxyType == Proxy.Type.DIRECT || StringUtils.isBlank(host)) {
                return NO_PROXY;
            }
            if (port < 0 || port > 65535) {
                Logger.LOG.warning("Illegal proxy port: " + port);
                return NO_PROXY;
            }
            return new SimpleProxySelector(new Proxy(proxyType, new InetSocketAddress(host, port)));
        }
        return SYSTEM_DEFAULT;
    }

    private static Authenticator getAuthenticator() {
        if (ConfigHolder.config().hasProxy() && ConfigHolder.config().hasProxyAuth()) {
            String username = ConfigHolder.config().getProxyUser();
            String password = ConfigHolder.config().getProxyPass();
            if (username != null || password != null) {
                return new SimpleAuthenticator(Lang.requireNonNullElse(username, ""), Lang.requireNonNullElse(password, "").toCharArray());
            }
            return null;
        }
        return null;
    }

    static void init() {
        ProxySelector.setDefault(ProxyManager.getProxySelector());
        InvalidationListener updateProxySelector = observable -> ProxySelector.setDefault(ProxyManager.getProxySelector());
        ConfigHolder.config().proxyTypeProperty().addListener(updateProxySelector);
        ConfigHolder.config().proxyHostProperty().addListener(updateProxySelector);
        ConfigHolder.config().proxyPortProperty().addListener(updateProxySelector);
        ConfigHolder.config().hasProxyProperty().addListener(updateProxySelector);
        Authenticator.setDefault(ProxyManager.getAuthenticator());
        InvalidationListener updateAuthenticator = observable -> Authenticator.setDefault(ProxyManager.getAuthenticator());
        ConfigHolder.config().hasProxyProperty().addListener(updateAuthenticator);
        ConfigHolder.config().hasProxyAuthProperty().addListener(updateAuthenticator);
        ConfigHolder.config().proxyUserProperty().addListener(updateAuthenticator);
        ConfigHolder.config().proxyPassProperty().addListener(updateAuthenticator);
    }

    private ProxyManager() {
    }

    private static final class SimpleAuthenticator
    extends Authenticator {
        private final String username;
        private final char[] password;

        private SimpleAuthenticator(String username, char[] password) {
            this.username = username;
            this.password = password;
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return this.getRequestorType() == Authenticator.RequestorType.PROXY ? new PasswordAuthentication(this.username, this.password) : null;
        }
    }

    private static final class SimpleProxySelector
    extends ProxySelector {
        private final List<Proxy> proxies;

        SimpleProxySelector(Proxy proxy) {
            this(Collections.singletonList(proxy));
        }

        SimpleProxySelector(List<Proxy> proxies) {
            this.proxies = proxies;
        }

        @Override
        public List<Proxy> select(URI uri) {
            if (uri == null) {
                throw new IllegalArgumentException("URI can't be null.");
            }
            return this.proxies;
        }

        @Override
        public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
            if (uri == null || sa == null || ioe == null) {
                throw new IllegalArgumentException("Arguments can't be null.");
            }
        }

        public String toString() {
            return "SimpleProxySelector" + this.proxies;
        }
    }
}

