/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.util.Duration;
import org.jackhuang.hmcl.util.logging.Logger;

public class TooltipInstaller {
    public static final TooltipInstaller INSTALLER;

    TooltipInstaller() {
    }

    public void installTooltip(Node node, Duration showDelay, Duration showDuration, Duration hideDelay, Tooltip tooltip) {
        Tooltip.install((Node)node, (Tooltip)tooltip);
    }

    static {
        TooltipInstaller installer = null;
        try {
            installer = new NewInstaller();
        }
        catch (Throwable e) {
            try {
                installer = new OldInstaller();
            }
            catch (Throwable e2) {
                e2.addSuppressed(e);
                Logger.LOG.warning("Failed to initialize TooltipInstaller", e2);
            }
        }
        INSTALLER = installer != null ? installer : new TooltipInstaller();
    }

    private static final class NewInstaller
    extends TooltipInstaller {
        private static final MethodHandle setTooltipShowDelay;
        private static final MethodHandle setTooltipShowDuration;
        private static final MethodHandle setTooltipHideDelay;

        private NewInstaller() {
        }

        @Override
        public void installTooltip(Node node, Duration showDelay, Duration showDuration, Duration hideDelay, Tooltip tooltip) {
            try {
                setTooltipShowDelay.invokeExact(tooltip, showDelay);
                setTooltipShowDuration.invokeExact(tooltip, showDuration);
                setTooltipHideDelay.invokeExact(tooltip, hideDelay);
            }
            catch (Throwable e) {
                Logger.LOG.warning("Failed to set tooltip show delay", e);
            }
            Tooltip.install((Node)node, (Tooltip)tooltip);
        }

        static {
            try {
                MethodHandles.Lookup lookup = MethodHandles.publicLookup();
                MethodType methodType = MethodType.methodType(Void.TYPE, Duration.class);
                setTooltipShowDelay = lookup.findVirtual(Tooltip.class, "setShowDelay", methodType);
                setTooltipShowDuration = lookup.findVirtual(Tooltip.class, "setShowDuration", methodType);
                setTooltipHideDelay = lookup.findVirtual(Tooltip.class, "setHideDelay", methodType);
            }
            catch (Exception e) {
                throw new ExceptionInInitializerError(e);
            }
        }
    }

    private static final class OldInstaller
    extends TooltipInstaller {
        private static final Constructor<?> createTooltipBehavior;
        private static final Method installTooltipBehavior;

        private OldInstaller() {
        }

        @Override
        public void installTooltip(Node node, Duration showDelay, Duration showDuration, Duration hideDelay, Tooltip tooltip) {
            try {
                Object behavior = createTooltipBehavior.newInstance(showDelay, showDuration, hideDelay, false);
                installTooltipBehavior.invoke(behavior, node, tooltip);
            }
            catch (ReflectiveOperationException e) {
                Logger.LOG.warning("Failed to set tooltip show delay", e);
                Tooltip.install((Node)node, (Tooltip)tooltip);
            }
        }

        static {
            try {
                Class<?> behaviorClass = Class.forName("javafx.scene.control.Tooltip$TooltipBehavior");
                createTooltipBehavior = behaviorClass.getDeclaredConstructor(Duration.class, Duration.class, Duration.class, Boolean.TYPE);
                createTooltipBehavior.setAccessible(true);
                installTooltipBehavior = behaviorClass.getDeclaredMethod("install", Node.class, Tooltip.class);
                installTooltipBehavior.setAccessible(true);
            }
            catch (Exception e) {
                throw new ExceptionInInitializerError(e);
            }
        }
    }
}

