/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.decorator;

import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Node;
import org.jackhuang.hmcl.ui.animation.AnimationProducer;
import org.jackhuang.hmcl.ui.construct.Navigator;
import org.jackhuang.hmcl.ui.decorator.DecoratorTransitionPage;

public abstract class DecoratorNavigatorPage
extends DecoratorTransitionPage {
    protected final Navigator navigator = new Navigator();

    public DecoratorNavigatorPage() {
        this.navigator.setOnNavigating((EventHandler<Navigator.NavigationEvent>)((EventHandler)this::onNavigating));
        this.navigator.setOnNavigated((EventHandler<Navigator.NavigationEvent>)((EventHandler)this::onNavigated));
        this.backableProperty().bind((ObservableValue)this.navigator.backableProperty());
    }

    @Override
    protected void navigate(Node page, AnimationProducer animationProducer) {
        this.navigator.navigate(page, animationProducer);
    }

    @Override
    public boolean back() {
        if (this.navigator.canGoBack()) {
            this.navigator.close();
            return false;
        }
        return true;
    }

    private void onNavigating(Navigator.NavigationEvent event) {
        if (event.getSource() != this.navigator) {
            return;
        }
        this.onNavigating(event.getNode());
    }

    private void onNavigated(Navigator.NavigationEvent event) {
        if (event.getSource() != this.navigator) {
            return;
        }
        this.onNavigated(event.getNode());
    }
}

