/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXPopup;
import com.jfoenix.controls.JFXRadioButton;
import javafx.beans.property.Property;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.paint.Paint;
import org.jackhuang.hmcl.setting.Theme;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.construct.IconedMenuItem;
import org.jackhuang.hmcl.ui.construct.MenuSeparator;
import org.jackhuang.hmcl.ui.construct.PopupMenu;
import org.jackhuang.hmcl.ui.construct.RipplerContainer;
import org.jackhuang.hmcl.ui.versions.GameItem;
import org.jackhuang.hmcl.ui.versions.GameListItem;
import org.jackhuang.hmcl.util.Lazy;
import org.jackhuang.hmcl.util.i18n.I18n;

public class GameListItemSkin
extends SkinBase<GameListItem> {
    private static GameListItem currentSkinnable;
    private static Lazy<JFXPopup> popup;

    public GameListItemSkin(GameListItem skinnable) {
        super((Control)skinnable);
        BorderPane root = new BorderPane();
        JFXRadioButton chkSelected = new JFXRadioButton();
        BorderPane.setAlignment((Node)chkSelected, (Pos)Pos.CENTER);
        chkSelected.setUserData((Object)skinnable);
        chkSelected.selectedProperty().bindBidirectional((Property)skinnable.selectedProperty());
        chkSelected.setToggleGroup(skinnable.getToggleGroup());
        root.setLeft((Node)chkSelected);
        GameItem gameItem = new GameItem(skinnable.getProfile(), skinnable.getVersion());
        gameItem.setMouseTransparent(true);
        root.setCenter((Node)gameItem);
        HBox right = new HBox();
        right.setAlignment(Pos.CENTER_RIGHT);
        if (skinnable.canUpdate()) {
            JFXButton btnUpgrade = new JFXButton();
            btnUpgrade.setOnAction(e -> skinnable.update());
            btnUpgrade.getStyleClass().add((Object)"toggle-icon4");
            btnUpgrade.setGraphic(FXUtils.limitingSize(SVG.UPDATE.createIcon((Paint)Theme.blackFill(), 24.0), 24.0, 24.0));
            FXUtils.installFastTooltip((Node)btnUpgrade, I18n.i18n("version.update"));
            right.getChildren().add((Object)btnUpgrade);
        }
        JFXButton btnLaunch = new JFXButton();
        btnLaunch.setOnAction(e -> skinnable.launch());
        btnLaunch.getStyleClass().add((Object)"toggle-icon4");
        BorderPane.setAlignment((Node)btnLaunch, (Pos)Pos.CENTER);
        btnLaunch.setGraphic(FXUtils.limitingSize(SVG.ROCKET_LAUNCH.createIcon((Paint)Theme.blackFill(), 24.0), 24.0, 24.0));
        FXUtils.installFastTooltip((Node)btnLaunch, I18n.i18n("version.launch.test"));
        right.getChildren().add((Object)btnLaunch);
        JFXButton btnManage = new JFXButton();
        btnManage.setOnAction(e -> {
            currentSkinnable = skinnable;
            popup.get().show((Node)root, JFXPopup.PopupVPosition.TOP, JFXPopup.PopupHPosition.RIGHT, 0.0, root.getHeight());
        });
        btnManage.getStyleClass().add((Object)"toggle-icon4");
        BorderPane.setAlignment((Node)btnManage, (Pos)Pos.CENTER);
        btnManage.setGraphic(FXUtils.limitingSize(SVG.MORE_VERT.createIcon((Paint)Theme.blackFill(), 24.0), 24.0, 24.0));
        FXUtils.installFastTooltip((Node)btnManage, I18n.i18n("settings.game.management"));
        right.getChildren().add((Object)btnManage);
        root.setRight((Node)right);
        root.getStyleClass().add((Object)"md-list-cell");
        root.setStyle("-fx-padding: 8 8 8 0");
        RipplerContainer container = new RipplerContainer((Node)root);
        this.getChildren().setAll((Object[])new Node[]{container});
        root.setCursor(Cursor.HAND);
        container.setOnMouseClicked(e -> {
            if (e.getButton() == MouseButton.PRIMARY) {
                if (e.getClickCount() == 1) {
                    skinnable.modifyGameSettings();
                }
            } else if (e.getButton() == MouseButton.SECONDARY) {
                currentSkinnable = skinnable;
                popup.get().show((Node)root, JFXPopup.PopupVPosition.TOP, JFXPopup.PopupHPosition.LEFT, e.getX(), e.getY());
            }
        });
    }

    static {
        popup = new Lazy<JFXPopup>(() -> {
            PopupMenu menu = new PopupMenu();
            JFXPopup popup = new JFXPopup((Region)menu);
            menu.getContent().setAll((Object[])new Node[]{new IconedMenuItem(SVG.ROCKET_LAUNCH, I18n.i18n("version.launch.test"), () -> currentSkinnable.launch(), popup), new IconedMenuItem(SVG.SCRIPT, I18n.i18n("version.launch_script"), () -> currentSkinnable.generateLaunchScript(), popup), new MenuSeparator(), new IconedMenuItem(SVG.SETTINGS, I18n.i18n("version.manage.manage"), () -> currentSkinnable.modifyGameSettings(), popup), new MenuSeparator(), new IconedMenuItem(SVG.EDIT, I18n.i18n("version.manage.rename"), () -> currentSkinnable.rename(), popup), new IconedMenuItem(SVG.FOLDER_COPY, I18n.i18n("version.manage.duplicate"), () -> currentSkinnable.duplicate(), popup), new IconedMenuItem(SVG.DELETE, I18n.i18n("version.manage.remove"), () -> currentSkinnable.remove(), popup), new IconedMenuItem(SVG.OUTPUT, I18n.i18n("modpack.export"), () -> currentSkinnable.export(), popup), new MenuSeparator(), new IconedMenuItem(SVG.FOLDER_OPEN, I18n.i18n("folder.game"), () -> currentSkinnable.browse(), popup)});
            return popup;
        });
    }
}

