/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.platform.windows;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jackhuang.hmcl.util.KeyValuePairUtils;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.platform.NativeUtils;
import org.jackhuang.hmcl.util.platform.OperatingSystem;
import org.jackhuang.hmcl.util.platform.SystemUtils;
import org.jackhuang.hmcl.util.platform.hardware.CentralProcessor;
import org.jackhuang.hmcl.util.platform.hardware.GraphicsCard;
import org.jackhuang.hmcl.util.platform.hardware.HardwareDetector;
import org.jackhuang.hmcl.util.platform.hardware.HardwareVendor;
import org.jackhuang.hmcl.util.platform.windows.Kernel32;
import org.jackhuang.hmcl.util.platform.windows.WinTypes;
import org.jackhuang.hmcl.util.platform.windows.WindowsCPUDetector;
import org.jetbrains.annotations.Nullable;

public final class WindowsHardwareDetector
extends HardwareDetector {
    @Override
    @Nullable
    public CentralProcessor detectCentralProcessor() {
        if (!OperatingSystem.isWindows7OrLater()) {
            return null;
        }
        return WindowsCPUDetector.detect();
    }

    @Override
    public List<GraphicsCard> detectGraphicsCards() {
        if (!OperatingSystem.isWindows7OrLater()) {
            return null;
        }
        try {
            String getCimInstance = OperatingSystem.SYSTEM_VERSION.startsWith("6.1") ? "Get-WmiObject" : "Get-CimInstance";
            List videoControllers = SystemUtils.run(Arrays.asList("powershell.exe", "-NoProfile", "-Command", String.join((CharSequence)" | ", getCimInstance + " -Class Win32_VideoController", "Select-Object Name,AdapterCompatibility,DriverVersion,AdapterDACType", "Format-List")), inputStream -> KeyValuePairUtils.loadList(new BufferedReader(new InputStreamReader((InputStream)inputStream, OperatingSystem.NATIVE_CHARSET))));
            ArrayList<GraphicsCard> cards = new ArrayList<GraphicsCard>(videoControllers.size());
            for (Map videoController : videoControllers) {
                String name = (String)videoController.get("Name");
                String adapterCompatibility = (String)videoController.get("AdapterCompatibility");
                String driverVersion = (String)videoController.get("DriverVersion");
                String adapterDACType = (String)videoController.get("AdapterDACType");
                if (!StringUtils.isNotBlank(name)) continue;
                cards.add(GraphicsCard.builder().setName(GraphicsCard.cleanName(name)).setVendor(HardwareVendor.of(adapterCompatibility)).setDriverVersion(driverVersion).setType(StringUtils.isBlank(adapterDACType) || "Internal".equalsIgnoreCase(adapterDACType) || "InternalDAC".equalsIgnoreCase(adapterDACType) ? GraphicsCard.Type.Integrated : GraphicsCard.Type.Discrete).build());
            }
            return cards;
        }
        catch (Throwable e) {
            Logger.LOG.warning("Failed to get graphics card info", e);
            return Collections.emptyList();
        }
    }

    @Override
    public long getTotalMemorySize() {
        Kernel32 kernel32;
        if (NativeUtils.USE_JNA && (kernel32 = Kernel32.INSTANCE) != null) {
            WinTypes.MEMORYSTATUSEX status = new WinTypes.MEMORYSTATUSEX();
            if (kernel32.GlobalMemoryStatusEx(status)) {
                return status.ullTotalPhys;
            }
            Logger.LOG.warning("Failed to get memory status: " + kernel32.GetLastError());
        }
        return super.getTotalMemorySize();
    }

    @Override
    public long getFreeMemorySize() {
        Kernel32 kernel32;
        if (NativeUtils.USE_JNA && (kernel32 = Kernel32.INSTANCE) != null) {
            WinTypes.MEMORYSTATUSEX status = new WinTypes.MEMORYSTATUSEX();
            if (kernel32.GlobalMemoryStatusEx(status)) {
                return status.ullAvailPhys;
            }
            Logger.LOG.warning("Failed to get memory status: " + kernel32.GetLastError());
        }
        return super.getFreeMemorySize();
    }
}

