/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXCheckBox;
import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXListView;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.jackhuang.hmcl.game.GameDumpGenerator;
import org.jackhuang.hmcl.game.LauncherHelper;
import org.jackhuang.hmcl.game.Log;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.setting.StyleSheets;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.SpinnerPane;
import org.jackhuang.hmcl.util.CircularArrayList;
import org.jackhuang.hmcl.util.Holder;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Log4jLevel;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.platform.ManagedProcess;
import org.jackhuang.hmcl.util.platform.SystemUtils;

public final class LogWindow
extends Stage {
    private static final Log4jLevel[] LEVELS = new Log4jLevel[]{Log4jLevel.FATAL, Log4jLevel.ERROR, Log4jLevel.WARN, Log4jLevel.INFO, Log4jLevel.DEBUG};
    private final CircularArrayList<Log> logs;
    private final Map<Log4jLevel, SimpleIntegerProperty> levelCountMap = new EnumMap<Log4jLevel, SimpleIntegerProperty>(Log4jLevel.class);
    private final Map<Log4jLevel, SimpleBooleanProperty> levelShownMap = new EnumMap<Log4jLevel, SimpleBooleanProperty>(Log4jLevel.class);
    private final LogWindowImpl impl;
    private final ManagedProcess gameProcess;

    public LogWindow(ManagedProcess gameProcess) {
        this(gameProcess, new CircularArrayList<Log>());
    }

    public LogWindow(ManagedProcess gameProcess, CircularArrayList<Log> logs) {
        for (Log4jLevel level : Log4jLevel.values()) {
            this.levelCountMap.put(level, new SimpleIntegerProperty());
            this.levelShownMap.put(level, new SimpleBooleanProperty(true));
        }
        this.logs = logs;
        this.impl = new LogWindowImpl();
        this.setScene(new Scene((Parent)this.impl, 800.0, 480.0));
        StyleSheets.init(this.getScene());
        this.setTitle(I18n.i18n("logwindow.title"));
        FXUtils.setIcon(this);
        for (SimpleBooleanProperty property : this.levelShownMap.values()) {
            property.addListener(o -> this.shakeLogs());
        }
        this.gameProcess = gameProcess;
    }

    public void logLine(Log log) {
        Log4jLevel level = log.getLevel();
        this.logs.add(log);
        if (this.levelShownMap.get((Object)level).get()) {
            this.impl.listView.getItems().add((Object)log);
        }
        SimpleIntegerProperty property = this.levelCountMap.get((Object)log.getLevel());
        property.set(property.get() + 1);
        this.checkLogCount();
        this.autoScroll();
    }

    public void logLines(List<Log> logs) {
        for (Log log : logs) {
            Log4jLevel level = log.getLevel();
            this.logs.add(log);
            if (this.levelShownMap.get((Object)level).get()) {
                this.impl.listView.getItems().add((Object)log);
            }
            SimpleIntegerProperty property = this.levelCountMap.get((Object)log.getLevel());
            property.set(property.get() + 1);
        }
        this.checkLogCount();
        this.autoScroll();
    }

    private void shakeLogs() {
        this.impl.listView.getItems().setAll((Collection)this.logs.stream().filter(log -> this.levelShownMap.get((Object)log.getLevel()).get()).collect(Collectors.toList()));
        this.autoScroll();
    }

    private void checkLogCount() {
        int nRemove = this.logs.size() - Log.getLogLines();
        if (nRemove <= 0) {
            return;
        }
        ObservableList items = this.impl.listView.getItems();
        int itemsSize = items.size();
        int count = 0;
        for (int i = 0; i < nRemove; ++i) {
            Log removedLog = this.logs.removeFirst();
            if (itemsSize <= count || items.get(count) != removedLog) continue;
            ++count;
        }
        items.remove(0, count);
    }

    private void autoScroll() {
        if (!this.impl.listView.getItems().isEmpty() && this.impl.autoScroll.get()) {
            this.impl.listView.scrollTo(this.impl.listView.getItems().size() - 1);
        }
    }

    private final class LogWindowImpl
    extends Control {
        private final ListView<Log> listView = new JFXListView<Log>();
        private final BooleanProperty autoScroll = new SimpleBooleanProperty();
        private final StringProperty[] buttonText = new StringProperty[LogWindow.access$200().length];
        private final BooleanProperty[] showLevel = new BooleanProperty[LogWindow.access$200().length];
        private final JFXComboBox<Integer> cboLines = new JFXComboBox();

        LogWindowImpl() {
            int i;
            this.getStyleClass().add((Object)"log-window");
            this.listView.setItems(FXCollections.observableList(new CircularArrayList(LogWindow.this.logs.size())));
            for (i = 0; i < LEVELS.length; ++i) {
                this.buttonText[i] = new SimpleStringProperty();
                this.showLevel[i] = new SimpleBooleanProperty(true);
            }
            this.cboLines.getItems().setAll((Object[])new Integer[]{500, 2000, 5000, 10000});
            this.cboLines.setValue(Log.getLogLines());
            this.cboLines.getSelectionModel().selectedItemProperty().addListener((a, b, newValue) -> ConfigHolder.config().setLogLines((Integer)newValue));
            for (i = 0; i < LEVELS.length; ++i) {
                this.buttonText[i].bind((ObservableValue)Bindings.concat((Object[])new Object[]{LogWindow.this.levelCountMap.get((Object)LEVELS[i]), " " + LEVELS[i].name().toLowerCase(Locale.ROOT) + "s"}));
                ((SimpleBooleanProperty)LogWindow.this.levelShownMap.get((Object)LEVELS[i])).bind((ObservableValue)this.showLevel[i]);
            }
        }

        private void onTerminateGame() {
            LauncherHelper.stopManagedProcesses();
        }

        private void onClear() {
            ((LogWindow)LogWindow.this).impl.listView.getItems().clear();
            LogWindow.this.logs.clear();
        }

        private void onExportLogs() {
            Lang.thread(() -> {
                Path logFile = Paths.get("minecraft-exported-logs-" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH-mm-ss")) + ".log", new String[0]).toAbsolutePath();
                try {
                    Files.write(logFile, (Iterable<? extends CharSequence>)LogWindow.this.logs.stream().map(Log::getLog).collect(Collectors.toList()), new OpenOption[0]);
                }
                catch (IOException e) {
                    Logger.LOG.warning("Failed to export logs", e);
                    return;
                }
                Platform.runLater(() -> {
                    Alert alert = new Alert(Alert.AlertType.INFORMATION, I18n.i18n("settings.launcher.launcher_log.export.success", logFile), new ButtonType[0]);
                    alert.setTitle(I18n.i18n("settings.launcher.launcher_log.export"));
                    alert.showAndWait();
                });
                FXUtils.showFileInExplorer(logFile);
            });
        }

        private void onExportDump(SpinnerPane pane) {
            assert (SystemUtils.supportJVMAttachment());
            pane.setLoading(true);
            Lang.thread(() -> {
                Path dumpFile = Paths.get("minecraft-exported-jstack-dump-" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH-mm-ss")) + ".log", new String[0]).toAbsolutePath();
                try {
                    if (LogWindow.this.gameProcess.isRunning()) {
                        GameDumpGenerator.writeDumpTo(LogWindow.this.gameProcess.getPID(), dumpFile);
                        FXUtils.showFileInExplorer(dumpFile);
                    }
                }
                catch (Throwable e) {
                    Logger.LOG.warning("Failed to create minecraft jstack dump", e);
                    Platform.runLater(() -> {
                        Alert alert = new Alert(Alert.AlertType.ERROR, I18n.i18n("logwindow.export_dump"), new ButtonType[0]);
                        alert.setTitle(I18n.i18n("message.error"));
                        alert.showAndWait();
                    });
                }
                Platform.runLater(() -> pane.setLoading(false));
            });
        }

        protected Skin<?> createDefaultSkin() {
            return new LogWindowSkin(this);
        }
    }

    private static final class LogWindowSkin
    extends SkinBase<LogWindowImpl> {
        private static final PseudoClass EMPTY = PseudoClass.getPseudoClass((String)"empty");
        private static final PseudoClass FATAL = PseudoClass.getPseudoClass((String)"fatal");
        private static final PseudoClass ERROR = PseudoClass.getPseudoClass((String)"error");
        private static final PseudoClass WARN = PseudoClass.getPseudoClass((String)"warn");
        private static final PseudoClass INFO = PseudoClass.getPseudoClass((String)"info");
        private static final PseudoClass DEBUG = PseudoClass.getPseudoClass((String)"debug");
        private static final PseudoClass TRACE = PseudoClass.getPseudoClass((String)"trace");
        private static final PseudoClass SELECTED = PseudoClass.getPseudoClass((String)"selected");
        private final Set<ListCell<Log>> selected = new HashSet<ListCell<Log>>();

        LogWindowSkin(LogWindowImpl control) {
            super((Control)control);
            VBox vbox = new VBox(3.0);
            vbox.setPadding(new Insets(3.0, 0.0, 3.0, 0.0));
            vbox.setStyle("-fx-background-color: white");
            this.getChildren().setAll((Object[])new Node[]{vbox});
            BorderPane borderPane = new BorderPane();
            borderPane.setPadding(new Insets(0.0, 3.0, 0.0, 3.0));
            HBox hBox = new HBox(3.0);
            hBox.setPadding(new Insets(0.0, 0.0, 0.0, 4.0));
            hBox.setAlignment(Pos.CENTER_LEFT);
            Label label = new Label(I18n.i18n("logwindow.show_lines"));
            hBox.getChildren().setAll((Object[])new Node[]{label, control.cboLines});
            borderPane.setLeft((Node)hBox);
            hBox = new HBox(3.0);
            for (int i = 0; i < LEVELS.length; ++i) {
                ToggleButton button = new ToggleButton();
                button.setStyle("-fx-background-color: " + FXUtils.toWeb(LEVELS[i].getColor()) + ";");
                button.getStyleClass().add((Object)"log-toggle");
                button.textProperty().bind((ObservableValue)control.buttonText[i]);
                button.setSelected(true);
                control.showLevel[i].bind((ObservableValue)button.selectedProperty());
                hBox.getChildren().add((Object)button);
            }
            borderPane.setRight((Node)hBox);
            vbox.getChildren().add((Object)borderPane);
            final ListView listView = control.listView;
            listView.getItems().addListener(observable -> {
                if (!listView.getItems().isEmpty() && control.autoScroll.get()) {
                    listView.scrollTo(listView.getItems().size() - 1);
                }
            });
            listView.setStyle("-fx-font-family: \"" + Lang.requireNonNullElse(ConfigHolder.config().getFontFamily(), FXUtils.DEFAULT_MONOSPACE_FONT) + "\"; -fx-font-size: " + ConfigHolder.config().getFontSize() + "px;");
            final Holder lastCell = new Holder();
            listView.setCellFactory(x -> new ListCell<Log>(){
                {
                    this.getStyleClass().add((Object)"log-window-list-cell");
                    Region clippedContainer = (Region)listView.lookup(".clipped-container");
                    if (clippedContainer != null) {
                        this.maxWidthProperty().bind((ObservableValue)clippedContainer.widthProperty());
                        this.prefWidthProperty().bind((ObservableValue)clippedContainer.widthProperty());
                    }
                    this.setPadding(new Insets(2.0));
                    this.setWrapText(true);
                    this.setGraphic(null);
                    this.setOnMouseClicked(event -> {
                        if (event.getButton() != MouseButton.PRIMARY) {
                            return;
                        }
                        if (!event.isControlDown()) {
                            for (ListCell logListCell : selected) {
                                if (logListCell == this) continue;
                                logListCell.pseudoClassStateChanged(SELECTED, false);
                                if (logListCell.getItem() == null) continue;
                                ((Log)logListCell.getItem()).setSelected(false);
                            }
                            selected.clear();
                        }
                        selected.add(this);
                        this.pseudoClassStateChanged(SELECTED, true);
                        if (this.getItem() != null) {
                            ((Log)this.getItem()).setSelected(true);
                        }
                        event.consume();
                    });
                }

                protected void updateItem(Log item, boolean empty) {
                    super.updateItem((Object)item, empty);
                    if (this == lastCell.value && !this.isVisible()) {
                        return;
                    }
                    lastCell.value = this;
                    this.pseudoClassStateChanged(EMPTY, empty);
                    this.pseudoClassStateChanged(FATAL, !empty && item.getLevel() == Log4jLevel.FATAL);
                    this.pseudoClassStateChanged(ERROR, !empty && item.getLevel() == Log4jLevel.ERROR);
                    this.pseudoClassStateChanged(WARN, !empty && item.getLevel() == Log4jLevel.WARN);
                    this.pseudoClassStateChanged(INFO, !empty && item.getLevel() == Log4jLevel.INFO);
                    this.pseudoClassStateChanged(DEBUG, !empty && item.getLevel() == Log4jLevel.DEBUG);
                    this.pseudoClassStateChanged(TRACE, !empty && item.getLevel() == Log4jLevel.TRACE);
                    this.pseudoClassStateChanged(SELECTED, !empty && item.isSelected());
                    if (empty) {
                        this.setText(null);
                    } else {
                        this.setText(item.getLog());
                    }
                }
            });
            listView.setOnKeyPressed(event -> {
                if (event.isControlDown() && event.getCode() == KeyCode.C) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (Log item : listView.getItems()) {
                        if (item == null || !item.isSelected()) continue;
                        if (item.getLog() != null) {
                            stringBuilder.append(item.getLog());
                        }
                        stringBuilder.append('\n');
                    }
                    FXUtils.copyText(stringBuilder.toString());
                }
            });
            VBox.setVgrow((Node)listView, (Priority)Priority.ALWAYS);
            vbox.getChildren().add((Object)listView);
            BorderPane bottom = new BorderPane();
            hBox = new HBox(3.0);
            bottom.setRight((Node)hBox);
            hBox.setAlignment(Pos.CENTER_RIGHT);
            hBox.setPadding(new Insets(0.0, 3.0, 0.0, 3.0));
            JFXCheckBox autoScrollCheckBox = new JFXCheckBox(I18n.i18n("logwindow.autoscroll"));
            autoScrollCheckBox.setSelected(true);
            control.autoScroll.bind((ObservableValue)autoScrollCheckBox.selectedProperty());
            JFXButton exportLogsButton = new JFXButton(I18n.i18n("button.export"));
            exportLogsButton.setOnAction(e -> ((LogWindowImpl)this.getSkinnable()).onExportLogs());
            JFXButton terminateButton = new JFXButton(I18n.i18n("logwindow.terminate_game"));
            terminateButton.setOnAction(e -> ((LogWindowImpl)this.getSkinnable()).onTerminateGame());
            SpinnerPane exportDumpPane = new SpinnerPane();
            JFXButton exportDumpButton = new JFXButton(I18n.i18n("logwindow.export_dump"));
            if (SystemUtils.supportJVMAttachment()) {
                exportDumpButton.setOnAction(e -> ((LogWindowImpl)this.getSkinnable()).onExportDump(exportDumpPane));
            } else {
                exportDumpButton.setTooltip(new Tooltip(I18n.i18n("logwindow.export_dump.no_dependency")));
                exportDumpButton.setDisable(true);
            }
            exportDumpPane.setContent((Node)exportDumpButton);
            JFXButton clearButton = new JFXButton(I18n.i18n("button.clear"));
            clearButton.setOnAction(e -> ((LogWindowImpl)this.getSkinnable()).onClear());
            hBox.getChildren().setAll((Object[])new Node[]{autoScrollCheckBox, exportLogsButton, terminateButton, exportDumpPane, clearButton});
            vbox.getChildren().add((Object)bottom);
        }
    }
}

