/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXListView;
import com.jfoenix.controls.JFXTextField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.mod.RemoteMod;
import org.jackhuang.hmcl.mod.RemoteModRepository;
import org.jackhuang.hmcl.mod.modrinth.ModrinthRemoteModRepository;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.WeakListenerHolder;
import org.jackhuang.hmcl.ui.construct.FloatListCell;
import org.jackhuang.hmcl.ui.construct.SpinnerPane;
import org.jackhuang.hmcl.ui.construct.TwoLineListItem;
import org.jackhuang.hmcl.ui.decorator.DecoratorPage;
import org.jackhuang.hmcl.ui.versions.DownloadPage;
import org.jackhuang.hmcl.ui.versions.ModTranslations;
import org.jackhuang.hmcl.ui.versions.VersionPage;
import org.jackhuang.hmcl.util.AggregatedObservableList;
import org.jackhuang.hmcl.util.Holder;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.javafx.BindingMapping;
import org.jackhuang.hmcl.util.javafx.ExtendedProperties;
import org.jackhuang.hmcl.util.versioning.GameVersionNumber;

public class DownloadListPage
extends Control
implements DecoratorPage,
VersionPage.VersionLoadable {
    protected final ReadOnlyObjectWrapper<DecoratorPage.State> state = new ReadOnlyObjectWrapper();
    private final BooleanProperty loading = new SimpleBooleanProperty(false);
    private final BooleanProperty failed = new SimpleBooleanProperty(false);
    private final boolean versionSelection;
    private final ObjectProperty<Profile.ProfileVersion> version = new SimpleObjectProperty();
    private final IntegerProperty pageOffset = new SimpleIntegerProperty(0);
    private final IntegerProperty pageCount = new SimpleIntegerProperty(-1);
    private final ListProperty<RemoteMod> items = new SimpleListProperty((Object)this, "items", FXCollections.observableArrayList());
    private final ObservableList<String> versions = FXCollections.observableArrayList();
    private final StringProperty selectedVersion = new SimpleStringProperty();
    private final DownloadPage.DownloadCallback callback;
    private boolean searchInitialized = false;
    protected final BooleanProperty supportChinese = new SimpleBooleanProperty();
    private final ObservableList<Node> actions = FXCollections.observableArrayList();
    protected final ListProperty<String> downloadSources = new SimpleListProperty((Object)this, "downloadSources", FXCollections.observableArrayList());
    protected final StringProperty downloadSource = new SimpleStringProperty();
    private final WeakListenerHolder listenerHolder = new WeakListenerHolder();
    private int searchID = 0;
    protected RemoteModRepository repository;
    private Runnable retrySearch;

    public DownloadListPage(RemoteModRepository repository) {
        this(repository, null, false);
    }

    public DownloadListPage(RemoteModRepository repository, DownloadPage.DownloadCallback callback, boolean versionSelection) {
        this.repository = repository;
        this.callback = callback;
        this.versionSelection = versionSelection;
    }

    public ObservableList<Node> getActions() {
        return this.actions;
    }

    @Override
    public void loadVersion(Profile profile, String version) {
        this.version.set((Object)new Profile.ProfileVersion(profile, version));
        this.setLoading(false);
        this.setFailed(false);
        if (!this.searchInitialized) {
            this.searchInitialized = true;
            this.search("", null, 0, "", RemoteModRepository.SortType.POPULARITY);
        }
        if (this.versionSelection) {
            this.versions.setAll((Collection)profile.getRepository().getDisplayVersions().map(Version::getId).collect(Collectors.toList()));
            this.selectedVersion.set((Object)profile.getSelectedVersion());
        }
    }

    public boolean isFailed() {
        return this.failed.get();
    }

    public BooleanProperty failedProperty() {
        return this.failed;
    }

    public void setFailed(boolean failed) {
        this.failed.set(failed);
    }

    public boolean isLoading() {
        return this.loading.get();
    }

    public BooleanProperty loadingProperty() {
        return this.loading;
    }

    public void setLoading(boolean loading) {
        this.loading.set(loading);
    }

    public void selectVersion(String versionID) {
        FXUtils.runInFX(() -> this.selectedVersion.set((Object)versionID));
    }

    private void search(String userGameVersion, RemoteModRepository.Category category, int pageOffset, String searchFilter, RemoteModRepository.SortType sort) {
        this.retrySearch = null;
        this.setLoading(true);
        this.setFailed(false);
        int currentSearchID = ++this.searchID;
        Task.supplyAsync(() -> {
            Profile.ProfileVersion version = (Profile.ProfileVersion)this.version.get();
            if (StringUtils.isBlank(version.getVersion())) {
                return userGameVersion;
            }
            return StringUtils.isNotBlank(version.getVersion()) ? version.getProfile().getRepository().getGameVersion(version.getVersion()).orElse("") : "";
        }).thenApplyAsync(gameVersion -> this.repository.search((String)gameVersion, category, pageOffset, 50, searchFilter, sort, RemoteModRepository.SortOrder.DESC)).whenComplete(Schedulers.javafx(), (result, exception) -> {
            if (this.searchID != currentSearchID) {
                return;
            }
            this.setLoading(false);
            if (exception == null) {
                this.items.setAll((Collection)result.getResults().collect(Collectors.toList()));
                this.pageCount.set(result.getTotalPages());
                this.failed.set(false);
            } else {
                this.failed.set(true);
                this.pageCount.set(-1);
                this.retrySearch = () -> this.search(userGameVersion, category, pageOffset, searchFilter, sort);
            }
        }).executor(true);
    }

    protected String getLocalizedCategory(String category) {
        return this.repository instanceof ModrinthRemoteModRepository ? I18n.i18n("modrinth.category." + category) : I18n.i18n("curse.category." + category);
    }

    private String getLocalizedCategoryIndent(ModDownloadListPageSkin.CategoryIndented category) {
        return StringUtils.repeats(' ', category.indent * 4) + (category.getCategory() == null ? I18n.i18n("curse.category.0") : this.getLocalizedCategory(category.getCategory().getId()));
    }

    protected String getLocalizedOfficialPage() {
        if (this.repository instanceof ModrinthRemoteModRepository) {
            return I18n.i18n("mods.modrinth");
        }
        return I18n.i18n("mods.curseforge");
    }

    protected Profile.ProfileVersion getProfileVersion() {
        if (this.versionSelection) {
            return new Profile.ProfileVersion(((Profile.ProfileVersion)this.version.get()).getProfile(), (String)this.selectedVersion.get());
        }
        return (Profile.ProfileVersion)this.version.get();
    }

    @Override
    public ReadOnlyObjectProperty<DecoratorPage.State> stateProperty() {
        return this.state.getReadOnlyProperty();
    }

    protected Skin<?> createDefaultSkin() {
        return new ModDownloadListPageSkin(this);
    }

    private static class ModDownloadListPageSkin
    extends SkinBase<DownloadListPage> {
        private final JFXListView<RemoteMod> listView = new JFXListView();

        protected ModDownloadListPageSkin(DownloadListPage control) {
            super((Control)control);
            BorderPane pane = new BorderPane();
            GridPane searchPane = new GridPane();
            pane.setTop((Node)searchPane);
            searchPane.getStyleClass().addAll((Object[])new String[]{"card"});
            BorderPane.setMargin((Node)searchPane, (Insets)new Insets(10.0, 10.0, 0.0, 10.0));
            ColumnConstraints nameColumn = new ColumnConstraints();
            nameColumn.setMinWidth(Double.NEGATIVE_INFINITY);
            ColumnConstraints column1 = new ColumnConstraints();
            column1.setHgrow(Priority.ALWAYS);
            ColumnConstraints column2 = new ColumnConstraints();
            column2.setHgrow(Priority.ALWAYS);
            searchPane.getColumnConstraints().setAll((Object[])new ColumnConstraints[]{nameColumn, column1, nameColumn, column2});
            searchPane.setHgap(16.0);
            searchPane.setVgap(10.0);
            int rowIndex = 0;
            if (control.versionSelection || !control.downloadSources.isEmpty()) {
                searchPane.addRow(rowIndex, new Node[0]);
                int columns = 0;
                JFXComboBox lastNode = null;
                if (control.versionSelection) {
                    JFXComboBox versionsComboBox = new JFXComboBox();
                    versionsComboBox.setMaxWidth(Double.MAX_VALUE);
                    Bindings.bindContent((List)versionsComboBox.getItems(), (ObservableList)control.versions);
                    ExtendedProperties.selectedItemPropertyFor(versionsComboBox).bindBidirectional((Property)control.selectedVersion);
                    searchPane.add((Node)new Label(I18n.i18n("version")), columns++, rowIndex);
                    lastNode = versionsComboBox;
                    searchPane.add(lastNode, columns++, rowIndex);
                }
                if (control.downloadSources.getSize() > 1) {
                    JFXComboBox downloadSourceComboBox = new JFXComboBox();
                    downloadSourceComboBox.setMaxWidth(Double.MAX_VALUE);
                    downloadSourceComboBox.getItems().setAll((Collection)control.downloadSources.get());
                    downloadSourceComboBox.setConverter(FXUtils.stringConverter(I18n::i18n));
                    ExtendedProperties.selectedItemPropertyFor(downloadSourceComboBox).bindBidirectional((Property)control.downloadSource);
                    searchPane.add((Node)new Label(I18n.i18n("settings.launcher.download_source")), columns++, rowIndex);
                    lastNode = downloadSourceComboBox;
                    searchPane.add(lastNode, columns++, rowIndex);
                }
                if (columns == 2) {
                    GridPane.setColumnSpan(lastNode, (Integer)3);
                }
                ++rowIndex;
            }
            JFXTextField nameField = new JFXTextField();
            nameField.setPromptText(((DownloadListPage)this.getSkinnable()).supportChinese.get() ? I18n.i18n("search.hint.chinese") : I18n.i18n("search.hint.english"));
            if (((DownloadListPage)this.getSkinnable()).supportChinese.get()) {
                FXUtils.installFastTooltip((Node)nameField, I18n.i18n("search.hint.chinese"));
            } else {
                FXUtils.installFastTooltip((Node)nameField, I18n.i18n("search.hint.english"));
            }
            JFXComboBox gameVersionField = new JFXComboBox();
            gameVersionField.setMaxWidth(Double.MAX_VALUE);
            gameVersionField.setEditable(true);
            gameVersionField.getItems().setAll((Object[])GameVersionNumber.getDefaultGameVersions());
            Label lblGameVersion = new Label(I18n.i18n("world.game_version"));
            searchPane.addRow(rowIndex++, new Node[]{new Label(I18n.i18n("mods.name")), nameField, lblGameVersion, gameVersionField});
            BindingMapping<?, Boolean> hasVersion = BindingMapping.of(((DownloadListPage)this.getSkinnable()).version).map(version -> version.getVersion() == null);
            lblGameVersion.managedProperty().bind(hasVersion);
            lblGameVersion.visibleProperty().bind(hasVersion);
            gameVersionField.managedProperty().bind(hasVersion);
            gameVersionField.visibleProperty().bind(hasVersion);
            FXUtils.installFastTooltip(gameVersionField, I18n.i18n("search.enter"));
            FXUtils.onChangeAndOperate(((DownloadListPage)this.getSkinnable()).version, version -> {
                if (StringUtils.isNotBlank(version.getVersion())) {
                    GridPane.setColumnSpan((Node)nameField, (Integer)3);
                } else {
                    GridPane.setColumnSpan((Node)nameField, (Integer)1);
                }
            });
            StackPane categoryStackPane = new StackPane();
            JFXComboBox categoryComboBox = new JFXComboBox();
            categoryComboBox.getItems().setAll((Object[])new CategoryIndented[]{CategoryIndented.ALL});
            categoryStackPane.getChildren().setAll((Object[])new Node[]{categoryComboBox});
            categoryComboBox.prefWidthProperty().bind((ObservableValue)categoryStackPane.widthProperty());
            categoryComboBox.getStyleClass().add((Object)"fit-width");
            categoryComboBox.setPromptText(I18n.i18n("mods.category"));
            categoryComboBox.getSelectionModel().select(0);
            categoryComboBox.setConverter(FXUtils.stringConverter(arg_0 -> ModDownloadListPageSkin.lambda$new$2((DownloadListPage)this.getSkinnable(), arg_0)));
            FXUtils.onChangeAndOperate(((DownloadListPage)this.getSkinnable()).downloadSource, downloadSource -> {
                categoryComboBox.getItems().setAll((Object[])new CategoryIndented[]{CategoryIndented.ALL});
                categoryComboBox.getSelectionModel().select(0);
                Task.supplyAsync(() -> ((DownloadListPage)this.getSkinnable()).repository.getCategories()).thenAcceptAsync(Schedulers.javafx(), categories -> {
                    if (!Objects.equals(((DownloadListPage)this.getSkinnable()).downloadSource.get(), downloadSource)) {
                        return;
                    }
                    ArrayList<CategoryIndented> result = new ArrayList<CategoryIndented>();
                    result.add(CategoryIndented.ALL);
                    for (RemoteModRepository.Category category : Lang.toIterable(categories)) {
                        ModDownloadListPageSkin.resolveCategory(category, 0, result);
                    }
                    categoryComboBox.getItems().setAll(result);
                    categoryComboBox.getSelectionModel().select(0);
                }).start();
            });
            StackPane sortStackPane = new StackPane();
            JFXComboBox sortComboBox = new JFXComboBox();
            sortStackPane.getChildren().setAll((Object[])new Node[]{sortComboBox});
            sortComboBox.prefWidthProperty().bind((ObservableValue)sortStackPane.widthProperty());
            sortComboBox.getStyleClass().add((Object)"fit-width");
            sortComboBox.setConverter(FXUtils.stringConverter(sortType -> I18n.i18n("curse.sort." + sortType.name().toLowerCase(Locale.ROOT))));
            sortComboBox.getItems().setAll((Object[])RemoteModRepository.SortType.values());
            sortComboBox.getSelectionModel().select(0);
            searchPane.addRow(rowIndex++, new Node[]{new Label(I18n.i18n("mods.category")), categoryStackPane, new Label(I18n.i18n("search.sort")), sortStackPane});
            SimpleIntegerProperty filterID = new SimpleIntegerProperty((Object)this, "Filter ID", 0);
            SimpleIntegerProperty currentFilterID = new SimpleIntegerProperty((Object)this, "Current Filter ID", -1);
            EventHandler searchAction = arg_0 -> this.lambda$new$7((IntegerProperty)currentFilterID, (IntegerProperty)filterID, control, gameVersionField, categoryComboBox, nameField, sortComboBox, arg_0);
            control.listenerHolder.add(FXUtils.observeWeak(() -> ModDownloadListPageSkin.lambda$new$8((IntegerProperty)filterID), new Observable[]{control.downloadSource, gameVersionField.getSelectionModel().selectedItemProperty(), categoryComboBox.getSelectionModel().selectedItemProperty(), nameField.textProperty(), sortComboBox.getSelectionModel().selectedItemProperty()}));
            HBox actionsBox = new HBox(8.0);
            GridPane.setColumnSpan((Node)actionsBox, (Integer)4);
            actionsBox.setAlignment(Pos.CENTER);
            AggregatedObservableList actions = new AggregatedObservableList();
            Holder changeButton = new Holder();
            JFXButton firstPageButton = FXUtils.newBorderButton(I18n.i18n("search.first_page"));
            firstPageButton.setOnAction(event -> {
                control.pageOffset.set(0);
                searchAction.handle(event);
                ((Runnable)changeButton.value).run();
            });
            JFXButton previousPageButton = FXUtils.newBorderButton(I18n.i18n("search.previous_page"));
            previousPageButton.setOnAction(event -> {
                int pageOffset = control.pageOffset.get();
                if (pageOffset > 0) {
                    control.pageOffset.set(pageOffset - 1);
                    searchAction.handle(event);
                    ((Runnable)changeButton.value).run();
                }
            });
            Label pageDescription = new Label();
            pageDescription.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
                int pageCount = control.pageCount.get();
                return I18n.i18n("search.page_n", control.pageOffset.get() + 1, pageCount == -1 ? "-" : String.valueOf(pageCount));
            }, (Observable[])new Observable[]{control.pageOffset, control.pageCount}));
            JFXButton nextPageButton = FXUtils.newBorderButton(I18n.i18n("search.next_page"));
            nextPageButton.setOnAction(event -> {
                int nv = control.pageOffset.get() + 1;
                if (nv < control.pageCount.get()) {
                    control.pageOffset.set(nv);
                    searchAction.handle(event);
                    ((Runnable)changeButton.value).run();
                }
            });
            JFXButton lastPageButton = FXUtils.newBorderButton(I18n.i18n("search.last_page"));
            lastPageButton.setOnAction(event -> {
                control.pageOffset.set(control.pageCount.get() - 1);
                searchAction.handle(event);
                ((Runnable)changeButton.value).run();
            });
            firstPageButton.setDisable(true);
            previousPageButton.setDisable(true);
            lastPageButton.setDisable(true);
            nextPageButton.setDisable(true);
            changeButton.value = () -> {
                int pageOffset = control.pageOffset.get();
                int pageCount = control.pageCount.get();
                boolean disableAll = pageCount >= -1 && pageCount <= 1;
                boolean disablePrevious = disableAll || pageOffset == 0;
                firstPageButton.setDisable(disablePrevious);
                previousPageButton.setDisable(disablePrevious);
                boolean disableNext = disableAll || pageOffset == pageCount - 1;
                nextPageButton.setDisable(disableNext);
                lastPageButton.setDisable(disableNext);
                this.listView.scrollTo(0);
            };
            FXUtils.onChange(control.pageCount, pageCountN -> {
                int pageCount = pageCountN.intValue();
                if (pageCount != -1 && control.pageOffset.get() + 1 >= pageCount) {
                    control.pageOffset.set(pageCount - 1);
                }
                ((Runnable)changeButton.value).run();
            });
            FXUtils.onChange(control.pageOffset, pageOffsetN -> ((Runnable)changeButton.value).run());
            Pane placeholder = new Pane();
            HBox.setHgrow((Node)placeholder, (Priority)Priority.SOMETIMES);
            JFXButton searchButton = FXUtils.newRaisedButton(I18n.i18n("search"));
            searchButton.setOnAction(searchAction);
            actions.appendList(FXCollections.observableArrayList((Object[])new Node[]{firstPageButton, previousPageButton, pageDescription, nextPageButton, lastPageButton, placeholder, searchButton}));
            actions.appendList(control.actions);
            Bindings.bindContent((List)actionsBox.getChildren(), actions.getAggregatedList());
            searchPane.addRow(rowIndex++, new Node[]{actionsBox});
            FXUtils.onChange(control.downloadSource, v -> searchAction.handle(null));
            nameField.setOnAction(searchAction);
            gameVersionField.setOnAction(searchAction);
            categoryComboBox.setOnAction(searchAction);
            sortComboBox.setOnAction(searchAction);
            SpinnerPane spinnerPane = new SpinnerPane();
            pane.setCenter((Node)spinnerPane);
            spinnerPane.loadingProperty().bind((ObservableValue)((DownloadListPage)this.getSkinnable()).loadingProperty());
            spinnerPane.failedReasonProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
                if (((DownloadListPage)this.getSkinnable()).isFailed()) {
                    return I18n.i18n("download.failed.refresh");
                }
                return null;
            }, (Observable[])new Observable[]{((DownloadListPage)this.getSkinnable()).failedProperty()}));
            spinnerPane.setOnFailedAction((EventHandler<Event>)((EventHandler)e -> {
                if (((DownloadListPage)this.getSkinnable()).retrySearch != null) {
                    ((DownloadListPage)this.getSkinnable()).retrySearch.run();
                }
            }));
            spinnerPane.setContent((Node)this.listView);
            Bindings.bindContent((List)this.listView.getItems(), (ObservableList)((DownloadListPage)this.getSkinnable()).items);
            FXUtils.onClicked(this.listView, () -> {
                if (this.listView.getSelectionModel().getSelectedIndex() < 0) {
                    return;
                }
                RemoteMod selectedItem = (RemoteMod)this.listView.getSelectionModel().getSelectedItem();
                Controllers.navigate((Node)new DownloadPage((DownloadListPage)this.getSkinnable(), selectedItem, ((DownloadListPage)this.getSkinnable()).getProfileVersion(), ((DownloadListPage)this.getSkinnable()).callback));
            });
            FXUtils.ignoreEvent(this.listView, KeyEvent.KEY_PRESSED, e -> e.getCode() == KeyCode.ESCAPE);
            this.listView.setCellFactory(x -> new FloatListCell<RemoteMod>(this.listView){
                TwoLineListItem content;
                ImageView imageView;
                {
                    super(listView);
                    this.content = new TwoLineListItem();
                    this.imageView = new ImageView();
                    HBox container = new HBox(8.0);
                    container.setAlignment(Pos.CENTER_LEFT);
                    this.pane.getChildren().add((Object)container);
                    container.getChildren().setAll((Object[])new Node[]{FXUtils.limitingSize((Node)this.imageView, 40.0, 40.0), this.content});
                    HBox.setHgrow((Node)this.content, (Priority)Priority.ALWAYS);
                }

                @Override
                protected void updateControl(RemoteMod dataItem, boolean empty) {
                    if (empty) {
                        return;
                    }
                    ModTranslations.Mod mod = ModTranslations.getTranslationsByRepositoryType(((DownloadListPage)this.getSkinnable()).repository.getType()).getModByCurseForgeId(dataItem.getSlug());
                    this.content.setTitle(mod != null && I18n.isUseChinese() ? mod.getDisplayName() : dataItem.getTitle());
                    this.content.setSubtitle(dataItem.getDescription());
                    this.content.getTags().setAll((Collection)dataItem.getCategories().stream().map(category -> ((DownloadListPage)this.getSkinnable()).getLocalizedCategory((String)category)).collect(Collectors.toList()));
                    if (StringUtils.isNotBlank(dataItem.getIconUrl())) {
                        this.imageView.imageProperty().bind(FXUtils.newRemoteImage(dataItem.getIconUrl(), 40, 40, true, true));
                    }
                }
            });
            this.getChildren().setAll((Object[])new Node[]{pane});
        }

        private static void resolveCategory(RemoteModRepository.Category category, int indent, List<CategoryIndented> result) {
            result.add(new CategoryIndented(indent, category));
            for (RemoteModRepository.Category subcategory : category.getSubcategories()) {
                ModDownloadListPageSkin.resolveCategory(subcategory, indent + 1, result);
            }
        }

        private static /* synthetic */ void lambda$new$8(IntegerProperty filterID) {
            filterID.set(filterID.get() + 1);
        }

        private /* synthetic */ void lambda$new$7(IntegerProperty currentFilterID, IntegerProperty filterID, DownloadListPage control, JFXComboBox gameVersionField, JFXComboBox categoryComboBox, JFXTextField nameField, JFXComboBox sortComboBox, ActionEvent e) {
            if (currentFilterID.get() != -1 && currentFilterID.get() != filterID.get()) {
                control.pageOffset.set(0);
            }
            currentFilterID.set(filterID.get());
            int pageOffset = control.pageOffset.get();
            ((DownloadListPage)this.getSkinnable()).search((String)gameVersionField.getSelectionModel().getSelectedItem(), Optional.ofNullable((CategoryIndented)categoryComboBox.getSelectionModel().getSelectedItem()).map(CategoryIndented::getCategory).orElse(null), pageOffset == -1 ? 0 : pageOffset, nameField.getText(), (RemoteModRepository.SortType)((Object)sortComboBox.getSelectionModel().getSelectedItem()));
        }

        private static /* synthetic */ String lambda$new$2(DownloadListPage rec$, CategoryIndented x$0) {
            return rec$.getLocalizedCategoryIndent(x$0);
        }

        private static class CategoryIndented {
            private static final CategoryIndented ALL = new CategoryIndented(0, null);
            private final int indent;
            private final RemoteModRepository.Category category;

            public CategoryIndented(int indent, RemoteModRepository.Category category) {
                this.indent = indent;
                this.category = category;
            }

            public int getIndent() {
                return this.indent;
            }

            public RemoteModRepository.Category getCategory() {
                return this.category;
            }
        }
    }
}

