/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.platform;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jackhuang.hmcl.java.JavaRuntime;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.function.ExceptionalFunction;
import org.jackhuang.hmcl.util.io.IOUtils;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.platform.ManagedProcess;
import org.jackhuang.hmcl.util.platform.OperatingSystem;
import org.jetbrains.annotations.Nullable;

public final class SystemUtils {
    private SystemUtils() {
    }

    @Nullable
    public static Path which(String command) {
        String path = System.getenv("PATH");
        if (path == null) {
            return null;
        }
        try {
            for (String item : path.split(File.pathSeparator)) {
                try {
                    Path program = Paths.get(item, command);
                    if (!Files.isExecutable(program)) continue;
                    return program.toRealPath(new LinkOption[0]);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static int callExternalProcess(String ... command) throws IOException, InterruptedException {
        return SystemUtils.callExternalProcess(Arrays.asList(command));
    }

    public static int callExternalProcess(List<String> command) throws IOException, InterruptedException {
        return SystemUtils.callExternalProcess(new ProcessBuilder(command));
    }

    public static int callExternalProcess(ProcessBuilder processBuilder) throws IOException, InterruptedException {
        ManagedProcess managedProcess = new ManagedProcess(processBuilder);
        managedProcess.pumpInputStream(SystemUtils::onLogLine);
        managedProcess.pumpErrorStream(SystemUtils::onLogLine);
        return managedProcess.getProcess().waitFor();
    }

    public static String run(String ... command) throws Exception {
        return SystemUtils.run(Arrays.asList(command), (InputStream inputStream) -> IOUtils.readFullyAsString(inputStream, OperatingSystem.NATIVE_CHARSET));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T run(List<String> command, ExceptionalFunction<InputStream, T, ?> convert) throws Exception {
        File nul = OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS ? new File("NUL") : new File("/dev/null");
        Process process = new ProcessBuilder(command).redirectInput(nul).redirectError(nul).start();
        try {
            InputStream inputStream = process.getInputStream();
            CompletableFuture<Object> future = CompletableFuture.supplyAsync(Lang.wrap(() -> convert.apply(inputStream)), Schedulers.io());
            if (!process.waitFor(15L, TimeUnit.SECONDS)) {
                throw new TimeoutException();
            }
            if (process.exitValue() != 0) {
                throw new IOException("Bad exit code: " + process.exitValue());
            }
            Object object = future.get();
            return (T)object;
        }
        finally {
            if (process.isAlive()) {
                process.destroy();
            }
        }
    }

    public static boolean supportJVMAttachment() {
        return JavaRuntime.CURRENT_VERSION >= 9 && Thread.currentThread().getContextClassLoader().getResource("com/sun/tools/attach/VirtualMachine.class") != null;
    }

    private static void onLogLine(String log) {
        Logger.LOG.info(log);
    }
}

