#! format: off
#! source: https://github.com/alexeyovchinnikov/SIAN-Julia

import AbstractAlgebra

function HIV_with_weights(; np=AbstractAlgebra, internal_ordering=:degrevlex, k=np.QQ)
    R, (x₄_8,x₄_7,x₃_7,x₄_6,x₂_6,x₃_6,x₁_6,x₄_5,x₂_5,x₃_5,x₁_5,x₄_4,x₂_4,x₃_4,x₁_4,x₄_3,x₂_3,x₃_3,x₁_3,x₄_2,x₂_2,x₃_2,x₁_2,x₄_1,x₂_1,x₃_1,x₁_1,x₄_0,x₂_0,x₃_0,x₁_0,z_aux,β_0,d_0,s_0,q₁_0,k₁_0,μ₁_0,q₂_0,μ₂_0,c_0,k₂_0) = np.polynomial_ring(k, [:x₄_8,:x₄_7,:x₃_7,:x₄_6,:x₂_6,:x₃_6,:x₁_6,:x₄_5,:x₂_5,:x₃_5,:x₁_5,:x₄_4,:x₂_4,:x₃_4,:x₁_4,:x₄_3,:x₂_3,:x₃_3,:x₁_3,:x₄_2,:x₂_2,:x₃_2,:x₁_2,:x₄_1,:x₂_1,:x₃_1,:x₁_1,:x₄_0,:x₂_0,:x₃_0,:x₁_0,:z_aux,:β_0,:d_0,:s_0,:q₁_0,:k₁_0,:μ₁_0,:q₂_0,:μ₂_0,:c_0,:k₂_0], internal_ordering=internal_ordering)
    sys = [
    		-x₁_0 + 3209453206249887172,
		x₄_0*x₁_0*β_0 + x₁_0*d_0 + x₁_1 - s_0,
		-x₄_0 + 2292637086454259742,
		-x₃_0^2*k₂_0 + x₄_0*c_0 + x₄_1,
		-x₁_1 - 1650234517251411727353622463752018436601219872295050969,
		x₁_1*x₄_0*β_0 + x₄_1*x₁_0*β_0 + x₁_1*d_0 + x₁_2,
		-x₄_1 - 2178892581807290317248583349133786427,
		-x₃_1^2*k₂_0 + x₄_1*c_0 + x₄_2,
		-x₂_0^3*k₁_0 - x₄_0*x₁_0*β_0*q₂_0 + x₃_0^2*μ₂_0 + x₃_1^2,
		-x₁_2 + 848516487676114923082357354011043760857364821520324535829525095342108732470938259286140707,
		2*x₄_1*x₁_1*β_0 + x₁_2*x₄_0*β_0 + x₄_2*x₁_0*β_0 + x₁_2*d_0 + x₁_3,
		-x₄_2 + 13740405880190201152756638516020117882824216121987382958373316380454658386140921971969349128,
		-x₃_2^2*k₂_0 + x₄_2*c_0 + x₄_3,
		-x₂_1^3*k₁_0 - x₁_1*x₄_0*β_0*q₂_0 - x₄_1*x₁_0*β_0*q₂_0 + x₃_1^2*μ₂_0 + x₃_2^2,
		-x₄_0*x₁_0*β_0*q₁_0 + x₂_0^3*k₁_0 + x₂_0^3*μ₁_0 + x₂_1^3,
		-x₁_3 - 10326599889019526865806370287732114086706886986191519706637398777292676008581228776990246671962243126422159069514984866422879491,
		3*x₁_2*x₄_1*β_0 + 3*x₄_2*x₁_1*β_0 + x₁_3*x₄_0*β_0 + x₄_3*x₁_0*β_0 + x₁_3*d_0 + x₁_4,
		-x₄_3 - 7065032766447093914986511197207450130965845367861370330255442949801317575856190868278660947182143547358971458234377824227513093,
		-x₃_3^2*k₂_0 + x₄_3*c_0 + x₄_4,
		-x₂_2^3*k₁_0 - 2*x₄_1*x₁_1*β_0*q₂_0 - x₁_2*x₄_0*β_0*q₂_0 - x₄_2*x₁_0*β_0*q₂_0 + x₃_2^2*μ₂_0 + x₃_3^2,
		-x₁_1*x₄_0*β_0*q₁_0 - x₄_1*x₁_0*β_0*q₁_0 + x₂_1^3*k₁_0 + x₂_1^3*μ₁_0 + x₂_2^3,
		-x₄_4 + 85982732971666668129237425912450129463117280783070451580565177221400306355421045623966891739626474289943720629871739590661022817366140811479645746547014894505416252,
		-x₃_4^2*k₂_0 + x₄_4*c_0 + x₄_5,
		-x₂_3^3*k₁_0 - 3*x₁_2*x₄_1*β_0*q₂_0 - 3*x₄_2*x₁_1*β_0*q₂_0 - x₁_3*x₄_0*β_0*q₂_0 - x₄_3*x₁_0*β_0*q₂_0 + x₃_3^2*μ₂_0 + x₃_4^2,
		-2*x₄_1*x₁_1*β_0*q₁_0 - x₁_2*x₄_0*β_0*q₁_0 - x₄_2*x₁_0*β_0*q₁_0 + x₂_2^3*k₁_0 + x₂_2^3*μ₁_0 + x₂_3^3,
		-x₄_5 - 213581298116205122600334618314176726314970264299222971369671803960080069856608228687093368514445633691428562739542380459597700351075923302245015377670487120073011878788446803814666594685637132658721891,
		-x₃_5^2*k₂_0 + x₄_5*c_0 + x₄_6,
		-x₂_4^3*k₁_0 - 6*x₄_2*x₁_2*β_0*q₂_0 - 4*x₁_3*x₄_1*β_0*q₂_0 - 4*x₄_3*x₁_1*β_0*q₂_0 - x₁_4*x₄_0*β_0*q₂_0 - x₄_4*x₁_0*β_0*q₂_0 + x₃_4^2*μ₂_0 + x₃_5^2,
		-3*x₁_2*x₄_1*β_0*q₁_0 - 3*x₄_2*x₁_1*β_0*q₁_0 - x₁_3*x₄_0*β_0*q₁_0 - x₄_3*x₁_0*β_0*q₁_0 + x₂_3^3*k₁_0 + x₂_3^3*μ₁_0 + x₂_4^3,
		-x₄_6 + 842854658286929685894274905027993741030240006619156708677637248443298518023585472503745593838673432597537411294585669236453182954903025399468404447152086476168207648238328652840518414320952185145154524575324180922137768427020609248838237,
		-x₃_6^2*k₂_0 + x₄_6*c_0 + x₄_7,
		-x₂_5^3*k₁_0 - 10*x₁_3*x₄_2*β_0*q₂_0 - 10*x₄_3*x₁_2*β_0*q₂_0 - 5*x₁_4*x₄_1*β_0*q₂_0 - 5*x₄_4*x₁_1*β_0*q₂_0 - x₁_5*x₄_0*β_0*q₂_0 - x₄_5*x₁_0*β_0*q₂_0 + x₃_5^2*μ₂_0 + x₃_6^2,
		6*x₄_2*x₁_2*β_0 + 4*x₁_3*x₄_1*β_0 + 4*x₄_3*x₁_1*β_0 + x₁_4*x₄_0*β_0 + x₄_4*x₁_0*β_0 + x₁_4*d_0 + x₁_5,
		-6*x₄_2*x₁_2*β_0*q₁_0 - 4*x₁_3*x₄_1*β_0*q₁_0 - 4*x₄_3*x₁_1*β_0*q₁_0 - x₁_4*x₄_0*β_0*q₁_0 - x₄_4*x₁_0*β_0*q₁_0 + x₂_4^3*k₁_0 + x₂_4^3*μ₁_0 + x₂_5^3,
		-x₄_7 - 5799865449233942129867993273999882730559171000615646313840931548276583381485479807599873256859953969059564320294541041151985454913989347800623303382957519799903556263366606757910942503643352097909924388849634174647294530356915536197423782372790181475533425411043872187514211,
		-x₃_7^2*k₂_0 + x₄_7*c_0 + x₄_8,
		-x₂_6^3*k₁_0 - 20*x₄_3*x₁_3*β_0*q₂_0 - 15*x₁_4*x₄_2*β_0*q₂_0 - 15*x₄_4*x₁_2*β_0*q₂_0 - 6*x₁_5*x₄_1*β_0*q₂_0 - 6*x₄_5*x₁_1*β_0*q₂_0 - x₁_6*x₄_0*β_0*q₂_0 - x₄_6*x₁_0*β_0*q₂_0 + x₃_6^2*μ₂_0 + x₃_7^2,
		10*x₁_3*x₄_2*β_0 + 10*x₄_3*x₁_2*β_0 + 5*x₁_4*x₄_1*β_0 + 5*x₄_4*x₁_1*β_0 + x₁_5*x₄_0*β_0 + x₄_5*x₁_0*β_0 + x₁_5*d_0 + x₁_6,
		-10*x₁_3*x₄_2*β_0*q₁_0 - 10*x₄_3*x₁_2*β_0*q₁_0 - 5*x₁_4*x₄_1*β_0*q₁_0 - 5*x₄_4*x₁_1*β_0*q₁_0 - x₁_5*x₄_0*β_0*q₁_0 - x₄_5*x₁_0*β_0*q₁_0 + x₂_5^3*k₁_0 + x₂_5^3*μ₁_0 + x₂_6^3,
		-x₁_4 + 25651296873178443950254659331296609314918354029704783236317127866097692780566755764447110180489116008435390111633704288517438879879427316629295604681836819614762404,
		-x₁_5 - 101227566511447287541449624256698359465049914762844693140416798441014479935614395909474758376375442332727971468808240022693138692407096632386547719614270415826100955137294611841266338552960524720400916,
		-x₁_6 + 696568809043596350429519566466345297205208802078694588267272001991816434652800992373793204037570144355979011944281948842289716606096798229952651310176691770862601087295233370356614949112198945760073267513202266504990826363321991976414550,
		-x₄_8 + 26623729751071110921259393075299308683117288568430567143629569600437661532314636065376230927808169450275005299938770804694281534848515783223923405481820751897218518492004403172841509537284211721441562718682214071206459273745842679972445101477976972636622249256004944339073314255691492582991095785170592519307995,
		z_aux - 1
    ]
end
