#! format: off
#! source: https://github.com/alexeyovchinnikov/SIAN-Julia

import AbstractAlgebra

function ChemicalReactionNetwork(; np=AbstractAlgebra, internal_ordering=:degrevlex, k=np.QQ)
    R, (x2_6,x3_6,x4_5,x2_5,x5_5,x1_5,x3_5,x6_5,x4_4,x2_4,x5_4,x1_4,x3_4,x6_4,x4_3,x2_3,x5_3,x1_3,x3_3,x6_3,x4_2,x2_2,x5_2,x1_2,x3_2,x6_2,x4_1,x2_1,x5_1,x1_1,x3_1,x6_1,x4_0,x2_0,x5_0,x1_0,x3_0,x6_0,z_aux,k1_0,k2_0,k4_0,k3_0,k5_0,k6_0) = np.polynomial_ring(k, [:x2_6,:x3_6,:x4_5,:x2_5,:x5_5,:x1_5,:x3_5,:x6_5,:x4_4,:x2_4,:x5_4,:x1_4,:x3_4,:x6_4,:x4_3,:x2_3,:x5_3,:x1_3,:x3_3,:x6_3,:x4_2,:x2_2,:x5_2,:x1_2,:x3_2,:x6_2,:x4_1,:x2_1,:x5_1,:x1_1,:x3_1,:x6_1,:x4_0,:x2_0,:x5_0,:x1_0,:x3_0,:x6_0,:z_aux,:k1_0,:k2_0,:k4_0,:k3_0,:k5_0,:k6_0], internal_ordering=internal_ordering)
    sys = [
    		-x2_0 + 544397587489487158925,
		-x2_0*x1_0*k1_0 - x4_0*k2_0 - x4_0*k3_0 + x2_1,
		-x3_0 + 29682033801657517034,
		x5_0*x3_0*k6_0 - x4_0*k3_0 - x6_0*k5_0 + x3_1,
		-x2_1 + 31319937365291324106855334029149083433729222633545127704567987,
		-x1_1*x2_0*k1_0 - x2_1*x1_0*k1_0 - x4_1*k2_0 - x4_1*k3_0 + x2_2,
		-x2_0*x1_0*k1_0 + x4_0*k2_0 + x4_0*k3_0 + x4_1,
		x2_0*x1_0*k1_0 - x4_0*k2_0 - x6_0*k4_0 + x1_1,
		-x3_1 - 1205403898926015103232327521221029715967312994127374687044129,
		x3_1*x5_0*k6_0 + x5_1*x3_0*k6_0 - x4_1*k3_0 - x6_1*k5_0 + x3_2,
		-x5_0*x3_0*k6_0 + x6_0*k4_0 + x6_0*k5_0 + x6_1,
		x5_0*x3_0*k6_0 - x6_0*k4_0 - x6_0*k5_0 + x5_1,
		-x2_2 - 229339524796362821697179199520342673234123591683553488185657952768354303216823322458483803211712707633,
		-2*x2_1*x1_1*k1_0 - x1_2*x2_0*k1_0 - x2_2*x1_0*k1_0 - x4_2*k2_0 - x4_2*k3_0 + x2_3,
		-x1_1*x2_0*k1_0 - x2_1*x1_0*k1_0 + x4_1*k2_0 + x4_1*k3_0 + x4_2,
		x1_1*x2_0*k1_0 + x2_1*x1_0*k1_0 - x4_1*k2_0 - x6_1*k4_0 + x1_2,
		-x3_2 + 51994373568763482184084092961808697028251976190716290042832706767730767453744791804300393099736005865,
		2*x5_1*x3_1*k6_0 + x3_2*x5_0*k6_0 + x5_2*x3_0*k6_0 - x4_2*k3_0 - x6_2*k5_0 + x3_3,
		x3_1*x5_0*k6_0 + x5_1*x3_0*k6_0 - x6_1*k4_0 - x6_1*k5_0 + x5_2,
		-x3_1*x5_0*k6_0 - x5_1*x3_0*k6_0 + x6_1*k4_0 + x6_1*k5_0 + x6_2,
		-x2_3 - 232038201156430746537091630904147281723828787963263084910508601531237857942582213788880858182009072907809417201406568624315583493857533204297241,
		-3*x1_2*x2_1*k1_0 - 3*x2_2*x1_1*k1_0 - x1_3*x2_0*k1_0 - x2_3*x1_0*k1_0 - x4_3*k2_0 - x4_3*k3_0 + x2_4,
		2*x2_1*x1_1*k1_0 + x1_2*x2_0*k1_0 + x2_2*x1_0*k1_0 - x4_2*k2_0 - x6_2*k4_0 + x1_3,
		-2*x2_1*x1_1*k1_0 - x1_2*x2_0*k1_0 - x2_2*x1_0*k1_0 + x4_2*k2_0 + x4_2*k3_0 + x4_3,
		-x3_3 - 2489841093515072908413476041338707895889602410462016515249818481973712038712671501796124969357657634299055404533594664232527151976813331542405,
		3*x3_2*x5_1*k6_0 + 3*x5_2*x3_1*k6_0 + x3_3*x5_0*k6_0 + x5_3*x3_0*k6_0 - x4_3*k3_0 - x6_3*k5_0 + x3_4,
		2*x5_1*x3_1*k6_0 + x3_2*x5_0*k6_0 + x5_2*x3_0*k6_0 - x6_2*k4_0 - x6_2*k5_0 + x5_3,
		-2*x5_1*x3_1*k6_0 - x3_2*x5_0*k6_0 - x5_2*x3_0*k6_0 + x6_2*k4_0 + x6_2*k5_0 + x6_3,
		-x2_4 + 6833268318610526294398509674052602741963506552428132533026349353865937016318327644539867625341607863425291998178353893918539978698743728647984446868290545116877979367133284448342699619,
		-6*x2_2*x1_2*k1_0 - 4*x1_3*x2_1*k1_0 - 4*x2_3*x1_1*k1_0 - x1_4*x2_0*k1_0 - x2_4*x1_0*k1_0 - x4_4*k2_0 - x4_4*k3_0 + x2_5,
		3*x1_2*x2_1*k1_0 + 3*x2_2*x1_1*k1_0 + x1_3*x2_0*k1_0 + x2_3*x1_0*k1_0 - x4_3*k2_0 - x6_3*k4_0 + x1_4,
		-3*x1_2*x2_1*k1_0 - 3*x2_2*x1_1*k1_0 - x1_3*x2_0*k1_0 - x2_3*x1_0*k1_0 + x4_3*k2_0 + x4_3*k3_0 + x4_4,
		-x3_4 + 139372684659646947400032617915256822925543857095425418659231178320203702886011430928972731874199419309231800473513836491566273073235642297304567870916637554479092119674738526118464349,
		6*x5_2*x3_2*k6_0 + 4*x3_3*x5_1*k6_0 + 4*x5_3*x3_1*k6_0 + x3_4*x5_0*k6_0 + x5_4*x3_0*k6_0 - x4_4*k3_0 - x6_4*k5_0 + x3_5,
		3*x3_2*x5_1*k6_0 + 3*x5_2*x3_1*k6_0 + x3_3*x5_0*k6_0 + x5_3*x3_0*k6_0 - x6_3*k4_0 - x6_3*k5_0 + x5_4,
		-3*x3_2*x5_1*k6_0 - 3*x5_2*x3_1*k6_0 - x3_3*x5_0*k6_0 - x5_3*x3_0*k6_0 + x6_3*k4_0 + x6_3*k5_0 + x6_4,
		-x2_5 + 6838486782430686299035071132630075973697920250584089671969973910608713502903358704862830483072894667290471182617874180462193424855391356314223488979143494081738912668378445300235299223669454169180240866472469798832273931874771,
		-10*x1_3*x2_2*k1_0 - 10*x2_3*x1_2*k1_0 - 5*x1_4*x2_1*k1_0 - 5*x2_4*x1_1*k1_0 - x1_5*x2_0*k1_0 - x2_5*x1_0*k1_0 - x4_5*k2_0 - x4_5*k3_0 + x2_6,
		6*x2_2*x1_2*k1_0 + 4*x1_3*x2_1*k1_0 + 4*x2_3*x1_1*k1_0 + x1_4*x2_0*k1_0 + x2_4*x1_0*k1_0 - x4_4*k2_0 - x6_4*k4_0 + x1_5,
		-6*x2_2*x1_2*k1_0 - 4*x1_3*x2_1*k1_0 - 4*x2_3*x1_1*k1_0 - x1_4*x2_0*k1_0 - x2_4*x1_0*k1_0 + x4_4*k2_0 + x4_4*k3_0 + x4_5,
		-x3_5 - 9432538466279061969626251017997506200087012855382375310271219785484843806387873289962755838840610044593372993207503051477869979995636787726121110375505203077815042851356368062845396310043125746401457803519321295745845533921,
		10*x3_3*x5_2*k6_0 + 10*x5_3*x3_2*k6_0 + 5*x3_4*x5_1*k6_0 + 5*x5_4*x3_1*k6_0 + x3_5*x5_0*k6_0 + x5_5*x3_0*k6_0 - x4_5*k3_0 - x6_5*k5_0 + x3_6,
		6*x5_2*x3_2*k6_0 + 4*x3_3*x5_1*k6_0 + 4*x5_3*x3_1*k6_0 + x3_4*x5_0*k6_0 + x5_4*x3_0*k6_0 - x6_4*k4_0 - x6_4*k5_0 + x5_5,
		-6*x5_2*x3_2*k6_0 - 4*x3_3*x5_1*k6_0 - 4*x5_3*x3_1*k6_0 - x3_4*x5_0*k6_0 - x5_4*x3_0*k6_0 + x6_4*k4_0 + x6_4*k5_0 + x6_5,
		-x2_6 - 431823661101178583505815491042523134350206755479826028667592462756788009689941949869407738348139688220524420514575971797513660499210284796566738796263877621740295059112585851154193458024478996326631221756791028085954163425908665515752702603237782667975897109333515649,
		-x3_6 + 769870577908006120564448207008580735409610931139128690554050380585838323906530768958771900337367983660052503963075641299189963096098994417170599661737028858960886234625288502945817380331987105651194636010000131880991008488153208097961558067253161665808187776817089,
		z_aux - 1
    ]
end
