#! format: off
#! source: https://github.com/alexeyovchinnikov/SIAN-Julia

import AbstractAlgebra

function Cholera(; np=AbstractAlgebra, internal_ordering=:degrevlex, k=np.QQ)
    R, (i_9,i_8,w_8,s_8,i_7,w_7,r_7,s_7,i_6,w_6,r_6,s_6,i_5,w_5,r_5,s_5,i_4,w_4,r_4,s_4,i_3,w_3,r_3,s_3,i_2,w_2,r_2,s_2,i_1,w_1,r_1,s_1,i_0,w_0,r_0,s_0,z_aux,mu_0,bi_0,bw_0,al_0,g_0,dz_0,k_0) = np.polynomial_ring(k, [:i_9,:i_8,:w_8,:s_8,:i_7,:w_7,:r_7,:s_7,:i_6,:w_6,:r_6,:s_6,:i_5,:w_5,:r_5,:s_5,:i_4,:w_4,:r_4,:s_4,:i_3,:w_3,:r_3,:s_3,:i_2,:w_2,:r_2,:s_2,:i_1,:w_1,:r_1,:s_1,:i_0,:w_0,:r_0,:s_0,:z_aux,:mu_0,:bi_0,:bw_0,:al_0,:g_0,:dz_0,:k_0], internal_ordering=internal_ordering)
    sys = [
    		-i_0 - r_0 - s_0 + 2980074650635745482722,
		r_0*mu_0 + r_0*al_0 - i_0*g_0 + r_1,
		-i_0*s_0*bi_0 - w_0*s_0*bw_0 + i_0*mu_0 + i_0*g_0 + i_1,
		i_0*s_0*bi_0 + w_0*s_0*bw_0 + s_0*mu_0 - r_0*al_0 + s_1 - mu_0,
		-i_0*k_0 + 187865766441801096442867884831449218259338,
		-i_1 - r_1 - s_1 - 587989940558935651497188412652797767056012,
		r_1*mu_0 + r_1*al_0 - i_1*g_0 + r_2,
		-s_1*i_0*bi_0 - i_1*s_0*bi_0 - s_1*w_0*bw_0 - w_1*s_0*bw_0 + i_1*mu_0 + i_1*g_0 + i_2,
		s_1*i_0*bi_0 + i_1*s_0*bi_0 + s_1*w_0*bw_0 + w_1*s_0*bw_0 + s_1*mu_0 - r_1*al_0 + s_2,
		-i_0*dz_0 + w_0*dz_0 + w_1,
		-i_1*k_0 + 1277410634018328126775017227746781373544979592248315878368595993560360406195112913062,
		-i_2*k_0 - 2341482585890381336538833296751745942818361578870820216616988459749244866760707031555541815643215948939122365114964260508063850,
		-2*i_1*s_1*bi_0 - s_2*i_0*bi_0 - i_2*s_0*bi_0 - 2*w_1*s_1*bw_0 - s_2*w_0*bw_0 - w_2*s_0*bw_0 + i_2*mu_0 + i_2*g_0 + i_3,
		-i_1*dz_0 + w_1*dz_0 + w_2,
		-i_3*k_0 + 3316015244139860530121857966267255563457696054341836040688382170569366288180772656573529715061868070249232375846729402189991897231243183810942121567633187898465260325146,
		-3*s_2*i_1*bi_0 - 3*i_2*s_1*bi_0 - s_3*i_0*bi_0 - i_3*s_0*bi_0 - 3*s_2*w_1*bw_0 - 3*w_2*s_1*bw_0 - s_3*w_0*bw_0 - w_3*s_0*bw_0 + i_3*mu_0 + i_3*g_0 + i_4,
		-i_2*dz_0 + w_2*dz_0 + w_3,
		2*i_1*s_1*bi_0 + s_2*i_0*bi_0 + i_2*s_0*bi_0 + 2*w_1*s_1*bw_0 + s_2*w_0*bw_0 + w_2*s_0*bw_0 + s_2*mu_0 - r_2*al_0 + s_3,
		-i_4*k_0 - 711767588783385145023388340846683054866008334206458998710644497577697279645891245332546655714533884848309778667396143632975186469663441981974068162334937266836639157223052701039453410718462860170791591818024586,
		-6*i_2*s_2*bi_0 - 4*s_3*i_1*bi_0 - 4*i_3*s_1*bi_0 - s_4*i_0*bi_0 - i_4*s_0*bi_0 - 6*w_2*s_2*bw_0 - 4*s_3*w_1*bw_0 - 4*w_3*s_1*bw_0 - s_4*w_0*bw_0 - w_4*s_0*bw_0 + i_4*mu_0 + i_4*g_0 + i_5,
		3*s_2*i_1*bi_0 + 3*i_2*s_1*bi_0 + s_3*i_0*bi_0 + i_3*s_0*bi_0 + 3*s_2*w_1*bw_0 + 3*w_2*s_1*bw_0 + s_3*w_0*bw_0 + w_3*s_0*bw_0 + s_3*mu_0 - r_3*al_0 + s_4,
		-i_3*dz_0 + w_3*dz_0 + w_4,
		r_2*mu_0 + r_2*al_0 - i_2*g_0 + r_3,
		-i_5*k_0 - 18665339724532000580604691285769607142920934357399551831480964903075741577870757797666897300030294582944931905607832352647880466738677411088168188229523985463421594620154643000945297999904581798490913330370177055753704211113126841752306417378998419358642,
		-10*s_3*i_2*bi_0 - 10*i_3*s_2*bi_0 - 5*s_4*i_1*bi_0 - 5*i_4*s_1*bi_0 - s_5*i_0*bi_0 - i_5*s_0*bi_0 - 10*s_3*w_2*bw_0 - 10*w_3*s_2*bw_0 - 5*s_4*w_1*bw_0 - 5*w_4*s_1*bw_0 - s_5*w_0*bw_0 - w_5*s_0*bw_0 + i_5*mu_0 + i_5*g_0 + i_6,
		6*i_2*s_2*bi_0 + 4*s_3*i_1*bi_0 + 4*i_3*s_1*bi_0 + s_4*i_0*bi_0 + i_4*s_0*bi_0 + 6*w_2*s_2*bw_0 + 4*s_3*w_1*bw_0 + 4*w_3*s_1*bw_0 + s_4*w_0*bw_0 + w_4*s_0*bw_0 + s_4*mu_0 - r_4*al_0 + s_5,
		-i_4*dz_0 + w_4*dz_0 + w_5,
		r_3*mu_0 + r_3*al_0 - i_3*g_0 + r_4,
		-i_6*k_0 + 83368010799974611909382386446631002045039777730921835098681336057320099362402100157422057780473244308796392262187575801000073554033141434465252932437061983204571177469369194997822796785158271078575363990002497784952965593543551975904451723114424207749293513848165974921635832137047353808469484746,
		-20*i_3*s_3*bi_0 - 15*s_4*i_2*bi_0 - 15*i_4*s_2*bi_0 - 6*s_5*i_1*bi_0 - 6*i_5*s_1*bi_0 - s_6*i_0*bi_0 - i_6*s_0*bi_0 - 20*w_3*s_3*bw_0 - 15*s_4*w_2*bw_0 - 15*w_4*s_2*bw_0 - 6*s_5*w_1*bw_0 - 6*w_5*s_1*bw_0 - s_6*w_0*bw_0 - w_6*s_0*bw_0 + i_6*mu_0 + i_6*g_0 + i_7,
		-i_5*dz_0 + w_5*dz_0 + w_6,
		10*s_3*i_2*bi_0 + 10*i_3*s_2*bi_0 + 5*s_4*i_1*bi_0 + 5*i_4*s_1*bi_0 + s_5*i_0*bi_0 + i_5*s_0*bi_0 + 10*s_3*w_2*bw_0 + 10*w_3*s_2*bw_0 + 5*s_4*w_1*bw_0 + 5*w_4*s_1*bw_0 + s_5*w_0*bw_0 + w_5*s_0*bw_0 + s_5*mu_0 - r_5*al_0 + s_6,
		r_4*mu_0 + r_4*al_0 - i_4*g_0 + r_5,
		-i_7*k_0 - 147967724216456888824593807280019292245302103850251837522159515303596838562643699163031711825578283990629163339503209909596209795604349100752179823072451003211338344645816712208045974936687218947527578753415691889254046093758180318902931670701150459085744978894957752687386282483147471744848096841479140419928757404958915652038052934379442,
		-35*s_4*i_3*bi_0 - 35*i_4*s_3*bi_0 - 21*s_5*i_2*bi_0 - 21*i_5*s_2*bi_0 - 7*s_6*i_1*bi_0 - 7*i_6*s_1*bi_0 - s_7*i_0*bi_0 - i_7*s_0*bi_0 - 35*s_4*w_3*bw_0 - 35*w_4*s_3*bw_0 - 21*s_5*w_2*bw_0 - 21*w_5*s_2*bw_0 - 7*s_6*w_1*bw_0 - 7*w_6*s_1*bw_0 - s_7*w_0*bw_0 - w_7*s_0*bw_0 + i_7*mu_0 + i_7*g_0 + i_8,
		-i_6*dz_0 + w_6*dz_0 + w_7,
		20*i_3*s_3*bi_0 + 15*s_4*i_2*bi_0 + 15*i_4*s_2*bi_0 + 6*s_5*i_1*bi_0 + 6*i_5*s_1*bi_0 + s_6*i_0*bi_0 + i_6*s_0*bi_0 + 20*w_3*s_3*bw_0 + 15*s_4*w_2*bw_0 + 15*w_4*s_2*bw_0 + 6*s_5*w_1*bw_0 + 6*w_5*s_1*bw_0 + s_6*w_0*bw_0 + w_6*s_0*bw_0 + s_6*mu_0 - r_6*al_0 + s_7,
		r_5*mu_0 + r_5*al_0 - i_5*g_0 + r_6,
		-i_8*k_0 - 674103273365030559391515752812072091829047312159829889448364059067220670276745456722507612194556136295436912111731469567590909041689687528599801557579800775473536986698752946179869493805440036196664100861484973318496238375134541202991386932229469343192215190091027687563318355352958089794174614458086269402784747884084002916914281085696398034501040776122991240187415034887078155914,
		-70*i_4*s_4*bi_0 - 56*s_5*i_3*bi_0 - 56*i_5*s_3*bi_0 - 28*s_6*i_2*bi_0 - 28*i_6*s_2*bi_0 - 8*s_7*i_1*bi_0 - 8*i_7*s_1*bi_0 - s_8*i_0*bi_0 - i_8*s_0*bi_0 - 70*w_4*s_4*bw_0 - 56*s_5*w_3*bw_0 - 56*w_5*s_3*bw_0 - 28*s_6*w_2*bw_0 - 28*w_6*s_2*bw_0 - 8*s_7*w_1*bw_0 - 8*w_7*s_1*bw_0 - s_8*w_0*bw_0 - w_8*s_0*bw_0 + i_8*mu_0 + i_8*g_0 + i_9,
		35*s_4*i_3*bi_0 + 35*i_4*s_3*bi_0 + 21*s_5*i_2*bi_0 + 21*i_5*s_2*bi_0 + 7*s_6*i_1*bi_0 + 7*i_6*s_1*bi_0 + s_7*i_0*bi_0 + i_7*s_0*bi_0 + 35*s_4*w_3*bw_0 + 35*w_4*s_3*bw_0 + 21*s_5*w_2*bw_0 + 21*w_5*s_2*bw_0 + 7*s_6*w_1*bw_0 + 7*w_6*s_1*bw_0 + s_7*w_0*bw_0 + w_7*s_0*bw_0 + s_7*mu_0 - r_7*al_0 + s_8,
		-i_7*dz_0 + w_7*dz_0 + w_8,
		r_6*mu_0 + r_6*al_0 - i_6*g_0 + r_7,
		-i_2 - r_2 - s_2 + 116014600548595291886176008075760517732197215875621423410450064,
		-i_3 - r_3 - s_3 - 22890506473045791995115165087583625844781809884223370988178227721730602360097763008,
		-i_4 - r_4 - s_4 + 4516459860352427093382687739390813045476029732369311452081971342192413898927916571756156200650811781376,
		-i_5 - r_5 - s_5 - 891129678331685668505471310021741105387507255043152430038674460356075455664492139206771807662640426076290683418128023964672,
		-i_6 - r_6 - s_6 + 175826228541211399892699778334585423146889420531107175406069200855246858982303884279890012859457287853465355668537083211173082437423411127619584,
		-i_7 - r_7 - s_7 - 34691766411486904318482481905083491952664034705323971165028302785858442473221550597346325692604524560056453654749755021785868967493673755968388313225830098258280448,
		-i_9*k_0 + 7471136511829128504299483090560499068662192052395856667723160028978279590694775782794424094143010609362277289590643587793496605382946287380413738801546605018611179544663229484501796360121821537396946476224658214561900384576832669227906100996542315194986195519446703769836611908531577602122585984958790071117884682479803541091090718034761019332672999051148441055356488226926951744455387486628157925225943716368750244978261890,
		z_aux - 1
    ]
end
