#! format: off
#! source: https://github.com/alexeyovchinnikov/SIAN-Julia

import AbstractAlgebra

function NFkB(; np=AbstractAlgebra, internal_ordering=:degrevlex, k=np.QQ)
    R, (x2_7,x3_6,x13_6,x10_6,x2_6,x5_6,x1_6,x8_6,x4_6,x3_5,x14_5,x13_5,x11_5,x10_5,x2_5,x12_5,x7_5,x5_5,x1_5,x8_5,x9_5,x6_5,x4_5,x3_4,x14_4,x13_4,x11_4,x10_4,x2_4,x12_4,x7_4,x5_4,x1_4,x8_4,x9_4,x6_4,x4_4,x3_3,x14_3,x13_3,x11_3,x10_3,x2_3,x12_3,x7_3,x5_3,x1_3,x8_3,x9_3,x6_3,x4_3,x3_2,x14_2,x13_2,x11_2,x10_2,x2_2,x12_2,x7_2,x5_2,x1_2,x8_2,x9_2,x6_2,x4_2,x3_1,x14_1,x13_1,x11_1,x10_1,x2_1,x12_1,x7_1,x5_1,x1_1,x8_1,x9_1,x6_1,x4_1,x3_0,x14_0,x13_0,x11_0,x10_0,x2_0,x12_0,x7_0,x5_0,x1_0,x8_0,x9_0,x6_0,x4_0,z_aux,k_prod_0,k_deg_0,k1_0,k3_0,t1_0,t2_0,k2_0,i1_0,c5_0,c_4a_0,i_1a_0,c_3a_0,e_2a_0) = np.polynomial_ring(k, [:x2_7,:x3_6,:x13_6,:x10_6,:x2_6,:x5_6,:x1_6,:x8_6,:x4_6,:x3_5,:x14_5,:x13_5,:x11_5,:x10_5,:x2_5,:x12_5,:x7_5,:x5_5,:x1_5,:x8_5,:x9_5,:x6_5,:x4_5,:x3_4,:x14_4,:x13_4,:x11_4,:x10_4,:x2_4,:x12_4,:x7_4,:x5_4,:x1_4,:x8_4,:x9_4,:x6_4,:x4_4,:x3_3,:x14_3,:x13_3,:x11_3,:x10_3,:x2_3,:x12_3,:x7_3,:x5_3,:x1_3,:x8_3,:x9_3,:x6_3,:x4_3,:x3_2,:x14_2,:x13_2,:x11_2,:x10_2,:x2_2,:x12_2,:x7_2,:x5_2,:x1_2,:x8_2,:x9_2,:x6_2,:x4_2,:x3_1,:x14_1,:x13_1,:x11_1,:x10_1,:x2_1,:x12_1,:x7_1,:x5_1,:x1_1,:x8_1,:x9_1,:x6_1,:x4_1,:x3_0,:x14_0,:x13_0,:x11_0,:x10_0,:x2_0,:x12_0,:x7_0,:x5_0,:x1_0,:x8_0,:x9_0,:x6_0,:x4_0,:z_aux,:k_prod_0,:k_deg_0,:k1_0,:k3_0,:t1_0,:t2_0,:k2_0,:i1_0,:c5_0,:c_4a_0,:i_1a_0,:c_3a_0,:e_2a_0], internal_ordering=internal_ordering)
    sys = [
    		-x3_0 - x2_0 - x1_0 + 1647632858386475149601764115394062,
		-1336647777665543647328022902114328*x2_0*x8_0*k2_0 + x3_0*k_deg_0 - x2_0*k3_0 + x3_1,
		x1_0*k_deg_0 + 1336647777665543647328022902114328*x1_0*k1_0 + x1_1 - k_prod_0,
		1336647777665543647328022902114328*x2_0*x8_0*k2_0 + x13_0*x2_0 + k(1)//k(5)*x10_0*x2_0 + x2_0*k_deg_0 - 1336647777665543647328022902114328*x1_0*k1_0 + x2_0*k3_0 - x4_0*t1_0 - x5_0*t2_0 + x2_1,
		-x12_0 + 987955128904990080816352011602744,
		x12_0*c_3a_0 + x12_1 - k(1)//k(2000000)*x7_0,
		-x2_0 + 461035911698253900217642437916575,
		-x9_0 + 815159065694907354358569488025252,
		x9_1 - k(1)//k(2000000)*x7_0 + k(1)//k(2500)*x9_0,
		-x13_0 - x10_0 + 1976947896707866373943232864676153,
		x13_0*x2_0 - k(1)//k(2)*x10_0*x6_0 - x14_0*e_2a_0 + x13_1 + k(1)//k(50000)*x13_0,
		k(1)//k(5)*x10_0*x2_0 + k(1)//k(2)*x10_0*x6_0 - x12_0*c_4a_0 + x10_0*i_1a_0 + x10_1 - k(1)//k(2000)*x11_0 + k(1)//k(10000)*x10_0,
		-x7_0 + 1191771947842957491405156028609000,
		k(1)//k(2)*x11_0*x7_0 - 5*x6_0*i1_0 + x7_1,
		-x3_1 - x2_1 - x1_1 + 183062700520099347309692513301048368639064176908656084321892022753,
		x1_1*k_deg_0 + 1336647777665543647328022902114328*x1_1*k1_0 + 1011511619070463686836131534843516*x1_0*k1_0 + x1_2,
		-1336647777665543647328022902114328*x8_1*x2_0*k2_0 - 1336647777665543647328022902114328*x2_1*x8_0*k2_0 - 1011511619070463686836131534843516*x2_0*x8_0*k2_0 + x3_1*k_deg_0 - x2_1*k3_0 + x3_2,
		1336647777665543647328022902114328*x8_1*x2_0*k2_0 + 1336647777665543647328022902114328*x2_1*x8_0*k2_0 + 1011511619070463686836131534843516*x2_0*x8_0*k2_0 + x2_1*x13_0 + k(1)//k(5)*x2_1*x10_0 + x13_1*x2_0 + k(1)//k(5)*x10_1*x2_0 + x2_1*k_deg_0 - 1336647777665543647328022902114328*x1_1*k1_0 - 1011511619070463686836131534843516*x1_0*k1_0 + x2_1*k3_0 - x4_1*t1_0 - x5_1*t2_0 + x2_2,
		-k(1)//k(5)*x10_0*x2_0 + x4_0*t1_0 + x4_1,
		x8_0*c5_0 + x8_1 - k(1)//k(2)*x9_0,
		-x13_0*x2_0 + x5_0*t2_0 + x5_1,
		-x12_1 - k(144768476684956506184543619288609647853526983960719392655855288691391)//k(2000),
		x12_1*c_3a_0 + x12_2 - k(1)//k(2000000)*x7_1,
		-x2_1 - 250665931281134561427938076743574034698476042323407341806306878832876878114340121005779472420342102528717711094600710928546190358963,
		-x13_1 - x10_1 + k(1181022351706159971538981833249887540704962549545877048907970230297947)//k(400),
		x2_1*x13_0 - k(1)//k(2)*x6_1*x10_0 + x13_1*x2_0 - k(1)//k(2)*x10_1*x6_0 - x14_1*e_2a_0 + x13_2 + k(1)//k(50000)*x13_1,
		k(1)//k(5)*x2_1*x10_0 + k(1)//k(2)*x6_1*x10_0 + k(1)//k(5)*x10_1*x2_0 + k(1)//k(2)*x10_1*x6_0 - x12_1*c_4a_0 + x10_1*i_1a_0 + x10_2 - k(1)//k(2000)*x11_1 + k(1)//k(10000)*x10_1,
		k(1)//k(2)*x10_0*x6_0 - x5_0*t2_0 + x6_0*i1_0 + x6_1 - k(1)//k(50000)*x13_0,
		k(1)//k(2)*x11_0*x7_0 - 5*x10_0*i_1a_0 + x11_1 + k(1)//k(400)*x11_0,
		-k(1)//k(2)*x11_0*x7_0 + 5*x14_0*e_2a_0 + x14_1,
		-x7_1 + 860015846305163472538772637185003177358364292209999439693615717530,
		k(1)//k(2)*x7_1*x11_0 + k(1)//k(2)*x11_1*x7_0 - 5*x6_1*i1_0 + x7_2,
		-x3_2 - x2_2 - x1_2 + k(313802249830663392370691823327539605567110852951882040736627740849469243701742995433370332327166669693915955374326202849851478976171126361210331902052814849892049282859)//k(2000),
		-2673295555331087294656045804228656*x2_1*x8_1*k2_0 - 1336647777665543647328022902114328*x8_2*x2_0*k2_0 - 2023023238140927373672263069687032*x8_1*x2_0*k2_0 - 1336647777665543647328022902114328*x2_2*x8_0*k2_0 - 2023023238140927373672263069687032*x2_1*x8_0*k2_0 - 397287622890585369835152886980316*x2_0*x8_0*k2_0 + x3_2*k_deg_0 - x2_2*k3_0 + x3_3,
		x1_2*k_deg_0 + 1336647777665543647328022902114328*x1_2*k1_0 + 2023023238140927373672263069687032*x1_1*k1_0 + 397287622890585369835152886980316*x1_0*k1_0 + x1_3,
		2673295555331087294656045804228656*x2_1*x8_1*k2_0 + 1336647777665543647328022902114328*x8_2*x2_0*k2_0 + 2023023238140927373672263069687032*x8_1*x2_0*k2_0 + 1336647777665543647328022902114328*x2_2*x8_0*k2_0 + 2023023238140927373672263069687032*x2_1*x8_0*k2_0 + 397287622890585369835152886980316*x2_0*x8_0*k2_0 + 2*x13_1*x2_1 + k(2)//k(5)*x10_1*x2_1 + x2_2*x13_0 + k(1)//k(5)*x2_2*x10_0 + x13_2*x2_0 + k(1)//k(5)*x10_2*x2_0 + x2_2*k_deg_0 - 1336647777665543647328022902114328*x1_2*k1_0 - 2023023238140927373672263069687032*x1_1*k1_0 - 397287622890585369835152886980316*x1_0*k1_0 + x2_2*k3_0 - x4_2*t1_0 - x5_2*t2_0 + x2_3,
		-k(1)//k(5)*x2_1*x10_0 - k(1)//k(5)*x10_1*x2_0 + x4_1*t1_0 + x4_2,
		-x2_1*x13_0 - x13_1*x2_0 + x5_1*t2_0 + x5_2,
		x8_1*c5_0 + x8_2 - k(1)//k(2)*x9_1,
		-x2_2 + k(272574901480397826112918590456040784334439845040077325335139904876210443330299139404711056866699843617347753675206834882607367288885187643459465941772088256495802132842861410974741380546832755133320482691281860870859658628201718826859)//k(2000),
		-x13_2 - x10_2 + k(78450562457665848092672955831884901391777713237970510184156935204131884219822397466986620162641987046954558194928806906171696858615321855258324755696819233568461032743377157)//k(500000000),
		k(2)//k(5)*x10_1*x2_1 + x10_1*x6_1 + k(1)//k(5)*x2_2*x10_0 + k(1)//k(2)*x6_2*x10_0 + k(1)//k(5)*x10_2*x2_0 + k(1)//k(2)*x10_2*x6_0 - x12_2*c_4a_0 + x10_2*i_1a_0 + x10_3 - k(1)//k(2000)*x11_2 + k(1)//k(10000)*x10_2,
		2*x13_1*x2_1 - x10_1*x6_1 + x2_2*x13_0 - k(1)//k(2)*x6_2*x10_0 + x13_2*x2_0 - k(1)//k(2)*x10_2*x6_0 - x14_2*e_2a_0 + x13_3 + k(1)//k(50000)*x13_2,
		k(1)//k(2)*x6_1*x10_0 + k(1)//k(2)*x10_1*x6_0 - x5_1*t2_0 + x6_1*i1_0 + x6_2 - k(1)//k(50000)*x13_1,
		-k(1)//k(2)*x7_1*x11_0 - k(1)//k(2)*x11_1*x7_0 + 5*x14_1*e_2a_0 + x14_2,
		k(1)//k(2)*x7_1*x11_0 + k(1)//k(2)*x11_1*x7_0 - 5*x10_1*i_1a_0 + x11_2 + k(1)//k(400)*x11_1,
		-x7_2 - k(513119985362448279004375944255170868913946277871741725248409454570828190636902526722454935002136871111)//k(250),
		x11_1*x7_1 + k(1)//k(2)*x7_2*x11_0 + k(1)//k(2)*x11_2*x7_0 - 5*x6_2*i1_0 + x7_3,
		-x3_3 - x2_3 - x1_3 - k(68245905532322895513350554298413154469838802327102029953843559190789362772521726164150630147156194672770734967493374020502043311260743896518839202848669918101941719547320339108157082210008013711887492450878922357474743129070140430351946255320820166568435590433079750607)//k(800000),
		4009943332996630941984068706342984*x8_2*x2_1*k2_0 + 4009943332996630941984068706342984*x2_2*x8_1*k2_0 + 6069069714422782121016789209061096*x2_1*x8_1*k2_0 + 1336647777665543647328022902114328*x8_3*x2_0*k2_0 + 3034534857211391060508394604530548*x8_2*x2_0*k2_0 + 1191862868671756109505458660940948*x8_1*x2_0*k2_0 + 1336647777665543647328022902114328*x2_3*x8_0*k2_0 + 3034534857211391060508394604530548*x2_2*x8_0*k2_0 + 1191862868671756109505458660940948*x2_1*x8_0*k2_0 + 386188247450726837739294267183732*x2_0*x8_0*k2_0 + 3*x2_2*x13_1 + k(3)//k(5)*x2_2*x10_1 + 3*x13_2*x2_1 + k(3)//k(5)*x10_2*x2_1 + x2_3*x13_0 + k(1)//k(5)*x2_3*x10_0 + x13_3*x2_0 + k(1)//k(5)*x10_3*x2_0 + x2_3*k_deg_0 - 1336647777665543647328022902114328*x1_3*k1_0 - 3034534857211391060508394604530548*x1_2*k1_0 - 1191862868671756109505458660940948*x1_1*k1_0 - 386188247450726837739294267183732*x1_0*k1_0 + x2_3*k3_0 - x4_3*t1_0 - x5_3*t2_0 + x2_4,
		x1_3*k_deg_0 + 1336647777665543647328022902114328*x1_3*k1_0 + 3034534857211391060508394604530548*x1_2*k1_0 + 1191862868671756109505458660940948*x1_1*k1_0 + 386188247450726837739294267183732*x1_0*k1_0 + x1_4,
		-4009943332996630941984068706342984*x8_2*x2_1*k2_0 - 4009943332996630941984068706342984*x2_2*x8_1*k2_0 - 6069069714422782121016789209061096*x2_1*x8_1*k2_0 - 1336647777665543647328022902114328*x8_3*x2_0*k2_0 - 3034534857211391060508394604530548*x8_2*x2_0*k2_0 - 1191862868671756109505458660940948*x8_1*x2_0*k2_0 - 1336647777665543647328022902114328*x2_3*x8_0*k2_0 - 3034534857211391060508394604530548*x2_2*x8_0*k2_0 - 1191862868671756109505458660940948*x2_1*x8_0*k2_0 - 386188247450726837739294267183732*x2_0*x8_0*k2_0 + x3_3*k_deg_0 - x2_3*k3_0 + x3_4,
		-2*x13_1*x2_1 - x2_2*x13_0 - x13_2*x2_0 + x5_2*t2_0 + x5_3,
		-k(2)//k(5)*x10_1*x2_1 - k(1)//k(5)*x2_2*x10_0 - k(1)//k(5)*x10_2*x2_0 + x4_2*t1_0 + x4_3,
		x8_2*c5_0 + x8_3 - k(1)//k(2)*x9_2,
		x9_2 - k(1)//k(2000000)*x7_1 + k(1)//k(2500)*x9_1,
		-x2_3 - k(59279756556722213049227571884890478869332392789430349017557217916386039722952674179836510816397684558377744084949694526461009570981460304906713680937262359816006015426009307338838392805496867244132002682685979361433547284187373351167604305356604944767789056434304971501254773835938347928465252649912256566811100598109927351230181483407)//k(800000),
		-x13_3 - x10_3 - k(2132684547885090484792204821825411077182462572721938436057611224701699199284474406163640922821348614397029889594205424948978558198346583307636809373986334885190976987945415712600439318028976032589232641295887308614961038369410553645930272565831204044454828205884518455666776317)//k(25000000000000),
		3*x2_2*x13_1 - k(3)//k(2)*x6_2*x10_1 + 3*x13_2*x2_1 - k(3)//k(2)*x10_2*x6_1 + x2_3*x13_0 - k(1)//k(2)*x6_3*x10_0 + x13_3*x2_0 - k(1)//k(2)*x10_3*x6_0 - x14_3*e_2a_0 + x13_4 + k(1)//k(50000)*x13_3,
		k(3)//k(5)*x2_2*x10_1 + k(3)//k(2)*x6_2*x10_1 + k(3)//k(5)*x10_2*x2_1 + k(3)//k(2)*x10_2*x6_1 + k(1)//k(5)*x2_3*x10_0 + k(1)//k(2)*x6_3*x10_0 + k(1)//k(5)*x10_3*x2_0 + k(1)//k(2)*x10_3*x6_0 - x12_3*c_4a_0 + x10_3*i_1a_0 + x10_4 - k(1)//k(2000)*x11_3 + k(1)//k(10000)*x10_3,
		x12_2*c_3a_0 + x12_3 - k(1)//k(2000000)*x7_2,
		-x11_1*x7_1 - k(1)//k(2)*x7_2*x11_0 - k(1)//k(2)*x11_2*x7_0 + 5*x14_2*e_2a_0 + x14_3,
		x10_1*x6_1 + k(1)//k(2)*x6_2*x10_0 + k(1)//k(2)*x10_2*x6_0 - x5_2*t2_0 + x6_2*i1_0 + x6_3 - k(1)//k(50000)*x13_2,
		x11_1*x7_1 + k(1)//k(2)*x7_2*x11_0 + k(1)//k(2)*x11_2*x7_0 - 5*x10_2*i_1a_0 + x11_3 + k(1)//k(400)*x11_2,
		-x7_3 + k(10696249023595331336851196973184706576250842939725253533029272965935163663406488098148425881405214195938676070086999677716461128218405902361)//k(12500000),
		k(3)//k(2)*x7_2*x11_1 + k(3)//k(2)*x11_2*x7_1 + k(1)//k(2)*x7_3*x11_0 + k(1)//k(2)*x11_3*x7_0 - 5*x6_3*i1_0 + x7_4,
		-x3_4 - x2_4 - x1_4 + k(46381754198305442044051533320955272499874863520384747377581903011561937359216661518335726335615990926851648666470605694424688501527528732781445064833908310136590401950268904340812920337178042005581464349825982423971304146512733956545565827030215322451361953984420045750509534213469570998965273366518027592509091532207276002719228774362167292076651383284446112731262560774591)//k(1000000000000),
		-8019886665993261883968137412685968*x2_2*x8_2*k2_0 - 5346591110662174589312091608457312*x8_3*x2_1*k2_0 - 12138139428845564242033578418122192*x8_2*x2_1*k2_0 - 5346591110662174589312091608457312*x2_3*x8_1*k2_0 - 12138139428845564242033578418122192*x2_2*x8_1*k2_0 - 4767451474687024438021834643763792*x2_1*x8_1*k2_0 - 1336647777665543647328022902114328*x8_4*x2_0*k2_0 - 4046046476281854747344526139374064*x8_3*x2_0*k2_0 - 2383725737343512219010917321881896*x8_2*x2_0*k2_0 - 1544752989802907350957177068734928*x8_1*x2_0*k2_0 - 1336647777665543647328022902114328*x2_4*x8_0*k2_0 - 4046046476281854747344526139374064*x2_3*x8_0*k2_0 - 2383725737343512219010917321881896*x2_2*x8_0*k2_0 - 1544752989802907350957177068734928*x2_1*x8_0*k2_0 - 1023847862111446462555753870167553*x2_0*x8_0*k2_0 + x3_4*k_deg_0 - x2_4*k3_0 + x3_5,
		8019886665993261883968137412685968*x2_2*x8_2*k2_0 + 5346591110662174589312091608457312*x8_3*x2_1*k2_0 + 12138139428845564242033578418122192*x8_2*x2_1*k2_0 + 5346591110662174589312091608457312*x2_3*x8_1*k2_0 + 12138139428845564242033578418122192*x2_2*x8_1*k2_0 + 4767451474687024438021834643763792*x2_1*x8_1*k2_0 + 1336647777665543647328022902114328*x8_4*x2_0*k2_0 + 4046046476281854747344526139374064*x8_3*x2_0*k2_0 + 2383725737343512219010917321881896*x8_2*x2_0*k2_0 + 1544752989802907350957177068734928*x8_1*x2_0*k2_0 + 1336647777665543647328022902114328*x2_4*x8_0*k2_0 + 4046046476281854747344526139374064*x2_3*x8_0*k2_0 + 2383725737343512219010917321881896*x2_2*x8_0*k2_0 + 1544752989802907350957177068734928*x2_1*x8_0*k2_0 + 1023847862111446462555753870167553*x2_0*x8_0*k2_0 + 6*x13_2*x2_2 + k(6)//k(5)*x10_2*x2_2 + 4*x2_3*x13_1 + k(4)//k(5)*x2_3*x10_1 + 4*x13_3*x2_1 + k(4)//k(5)*x10_3*x2_1 + x2_4*x13_0 + k(1)//k(5)*x2_4*x10_0 + x13_4*x2_0 + k(1)//k(5)*x10_4*x2_0 + x2_4*k_deg_0 - 1336647777665543647328022902114328*x1_4*k1_0 - 4046046476281854747344526139374064*x1_3*k1_0 - 2383725737343512219010917321881896*x1_2*k1_0 - 1544752989802907350957177068734928*x1_1*k1_0 - 1023847862111446462555753870167553*x1_0*k1_0 + x2_4*k3_0 - x4_4*t1_0 - x5_4*t2_0 + x2_5,
		x1_4*k_deg_0 + 1336647777665543647328022902114328*x1_4*k1_0 + 4046046476281854747344526139374064*x1_3*k1_0 + 2383725737343512219010917321881896*x1_2*k1_0 + 1544752989802907350957177068734928*x1_1*k1_0 + 1023847862111446462555753870167553*x1_0*k1_0 + x1_5,
		-3*x2_2*x13_1 - 3*x13_2*x2_1 - x2_3*x13_0 - x13_3*x2_0 + x5_3*t2_0 + x5_4,
		-k(3)//k(5)*x2_2*x10_1 - k(3)//k(5)*x10_2*x2_1 - k(1)//k(5)*x2_3*x10_0 - k(1)//k(5)*x10_3*x2_0 + x4_3*t1_0 + x4_4,
		x8_3*c5_0 + x8_4 - k(1)//k(2)*x9_3,
		x9_3 - k(1)//k(2000000)*x7_2 + k(1)//k(2500)*x9_2,
		-x2_4 + k(40288118035843870963472063938808893128100901054395084268612096915011756053988250983167745524856234714444843704132937040998551640300905747111823407158163551867542006089702464270364181343014321718283764721619514243726733602446783572672848607825635395669474062254332302018975968247967785527946827611696515997689007663145598917517725400331985658755225961506817402069545815073011169396159757047925456414989080843541164679989991539649919964774591)//k(1000000000000),
		-x13_4 - x10_4 + k(57977192747881802555064416651194090624843579400480934221977378764167837787092424651817729384008486636020231170830699447693785447566827820203050593985071161366590613660499064283939317751623894151382165544959276541778185058875724156621386340085767353448301078758999822117243201610553805469502968817598157468549805970821353484957941822265136786980723687089358779166818217804291922117)//k(1250000000000000000),
		k(6)//k(5)*x10_2*x2_2 + 3*x10_2*x6_2 + k(4)//k(5)*x2_3*x10_1 + 2*x6_3*x10_1 + k(4)//k(5)*x10_3*x2_1 + 2*x10_3*x6_1 + k(1)//k(5)*x2_4*x10_0 + k(1)//k(2)*x6_4*x10_0 + k(1)//k(5)*x10_4*x2_0 + k(1)//k(2)*x10_4*x6_0 - x12_4*c_4a_0 + x10_4*i_1a_0 + x10_5 - k(1)//k(2000)*x11_4 + k(1)//k(10000)*x10_4,
		6*x13_2*x2_2 - 3*x10_2*x6_2 + 4*x2_3*x13_1 - 2*x6_3*x10_1 + 4*x13_3*x2_1 - 2*x10_3*x6_1 + x2_4*x13_0 - k(1)//k(2)*x6_4*x10_0 + x13_4*x2_0 - k(1)//k(2)*x10_4*x6_0 - x14_4*e_2a_0 + x13_5 + k(1)//k(50000)*x13_4,
		k(3)//k(2)*x6_2*x10_1 + k(3)//k(2)*x10_2*x6_1 + k(1)//k(2)*x6_3*x10_0 + k(1)//k(2)*x10_3*x6_0 - x5_3*t2_0 + x6_3*i1_0 + x6_4 - k(1)//k(50000)*x13_3,
		k(3)//k(2)*x7_2*x11_1 + k(3)//k(2)*x11_2*x7_1 + k(1)//k(2)*x7_3*x11_0 + k(1)//k(2)*x11_3*x7_0 - 5*x10_3*i_1a_0 + x11_4 + k(1)//k(400)*x11_3,
		x12_3*c_3a_0 + x12_4 - k(1)//k(2000000)*x7_3,
		-k(3)//k(2)*x7_2*x11_1 - k(3)//k(2)*x11_2*x7_1 - k(1)//k(2)*x7_3*x11_0 - k(1)//k(2)*x11_3*x7_0 + 5*x14_3*e_2a_0 + x14_4,
		-x7_4 - k(100719703522946580858911191276127603396851625688668810737498111372030992961946479828533058385642252118440853363143812757032392570519791622232154821623065071725079149603766204669595432797141773484579009909112208287137959285534199146551871883611)//k(625000000000),
		3*x11_2*x7_2 + 2*x7_3*x11_1 + 2*x11_3*x7_1 + k(1)//k(2)*x7_4*x11_0 + k(1)//k(2)*x11_4*x7_0 - 5*x6_4*i1_0 + x7_5,
		-x3_5 - x2_5 - x1_5 - k(1260891539635668171529601185690944904604016164797769979966500397338758020467738849243425174578593365981798273668976260270938927035586140083000090533906219627075146817577196856920042879384584271166251792543481123267582335946625169444471561903469421766299225239423141438933416063762713050892321100993311754871581424828622187710848155883111643926020897298625518279058775003992255746815588079673632236638446482560720292476880612833206993885345533328255140910512724007024140261575671)//k(50000000000000000),
		13366477776655436473280229021143280*x8_3*x2_2*k2_0 + 13366477776655436473280229021143280*x2_3*x8_2*k2_0 + 30345348572113910605083946045305480*x2_2*x8_2*k2_0 + 6683238888327718236640114510571640*x8_4*x2_1*k2_0 + 20230232381409273736722630696870320*x8_3*x2_1*k2_0 + 11918628686717561095054586609409480*x8_2*x2_1*k2_0 + 6683238888327718236640114510571640*x2_4*x8_1*k2_0 + 20230232381409273736722630696870320*x2_3*x8_1*k2_0 + 11918628686717561095054586609409480*x2_2*x8_1*k2_0 + 7723764949014536754785885343674640*x2_1*x8_1*k2_0 + 1336647777665543647328022902114328*x8_5*x2_0*k2_0 + 5057558095352318434180657674217580*x8_4*x2_0*k2_0 + 3972876228905853698351528869803160*x8_3*x2_0*k2_0 + 3861882474507268377392942671837320*x8_2*x2_0*k2_0 + 5119239310557232312778769350837765*x8_1*x2_0*k2_0 + 1336647777665543647328022902114328*x2_5*x8_0*k2_0 + 5057558095352318434180657674217580*x2_4*x8_0*k2_0 + 3972876228905853698351528869803160*x2_3*x8_0*k2_0 + 3861882474507268377392942671837320*x2_2*x8_0*k2_0 + 5119239310557232312778769350837765*x2_1*x8_0*k2_0 + 200927688232820355363963286677475*x2_0*x8_0*k2_0 + 10*x2_3*x13_2 + 2*x2_3*x10_2 + 10*x13_3*x2_2 + 2*x10_3*x2_2 + 5*x2_4*x13_1 + x2_4*x10_1 + 5*x13_4*x2_1 + x10_4*x2_1 + x2_5*x13_0 + k(1)//k(5)*x2_5*x10_0 + x13_5*x2_0 + k(1)//k(5)*x10_5*x2_0 + x2_5*k_deg_0 - 1336647777665543647328022902114328*x1_5*k1_0 - 5057558095352318434180657674217580*x1_4*k1_0 - 3972876228905853698351528869803160*x1_3*k1_0 - 3861882474507268377392942671837320*x1_2*k1_0 - 5119239310557232312778769350837765*x1_1*k1_0 - 200927688232820355363963286677475*x1_0*k1_0 + x2_5*k3_0 - x4_5*t1_0 - x5_5*t2_0 + x2_6,
		x1_5*k_deg_0 + 1336647777665543647328022902114328*x1_5*k1_0 + 5057558095352318434180657674217580*x1_4*k1_0 + 3972876228905853698351528869803160*x1_3*k1_0 + 3861882474507268377392942671837320*x1_2*k1_0 + 5119239310557232312778769350837765*x1_1*k1_0 + 200927688232820355363963286677475*x1_0*k1_0 + x1_6,
		-13366477776655436473280229021143280*x8_3*x2_2*k2_0 - 13366477776655436473280229021143280*x2_3*x8_2*k2_0 - 30345348572113910605083946045305480*x2_2*x8_2*k2_0 - 6683238888327718236640114510571640*x8_4*x2_1*k2_0 - 20230232381409273736722630696870320*x8_3*x2_1*k2_0 - 11918628686717561095054586609409480*x8_2*x2_1*k2_0 - 6683238888327718236640114510571640*x2_4*x8_1*k2_0 - 20230232381409273736722630696870320*x2_3*x8_1*k2_0 - 11918628686717561095054586609409480*x2_2*x8_1*k2_0 - 7723764949014536754785885343674640*x2_1*x8_1*k2_0 - 1336647777665543647328022902114328*x8_5*x2_0*k2_0 - 5057558095352318434180657674217580*x8_4*x2_0*k2_0 - 3972876228905853698351528869803160*x8_3*x2_0*k2_0 - 3861882474507268377392942671837320*x8_2*x2_0*k2_0 - 5119239310557232312778769350837765*x8_1*x2_0*k2_0 - 1336647777665543647328022902114328*x2_5*x8_0*k2_0 - 5057558095352318434180657674217580*x2_4*x8_0*k2_0 - 3972876228905853698351528869803160*x2_3*x8_0*k2_0 - 3861882474507268377392942671837320*x2_2*x8_0*k2_0 - 5119239310557232312778769350837765*x2_1*x8_0*k2_0 - 200927688232820355363963286677475*x2_0*x8_0*k2_0 + x3_5*k_deg_0 - x2_5*k3_0 + x3_6,
		-k(6)//k(5)*x10_2*x2_2 - k(4)//k(5)*x2_3*x10_1 - k(4)//k(5)*x10_3*x2_1 - k(1)//k(5)*x2_4*x10_0 - k(1)//k(5)*x10_4*x2_0 + x4_4*t1_0 + x4_5,
		-6*x13_2*x2_2 - 4*x2_3*x13_1 - 4*x13_3*x2_1 - x2_4*x13_0 - x13_4*x2_0 + x5_4*t2_0 + x5_5,
		x8_4*c5_0 + x8_5 - k(1)//k(2)*x9_4,
		x9_4 - k(1)//k(2000000)*x7_3 + k(1)//k(2500)*x9_3,
		-x2_5 - k(1095235573929514078286055157428301796888988100334602736286809545428616940947937567912922031653871249227953695968405574496308836918348353186079514749826800301283379846994868096922060837742743125197343088331061685231920514592524010486423959043208815231373887431339122714594577856856997351279974941909555991761375508394486661433355801735397367571835750125930907350548793291226585745002710075333007593622398312664503692888373886305505169529195315247241933751993089401755276977583990068234495887779890958990884878492171362076489226524379453375975671)//k(50000000000000000),
		-x13_5 - x10_5 - k(1576114424544585214412001482113681130755020205997212474958125496665711090146445691788559743171091444865518028899285473560744158589087693317362161889664290413068133913680038393120979859799774388902486550261443249689531776925936110349138968756800371943732367307472599439194071479546392088460992898860383500561113114905616018258880626935500114914644715518339755078347521197800441819714898557147421174091292517366056694851707921456888938740722032018465559231536651013564454106227116801117)//k(62500000000000000000000),
		10*x2_3*x13_2 - 5*x6_3*x10_2 + 10*x13_3*x2_2 - 5*x10_3*x6_2 + 5*x2_4*x13_1 - k(5)//k(2)*x6_4*x10_1 + 5*x13_4*x2_1 - k(5)//k(2)*x10_4*x6_1 + x2_5*x13_0 - k(1)//k(2)*x6_5*x10_0 + x13_5*x2_0 - k(1)//k(2)*x10_5*x6_0 - x14_5*e_2a_0 + x13_6 + k(1)//k(50000)*x13_5,
		2*x2_3*x10_2 + 5*x6_3*x10_2 + 2*x10_3*x2_2 + 5*x10_3*x6_2 + x2_4*x10_1 + k(5)//k(2)*x6_4*x10_1 + x10_4*x2_1 + k(5)//k(2)*x10_4*x6_1 + k(1)//k(5)*x2_5*x10_0 + k(1)//k(2)*x6_5*x10_0 + k(1)//k(5)*x10_5*x2_0 + k(1)//k(2)*x10_5*x6_0 - x12_5*c_4a_0 + x10_5*i_1a_0 + x10_6 - k(1)//k(2000)*x11_5 + k(1)//k(10000)*x10_5,
		3*x11_2*x7_2 + 2*x7_3*x11_1 + 2*x11_3*x7_1 + k(1)//k(2)*x7_4*x11_0 + k(1)//k(2)*x11_4*x7_0 - 5*x10_4*i_1a_0 + x11_5 + k(1)//k(400)*x11_4,
		-3*x11_2*x7_2 - 2*x7_3*x11_1 - 2*x11_3*x7_1 - k(1)//k(2)*x7_4*x11_0 - k(1)//k(2)*x11_4*x7_0 + 5*x14_4*e_2a_0 + x14_5,
		x12_4*c_3a_0 + x12_5 - k(1)//k(2000000)*x7_4,
		3*x10_2*x6_2 + 2*x6_3*x10_1 + 2*x10_3*x6_1 + k(1)//k(2)*x6_4*x10_0 + k(1)//k(2)*x10_4*x6_0 - x5_4*t2_0 + x6_4*i1_0 + x6_5 - k(1)//k(50000)*x13_4,
		-x2_6 + k(29774062946635889714006341297964878817710922345959035151505433052170469473611243254102577156928754816926798353959097018515881620718336295084282024250036796430998896880321200646260554934190885504246802549640346513866288418515006068565307849157609922923496811091851675554534136156921883867701708670603106268423316705278810258101802572648323287458523487230669136205179015078214574863328670968014212088845289905834561099680815698560887481362126367704787434381970063019030625772038152698947671111489623714416352785333544410305993496510203948475985932348357116338083168655103670417175037587856719806844658348467741368360941359530422061879156983646823071)//k(2500000000000000000000),
		26732955553310872946560458042286560*x2_3*x8_3*k2_0 + 20049716664983154709920343531714920*x8_4*x2_2*k2_0 + 60690697144227821210167892090610960*x8_3*x2_2*k2_0 + 20049716664983154709920343531714920*x2_4*x8_2*k2_0 + 60690697144227821210167892090610960*x2_3*x8_2*k2_0 + 35755886060152683285163759828228440*x2_2*x8_2*k2_0 + 8019886665993261883968137412685968*x8_5*x2_1*k2_0 + 30345348572113910605083946045305480*x8_4*x2_1*k2_0 + 23837257373435122190109173218818960*x8_3*x2_1*k2_0 + 23171294847043610264357656031023920*x8_2*x2_1*k2_0 + 8019886665993261883968137412685968*x2_5*x8_1*k2_0 + 30345348572113910605083946045305480*x2_4*x8_1*k2_0 + 23837257373435122190109173218818960*x2_3*x8_1*k2_0 + 23171294847043610264357656031023920*x2_2*x8_1*k2_0 + 30715435863343393876672616105026590*x2_1*x8_1*k2_0 + 1336647777665543647328022902114328*x8_6*x2_0*k2_0 + 6069069714422782121016789209061096*x8_5*x2_0*k2_0 + 5959314343358780547527293304704740*x8_4*x2_0*k2_0 + 7723764949014536754785885343674640*x8_3*x2_0*k2_0 + 15357717931671696938336308052513295*x8_2*x2_0*k2_0 + 1205566129396922132183779720064850*x8_1*x2_0*k2_0 + 1336647777665543647328022902114328*x2_6*x8_0*k2_0 + 6069069714422782121016789209061096*x2_5*x8_0*k2_0 + 5959314343358780547527293304704740*x2_4*x8_0*k2_0 + 7723764949014536754785885343674640*x2_3*x8_0*k2_0 + 15357717931671696938336308052513295*x2_2*x8_0*k2_0 + 1205566129396922132183779720064850*x2_1*x8_0*k2_0 + 671809299877339573998415772096967*x2_0*x8_0*k2_0 + 20*x13_3*x2_3 + 4*x10_3*x2_3 + 15*x2_4*x13_2 + 3*x2_4*x10_2 + 15*x13_4*x2_2 + 3*x10_4*x2_2 + 6*x2_5*x13_1 + k(6)//k(5)*x2_5*x10_1 + 6*x13_5*x2_1 + k(6)//k(5)*x10_5*x2_1 + x2_6*x13_0 + k(1)//k(5)*x2_6*x10_0 + x13_6*x2_0 + k(1)//k(5)*x10_6*x2_0 + x2_6*k_deg_0 - 1336647777665543647328022902114328*x1_6*k1_0 - 6069069714422782121016789209061096*x1_5*k1_0 - 5959314343358780547527293304704740*x1_4*k1_0 - 7723764949014536754785885343674640*x1_3*k1_0 - 15357717931671696938336308052513295*x1_2*k1_0 - 1205566129396922132183779720064850*x1_1*k1_0 - 671809299877339573998415772096967*x1_0*k1_0 + x2_6*k3_0 - x4_6*t1_0 - x5_6*t2_0 + x2_7,
		-2*x2_3*x10_2 - 2*x10_3*x2_2 - x2_4*x10_1 - x10_4*x2_1 - k(1)//k(5)*x2_5*x10_0 - k(1)//k(5)*x10_5*x2_0 + x4_5*t1_0 + x4_6,
		-10*x2_3*x13_2 - 10*x13_3*x2_2 - 5*x2_4*x13_1 - 5*x13_4*x2_1 - x2_5*x13_0 - x13_5*x2_0 + x5_5*t2_0 + x5_6,
		x8_5*c5_0 + x8_6 - k(1)//k(2)*x9_5,
		x9_5 - k(1)//k(2000000)*x7_4 + k(1)//k(2500)*x9_4,
		-x3_6 - x2_6 - x1_6 + k(34277433059720083991378302202315926802787860320361821993500770001535271874264072245266359833612140388626607662362569204619881760130953408911454066006584360195946188421969874703916059511287209228782064937403819858509252218086404173212339383508815820148924511717504956145996331226160883163415514397979944130025230270371683911420796720252408368738121619572982265661916901010209873851402843244664463992686746995828845705672083576428774027716684004976334557308892980071651556405274507012395756619926685929402051024911717245840303404905234048668535244314474302631072203639020543940423071)//k(2500000000000000000000),
		-x12_2 + k(1060671240449538741101972212403281857127493654537145517731415072069643600066885521016293537028520963253)//k(200000),
		-x12_3 - k(194279774519736500682136657639506737412853320649547930227804221693942199369238287281521258199396857896379659753106694244474190502516733611)//k(500000000),
		-x12_4 + k(711712156378305245912297487219212778981722092186766630453789705679176854745012109022451300613790241135565123637420325767689572062535968964008721068388188377820890308816652361)//k(25000000000000),
		-x12_5 - k(100719703522946580858911191276130210637851306792410070829175830333215335176707793842548572495781940173477069675283929312572536885437978977135574876482624601856361369055217611524554917411782459266970185587642667521693636615268629133221970133611)//k(1250000000000000000),
		-x2_7 - k(809410181199326403842656295578526129858397249323680753226177876956830627895550285734140240657638468554445955139016679457799884796255959532481027222969353275397554894492605065223994823728146124246405171544286592301116722926803463127104446843667769537214557786424114558355219044961647900073018389315042034682651710257244613212644764174270368094414491604359874214653567573384986396864983383620115437134828967904775666366042550295290689987001763838167085092483101707804509957382058173854687863409209406651285605332370977207560626501003554260378044152562764288294228478675641132472082339987572535782340868089942327767606330617267660445910431464554273994678238137505166333867537797960328534591548718065656400369207471049848268169401135618647114882537142071)//k(125000000000000000000000000),
		-x9_1 - k(3254677403040414629977252171957963)//k(10000),
		-x9_2 + k(671887379925908962920916122800783935728559793314976435838898026693)//k(1562500),
		-x9_3 - k(64139998170306034875546993031896358624993482812782259062785839786166066801269772533346489848689477315963)//k(62500000000),
		-x9_4 + k(267406225589883283421279924329617664662831066174355477827919796275964526085136133704839683286273714043131168957254082076297487600218056822877)//k(625000000000000),
		-x9_5 - k(503598517614732904294555956380638016984258128443344053687490556860154964809732399142665291928211260593273891718078596918847082549917428769812098372812747269937074933122689127688521698805067600567989905718085717264706124732860946133631586709563)//k(6250000000000000000),
		-x13_6 - x10_6 + k(42846791324650104989222877752894908503484825400452277491875962501708774253012327961864361341265760437378692853609592475600852311438244539845541021008093200587913724566660944260226152542162476458965317389045749241536709800227222223659233239461547069339163196843056715306964363246015510157163696050304617410831581214971186040778221839052441075790691653368628595459515448454894466846993311721034072635078571597005628619345556147439811010079237394738018910208689573516081033506160759855301849567877752077599304410182552006710696441955424980362183006989603190763778673846006901883146047346117)//k(3125000000000000000000000000),
		-x7_5 + k(2738072853038748781659896476340540471018717490408491299340947725716871039026412035853683595493716873657877483155374246745702337586856748574173205729356310840995773371516655652317759574759902304078665746129014585345662291556384777421286437251366314875285094760215166146400654658160394298596917831433578670114458862798916294122437692982258929364861)//k(31250000000000000),
		z_aux - 1
    ]
end
