```@meta
CurrentModule = MathOptInterface
DocTestSetup = quote
    import MathOptInterface as MOI
end
DocTestFilters = [r"MathOptInterface|MOI"]
```

# The `Benchmarks` submodule

To aid the development of efficient solver wrappers, MathOptInterface provides
benchmarking capability. Benchmarking a wrapper follows a two-step process.

First, prior to making changes, create a baseline for the benchmark results on a
given benchmark suite as follows:

```julia
using SolverPackage  # Replace with your choice of solver.
import MathOptInterface as MOI

suite = MOI.Benchmarks.suite() do
    SolverPackage.Optimizer()
end

MOI.Benchmarks.create_baseline(
    suite, "current"; directory = "/tmp", verbose = true
)
```
Use the `exclude` argument to [`Benchmarks.suite`](@ref) to
exclude benchmarks that the solver doesn't support.

Second, after making changes to the package, re-run the benchmark suite and
compare to the prior saved results:

```julia
using SolverPackage
import MathOptInterface as MOI

suite = MOI.Benchmarks.suite() do
    SolverPackage.Optimizer()
end

MOI.Benchmarks.compare_against_baseline(
    suite, "current"; directory = "/tmp", verbose = true
)
```

This comparison will create a report detailing improvements and regressions.
