# [Tutorials and Publications](@id tutandpub)

This list has a number of notebooks with tutorials, examples, and reproduction of published results (some of these results originally obtained with this very library).

## On the topic of explicit use of the Tableaux formalism for Stabilizer states 

- [Quantum coding with low-depth random circuits](https://github.com/QuantumSavory/QuantumClifford.jl/blob/master/docs/src/notebooks/Stabilizer_Codes_Based_on_Random_Circuits.ipynb) reproducing results from [gullans2021quantum](@cite). [view on nbviewer.jupyter.org](https://nbviewer.jupyter.org/github/QuantumSavory/QuantumClifford.jl/blob/master/docs/src/notebooks/Stabilizer_Codes_Based_on_Random_Circuits.ipynb)


## On the Monte Carlo and Perturbative Expansions for **Noisy** Clifford circuits

- [In-depth study of multi-partite entanglement purification circuits](https://github.com/QuantumSavory/QuantumClifford.jl/blob/master/docs/src/notebooks/Noisy_Circuits_Tutorial_with_Purification_Circuits.ipynb) reproducing results from [krastanov2020heterogeneous](@cite). [view on nbviewer.jupyter.org](https://nbviewer.jupyter.org/github/QuantumSavory/QuantumClifford.jl/blob/master/docs/src/notebooks/Noisy_Circuits_Tutorial_with_Purification_Circuits.ipynb)
- [Comparing the Monte Carlo and Perturbative method for noisy circuit simulations](https://github.com/QuantumSavory/QuantumClifford.jl/blob/master/docs/src/notebooks/Perturbative_Expansions_vs_Monte_Carlo_Simulations.ipynb). [view on nbviewer.jupyter.org](https://nbviewer.jupyter.org/github/QuantumSavory/QuantumClifford.jl/blob/master/docs/src/notebooks/Perturbative_Expansions_vs_Monte_Carlo_Simulations.ipynb)
- [Showcasing symbolic perturbative expansions of noisy circuits](https://github.com/QuantumSavory/QuantumClifford.jl/blob/master/docs/src/notebooks/Symbolic_Perturbative_Expansions.ipynb). [view on nbviewer.jupyter.org](https://nbviewer.jupyter.org/github/QuantumSavory/QuantumClifford.jl/blob/master/docs/src/notebooks/Symbolic_Perturbative_Expansions.ipynb)
