# The complete functionality of LibSixel consists of three parts:
#
# 1. [libsixel_jll], the pre-built [libsixel] artifacts using [BinaryBuilder]
# 2. `CModule.jl`, the C wrapper generated by [Clang.jl] using codes in `$PROJECT_ROOT/gen/`
# 3. The julia high-level interfaces that hides the C details.
#
# # Links
# 
# [libsixel_jll]: https://github.com/JuliaBinaryWrappers/libsixel_jll.jl
# [libsixel]: https://github.com/saitoha/libsixel
# [BinaryBuilder]: https://github.com/JuliaPackaging/BinaryBuilder.jl
# [Clang.jl]: https://github.com/JuliaInterop/Clang.jl


# The high-level libsixel APIs do not support custom IO types. Hence here we provide our Julia
# flavor high-level API by wrapping the low-level libsixel API `sixel_encode` and
# `sixel_decode`/`sixel_decode_raw`

module LibSixel

export LibSixelEncoder, LibSixelDecoder

using ..SixelInterface
import ..SixelInterface: canonical_sixel_eltype

# This file is auto-generated by Clang.jl and is not expected to be modified directly.
# However, there're still some methods are modified:
# - `sixel_output_new`: ccall argtype for `priv` is relaxed from `Ptr{Cvoid}` to `Any`
include("CModule.jl")
using .C
include("types.jl")

using ImageCore, OffsetArrays
include("encoder.jl")  # high-level encoder API
include("decoder.jl") # high-level decoder API

end # module
