from amaranth.build import *
from amaranth.vendor import XilinxPlatform


__all__ = ["MicroZedZ020Platform"]


class MicroZedZ020Platform(XilinxPlatform):
    device     = "xc7z020"
    package    = "clg400"
    speed      = "1"
    resources  = []
    connectors = [
        Connector("JX1", 0,
            "F9  J6  "
            "F6  G6  "
            "-   -   "
            "-   R11 "
            "R19 T19 "
            "T11 T12 "
            "T10 U12 "
            "-   -   "
            "U13 V12 "
            "V13 W13 "
            "-   -   "
            "T14 P14 "
            "T15 R14 "
            "-   -   "
            "Y16 Y17 "
            "W14 Y14 "
            "-   -   "
            "T16 V15 "
            "U17 W15 "
            "-   -   "
            "U14 U18 "
            "U15 U19 "
            "-   -   "
            "N18 N20 "
            "P19 P20 "
            "-   -   "
            "T20 V20 "
            "U20 W20 "
            "-   -   "
            "-   -   "
            "Y18 V16 "
            "Y19 W16 "
            "-   -   "
            "R16 T17 "
            "R17 R18 "
            "-   -   "
            "V17 W18 "
            "V18 W19 "
            "-   -   "
            "-   -   "
            "N17 P15 "
            "P18 P16 "
            "-   -   "
            "U7  T9  "
            "V7  U10 "
            "V8  T5  "
            "W8  U5  "
            "-   -   "
            "K9  M9  "
            "L10 M10 "
        ),
        Connector("JX2", 0,
            "E8  E9  "
            "C6  D9  "
            "E6  B5  "
            "C5  C8  "
            "R10 -   "
            "C7  -   "
            "G14 J15 "
            "-   -   "
            "C20 B19 "
            "B20 A20 "
            "-   -   "
            "E17 D19 "
            "D18 D20 "
            "-   -   "
            "E18 F16 "
            "E19 F17 "
            "-   -   "
            "L19 M19 "
            "L20 M20 "
            "-   -   "
            "M17 K19 "
            "M18 J19 "
            "-   -   "
            "L16 K17 "
            "L17 K18 "
            "-   -   "
            "H16 J18 "
            "H17 H18 "
            "-   -   "
            "-   -   "
            "G17 F19 "
            "G18 F20 "
            "-   -   "
            "G19 J20 "
            "G20 H20 "
            "-   -   "
            "K14 H15 "
            "J14 G15 "
            "-   -   "
            "-   -   "
            "N15 L14 "
            "N16 L15 "
            "-   -   "
            "M14 K16 "
            "M15 J16 "
            "-   -   "
            "Y12 V11 "
            "Y13 V10 "
            "V6  -   "
            "W6  V5  "
        ),
    ]
