/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.immutable.reference;

import com.android.tools.smali.dexlib2.base.reference.BaseTypeReference;
import com.android.tools.smali.dexlib2.iface.reference.TypeReference;
import com.android.tools.smali.dexlib2.immutable.reference.ImmutableReference;
import com.android.tools.smali.util.ImmutableConverter;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ImmutableTypeReference
extends BaseTypeReference
implements ImmutableReference {
    @Nonnull
    protected final String type;
    private static final ImmutableConverter<ImmutableTypeReference, TypeReference> CONVERTER = new ImmutableConverter<ImmutableTypeReference, TypeReference>(){

        @Override
        protected boolean isImmutable(@Nonnull TypeReference item) {
            return item instanceof ImmutableTypeReference;
        }

        @Override
        @Nonnull
        protected ImmutableTypeReference makeImmutable(@Nonnull TypeReference item) {
            return ImmutableTypeReference.of(item);
        }
    };

    public ImmutableTypeReference(String type) {
        this.type = type;
    }

    @Nonnull
    public static ImmutableTypeReference of(@Nonnull TypeReference typeReference) {
        if (typeReference instanceof ImmutableTypeReference) {
            return (ImmutableTypeReference)typeReference;
        }
        return new ImmutableTypeReference(typeReference.getType());
    }

    @Override
    @Nonnull
    public String getType() {
        return this.type;
    }

    @Nonnull
    public static List<ImmutableTypeReference> immutableListOf(@Nullable List<? extends TypeReference> list) {
        return CONVERTER.toList(list);
    }
}

