/*
 * Decompiled with CFR 0.152.
 */
package apdu4j.pcsc;

import apdu4j.core.APDUBIBO;
import apdu4j.core.BIBO;
import apdu4j.core.CommandAPDU;
import apdu4j.core.HexUtils;
import apdu4j.core.ResponseAPDU;
import apdu4j.pcsc.CardBIBO;
import apdu4j.pcsc.PCSCReader;
import apdu4j.pcsc.PinPadTerminal;
import apdu4j.pcsc.ReaderAliases;
import apdu4j.pcsc.SCard;
import apdu4j.pcsc.terminals.LoggingCardTerminal;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.smartcardio.Card;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CardTerminals;
import javax.smartcardio.TerminalFactory;
import jnasmartcardio.Smartcardio;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TerminalManager {
    private static final Logger logger = LoggerFactory.getLogger(TerminalManager.class);
    public static final String LIB_PROP = "sun.security.smartcardio.library";
    private static final String debian64_path = "/usr/lib/x86_64-linux-gnu/libpcsclite.so.1";
    private static final String ubuntu_path = "/lib/libpcsclite.so.1";
    private static final String ubuntu32_path = "/lib/i386-linux-gnu/libpcsclite.so.1";
    private static final String ubuntu64_path = "/lib/x86_64-linux-gnu/libpcsclite.so.1";
    private static final String freebsd_path = "/usr/local/lib/libpcsclite.so";
    private static final String fedora64_path = "/usr/lib64/libpcsclite.so.1";
    private static final String raspbian_path = "/usr/lib/arm-linux-gnueabihf/libpcsclite.so.1";
    private final TerminalFactory factory;
    private ThreadLocal<CardTerminals> threadLocalTerminals = ThreadLocal.withInitial(() -> null);

    public static TerminalManager getDefault() {
        return new TerminalManager(TerminalManager.getTerminalFactory());
    }

    public TerminalManager(TerminalFactory factory) {
        this.factory = factory;
    }

    public CardTerminals terminals() {
        return this.terminals(false);
    }

    public CardTerminals terminals(boolean fresh) {
        CardTerminals terms = this.threadLocalTerminals.get();
        if (terms != null && fresh && terms instanceof Smartcardio.JnaCardTerminals) {
            try {
                ((Smartcardio.JnaCardTerminals)terms).close();
            }
            catch (Smartcardio.JnaPCSCException e) {
                logger.warn("Could not release context: {}", (Object)SCard.getExceptionMessage(e), (Object)e);
            }
        }
        if (terms == null || fresh) {
            terms = this.factory.terminals();
            this.threadLocalTerminals.set(terms);
        }
        return terms;
    }

    public TerminalFactory getFactory() {
        return this.factory;
    }

    public CardTerminal getTerminal(String name) {
        return this.terminals().getTerminal(name);
    }

    public static boolean isEnabled(String feature, boolean def) {
        return Boolean.parseBoolean(System.getProperty(feature, System.getenv().getOrDefault("_" + feature.toUpperCase().replace(".", "_"), Boolean.toString(def))));
    }

    public static String detectLibraryPath() {
        String os = System.getProperty("os.name");
        if (os.equalsIgnoreCase("Linux")) {
            if (System.getProperty("os.arch").contains("64")) {
                if (new File(debian64_path).exists()) {
                    return debian64_path;
                }
                if (new File(fedora64_path).exists()) {
                    return fedora64_path;
                }
                if (new File(ubuntu64_path).exists()) {
                    return ubuntu64_path;
                }
            } else {
                if (new File(ubuntu_path).exists()) {
                    return ubuntu_path;
                }
                if (new File(ubuntu32_path).exists()) {
                    return ubuntu32_path;
                }
                if (new File(raspbian_path).exists()) {
                    return raspbian_path;
                }
            }
        } else if (os.equalsIgnoreCase("FreeBSD")) {
            if (new File(freebsd_path).exists()) {
                return freebsd_path;
            }
            System.err.println("Hint: pcsc-lite is missing. pkg install devel/libccid");
        } else if (os.equalsIgnoreCase("Mac OS X")) {
            return "/System/Library/Frameworks/PCSC.framework/PCSC";
        }
        return null;
    }

    public static void fixPlatformPaths() {
        Optional<String> lib = Optional.ofNullable(TerminalManager.detectLibraryPath());
        if (System.getProperty(LIB_PROP) == null && lib.isPresent()) {
            System.setProperty(LIB_PROP, lib.get());
        }
    }

    public static TerminalFactory getTerminalFactory() {
        try {
            return TerminalFactory.getInstance("PC/SC", null, new Smartcardio());
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("jnasmartcardio not bundled or pcsc-lite not available");
            TerminalManager.fixPlatformPaths();
            return TerminalFactory.getDefault();
        }
    }

    public static List<CardTerminal> byATR(List<CardTerminal> terminals, Collection<byte[]> atrs) {
        return terminals.stream().filter(t -> {
            try {
                if (t.isCardPresent()) {
                    Card c = t.connect("DIRECT");
                    byte[] atr = c.getATR().getBytes();
                    c.disconnect(false);
                    return atrs.stream().anyMatch(a -> Arrays.equals(a, atr));
                }
                return false;
            }
            catch (CardException e) {
                logger.debug("Failed to get ATR: " + e.getMessage(), e);
                return false;
            }
        }).collect(Collectors.toList());
    }

    public static List<CardTerminal> byATR(CardTerminals terminals, Collection<byte[]> atrs) throws CardException {
        List<CardTerminal> tl = terminals.list(CardTerminals.State.ALL);
        return TerminalManager.byATR(tl, atrs);
    }

    public static List<CardTerminal> byFilter(List<CardTerminal> terminals, Function<BIBO, Boolean> f) {
        return terminals.stream().filter(t -> {
            if (!t.isCardPresent()) return false;
            CardBIBO b = CardBIBO.wrap(t.connect("*"));
            try {
                boolean bl = (Boolean)f.apply(b);
                if (b == null) return bl;
                b.close();
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    if (b == null) throw throwable;
                    try {
                        b.close();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (CardException e) {
                    logger.debug("Failed to detect card: " + e.getMessage(), e);
                    return false;
                }
            }
        }).collect(Collectors.toList());
    }

    public static Function<BIBO, Boolean> hasAID(Collection<byte[]> aidlist) {
        return bibo -> {
            APDUBIBO b = new APDUBIBO((BIBO)bibo);
            for (byte[] aid : aidlist) {
                CommandAPDU s = new CommandAPDU(0, 164, 4, 0, aid, 256);
                ResponseAPDU r = b.transmit(s);
                if (r.getSW() != 36864) continue;
                logger.debug("matched for AID {}", (Object)HexUtils.bin2hex(aid));
                return true;
            }
            return false;
        };
    }

    public static List<CardTerminal> byAID(List<CardTerminal> terminals, Collection<byte[]> aidlist) {
        return TerminalManager.byFilter(terminals, TerminalManager.hasAID(aidlist));
    }

    public static List<CardTerminal> byAID(Collection<byte[]> aidlist) throws NoSuchAlgorithmException, CardException {
        TerminalFactory tf = TerminalFactory.getInstance("PC/SC", null, new Smartcardio());
        CardTerminals ts = tf.terminals();
        return TerminalManager.byAID(ts.list(), aidlist);
    }

    public static String getVersion() {
        String string;
        block8: {
            Properties prop = new Properties();
            InputStream versionfile = TerminalManager.class.getResourceAsStream("git.properties");
            try {
                prop.load(versionfile);
                string = prop.getProperty("git.commit.id.describe", "unknown-development");
                if (versionfile == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (versionfile != null) {
                        try {
                            versionfile.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return "unknown-error";
                }
            }
            versionfile.close();
        }
        return string;
    }

    public static boolean isContactless(CardTerminal t) {
        return TerminalManager.isContactless(t.getName());
    }

    public static boolean isContactless(String reader) {
        String[] contactless;
        for (String s : contactless = new String[]{"Contactless", " PICC", "KP382", "502-CL", "ACR1255U"}) {
            if (!TerminalManager.fragmentMatches(s, reader)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSpecial(CardTerminal t) {
        return TerminalManager.isSpecial(t.getName());
    }

    public static boolean isSpecial(String reader) {
        String[] special;
        for (String s : special = new String[]{"YubiKey"}) {
            if (!TerminalManager.fragmentMatches(s, reader)) continue;
            return true;
        }
        return false;
    }

    public static <T> Optional<T> toSingleton(Collection<T> collection, Predicate<T> filter) {
        List result = collection.stream().filter(filter).limit(2L).collect(Collectors.toList());
        if (result.size() == 1) {
            return Optional.of(result.get(0));
        }
        return Optional.empty();
    }

    public static Optional<String> hintMatchesExactlyOne(String hint, List<String> hay) {
        if (hint == null) {
            return Optional.empty();
        }
        return TerminalManager.toSingleton(hay, n -> TerminalManager.fragmentMatches(hint, n));
    }

    private static boolean fragmentMatches(String fragment, String longer) {
        return longer.toLowerCase().contains(fragment.toLowerCase());
    }

    public static boolean ignoreReader(String ignoreHints, String readerName) {
        if (ignoreHints != null) {
            String reader = readerName.toLowerCase();
            String[] names = ignoreHints.toLowerCase().split(";");
            return Arrays.stream(names).anyMatch(reader::contains);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static List<PCSCReader> listPCSC(List<CardTerminal> terminals, OutputStream logStream, boolean probePinpad) throws CardException {
        result = new ArrayList<PCSCReader>();
        for (CardTerminal t : terminals) {
            if (logStream != null) {
                t = LoggingCardTerminal.getInstance(t, logStream);
            }
            try {
                name = t.getName();
                present = t.isCardPresent();
                exclusive = false;
                vmd = null;
                atr = null;
                if (present) {
                    c = null;
                    try {
                        c = t.connect("*");
                        atr = c.getATR().getBytes();
                        if (!probePinpad) ** GOTO lbl65
                        vmd = PinPadTerminal.getVMD(t, c);
                    }
                    catch (CardException e) {
                        err = SCard.getExceptionMessage(e);
                        if (err.equals("SCARD_W_UNPOWERED_CARD")) {
                            TerminalManager.logger.warn("Unpowered card. Contact card inserted wrong way or card mute?");
                            present = false;
                        }
                        if (err.equals("SCARD_E_SHARING_VIOLATION")) {
                            exclusive = true;
                            try {
                                c = t.connect("DIRECT");
                                atr = c.getATR().getBytes();
                                if (!probePinpad) ** GOTO lbl65
                                vmd = PinPadTerminal.getVMD(t, c);
                            }
                            catch (CardException e2) {
                                err2 = SCard.getExceptionMessage(e);
                                if (!probePinpad) ** GOTO lbl65
                                if (err2.equals("SCARD_E_SHARING_VIOLATION")) {
                                    vmd = "???";
                                }
                                vmd = "EEE";
                                TerminalManager.logger.debug("Unexpected error: {}", (Object)err2, (Object)e2);
                            }
                        }
                        if (probePinpad) {
                            vmd = "EEE";
                        }
                        TerminalManager.logger.debug("Unexpected error: {}", (Object)err, (Object)e);
                    }
                    finally {
                        if (c != null) {
                            c.disconnect(false);
                        }
                    }
                } else if (probePinpad) {
                    c = null;
                    try {
                        c = t.connect("DIRECT");
                        vmd = PinPadTerminal.getVMD(t, c);
                    }
                    catch (CardException e) {
                        vmd = "EEE";
                        err = SCard.getExceptionMessage(e);
                        TerminalManager.logger.debug("Could not connect to reader in direct mode: {}", (Object)err, (Object)e);
                    }
                    finally {
                        if (c != null) {
                            c.disconnect(false);
                        }
                    }
                }
                result.add(new PCSCReader(name, atr, present, exclusive, vmd));
            }
            catch (CardException e) {
                err = SCard.getExceptionMessage(e);
                TerminalManager.logger.debug("Unexpected PC/SC error: {}", (Object)err, (Object)e);
            }
        }
        return result;
    }

    public static List<PCSCReader> dwimify(List<PCSCReader> readers, String preferHint, String ignoreHints) {
        logger.debug("Processing {} readers with {} as preferred and {} as ignored", readers.size(), preferHint, ignoreHints);
        ReaderAliases aliases = ReaderAliases.getDefault().apply(readers.stream().map(PCSCReader::getName).collect(Collectors.toList()));
        List<String> aliasedNames = readers.stream().map(r -> aliases.extended(r.getName())).collect(Collectors.toList());
        if (readers.size() == 0) {
            return readers;
        }
        Optional<Object> pref = Optional.empty();
        if (preferHint != null && preferHint.matches("\\d{1,2}")) {
            int index = Integer.parseInt(preferHint);
            if (index >= 1 && index <= readers.size()) {
                pref = Optional.of(readers.get(index - 1).getName());
                logger.debug("Chose {} by index {}", pref.get(), (Object)index);
            } else {
                logger.warn("Reader index out of bounds: {} vs {}", (Object)index, (Object)readers.size());
            }
        } else if (preferHint != null) {
            pref = TerminalManager.hintMatchesExactlyOne(preferHint, aliasedNames);
        } else if (readers.size() == 1) {
            readers.get(0).setPreferred(true);
            return readers;
        }
        logger.debug("Preferred reader: " + pref);
        for (PCSCReader r2 : readers) {
            if (pref.isPresent() && ((String)pref.get()).toLowerCase().contains(r2.getName().toLowerCase())) {
                r2.setPreferred(true);
                continue;
            }
            if (!TerminalManager.ignoreReader(ignoreHints, r2.getName())) continue;
            r2.setIgnore(true);
        }
        return readers;
    }

    public static Optional<CardTerminal> getLucky(List<PCSCReader> readers, CardTerminals terminals) {
        Optional<PCSCReader> lucky;
        Optional<PCSCReader> preferred = TerminalManager.toSingleton(readers, e -> e.isPreferred());
        Optional<PCSCReader> chosen = preferred.or(() -> TerminalManager.lambda$getLucky$9(lucky = TerminalManager.toSingleton(readers, e -> !e.isIgnore() && e.isPresent())));
        if (chosen.isPresent()) {
            return Optional.ofNullable(terminals.getTerminal(chosen.get().getName()));
        }
        return Optional.empty();
    }

    public static boolean isMacOS() {
        return System.getProperty("os.name").equalsIgnoreCase("mac os x");
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().startsWith("windows");
    }

    private static /* synthetic */ Optional lambda$getLucky$9(Optional lucky) {
        return lucky;
    }
}

