/*
 * Decompiled with CFR 0.152.
 */
package apdu4j.pcsc.providers;

import apdu4j.core.HexUtils;
import apdu4j.pcsc.providers.EmulatedSingleTerminalProvider;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import javax.smartcardio.ATR;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;

public class APDUReplayProvider
extends EmulatedSingleTerminalProvider {
    static final long serialVersionUID = -8337184383179443730L;
    public static final String READER_NAME = "APDUReplay terminal 0";

    public APDUReplayProvider() {
        super(APDUReplayProviderImpl.class);
    }

    public static final class ReplayTerminal
    extends CardTerminal {
        private static final String PROTOCOL = "# PROTOCOL: ";
        private static final String ATR = "# ATR: ";
        ATR atr;
        String protocol;
        final boolean strict;
        List<byte[]> commands = null;
        List<byte[]> responses = null;

        public synchronized byte[] replay_transmit(byte[] cmd) throws CardException {
            if (this.commands.size() == 0) {
                throw new CardException("Replay script depleted!");
            }
            byte[] expected_cmd = this.commands.remove(0);
            if (this.strict && !Arrays.equals(cmd, expected_cmd)) {
                throw new CardException("replay: expected " + HexUtils.bin2hex(expected_cmd) + " but got " + HexUtils.bin2hex(cmd));
            }
            return this.responses.remove(0);
        }

        private void parseScript(InputStream script_stream) {
            Scanner script = new Scanner(script_stream, StandardCharsets.UTF_8.name());
            this.commands = new ArrayList<byte[]>();
            this.responses = new ArrayList<byte[]>();
            boolean is_cmd = true;
            while (script.hasNextLine()) {
                String l = script.nextLine().trim();
                if (l.startsWith("#")) {
                    if (l.startsWith(ATR)) {
                        this.atr = new ATR(HexUtils.hex2bin(l.substring(ATR.length())));
                        continue;
                    }
                    if (!l.startsWith(PROTOCOL)) continue;
                    this.protocol = l.substring(PROTOCOL.length());
                    continue;
                }
                byte[] r = HexUtils.hex2bin(l);
                if (is_cmd) {
                    this.commands.add(r);
                } else {
                    this.responses.add(r);
                }
                is_cmd = !is_cmd;
            }
            if (this.atr == null || this.protocol == null || this.responses.size() == 0 || this.responses.size() != this.commands.size()) {
                throw new IllegalArgumentException("Incomplete APDU dump!");
            }
        }

        public ReplayTerminal(InputStream script, boolean strict) {
            this.parseScript(script);
            this.strict = strict;
        }

        @Override
        public Card connect(String protocol) throws CardException {
            return new ReplayCard();
        }

        @Override
        public String getName() {
            return APDUReplayProvider.READER_NAME;
        }

        @Override
        public boolean isCardPresent() throws CardException {
            return true;
        }

        @Override
        public boolean waitForCardAbsent(long arg0) throws CardException {
            try {
                Thread.sleep(arg0);
            }
            catch (InterruptedException e) {
                throw new CardException("Interrupted", e);
            }
            return false;
        }

        @Override
        public boolean waitForCardPresent(long arg0) throws CardException {
            return true;
        }

        public final class ReplayCard
        extends Card {
            private final CardChannel basicChannel = new ReplayChannel(this);

            ReplayCard() {
            }

            @Override
            public void beginExclusive() throws CardException {
            }

            @Override
            public void disconnect(boolean reset) throws CardException {
            }

            @Override
            public void endExclusive() throws CardException {
            }

            @Override
            public ATR getATR() {
                return ReplayTerminal.this.atr;
            }

            @Override
            public CardChannel getBasicChannel() {
                return this.basicChannel;
            }

            @Override
            public String getProtocol() {
                return ReplayTerminal.this.protocol;
            }

            @Override
            public CardChannel openLogicalChannel() throws CardException {
                throw new CardException("Logical channels not supported");
            }

            @Override
            public byte[] transmitControlCommand(int arg0, byte[] arg1) throws CardException {
                throw new RuntimeException("Control commands don't make sense");
            }

            public final class ReplayChannel
            extends CardChannel {
                final Card card;

                protected ReplayChannel(Card card) {
                    this.card = card;
                }

                @Override
                public void close() throws CardException {
                    throw new IllegalStateException("Can't close basic channel");
                }

                @Override
                public Card getCard() {
                    return this.card;
                }

                @Override
                public int getChannelNumber() {
                    return 0;
                }

                @Override
                public ResponseAPDU transmit(CommandAPDU apdu) throws CardException {
                    return new ResponseAPDU(ReplayTerminal.this.replay_transmit(apdu.getBytes()));
                }

                @Override
                public int transmit(ByteBuffer arg0, ByteBuffer arg1) throws CardException {
                    byte[] cmd = new byte[arg0.remaining()];
                    arg0.get(cmd);
                    byte[] resp = ReplayTerminal.this.replay_transmit(cmd);
                    arg1.put(resp);
                    return resp.length;
                }
            }
        }
    }

    public static class APDUReplayProviderImpl
    extends EmulatedSingleTerminalProvider.EmulatedTerminalFactorySpi {
        public APDUReplayProviderImpl(Object parameter) {
            super(parameter);
        }

        @Override
        protected CardTerminal getTheTerminal() {
            if (this.parameter instanceof InputStream) {
                return new ReplayTerminal((InputStream)this.parameter, true);
            }
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " requires InputStream parameter");
        }
    }
}

