/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp;

import apdu4j.core.CommandAPDU;
import apdu4j.core.HexUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.interfaces.RSAPrivateKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.javacard.gp.GPCrypto;
import pro.javacard.gp.GPException;
import pro.javacard.gp.GPUtils;

public abstract class DMTokenizer {
    private static final Logger log = LoggerFactory.getLogger(DMTokenizer.class);

    private DMTokenizer() {
    }

    protected abstract byte[] getToken(CommandAPDU var1);

    protected abstract boolean canTokenize(CommandAPDU var1);

    public CommandAPDU tokenize(CommandAPDU apdu) {
        try {
            ByteArrayOutputStream data = new ByteArrayOutputStream();
            data.write(apdu.getData());
            if (!this.canTokenize(apdu)) {
                throw new IllegalArgumentException("No DM token for APDU: " + String.valueOf(apdu));
            }
            byte[] token = this.getToken(apdu);
            if (token.length > 0) {
                if (apdu.getINS() == 228) {
                    data.write(158);
                }
                data.write(GPUtils.encodeLength(token.length));
                data.write(token);
            } else if (apdu.getINS() != 228) {
                data.write(0);
            }
            return new CommandAPDU(apdu.getCLA(), apdu.getINS(), apdu.getP1(), apdu.getP2(), data.toByteArray());
        }
        catch (IOException e) {
            throw new GPException("Could not tokenize APDU: " + e.getMessage(), e);
        }
    }

    protected byte[] dtbs(CommandAPDU apdu) {
        try {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            bo.write(apdu.getP1());
            bo.write(apdu.getP2());
            bo.write(apdu.getData().length);
            bo.write(apdu.getData());
            return bo.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("Memory error", e);
        }
    }

    public static DMTokenizer forPrivateKey(RSAPrivateKey pkey) {
        return new RSATokenizer(pkey);
    }

    public static DMTokenizer forToken(byte[] token) {
        return new StaticTokenizer(token);
    }

    public static DMTokenizer none() {
        return new NULLTokenizer();
    }

    static class RSATokenizer
    extends DMTokenizer {
        private final RSAPrivateKey privateKey;

        RSATokenizer(RSAPrivateKey privateKey) {
            this.privateKey = privateKey;
        }

        @Override
        protected boolean canTokenize(CommandAPDU apdu) {
            return true;
        }

        @Override
        protected byte[] getToken(CommandAPDU apdu) {
            byte[] dtbs = this.dtbs(apdu);
            try {
                byte[] token = GPCrypto.rsa_sign(this.privateKey, dtbs);
                log.trace("DM token: {}", (Object)HexUtils.bin2hex(token));
                return token;
            }
            catch (GeneralSecurityException e) {
                throw new GPException("Can not calculate DM token: " + e.getMessage(), e);
            }
        }
    }

    static class StaticTokenizer
    extends DMTokenizer {
        private final byte[] token;
        private boolean used = false;

        StaticTokenizer(byte[] token) {
            this.token = token;
        }

        @Override
        protected byte[] getToken(CommandAPDU apdu) {
            this.used = true;
            return this.token;
        }

        @Override
        protected boolean canTokenize(CommandAPDU apdu) {
            return !this.used;
        }
    }

    static class NULLTokenizer
    extends DMTokenizer {
        NULLTokenizer() {
        }

        @Override
        protected byte[] getToken(CommandAPDU apdu) {
            return new byte[0];
        }

        @Override
        protected boolean canTokenize(CommandAPDU apdu) {
            return true;
        }
    }
}

