/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public abstract class GPCardProfile {
    public static final Map<String, GPCardProfile> profiles;
    protected boolean useTags = true;
    protected boolean reportsModules = true;
    protected boolean oldStyleSSD = false;

    private GPCardProfile() {
    }

    public boolean getStatusUsesTags() {
        return this.useTags;
    }

    public boolean doesReportModules() {
        return this.reportsModules;
    }

    public boolean oldStyleSSDParameters() {
        return this.oldStyleSSD;
    }

    static GPCardProfile defaultProfile() {
        return new DefaultModernProfile();
    }

    static Optional<GPCardProfile> fromCPLC(byte[] cplc) {
        return Optional.of(GPCardProfile.defaultProfile());
    }

    public static Optional<GPCardProfile> fromName(String name) {
        return Optional.ofNullable(profiles.get(name));
    }

    static {
        LinkedHashMap<String, GPCardProfile> tmp = new LinkedHashMap<String, GPCardProfile>();
        tmp.put("default", GPCardProfile.defaultProfile());
        tmp.put("old", new OldCardProfile());
        profiles = Collections.unmodifiableMap(tmp);
    }

    static class DefaultModernProfile
    extends GPCardProfile {
        DefaultModernProfile() {
        }
    }

    static class OldCardProfile
    extends GPCardProfile {
        OldCardProfile() {
            this.useTags = false;
            this.reportsModules = false;
            this.oldStyleSSD = true;
        }
    }
}

