/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp;

import apdu4j.core.HexUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import pro.javacard.capfile.AID;
import pro.javacard.gp.GPDataException;

public class GPRegistryEntry {
    AID aid;
    int lifecycle;
    Kind kind;
    AID domain;
    private final EnumSet<Privilege> privileges = EnumSet.noneOf(Privilege.class);
    private AID from;
    private byte[] version;
    private final List<AID> modules = new ArrayList<AID>();
    HashSet<Integer> implicitContact = new HashSet();
    HashSet<Integer> implicitContactless = new HashSet();

    GPRegistryEntry() {
    }

    public Set<Privilege> getPrivileges() {
        return Collections.unmodifiableSet(this.privileges);
    }

    void setPrivileges(Set<Privilege> privs) {
        this.privileges.addAll(privs);
    }

    public Optional<AID> getSource() {
        return Optional.ofNullable(this.from);
    }

    void setLoadFile(AID aid) {
        this.from = aid;
    }

    public boolean hasPrivilege(Privilege p) {
        return this.privileges.contains((Object)p);
    }

    public byte[] getVersion() {
        if (this.version == null) {
            return null;
        }
        return (byte[])this.version.clone();
    }

    public boolean equals(Object other) {
        if (other instanceof GPRegistryEntry) {
            GPRegistryEntry o = (GPRegistryEntry)other;
            return o.kind.equals((Object)this.kind) && o.aid.equals(this.aid);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.aid, this.kind});
    }

    void setVersion(byte[] v) {
        this.version = (byte[])v.clone();
    }

    public String getVersionString() {
        if (this.version == null) {
            return "<null>";
        }
        if (this.version.length == 2) {
            return (this.version[0] & 0xFF) + "." + (this.version[1] & 0xFF);
        }
        return "<unknown format " + HexUtils.bin2hex(this.version) + ">";
    }

    public void addModule(AID aid) {
        this.modules.add(aid);
    }

    public List<AID> getModules() {
        return new ArrayList<AID>(this.modules);
    }

    static String getLifeCycleString(Kind kind, int lifeCycleState) {
        switch (kind.ordinal()) {
            case 0: {
                switch (lifeCycleState) {
                    case 1: {
                        return "OP_READY";
                    }
                    case 7: {
                        return "INITIALIZED";
                    }
                    case 15: {
                        return "SECURED";
                    }
                    case 127: {
                        return "CARD_LOCKED";
                    }
                    case 255: {
                        return "TERMINATED";
                    }
                }
                return "ERROR (0x" + Integer.toHexString(lifeCycleState) + ")";
            }
            case 1: {
                if (lifeCycleState == 3) {
                    return "INSTALLED";
                }
                if (lifeCycleState <= 127) {
                    if ((lifeCycleState & 0x78) != 0) {
                        return "SELECTABLE (0x" + Integer.toHexString(lifeCycleState) + ")";
                    }
                    return "SELECTABLE";
                }
                if (lifeCycleState > 131) {
                    return "LOCKED";
                }
                return "ERROR (0x" + Integer.toHexString(lifeCycleState) + ")";
            }
            case 3: {
                if (lifeCycleState == 1) {
                    return "LOADED";
                }
                if (lifeCycleState == 0) {
                    return "LOGICALLY_DELETED";
                }
                return "ERROR (0x" + Integer.toHexString(lifeCycleState) + ")";
            }
            case 2: {
                if (lifeCycleState == 3) {
                    return "INSTALLED";
                }
                if (lifeCycleState == 7) {
                    return "SELECTABLE";
                }
                if (lifeCycleState == 15) {
                    return "PERSONALIZED";
                }
                if ((lifeCycleState & 0x83) == 131) {
                    return "LOCKED";
                }
                return "ERROR (0x" + Integer.toHexString(lifeCycleState) + ")";
            }
        }
        return "ERROR";
    }

    public AID getAID() {
        return this.aid;
    }

    void setAID(AID aid) {
        this.aid = aid;
    }

    public Optional<AID> getDomain() {
        return Optional.ofNullable(this.domain);
    }

    public int getLifeCycle() {
        return this.lifecycle;
    }

    void setLifeCycle(int lifecycle) {
        this.lifecycle = lifecycle;
    }

    public Kind getType() {
        return this.kind;
    }

    void setType(Kind type) {
        this.kind = type;
    }

    public boolean isPackage() {
        return this.kind == Kind.ExecutableLoadFile;
    }

    public boolean isApplet() {
        return this.kind == Kind.Application;
    }

    public boolean isDomain() {
        return this.kind == Kind.SecurityDomain || this.kind == Kind.IssuerSecurityDomain;
    }

    void setDomain(AID dom) {
        this.domain = dom;
    }

    public String toString() {
        return String.format("%s: %s, %s", this.kind.toShortString(), HexUtils.bin2hex(this.aid.getBytes()), this.getLifeCycleString());
    }

    public String getLifeCycleString() {
        return GPRegistryEntry.getLifeCycleString(this.kind, this.lifecycle);
    }

    public Set<Integer> getImplicitlySelectedContact() {
        return Collections.unmodifiableSet(this.implicitContact);
    }

    public Set<Integer> getImplicitlySelectedContactless() {
        return Collections.unmodifiableSet(this.implicitContactless);
    }

    public static enum Privilege {
        SecurityDomain(128, 0),
        DAPVerification(192, 0),
        DelegatedManagement(160, 0),
        CardLock(16, 0),
        CardTerminate(8, 0),
        CardReset(4, 0),
        CVMManagement(2, 0),
        MandatedDAPVerification(193, 0),
        TrustedPath(128, 1),
        AuthorizedManagement(64, 1),
        TokenVerification(32, 1),
        GlobalDelete(16, 1),
        GlobalLock(8, 1),
        GlobalRegistry(4, 1),
        FinalApplication(2, 1),
        GlobalService(1, 1),
        ReceiptGeneration(128, 2),
        CipheredLoadFileDataBlock(64, 2),
        ContactlessActivation(32, 2),
        ContactlessSelfActivation(16, 2),
        PrivacyTrusted(8, 2);

        byte value;
        int pos;

        private Privilege(int value, int pos) {
            this.value = (byte)value;
            this.pos = pos;
        }

        public static Optional<Privilege> lookup(String v) {
            return Arrays.stream(Privilege.values()).filter(e -> e.name().equalsIgnoreCase(v)).findFirst();
        }

        public static Set<Privilege> fromBytes(byte[] v) {
            if (v.length != 1 && v.length != 3) {
                throw new IllegalArgumentException("Privileges must be encoded on 1 or 3 bytes: " + HexUtils.bin2hex(v));
            }
            if (v.length == 3 && (v[2] & 0xF) != 0) {
                throw new GPDataException("RFU bits set in privileges", v);
            }
            LinkedHashSet<Privilege> r = new LinkedHashSet<Privilege>();
            int i = 0;
            while (i < v.length) {
                int p = i++;
                Arrays.stream(Privilege.values()).filter(e -> e.pos == p).forEach(e -> {
                    if (e.value == (e.value & v[p])) {
                        r.add((Privilege)((Object)e));
                    }
                });
            }
            return r;
        }

        static boolean isOneByte(Set<Privilege> privs) {
            return privs.stream().noneMatch(e -> e.pos != 0);
        }

        public static byte[] toBytes(Set<Privilege> privs) {
            byte[] r = new byte[3];
            for (Privilege p : privs) {
                int n = p.pos;
                r[n] = (byte)(r[n] | p.value);
            }
            return r;
        }

        public static byte[] toByteOrBytes(Set<Privilege> privs) {
            byte[] r = Privilege.toBytes(privs);
            if (Privilege.isOneByte(privs)) {
                r = Arrays.copyOf(r, 1);
            }
            return r;
        }

        public static byte toByte(Set<Privilege> privs) {
            if (!Privilege.isOneByte(privs)) {
                throw new IllegalStateException("This privileges set can not be encoded in one byte");
            }
            return Privilege.toBytes(privs)[0];
        }
    }

    public static enum Kind {
        IssuerSecurityDomain,
        Application,
        SecurityDomain,
        ExecutableLoadFile;


        public String toShortString() {
            switch (this.ordinal()) {
                case 0: {
                    return "ISD";
                }
                case 1: {
                    return "APP";
                }
                case 2: {
                    return "DOM";
                }
                case 3: {
                    return "PKG";
                }
            }
            throw new IllegalStateException("Unknown entry type");
        }
    }
}

