/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.pace;

import apdu4j.core.APDUBIBO;
import apdu4j.core.CommandAPDU;
import apdu4j.core.HexUtils;
import apdu4j.core.ResponseAPDU;
import com.payneteasy.tlv.BerTag;
import com.payneteasy.tlv.BerTlv;
import com.payneteasy.tlv.BerTlvBuilder;
import com.payneteasy.tlv.BerTlvParser;
import com.payneteasy.tlv.BerTlvs;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Arrays;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.macs.CMac;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.javacard.pace.AESSecureChannel;
import pro.javacard.pace.PACEException;
import pro.javacard.pace.SCHelpers;

public final class PACE {
    private static final Logger log = LoggerFactory.getLogger(PACE.class);
    private final byte[] keyENC;
    private final byte[] keyMAC;
    private static final byte[] oid = HexUtils.hex2bin("04007F00070202040204");
    static final byte PASSWORD_CAN = 2;
    private static final BerTlvParser parser = new BerTlvParser();
    private static final byte COUNTER_ENC = 1;
    private static final byte COUNTER_MAC = 2;
    private static final byte COUNTER_PI = 3;

    public byte[] getENC() {
        return (byte[])this.keyENC.clone();
    }

    public byte[] getMAC() {
        return (byte[])this.keyMAC.clone();
    }

    private PACE(byte[] keyENC, byte[] keyMAC) {
        this.keyENC = keyENC;
        this.keyMAC = keyMAC;
        log.info("Computed PACE: ENC: {} MAC:{}", (Object)Hex.toHexString(keyENC), (Object)Hex.toHexString(keyMAC));
    }

    public static PACE executePACE(APDUBIBO c, byte[] aid, String can, PACECurve curve) throws PACEException, IOException, GeneralSecurityException {
        ResponseAPDU r = c.transmit(new CommandAPDU(0, 164, 4, 0, aid, 256));
        PACEException.check(r);
        r = c.transmit(PACE.set_at(oid, (byte)2, curve));
        PACEException.check(r);
        r = c.transmit(PACE.general_authenticate(new byte[]{124, 0}));
        r = PACEException.check(r);
        SCHelpers.trace_tlv(r.getData(), log);
        BerTlv encryptedNonce = PACE.require_tag(r.getData(), 128);
        byte[] key = PACE.kdf(can.getBytes(StandardCharsets.UTF_8), (byte)3);
        byte[] nonce = AESSecureChannel.decrypt(key, new byte[16], encryptedNonce.getBytesValue());
        AsymmetricCipherKeyPair host_map = PACE.generate(curve.spec);
        byte[] host_map_pub = ((ECPublicKeyParameters)host_map.getPublic()).getQ().getEncoded(false);
        BerTlvBuilder payload = new BerTlvBuilder(new BerTag(124)).addBytes(new BerTag(129), host_map_pub);
        CommandAPDU apdu2 = PACE.general_authenticate(payload.buildArray());
        SCHelpers.trace_tlv(apdu2.getData(), log);
        r = PACEException.check(c.transmit(apdu2));
        SCHelpers.trace_tlv(r.getData(), log);
        BerTlv card_map_tag = PACE.require_tag(r.getData(), 130);
        byte[] card_map_pub = PACE.decodePublic(curve.spec, card_map_tag.getBytesValue());
        if (Arrays.equals(card_map_pub, host_map_pub)) {
            throw new PACEException("PACE: card and host keys can not be equal!");
        }
        ECParameterSpec parameters = PACE.parameterMap(curve.spec, (ECPrivateKeyParameters)host_map.getPrivate(), card_map_pub, nonce);
        AsymmetricCipherKeyPair ephemeral_host = PACE.generate(parameters);
        byte[] ephemeral_host_pub = ((ECPublicKeyParameters)ephemeral_host.getPublic()).getQ().getEncoded(false);
        payload = new BerTlvBuilder(new BerTag(124)).addBytes(new BerTag(131), ephemeral_host_pub);
        CommandAPDU apdu3 = PACE.general_authenticate(payload.buildArray());
        SCHelpers.trace_tlv(apdu3.getData(), log);
        r = PACEException.check(c.transmit(apdu3));
        SCHelpers.trace_tlv(r.getData(), log);
        BerTlv ephemeral_card_tag = PACE.require_tag(r.getData(), 132);
        byte[] ephemeral_card_pub = PACE.decodePublic(parameters, ephemeral_card_tag.getBytesValue());
        if (Arrays.equals(ephemeral_host_pub, ephemeral_card_pub)) {
            throw new PACEException("PACE security violation: equal keys");
        }
        byte[] k = PACE.generateSharedSecret(curve.spec, ((ECPrivateKeyParameters)ephemeral_host.getPrivate()).getD().toByteArray(), ephemeral_card_pub);
        byte[] keyMAC = PACE.kdf(k, (byte)2);
        byte[] keyENC = PACE.kdf(k, (byte)1);
        byte[] host_auth_token = PACE.aes_mac8(keyMAC, PACE.auth_token(ephemeral_card_pub));
        payload = new BerTlvBuilder(new BerTag(124)).addBytes(new BerTag(133), host_auth_token);
        CommandAPDU apdu4 = PACE.general_authenticate_last(payload.buildArray());
        SCHelpers.trace_tlv(apdu4.getData(), log);
        r = PACEException.check(c.transmit(apdu4));
        SCHelpers.trace_tlv(r.getData(), log);
        BerTlv auth_token_card = PACE.require_tag(r.getData(), 134);
        byte[] my_auth_token_card = PACE.aes_mac8(keyMAC, PACE.auth_token(ephemeral_host_pub));
        if (!Arrays.equals(auth_token_card.getBytesValue(), my_auth_token_card)) {
            throw new PACEException("PACE: invalid card auth token: " + HexUtils.bin2hex(r.getData()));
        }
        log.info("Card authenticated");
        return new PACE(keyENC, keyMAC);
    }

    static BerTlv require_tag(byte[] response, int tag) throws PACEException {
        BerTlvs tlvs = parser.parse(response);
        BerTlv found = tlvs.find(new BerTag(tag));
        if (found == null) {
            throw new PACEException(String.format("PACE: invalid response, missing tag 0x%02X: %s", tag, HexUtils.bin2hex(response)));
        }
        return found;
    }

    static AsymmetricCipherKeyPair generate(ECParameterSpec p) {
        ECDomainParameters domain = new ECDomainParameters(p.getCurve(), p.getG(), p.getN(), p.getH());
        ECKeyGenerationParameters keyGenParams = new ECKeyGenerationParameters(domain, new SecureRandom());
        ECKeyPairGenerator generator = new ECKeyPairGenerator();
        generator.init(keyGenParams);
        AsymmetricCipherKeyPair keyPair = generator.generateKeyPair();
        return keyPair;
    }

    static byte[] decodePublic(ECParameterSpec p, byte[] data) {
        ECDomainParameters domain = new ECDomainParameters(p.getCurve(), p.getG(), p.getN(), p.getH());
        ECPoint q = domain.getCurve().decodePoint(data);
        ECPublicKeyParameters tmp = new ECPublicKeyParameters(q, domain);
        return tmp.getQ().getEncoded(false);
    }

    private static CommandAPDU general_authenticate(byte[] payload) {
        return new CommandAPDU(16, 134, 0, 0, payload, 256);
    }

    private static CommandAPDU general_authenticate_last(byte[] payload) {
        return new CommandAPDU(0, 134, 0, 0, payload, 256);
    }

    private static CommandAPDU set_at(byte[] oid, byte password, PACECurve curve) throws IOException {
        ByteArrayOutputStream payload = new ByteArrayOutputStream();
        payload.write(new BerTlvBuilder().addBytes(new BerTag(128), oid).buildArray());
        payload.write(new BerTlvBuilder().addByte(new BerTag(131), password).buildArray());
        payload.write(new BerTlvBuilder().addByte(new BerTag(132), curve.code).buildArray());
        return new CommandAPDU(0, 34, 193, 164, payload.toByteArray(), 256);
    }

    static byte[] kdf(byte[] secret, byte counter) throws GeneralSecurityException {
        return PACE.kdf(secret, counter, null);
    }

    private static byte[] kdf(byte[] secret, byte counter, byte[] nonce) throws GeneralSecurityException {
        MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
        byte[] c = new byte[]{0, 0, 0, counter};
        sha256.update(secret);
        if (nonce != null) {
            sha256.update(nonce);
        }
        sha256.update(c);
        return sha256.digest();
    }

    private static ECParameterSpec parameterMap(ECParameterSpec curve, ECPrivateKeyParameters mapKey, byte[] card_pub, byte[] nonce) {
        ECPoint card_map_pub = curve.getCurve().decodePoint(card_pub);
        BigInteger d = mapKey.getD();
        BigInteger s = new BigInteger(1, nonce);
        ECPoint h = card_map_pub.multiply(curve.getH().multiply(d));
        ECPoint newG = curve.getG().multiply(s).add(h);
        return new ECParameterSpec(curve.getCurve(), newG, curve.getN(), curve.getH());
    }

    public static byte[] generateSharedSecret(ECParameterSpec curve, byte[] sk, byte[] pk) {
        BigInteger d = new BigInteger(1, sk);
        ECPoint q = curve.getCurve().decodePoint(pk);
        ECPoint k = q.multiply(d);
        return PACE.positive(k.normalize().getXCoord().toBigInteger().toByteArray());
    }

    public static byte[] positive(byte[] bytes) {
        if (bytes[0] == 0 && bytes.length % 2 == 1) {
            return Arrays.copyOfRange(bytes, 1, bytes.length);
        }
        return bytes;
    }

    static byte[] aes_mac8(byte[] key, byte[] data) {
        byte[] fullmac = new byte[16];
        CMac cMAC = new CMac(AESEngine.newInstance());
        cMAC.init(new KeyParameter(key));
        cMAC.update(data, 0, data.length);
        cMAC.doFinal(fullmac, 0);
        return Arrays.copyOf(fullmac, 8);
    }

    private static byte[] auth_token(byte[] key) {
        BerTlvBuilder payload = new BerTlvBuilder(new BerTag(127, 73)).addBytes(new BerTag(6), oid).addBytes(new BerTag(134), key);
        return payload.buildArray();
    }

    public static enum PACECurve {
        secp256r1(12, ECNamedCurveTable.getParameterSpec("secp256r1")),
        brainpoolp256r1(13, ECNamedCurveTable.getParameterSpec("brainpoolp256r1")),
        secp384r1(15, ECNamedCurveTable.getParameterSpec("secp384r1")),
        brainpoolp384r1(16, ECNamedCurveTable.getParameterSpec("brainpoolp384r1"));

        final byte code;
        final ECParameterSpec spec;

        private PACECurve(int code, ECParameterSpec ecParameterSpec) {
            this.code = (byte)code;
            this.spec = ecParameterSpec;
        }
    }
}

