/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.sdk;

import java.util.Arrays;
import java.util.Optional;

public enum SDKVersion {
    V211("2.1.1"),
    V212("2.1.2"),
    V221("2.2.1"),
    V222("2.2.2"),
    V301("3.0.1"),
    V304("3.0.4"),
    V305("3.0.5"),
    V310("3.1.0"),
    V320("3.2.0");

    final String v;

    private SDKVersion(String v) {
        this.v = v;
    }

    public String toString() {
        return this.v;
    }

    public boolean isV3() {
        return this.name().startsWith("V3");
    }

    public boolean isOneOf(SDKVersion ... versions) {
        for (SDKVersion v : versions) {
            if (!this.equals((Object)v)) continue;
            return true;
        }
        return false;
    }

    public static Optional<SDKVersion> fromVersion(String versionString) {
        return Arrays.stream(SDKVersion.values()).filter(ver -> ver.v.equals(versionString)).findFirst();
    }
}

