/*
 * Decompiled with CFR 0.152.
 */
package kala.compress.utils;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.util.Objects;

public final class IOUtils {
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    public static final OpenOption[] EMPTY_OPEN_OPTIONS = new OpenOption[0];
    public static final LinkOption[] EMPTY_LINK_OPTIONS = new LinkOption[0];
    private static final byte[] SKIP_BUFFER = new byte[8192];

    public static void close(Closeable closeable) throws IOException {
        if (closeable != null) {
            closeable.close();
        }
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static long copy(InputStream input, OutputStream output) throws IOException {
        return IOUtils.copy(input, output, 8192);
    }

    public static long copy(InputStream input, OutputStream output, int bufferSize) throws IOException {
        int n;
        Objects.requireNonNull(input);
        Objects.requireNonNull(output);
        byte[] buffer = new byte[bufferSize];
        long count = 0L;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static long copyRange(InputStream input, long len, OutputStream output) throws IOException {
        return IOUtils.copyRange(input, len, output, 8192);
    }

    public static long copyRange(InputStream input, long len, OutputStream output, int bufferSize) throws IOException {
        long count;
        if (bufferSize < 1) {
            throw new IllegalArgumentException("bufferSize must be bigger than 0");
        }
        byte[] buffer = new byte[(int)Math.min((long)bufferSize, Math.max(0L, len))];
        int n = 0;
        for (count = 0L; count < len && -1 != (n = input.read(buffer, 0, (int)Math.min(len - count, (long)buffer.length))); count += (long)n) {
            if (output == null) continue;
            output.write(buffer, 0, n);
        }
        return count;
    }

    public static int readFully(InputStream input, byte[] array) throws IOException {
        return IOUtils.readFully(input, array, 0, array.length);
    }

    public static int readFully(InputStream input, byte[] array, int offset, int length) throws IOException {
        int count;
        int x;
        if (length < 0 || offset < 0 || length + offset > array.length || length + offset < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (count = 0; count != length && (x = input.read(array, offset + count, length - count)) != -1; count += x) {
        }
        return count;
    }

    public static void readFully(ReadableByteChannel channel, ByteBuffer byteBuffer) throws IOException {
        int read;
        int readNow;
        int expectedLength = byteBuffer.remaining();
        for (read = 0; read < expectedLength && (readNow = channel.read(byteBuffer)) > 0; read += readNow) {
        }
        if (read < expectedLength) {
            throw new EOFException();
        }
    }

    public static byte[] readRange(InputStream input, int length) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        IOUtils.copyRange(input, length, output);
        return output.toByteArray();
    }

    public static byte[] readRange(ReadableByteChannel input, int length) throws IOException {
        int readCount;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ByteBuffer b = ByteBuffer.allocate(Math.min(length, 8192));
        for (int read = 0; read < length; read += readCount) {
            b.limit(Math.min(length - read, b.capacity()));
            readCount = input.read(b);
            if (readCount <= 0) break;
            output.write(b.array(), 0, readCount);
            b.rewind();
        }
        return output.toByteArray();
    }

    public static long skip(InputStream input, long toSkip) throws IOException {
        byte[] skipBuffer;
        long remain;
        long n;
        if (toSkip < 0L) {
            throw new IllegalArgumentException("Skip count must be non-negative, actual: " + toSkip);
        }
        for (remain = toSkip; remain > 0L && (n = (long)input.read(skipBuffer = new byte[8192], 0, (int)Math.min(remain, (long)skipBuffer.length))) >= 0L; remain -= n) {
        }
        return toSkip - remain;
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        IOUtils.copy(input, output);
        return output.toByteArray();
    }

    private IOUtils() {
    }
}

