/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.chardet.prober;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.glavo.chardet.DetectedCharset;

public abstract class CharsetProber {
    public static final float SHORTCUT_THRESHOLD = 0.95f;
    public static final int ASCII_A = 97;
    public static final int ASCII_Z = 122;
    public static final int ASCII_A_CAPITAL = 65;
    public static final int ASCII_Z_CAPITAL = 90;
    public static final int ASCII_LT = 60;
    public static final int ASCII_GT = 62;
    public static final int ASCII_SP = 32;
    private boolean active = true;

    public abstract DetectedCharset getCharset();

    public abstract ProbingState handleData(ByteBuffer var1, int var2, int var3);

    public abstract ProbingState getState();

    public abstract void reset();

    public abstract float getConfidence();

    public abstract void setOption();

    private static void put(ByteBuffer output, ByteBuffer input, int inputOffset, int inputLength) {
        if (input.hasArray()) {
            output.put(input.array(), input.arrayOffset() + inputOffset, inputLength);
        } else {
            ByteBuffer duplicate = input.duplicate();
            ((Buffer)duplicate).limit(inputOffset + inputLength);
            ((Buffer)duplicate).position(inputOffset);
            output.put(duplicate);
        }
    }

    public final ByteBuffer filterWithoutEnglishLetters(ByteBuffer buf, int offset, int length) {
        int curPtr;
        ByteBuffer out = ByteBuffer.allocate(length);
        boolean meetMSB = false;
        int prevPtr = offset;
        int maxPtr = offset + length;
        for (curPtr = offset; curPtr < maxPtr; ++curPtr) {
            byte c = buf.get(curPtr);
            if (!this.isAscii(c)) {
                meetMSB = true;
                continue;
            }
            if (!this.isAsciiSymbol(c)) continue;
            if (meetMSB && curPtr > prevPtr) {
                CharsetProber.put(out, buf, prevPtr, curPtr - prevPtr);
                out.put((byte)32);
                prevPtr = curPtr + 1;
                meetMSB = false;
                continue;
            }
            prevPtr = curPtr + 1;
        }
        if (meetMSB && curPtr > prevPtr) {
            CharsetProber.put(out, buf, prevPtr, curPtr - prevPtr);
        }
        return out;
    }

    public ByteBuffer filterWithEnglishLetters(ByteBuffer buf, int offset, int length) {
        int curPtr;
        ByteBuffer out = ByteBuffer.allocate(length);
        boolean isInTag = false;
        int prevPtr = offset;
        int maxPtr = offset + length;
        for (curPtr = offset; curPtr < maxPtr; ++curPtr) {
            byte c = buf.get(curPtr);
            if (c == 62) {
                isInTag = false;
            } else if (c == 60) {
                isInTag = true;
            }
            if (!this.isAscii(c) || !this.isAsciiSymbol(c)) continue;
            if (curPtr > prevPtr && !isInTag) {
                CharsetProber.put(out, buf, prevPtr, curPtr - prevPtr);
                out.put((byte)32);
                prevPtr = curPtr + 1;
                continue;
            }
            prevPtr = curPtr + 1;
        }
        if (!isInTag && curPtr > prevPtr) {
            CharsetProber.put(out, buf, prevPtr, curPtr - prevPtr);
        }
        return out;
    }

    private boolean isAscii(byte b) {
        return (b & 0x80) == 0;
    }

    private boolean isAsciiSymbol(byte b) {
        int c = b & 0xFF;
        return c < 65 || c > 90 && c < 97 || c > 122;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public static enum ProbingState {
        DETECTING,
        FOUND_IT,
        NOT_ME;

    }
}

