/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Collections;
import java.util.concurrent.CancellationException;
import javafx.application.Platform;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.jackhuang.hmcl.Launcher;
import org.jackhuang.hmcl.Metadata;
import org.jackhuang.hmcl.java.JavaRuntime;
import org.jackhuang.hmcl.ui.AwtUtils;
import org.jackhuang.hmcl.ui.SwingUtils;
import org.jackhuang.hmcl.util.FileSaver;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.ModuleHelper;
import org.jackhuang.hmcl.util.SelfDependencyPatcher;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.platform.OperatingSystem;

public final class Main {
    private Main() {
    }

    public static void main(String[] args) {
        String animationFrameRate;
        System.getProperties().putIfAbsent("java.net.useSystemProxies", "true");
        System.getProperties().putIfAbsent("javafx.autoproxy.disable", "true");
        System.getProperties().putIfAbsent("http.agent", "HMCL/" + Metadata.VERSION);
        Main.createHMCLDirectories();
        Logger.LOG.start(Metadata.HMCL_CURRENT_DIRECTORY.resolve("logs"));
        if ("true".equalsIgnoreCase(System.getenv("HMCL_FORCE_GPU"))) {
            System.getProperties().putIfAbsent("prism.forceGPU", "true");
        }
        if ((animationFrameRate = System.getenv("HMCL_ANIMATION_FRAME_RATE")) != null) {
            try {
                if (Integer.parseInt(animationFrameRate) <= 0) {
                    throw new NumberFormatException(animationFrameRate);
                }
                System.getProperties().putIfAbsent("javafx.animation.pulse", animationFrameRate);
            }
            catch (NumberFormatException e) {
                Logger.LOG.warning("Invalid animation frame rate: " + animationFrameRate);
            }
        }
        Main.checkDirectoryPath();
        if (JavaRuntime.CURRENT_VERSION < 9) {
            Lang.thread(Main::fixLetsEncrypt, "CA Certificate Check", true);
        }
        if (OperatingSystem.CURRENT_OS == OperatingSystem.MACOS) {
            Main.initIcon();
        }
        Main.checkJavaFX();
        Main.verifyJavaFX();
        Main.addEnableNativeAccess();
        Main.enableUnsafeMemoryAccess();
        Launcher.main(args);
    }

    public static void exit(int exitCode) {
        FileSaver.shutdown();
        Logger.LOG.shutdown();
        System.exit(exitCode);
    }

    private static void createHMCLDirectories() {
        if (!Files.isDirectory(Metadata.HMCL_CURRENT_DIRECTORY, new LinkOption[0])) {
            try {
                Files.createDirectories(Metadata.HMCL_CURRENT_DIRECTORY, new FileAttribute[0]);
                if (OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS) {
                    try {
                        Files.setAttribute(Metadata.HMCL_CURRENT_DIRECTORY, "dos:hidden", true, new LinkOption[0]);
                    }
                    catch (IOException e) {
                        Logger.LOG.warning("Failed to set hidden attribute of " + Metadata.HMCL_CURRENT_DIRECTORY, e);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
                Main.showErrorAndExit(I18n.i18n("fatal.create_hmcl_current_directory_failure", Metadata.HMCL_CURRENT_DIRECTORY));
            }
        }
        if (!Files.isDirectory(Metadata.HMCL_GLOBAL_DIRECTORY, new LinkOption[0])) {
            try {
                Files.createDirectories(Metadata.HMCL_GLOBAL_DIRECTORY, new FileAttribute[0]);
            }
            catch (IOException e) {
                Logger.LOG.warning("Failed to create HMCL global directory " + Metadata.HMCL_GLOBAL_DIRECTORY, e);
            }
        }
    }

    private static void initIcon() {
        Image image = Toolkit.getDefaultToolkit().getImage(Main.class.getResource("/assets/img/icon-mac.png"));
        AwtUtils.setAppleIcon(image);
    }

    private static void checkDirectoryPath() {
        String currentDirectory = new File("").getAbsolutePath();
        if (currentDirectory.contains("!")) {
            Main.showErrorAndExit("Exclamation mark(!) is not allowed in the path where HMCL is in.\nThe path is " + currentDirectory);
        }
    }

    private static void checkJavaFX() {
        try {
            SelfDependencyPatcher.patch();
        }
        catch (SelfDependencyPatcher.PatchException e) {
            Logger.LOG.error("unable to patch JVM", e);
            Main.showErrorAndExit(I18n.i18n("fatal.javafx.missing"));
        }
        catch (SelfDependencyPatcher.IncompatibleVersionException e) {
            Logger.LOG.error("unable to patch JVM", e);
            Main.showErrorAndExit(I18n.i18n("fatal.javafx.incompatible"));
        }
        catch (CancellationException e) {
            Logger.LOG.error("User cancels downloading JavaFX", e);
            Main.exit(0);
        }
    }

    private static void verifyJavaFX() {
        try {
            Class.forName("javafx.beans.binding.Binding");
            Class.forName("javafx.stage.Stage");
            Class.forName("javafx.scene.control.Skin");
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            Main.showErrorAndExit(I18n.i18n("fatal.javafx.incomplete"));
        }
    }

    private static void addEnableNativeAccess() {
        if (JavaRuntime.CURRENT_VERSION > 21) {
            try {
                ModuleHelper.addEnableNativeAccess(Class.forName("javafx.stage.Stage"));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace(System.err);
                Main.showErrorAndExit(I18n.i18n("fatal.javafx.incomplete"));
            }
        }
    }

    private static void enableUnsafeMemoryAccess() {
        if (JavaRuntime.CURRENT_VERSION == 24 || JavaRuntime.CURRENT_VERSION == 25) {
            try {
                Class<?> clazz = Class.forName("sun.misc.Unsafe");
                Method trySetMemoryAccessWarned = clazz.getDeclaredMethod("trySetMemoryAccessWarned", new Class[0]);
                trySetMemoryAccessWarned.setAccessible(true);
                trySetMemoryAccessWarned.invoke(null, new Object[0]);
            }
            catch (Throwable e) {
                e.printStackTrace(System.err);
            }
        }
    }

    static void showErrorAndExit(String message) {
        System.err.println(message);
        System.err.println("A fatal error has occurred, forcibly exiting.");
        try {
            if (Platform.isFxApplicationThread()) {
                new Alert(Alert.AlertType.ERROR, message, new ButtonType[0]).showAndWait();
                Main.exit(1);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        SwingUtils.showErrorDialog(message);
        Main.exit(1);
    }

    static void showWarningAndContinue(String message) {
        System.err.println(message);
        System.err.println("Potential issues have been detected.");
        try {
            if (Platform.isFxApplicationThread()) {
                new Alert(Alert.AlertType.WARNING, message, new ButtonType[0]).showAndWait();
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        SwingUtils.showWarningDialog(message);
    }

    private static void fixLetsEncrypt() {
        try {
            KeyStore defaultKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            Path ksPath = Paths.get(System.getProperty("java.home"), "lib", "security", "cacerts");
            try (InputStream ksStream = Files.newInputStream(ksPath, new OpenOption[0]);){
                defaultKeyStore.load(ksStream, "changeit".toCharArray());
            }
            KeyStore letsEncryptKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            try (InputStream letsEncryptFile = Main.class.getResourceAsStream("/assets/lekeystore.jks");){
                letsEncryptKeyStore.load(letsEncryptFile, "supersecretpassword".toCharArray());
            }
            KeyStore merged = KeyStore.getInstance(KeyStore.getDefaultType());
            merged.load(null, new char[0]);
            for (String alias : Collections.list(letsEncryptKeyStore.aliases())) {
                merged.setCertificateEntry(alias, letsEncryptKeyStore.getCertificate(alias));
            }
            for (String alias : Collections.list(defaultKeyStore.aliases())) {
                merged.setCertificateEntry(alias, defaultKeyStore.getCertificate(alias));
            }
            TrustManagerFactory instance = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            instance.init(merged);
            SSLContext tls = SSLContext.getInstance("TLS");
            tls.init(null, instance.getTrustManagers(), null);
            HttpsURLConnection.setDefaultSSLSocketFactory(tls.getSocketFactory());
            Logger.LOG.info("Added Lets Encrypt root certificates as additional trust");
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            Logger.LOG.error("Failed to load lets encrypt certificate. Expect problems", e);
        }
    }
}

