/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.mod.multimc;

import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.jackhuang.hmcl.download.LibraryAnalyzer;
import org.jackhuang.hmcl.util.io.NetworkUtils;

public final class MultiMCComponents {
    private static final Map<String, LibraryAnalyzer.LibraryType> ID_TYPE = new HashMap<String, LibraryAnalyzer.LibraryType>();
    private static final Map<LibraryAnalyzer.LibraryType, String> TYPE_ID;
    private static final Collection<Map.Entry<String, LibraryAnalyzer.LibraryType>> PAIRS;

    private MultiMCComponents() {
    }

    public static String getComponent(LibraryAnalyzer.LibraryType type) {
        return TYPE_ID.get((Object)type);
    }

    public static LibraryAnalyzer.LibraryType getComponent(String type) {
        return ID_TYPE.get(type);
    }

    public static Collection<Map.Entry<String, LibraryAnalyzer.LibraryType>> getPairs() {
        return PAIRS;
    }

    public static URL getMetaURL(String componentID, String version) {
        return NetworkUtils.toURL(String.format("https://meta.multimc.org/v1/%s/%s.json", componentID, version));
    }

    static {
        ID_TYPE.put("net.minecraft", LibraryAnalyzer.LibraryType.MINECRAFT);
        ID_TYPE.put("net.minecraftforge", LibraryAnalyzer.LibraryType.FORGE);
        ID_TYPE.put("net.neoforged", LibraryAnalyzer.LibraryType.NEO_FORGE);
        ID_TYPE.put("com.mumfrey.liteloader", LibraryAnalyzer.LibraryType.LITELOADER);
        ID_TYPE.put("net.fabricmc.fabric-loader", LibraryAnalyzer.LibraryType.FABRIC);
        ID_TYPE.put("org.quiltmc.quilt-loader", LibraryAnalyzer.LibraryType.QUILT);
        TYPE_ID = ID_TYPE.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        PAIRS = Collections.unmodifiableCollection(ID_TYPE.entrySet());
        if (TYPE_ID.isEmpty()) {
            throw new AssertionError((Object)"Please make sure TYPE_ID and PAIRS is initialized after ID_TYPE!");
        }
    }
}

