/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.mod.multimc;

import com.google.gson.JsonParseException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.jackhuang.hmcl.download.DefaultDependencyManager;
import org.jackhuang.hmcl.download.game.GameAssetDownloadTask;
import org.jackhuang.hmcl.download.game.GameDownloadTask;
import org.jackhuang.hmcl.download.game.GameLibrariesTask;
import org.jackhuang.hmcl.game.Artifact;
import org.jackhuang.hmcl.game.DefaultGameRepository;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.mod.MinecraftInstanceTask;
import org.jackhuang.hmcl.mod.Modpack;
import org.jackhuang.hmcl.mod.ModpackConfiguration;
import org.jackhuang.hmcl.mod.ModpackInstallTask;
import org.jackhuang.hmcl.mod.multimc.MultiMCComponents;
import org.jackhuang.hmcl.mod.multimc.MultiMCInstanceConfiguration;
import org.jackhuang.hmcl.mod.multimc.MultiMCInstancePatch;
import org.jackhuang.hmcl.mod.multimc.MultiMCManifest;
import org.jackhuang.hmcl.mod.multimc.MultiMCModpackProvider;
import org.jackhuang.hmcl.task.GetTask;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.io.CompressingUtils;
import org.jackhuang.hmcl.util.io.FileUtils;

public final class MultiMCModpackInstallTask
extends Task<MultiMCInstancePatch.ResolvedInstance> {
    private final File zipFile;
    private final Modpack modpack;
    private final MultiMCInstanceConfiguration manifest;
    private final String name;
    private final DefaultGameRepository repository;
    private final List<Task<?>> dependents = new ArrayList();
    private final List<Task<?>> dependencies = new ArrayList();
    private final DefaultDependencyManager dependencyManager;

    public MultiMCModpackInstallTask(DefaultDependencyManager dependencyManager, File zipFile, Modpack modpack, MultiMCInstanceConfiguration manifest, String name) {
        this.zipFile = zipFile;
        this.modpack = modpack;
        this.manifest = manifest;
        this.name = name;
        this.dependencyManager = dependencyManager;
        this.repository = dependencyManager.getGameRepository();
        File json = this.repository.getModpackConfiguration(name);
        if (this.repository.hasVersion(name) && !json.exists()) {
            throw new IllegalArgumentException("Version " + name + " already exists.");
        }
        this.onDone().register(event -> {
            if (event.isFailed()) {
                this.repository.removeVersionFromDisk(name);
            }
        });
    }

    @Override
    public boolean doPreExecute() {
        return true;
    }

    @Override
    public void preExecute() throws Exception {
        String mcDirectory;
        File run = this.repository.getRunDirectory(this.name);
        File json = this.repository.getModpackConfiguration(this.name);
        ModpackConfiguration<MultiMCInstanceConfiguration> config = null;
        try {
            if (json.exists()) {
                config = JsonUtils.GSON.fromJson(FileUtils.readText(json), ModpackConfiguration.typeOf(MultiMCInstanceConfiguration.class));
                if (!MultiMCModpackProvider.INSTANCE.getName().equals(config.getType())) {
                    throw new IllegalArgumentException("Version " + this.name + " is not a MultiMC modpack. Cannot update this version.");
                }
            }
        }
        catch (JsonParseException | IOException exception) {
            // empty catch block
        }
        try (FileSystem fs = this.openModpack();){
            mcDirectory = MultiMCModpackInstallTask.getRootPath(fs).resolve(".minecraft").toAbsolutePath().normalize().toString();
        }
        this.dependents.add(new ModpackInstallTask<MultiMCInstanceConfiguration>(this.zipFile, run, this.modpack.getEncoding(), Collections.singletonList(mcDirectory), any -> true, config).withStage("hmcl.modpack"));
        this.dependents.add(new MinecraftInstanceTask<MultiMCInstanceConfiguration>(this.zipFile, this.modpack.getEncoding(), Collections.singletonList(mcDirectory), this.manifest, MultiMCModpackProvider.INSTANCE, this.manifest.getName(), null, this.repository.getModpackConfiguration(this.name)).withStage("hmcl.modpack"));
        try (FileSystem fs = this.openModpack();){
            Path root = MultiMCModpackInstallTask.getRootPath(fs);
            ArrayList<Task<MultiMCInstancePatch>> patches = new ArrayList<Task<MultiMCInstancePatch>>();
            for (MultiMCManifest.MultiMCManifestComponent component : Objects.requireNonNull(Objects.requireNonNull(this.manifest.getMmcPack(), "mmc-pack.json").getComponents(), "components")) {
                String componentID = Objects.requireNonNull(component.getUid(), "Component ID");
                Path patchPath = root.resolve(String.format("patches/%s.json", componentID));
                if (Files.exists(patchPath, new LinkOption[0])) {
                    if (!Files.isRegularFile(patchPath, new LinkOption[0])) {
                        throw new IllegalArgumentException("Json-Patch isn't a file: " + componentID);
                    }
                    MultiMCInstancePatch patch = MultiMCInstancePatch.read(componentID, FileUtils.readText(patchPath, StandardCharsets.UTF_8));
                    patches.add(Task.supplyAsync(() -> patch));
                    continue;
                }
                patches.add(new GetTask(MultiMCComponents.getMetaURL(componentID, component.getVersion())).thenApplyAsync(s -> MultiMCInstancePatch.read(componentID, s)));
            }
            this.dependents.add(new MMCInstancePatchesAssembleTask(patches));
        }
    }

    @Override
    public List<Task<?>> getDependents() {
        return this.dependents;
    }

    @Override
    public void execute() throws Exception {
        MultiMCInstancePatch.ResolvedInstance artifact = null;
        for (int i = this.dependents.size() - 1; i >= 0; --i) {
            Task<?> task = this.dependents.get(i);
            if (!(task instanceof MMCInstancePatchesAssembleTask)) continue;
            artifact = MultiMCInstancePatch.resolveArtifact((List)((MMCInstancePatchesAssembleTask)task).getResult(), this.name);
            break;
        }
        Objects.requireNonNull(artifact, "artifact");
        try (FileSystem fs = this.openModpack();){
            Path iconFile;
            String iconKey;
            Path root = MultiMCModpackInstallTask.getRootPath(fs);
            Path libraries = root.resolve("libraries");
            if (Files.exists(libraries, new LinkOption[0])) {
                FileUtils.copyDirectory(libraries, this.repository.getVersionRoot(this.name).toPath().resolve("libraries"));
            }
            if ((iconKey = this.manifest.getIconKey()) != null && Files.exists(iconFile = root.resolve(iconKey + ".png"), new LinkOption[0])) {
                FileUtils.copyFile(iconFile, this.repository.getVersionRoot(this.name).toPath().resolve("icon.png"));
            }
        }
        Version version = artifact.getVersion();
        this.dependencies.add(this.repository.saveAsync(artifact.getVersion()));
        this.dependencies.add(new GameAssetDownloadTask(this.dependencyManager, version, true, true));
        this.dependencies.add(new GameLibrariesTask(this.dependencyManager, version.setLibraries(Lang.merge(version.getLibraries(), artifact.getMavenOnlyFiles())), true));
        Artifact mainJarArtifact = artifact.getMainJar().getArtifact();
        String gameVersion = artifact.getGameVersion();
        if (gameVersion != null && "com.mojang".equals(mainJarArtifact.getGroup()) && "minecraft".equals(mainJarArtifact.getName()) && Objects.equals(gameVersion, mainJarArtifact.getVersion()) && "client".equals(mainJarArtifact.getClassifier())) {
            this.dependencies.add(new GameDownloadTask(this.dependencyManager, gameVersion, version));
        } else {
            this.dependencies.add(new GameDownloadTask(this.dependencyManager, null, version));
        }
        this.setResult(artifact);
    }

    @Override
    public List<Task<?>> getDependencies() {
        return this.dependencies;
    }

    @Override
    public boolean doPostExecute() {
        return true;
    }

    @Override
    public void postExecute() throws Exception {
        MultiMCInstancePatch.ResolvedInstance artifact = Objects.requireNonNull((MultiMCInstancePatch.ResolvedInstance)this.getResult(), "ResolvedInstance");
        List<String> files = artifact.getJarModFileNames();
        if (!this.isDependenciesSucceeded() || files.isEmpty()) {
            return;
        }
        try (FileSystem fs = this.openModpack();){
            Path root = MultiMCModpackInstallTask.getRootPath(fs).resolve("jarmods");
            try (FileSystem mc = CompressingUtils.writable(this.repository.getVersionRoot(this.name).toPath().resolve(this.name + ".jar")).setAutoDetectEncoding(true).build();){
                for (String fileName : files) {
                    FileSystem jm = CompressingUtils.readonly(root.resolve(fileName)).setAutoDetectEncoding(true).build();
                    try {
                        FileUtils.copyDirectory(jm.getPath("/", new String[0]), mc.getPath("/", new String[0]));
                    }
                    finally {
                        if (jm == null) continue;
                        jm.close();
                    }
                }
            }
        }
    }

    private FileSystem openModpack() throws IOException {
        return CompressingUtils.readonly(this.zipFile.toPath()).setAutoDetectEncoding(true).setEncoding(this.modpack.getEncoding()).build();
    }

    private static boolean testPath(Path root) {
        return Files.exists(root.resolve("instance.cfg"), new LinkOption[0]);
    }

    private static Path getRootPath(FileSystem fs) throws IOException {
        Path root = fs.getPath("/", new String[0]);
        if (MultiMCModpackInstallTask.testPath(root)) {
            return root;
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(root);){
            for (Path candidate : stream) {
                if (!MultiMCModpackInstallTask.testPath(candidate)) continue;
                Path path = candidate;
                return path;
            }
        }
        throw new IOException("Not a valid MultiMC modpack");
    }

    private static final class MMCInstancePatchesAssembleTask
    extends Task<List<MultiMCInstancePatch>> {
        private final List<Task<MultiMCInstancePatch>> patches;

        public MMCInstancePatchesAssembleTask(List<Task<MultiMCInstancePatch>> patches) {
            this.patches = patches;
        }

        @Override
        public Collection<? extends Task<?>> getDependents() {
            return this.patches;
        }

        @Override
        public void execute() throws Exception {
            HashMap<String, MultiMCInstancePatch> existed = new HashMap<String, MultiMCInstancePatch>();
            for (Task<MultiMCInstancePatch> task : this.patches) {
                MultiMCInstancePatch result = task.getResult();
                existed.put(result.getID(), result);
            }
            block1: while (true) {
                block2: for (MultiMCInstancePatch multiMCInstancePatch : existed.values()) {
                    for (MultiMCManifest.MultiMCManifestCachedRequires require : multiMCInstancePatch.getRequires()) {
                        String componentID = require.getID();
                        if (existed.containsKey(componentID)) continue;
                        Task<MultiMCInstancePatch> task = new GetTask(MultiMCComponents.getMetaURL(componentID, Lang.requireNonNullElse(require.getEqualsVersion(), require.getSuggests()))).thenApplyAsync(s -> MultiMCInstancePatch.read(componentID, s));
                        task.run();
                        MultiMCInstancePatch result = Objects.requireNonNull(task.getResult());
                        existed.put(result.getID(), result);
                        continue block1;
                        continue block2;
                    }
                }
                break;
            }
            this.setResult(new ArrayList(existed.values()));
        }
    }
}

