/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.setting;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableSet;
import org.jackhuang.hmcl.setting.Config;
import org.jackhuang.hmcl.util.javafx.ObservableHelper;
import org.jackhuang.hmcl.util.javafx.PropertyUtils;
import org.jetbrains.annotations.Nullable;

@JsonAdapter(value=Serializer.class)
public final class GlobalConfig
implements Observable {
    private final IntegerProperty agreementVersion = new SimpleIntegerProperty();
    private final IntegerProperty platformPromptVersion = new SimpleIntegerProperty();
    private final IntegerProperty logRetention = new SimpleIntegerProperty();
    private final BooleanProperty enableOfflineAccount = new SimpleBooleanProperty(false);
    private final ObservableSet<String> userJava = FXCollections.observableSet(new LinkedHashSet());
    private final ObservableSet<String> disabledJava = FXCollections.observableSet(new LinkedHashSet());
    private final Map<String, Object> unknownFields = new HashMap<String, Object>();
    private final transient ObservableHelper helper = new ObservableHelper(this);

    @Nullable
    public static GlobalConfig fromJson(String json) throws JsonParseException {
        GlobalConfig loaded = Config.CONFIG_GSON.fromJson(json, GlobalConfig.class);
        if (loaded == null) {
            return null;
        }
        GlobalConfig instance = new GlobalConfig();
        PropertyUtils.copyProperties(loaded, instance);
        instance.unknownFields.putAll(loaded.unknownFields);
        return instance;
    }

    public GlobalConfig() {
        PropertyUtils.attachListener(this, this.helper);
    }

    public void addListener(InvalidationListener listener) {
        this.helper.addListener(listener);
    }

    public void removeListener(InvalidationListener listener) {
        this.helper.removeListener(listener);
    }

    public String toJson() {
        return Config.CONFIG_GSON.toJson(this);
    }

    public int getAgreementVersion() {
        return this.agreementVersion.get();
    }

    public IntegerProperty agreementVersionProperty() {
        return this.agreementVersion;
    }

    public void setAgreementVersion(int agreementVersion) {
        this.agreementVersion.set(agreementVersion);
    }

    public int getPlatformPromptVersion() {
        return this.platformPromptVersion.get();
    }

    public IntegerProperty platformPromptVersionProperty() {
        return this.platformPromptVersion;
    }

    public void setPlatformPromptVersion(int platformPromptVersion) {
        this.platformPromptVersion.set(platformPromptVersion);
    }

    public int getLogRetention() {
        return this.logRetention.get();
    }

    public IntegerProperty logRetentionProperty() {
        return this.logRetention;
    }

    public void setLogRetention(int logRetention) {
        this.logRetention.set(logRetention);
    }

    public boolean isEnableOfflineAccount() {
        return this.enableOfflineAccount.get();
    }

    public BooleanProperty enableOfflineAccountProperty() {
        return this.enableOfflineAccount;
    }

    public void setEnableOfflineAccount(boolean value) {
        this.enableOfflineAccount.set(value);
    }

    public ObservableSet<String> getUserJava() {
        return this.userJava;
    }

    public ObservableSet<String> getDisabledJava() {
        return this.disabledJava;
    }

    public static final class Serializer
    implements JsonSerializer<GlobalConfig>,
    JsonDeserializer<GlobalConfig> {
        private static final Set<String> knownFields = new HashSet<String>(Arrays.asList("agreementVersion", "platformPromptVersion", "logRetention", "userJava", "disabledJava", "enableOfflineAccount"));

        @Override
        public JsonElement serialize(GlobalConfig src, Type typeOfSrc, JsonSerializationContext context) {
            if (src == null) {
                return JsonNull.INSTANCE;
            }
            JsonObject jsonObject = new JsonObject();
            jsonObject.add("agreementVersion", context.serialize(src.getAgreementVersion()));
            jsonObject.add("platformPromptVersion", context.serialize(src.getPlatformPromptVersion()));
            jsonObject.add("logRetention", context.serialize(src.getLogRetention()));
            if (src.enableOfflineAccount.get()) {
                jsonObject.addProperty("enableOfflineAccount", true);
            }
            if (!src.getUserJava().isEmpty()) {
                jsonObject.add("userJava", context.serialize(src.getUserJava()));
            }
            if (!src.getDisabledJava().isEmpty()) {
                jsonObject.add("disabledJava", context.serialize(src.getDisabledJava()));
            }
            for (Map.Entry entry : src.unknownFields.entrySet()) {
                jsonObject.add((String)entry.getKey(), context.serialize(entry.getValue()));
            }
            return jsonObject;
        }

        @Override
        public GlobalConfig deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonElement disabledJava;
            if (!(json instanceof JsonObject)) {
                return null;
            }
            JsonObject obj = (JsonObject)json;
            GlobalConfig config = new GlobalConfig();
            config.setAgreementVersion(Optional.ofNullable(obj.get("agreementVersion")).map(JsonElement::getAsInt).orElse(0));
            config.setPlatformPromptVersion(Optional.ofNullable(obj.get("platformPromptVersion")).map(JsonElement::getAsInt).orElse(0));
            config.setLogRetention(Optional.ofNullable(obj.get("logRetention")).map(JsonElement::getAsInt).orElse(20));
            config.setEnableOfflineAccount(Optional.ofNullable(obj.get("enableOfflineAccount")).map(JsonElement::getAsBoolean).orElse(false));
            JsonElement userJava = obj.get("userJava");
            if (userJava != null && userJava.isJsonArray()) {
                for (JsonElement element : userJava.getAsJsonArray()) {
                    config.userJava.add((Object)element.getAsString());
                }
            }
            if ((disabledJava = obj.get("disabledJava")) != null && disabledJava.isJsonArray()) {
                for (JsonElement jsonElement : disabledJava.getAsJsonArray()) {
                    config.disabledJava.add((Object)jsonElement.getAsString());
                }
            }
            for (Map.Entry entry : obj.entrySet()) {
                if (knownFields.contains(entry.getKey())) continue;
                config.unknownFields.put((String)entry.getKey(), context.deserialize((JsonElement)entry.getValue(), (Type)((Object)Object.class)));
            }
            return config;
        }
    }
}

