/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jsoup.nodes.TextNode;

public final class HTMLRenderer {
    private final List<Node> children = new ArrayList<Node>();
    private final List<org.jsoup.nodes.Node> stack = new ArrayList<org.jsoup.nodes.Node>();
    private boolean bold;
    private boolean italic;
    private boolean underline;
    private boolean strike;
    private boolean highlight;
    private String headerLevel;
    private org.jsoup.nodes.Node hyperlink;
    private final Consumer<URI> onClickHyperlink;

    private static URI resolveLink(org.jsoup.nodes.Node linkNode) {
        String href = linkNode.absUrl("href");
        if (href.isEmpty()) {
            return null;
        }
        try {
            return new URI(href);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public HTMLRenderer(Consumer<URI> onClickHyperlink) {
        this.onClickHyperlink = onClickHyperlink;
    }

    private void updateStyle() {
        this.bold = false;
        this.italic = false;
        this.underline = false;
        this.strike = false;
        this.highlight = false;
        this.headerLevel = null;
        this.hyperlink = null;
        for (org.jsoup.nodes.Node node : this.stack) {
            String nodeName;
            switch (nodeName = node.nodeName()) {
                case "b": 
                case "strong": {
                    this.bold = true;
                    break;
                }
                case "i": 
                case "em": {
                    this.italic = true;
                    break;
                }
                case "ins": {
                    this.underline = true;
                    break;
                }
                case "del": {
                    this.strike = true;
                    break;
                }
                case "mark": {
                    this.highlight = true;
                    break;
                }
                case "a": {
                    this.hyperlink = node;
                    break;
                }
                case "h1": 
                case "h2": 
                case "h3": 
                case "h4": 
                case "h5": 
                case "h6": {
                    this.headerLevel = nodeName;
                }
            }
        }
    }

    private void pushNode(org.jsoup.nodes.Node node) {
        this.stack.add(node);
        this.updateStyle();
    }

    private void popNode() {
        this.stack.remove(this.stack.size() - 1);
        this.updateStyle();
    }

    private void applyStyle(Text text) {
        if (this.hyperlink != null) {
            URI target = HTMLRenderer.resolveLink(this.hyperlink);
            if (target != null) {
                FXUtils.onClicked((Node)text, () -> this.onClickHyperlink.accept(target));
                text.setCursor(Cursor.HAND);
            }
            text.getStyleClass().add((Object)"html-hyperlink");
        }
        if (this.hyperlink != null || this.underline) {
            text.setUnderline(true);
        }
        if (this.strike) {
            text.setStrikethrough(true);
        }
        if (this.bold || this.highlight) {
            text.getStyleClass().add((Object)"html-bold");
        }
        if (this.italic) {
            text.getStyleClass().add((Object)"html-italic");
        }
        if (this.headerLevel != null) {
            text.getStyleClass().add((Object)("html-" + this.headerLevel));
        }
    }

    private void appendText(String text) {
        Text textNode = new Text(text);
        this.applyStyle(textNode);
        this.children.add((Node)textNode);
    }

    private void appendAutoLineBreak(String text) {
        AutoLineBreak textNode = new AutoLineBreak(text);
        this.applyStyle(textNode);
        this.children.add((Node)textNode);
    }

    private void appendImage(org.jsoup.nodes.Node node) {
        String src = node.absUrl("src");
        String alt = node.attr("alt");
        if (StringUtils.isNotBlank(src)) {
            String widthAttr = node.attr("width");
            String heightAttr = node.attr("height");
            int width = 0;
            int height = 0;
            if (!widthAttr.isEmpty() && !heightAttr.isEmpty()) {
                try {
                    width = (int)Double.parseDouble(widthAttr);
                    height = (int)Double.parseDouble(heightAttr);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (width <= 0 || height <= 0) {
                    width = 0;
                    height = 0;
                }
            }
            try {
                URI target;
                Image image = FXUtils.getRemoteImageTask(src, width, height, true, true).run();
                if (image == null) {
                    throw new AssertionError((Object)"Image loading task returned null");
                }
                ImageView imageView = new ImageView(image);
                if (this.hyperlink != null && (target = HTMLRenderer.resolveLink(this.hyperlink)) != null) {
                    FXUtils.onClicked((Node)imageView, () -> this.onClickHyperlink.accept(target));
                    imageView.setCursor(Cursor.HAND);
                }
                this.children.add((Node)imageView);
                return;
            }
            catch (Throwable e) {
                Logger.LOG.warning("Failed to load image: " + src, e);
            }
        }
        if (!alt.isEmpty()) {
            this.appendText(alt);
        }
    }

    public void appendNode(org.jsoup.nodes.Node node) {
        if (node instanceof TextNode) {
            this.appendText(((TextNode)node).text());
        }
        String name = node.nodeName();
        switch (name) {
            case "img": {
                this.appendImage(node);
                break;
            }
            case "li": {
                this.appendText("\n \u2022 ");
                break;
            }
            case "dt": {
                this.appendText(" ");
                break;
            }
            case "p": 
            case "h1": 
            case "h2": 
            case "h3": 
            case "h4": 
            case "h5": 
            case "h6": 
            case "tr": {
                if (this.children.isEmpty()) break;
                this.appendAutoLineBreak("\n\n");
            }
        }
        if (node.childNodeSize() > 0) {
            this.pushNode(node);
            for (org.jsoup.nodes.Node childNode : node.childNodes()) {
                this.appendNode(childNode);
            }
            this.popNode();
        }
        switch (name) {
            case "br": 
            case "dd": 
            case "p": 
            case "h1": 
            case "h2": 
            case "h3": 
            case "h4": 
            case "h5": 
            case "h6": {
                this.appendAutoLineBreak("\n");
            }
        }
    }

    private static boolean isSpacing(String text) {
        if (text == null) {
            return true;
        }
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch == ' ' || ch == '\t') continue;
            return false;
        }
        return true;
    }

    public void mergeLineBreaks() {
        for (int i = 0; i < this.children.size(); ++i) {
            Node child = this.children.get(i);
            if (!(child instanceof AutoLineBreak)) continue;
            int lastAutoLineBreak = -1;
            for (int j = i + 1; j < this.children.size(); ++j) {
                Node otherChild = this.children.get(j);
                if (otherChild instanceof AutoLineBreak) {
                    lastAutoLineBreak = j;
                    continue;
                }
                if (!(otherChild instanceof Text) || !HTMLRenderer.isSpacing(((Text)otherChild).getText())) break;
            }
            if (lastAutoLineBreak <= 0) continue;
            this.children.subList(i + 1, lastAutoLineBreak + 1).clear();
            if (((Text)child).getText().length() != 1) continue;
            ((Text)child).setText("\n\n");
        }
    }

    public TextFlow render() {
        TextFlow textFlow = new TextFlow();
        textFlow.getStyleClass().add((Object)"html");
        textFlow.getChildren().setAll(this.children);
        return textFlow;
    }

    private static final class AutoLineBreak
    extends Text {
        public AutoLineBreak(String text) {
            super(text);
        }
    }
}

