/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.account;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CancellationException;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Skin;
import javafx.scene.image.Image;
import javafx.scene.layout.Region;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.jackhuang.hmcl.auth.Account;
import org.jackhuang.hmcl.auth.AuthenticationException;
import org.jackhuang.hmcl.auth.CredentialExpiredException;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorAccount;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorServer;
import org.jackhuang.hmcl.auth.offline.OfflineAccount;
import org.jackhuang.hmcl.auth.yggdrasil.CompleteGameProfile;
import org.jackhuang.hmcl.auth.yggdrasil.TextureType;
import org.jackhuang.hmcl.setting.Accounts;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.DialogController;
import org.jackhuang.hmcl.ui.account.AccountListItemSkin;
import org.jackhuang.hmcl.ui.account.OfflineAccountSkinPane;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.skin.InvalidSkinException;
import org.jackhuang.hmcl.util.skin.NormalizedSkin;
import org.jetbrains.annotations.Nullable;

public class AccountListItem
extends RadioButton {
    private final Account account;
    private final StringProperty title = new SimpleStringProperty();
    private final StringProperty subtitle = new SimpleStringProperty();

    public AccountListItem(Account account) {
        String portableSuffix;
        this.account = account;
        this.getStyleClass().clear();
        this.setUserData(account);
        String loginTypeName = Accounts.getLocalizedLoginTypeName(Accounts.getAccountFactory(account));
        String string = portableSuffix = account.isPortable() ? ", " + I18n.i18n("account.portable") : "";
        if (account instanceof AuthlibInjectorAccount) {
            AuthlibInjectorServer server = ((AuthlibInjectorAccount)account).getServer();
            Object[] objectArray = new Object[6];
            objectArray[0] = loginTypeName;
            objectArray[1] = ", ";
            objectArray[2] = I18n.i18n("account.injector.server");
            objectArray[3] = ": ";
            objectArray[4] = Bindings.createStringBinding(server::getName, (Observable[])new Observable[]{server});
            objectArray[5] = portableSuffix;
            this.subtitle.bind((ObservableValue)Bindings.concat((Object[])objectArray));
        } else {
            this.subtitle.set((Object)(loginTypeName + portableSuffix));
        }
        StringBinding characterName = Bindings.createStringBinding(account::getCharacter, (Observable[])new Observable[]{account});
        if (account instanceof OfflineAccount) {
            this.title.bind((ObservableValue)characterName);
        } else {
            this.title.bind((ObservableValue)(account.getUsername().isEmpty() ? characterName : Bindings.concat((Object[])new Object[]{account.getUsername(), " - ", characterName})));
        }
    }

    protected Skin<?> createDefaultSkin() {
        return new AccountListItemSkin(this);
    }

    public Task<?> refreshAsync() {
        return Task.runAsync(() -> {
            this.account.clearCache();
            try {
                this.account.logIn();
            }
            catch (CredentialExpiredException e) {
                try {
                    DialogController.logIn(this.account);
                }
                catch (CancellationException cancellationException) {
                }
                catch (Exception e1) {
                    Logger.LOG.warning("Failed to refresh " + this.account + " with password", e1);
                    throw e1;
                }
            }
            catch (AuthenticationException e) {
                Logger.LOG.warning("Failed to refresh " + this.account + " with token", e);
                throw e;
            }
        });
    }

    public ObservableBooleanValue canUploadSkin() {
        if (this.account instanceof AuthlibInjectorAccount) {
            AuthlibInjectorAccount aiAccount = (AuthlibInjectorAccount)this.account;
            ObjectBinding<Optional<CompleteGameProfile>> profile = aiAccount.getYggdrasilService().getProfileRepository().binding(aiAccount.getUUID());
            return Bindings.createBooleanBinding(() -> {
                Set uploadableTextures = ((Optional)profile.get()).map(AuthlibInjectorAccount::getUploadableTextures).orElse(Collections.emptySet());
                return uploadableTextures.contains((Object)TextureType.SKIN);
            }, (Observable[])new Observable[]{profile});
        }
        if (this.account instanceof OfflineAccount || this.account.canUploadSkin()) {
            return Bindings.createBooleanBinding(() -> true, (Observable[])new Observable[0]);
        }
        return Bindings.createBooleanBinding(() -> false, (Observable[])new Observable[0]);
    }

    @Nullable
    public Task<?> uploadSkin() {
        if (this.account instanceof OfflineAccount) {
            Controllers.dialog((Region)new OfflineAccountSkinPane((OfflineAccount)this.account));
            return null;
        }
        if (!this.account.canUploadSkin()) {
            return null;
        }
        FileChooser chooser = new FileChooser();
        chooser.setTitle(I18n.i18n("account.skin.upload"));
        chooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(I18n.i18n("account.skin.file"), new String[]{"*.png"}));
        File selectedFile = chooser.showOpenDialog((Window)Controllers.getStage());
        if (selectedFile == null) {
            return null;
        }
        return this.refreshAsync().thenRunAsync(() -> {
            Image skinImg;
            try (FileInputStream input = new FileInputStream(selectedFile);){
                skinImg = new Image((InputStream)input);
            }
            catch (IOException e) {
                throw new InvalidSkinException("Failed to read skin image", e);
            }
            if (skinImg.isError()) {
                throw new InvalidSkinException("Failed to read skin image", skinImg.getException());
            }
            NormalizedSkin skin = new NormalizedSkin(skinImg);
            String model = skin.isSlim() ? "slim" : "";
            Logger.LOG.info("Uploading skin [" + selectedFile + "], model [" + model + "]");
            this.account.uploadSkin(skin.isSlim(), selectedFile.toPath());
        }).thenComposeAsync(this.refreshAsync()).whenComplete(Schedulers.javafx(), e -> {
            if (e != null) {
                Controllers.dialog(Accounts.localizeErrorMessage(e), I18n.i18n("account.skin.upload.failed"), MessageDialogPane.MessageType.ERROR);
            }
        });
    }

    public void remove() {
        Accounts.getAccounts().remove((Object)this.account);
    }

    public Account getAccount() {
        return this.account;
    }

    public String getTitle() {
        return (String)this.title.get();
    }

    public void setTitle(String title) {
        this.title.set((Object)title);
    }

    public StringProperty titleProperty() {
        return this.title;
    }

    public String getSubtitle() {
        return (String)this.subtitle.get();
    }

    public void setSubtitle(String subtitle) {
        this.subtitle.set((Object)subtitle);
    }

    public StringProperty subtitleProperty() {
        return this.subtitle;
    }
}

