/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import com.jfoenix.controls.JFXProgressBar;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Paint;
import org.jackhuang.hmcl.download.fabric.FabricAPIInstallTask;
import org.jackhuang.hmcl.download.fabric.FabricInstallTask;
import org.jackhuang.hmcl.download.forge.ForgeNewInstallTask;
import org.jackhuang.hmcl.download.forge.ForgeOldInstallTask;
import org.jackhuang.hmcl.download.game.GameAssetDownloadTask;
import org.jackhuang.hmcl.download.game.GameInstallTask;
import org.jackhuang.hmcl.download.java.mojang.MojangJavaDownloadTask;
import org.jackhuang.hmcl.download.liteloader.LiteLoaderInstallTask;
import org.jackhuang.hmcl.download.neoforge.NeoForgeInstallTask;
import org.jackhuang.hmcl.download.neoforge.NeoForgeOldInstallTask;
import org.jackhuang.hmcl.download.optifine.OptiFineInstallTask;
import org.jackhuang.hmcl.download.quilt.QuiltAPIInstallTask;
import org.jackhuang.hmcl.download.quilt.QuiltInstallTask;
import org.jackhuang.hmcl.game.HMCLModpackInstallTask;
import org.jackhuang.hmcl.java.JavaInstallTask;
import org.jackhuang.hmcl.mod.MinecraftInstanceTask;
import org.jackhuang.hmcl.mod.ModpackInstallTask;
import org.jackhuang.hmcl.mod.ModpackUpdateTask;
import org.jackhuang.hmcl.mod.curse.CurseCompletionTask;
import org.jackhuang.hmcl.mod.curse.CurseInstallTask;
import org.jackhuang.hmcl.mod.mcbbs.McbbsModpackCompletionTask;
import org.jackhuang.hmcl.mod.mcbbs.McbbsModpackExportTask;
import org.jackhuang.hmcl.mod.modrinth.ModrinthCompletionTask;
import org.jackhuang.hmcl.mod.modrinth.ModrinthInstallTask;
import org.jackhuang.hmcl.mod.multimc.MultiMCModpackExportTask;
import org.jackhuang.hmcl.mod.multimc.MultiMCModpackInstallTask;
import org.jackhuang.hmcl.mod.server.ServerModpackCompletionTask;
import org.jackhuang.hmcl.mod.server.ServerModpackExportTask;
import org.jackhuang.hmcl.mod.server.ServerModpackLocalInstallTask;
import org.jackhuang.hmcl.setting.Theme;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.task.TaskExecutor;
import org.jackhuang.hmcl.task.TaskListener;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.construct.AdvancedListBox;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;

public final class TaskListPane
extends StackPane {
    private TaskExecutor executor;
    private final AdvancedListBox listBox = new AdvancedListBox();
    private final Map<Task<?>, ProgressListNode> nodes = new HashMap();
    private final List<StageNode> stageNodes = new ArrayList<StageNode>();
    private final ObjectProperty<Insets> progressNodePadding = new SimpleObjectProperty((Object)Insets.EMPTY);

    public TaskListPane() {
        this.listBox.setSpacing(0.0);
        this.getChildren().setAll((Object[])new Node[]{this.listBox});
    }

    public void setExecutor(TaskExecutor executor) {
        final List<String> stages = Lang.removingDuplicates(executor.getStages());
        this.executor = executor;
        executor.addTaskListener(new TaskListener(){

            @Override
            public void onStart() {
                Platform.runLater(() -> {
                    TaskListPane.this.stageNodes.clear();
                    TaskListPane.this.listBox.clear();
                    TaskListPane.this.stageNodes.addAll(stages.stream().map(StageNode::new).collect(Collectors.toList()));
                    TaskListPane.this.stageNodes.forEach(TaskListPane.this.listBox::add);
                    if (stages.isEmpty()) {
                        TaskListPane.this.progressNodePadding.setValue((Object)new Insets(0.0, 0.0, 8.0, 0.0));
                    } else {
                        TaskListPane.this.progressNodePadding.setValue((Object)new Insets(0.0, 0.0, 8.0, 26.0));
                    }
                });
            }

            @Override
            public void onReady(Task<?> task) {
                if (task.getStage() != null) {
                    Platform.runLater(() -> TaskListPane.this.stageNodes.stream().filter(x -> ((StageNode)x).stage.equals(task.getStage())).findAny().ifPresent(StageNode::begin));
                }
            }

            @Override
            public void onRunning(Task<?> task) {
                if (!task.getSignificance().shouldShow() || task.getName() == null) {
                    return;
                }
                if (task instanceof GameAssetDownloadTask) {
                    task.setName(I18n.i18n("assets.download_all"));
                } else if (task instanceof GameInstallTask) {
                    task.setName(I18n.i18n("install.installer.install", I18n.i18n("install.installer.game")));
                } else if (task instanceof ForgeNewInstallTask || task instanceof ForgeOldInstallTask) {
                    task.setName(I18n.i18n("install.installer.install", I18n.i18n("install.installer.forge")));
                } else if (task instanceof NeoForgeInstallTask || task instanceof NeoForgeOldInstallTask) {
                    task.setName(I18n.i18n("install.installer.install", I18n.i18n("install.installer.neoforge")));
                } else if (task instanceof LiteLoaderInstallTask) {
                    task.setName(I18n.i18n("install.installer.install", I18n.i18n("install.installer.liteloader")));
                } else if (task instanceof OptiFineInstallTask) {
                    task.setName(I18n.i18n("install.installer.install", I18n.i18n("install.installer.optifine")));
                } else if (task instanceof FabricInstallTask) {
                    task.setName(I18n.i18n("install.installer.install", I18n.i18n("install.installer.fabric")));
                } else if (task instanceof FabricAPIInstallTask) {
                    task.setName(I18n.i18n("install.installer.install", I18n.i18n("install.installer.fabric-api")));
                } else if (task instanceof QuiltInstallTask) {
                    task.setName(I18n.i18n("install.installer.install", I18n.i18n("install.installer.quilt")));
                } else if (task instanceof QuiltAPIInstallTask) {
                    task.setName(I18n.i18n("install.installer.install", I18n.i18n("install.installer.quilt-api")));
                } else if (task instanceof CurseCompletionTask || task instanceof ModrinthCompletionTask || task instanceof ServerModpackCompletionTask || task instanceof McbbsModpackCompletionTask) {
                    task.setName(I18n.i18n("modpack.completion"));
                } else if (task instanceof ModpackInstallTask) {
                    task.setName(I18n.i18n("modpack.installing"));
                } else if (task instanceof ModpackUpdateTask) {
                    task.setName(I18n.i18n("modpack.update"));
                } else if (task instanceof CurseInstallTask) {
                    task.setName(I18n.i18n("modpack.installing.given", I18n.i18n("modpack.type.curse")));
                } else if (task instanceof MultiMCModpackInstallTask) {
                    task.setName(I18n.i18n("modpack.installing.given", I18n.i18n("modpack.type.multimc")));
                } else if (task instanceof ModrinthInstallTask) {
                    task.setName(I18n.i18n("modpack.installing.given", I18n.i18n("modpack.type.modrinth")));
                } else if (task instanceof ServerModpackLocalInstallTask) {
                    task.setName(I18n.i18n("install.installing") + ": " + I18n.i18n("modpack.type.server"));
                } else if (task instanceof HMCLModpackInstallTask) {
                    task.setName(I18n.i18n("modpack.installing.given", I18n.i18n("modpack.type.hmcl")));
                } else if (task instanceof McbbsModpackExportTask || task instanceof MultiMCModpackExportTask || task instanceof ServerModpackExportTask) {
                    task.setName(I18n.i18n("modpack.export"));
                } else if (task instanceof MinecraftInstanceTask) {
                    task.setName(I18n.i18n("modpack.scan"));
                } else if (task instanceof MojangJavaDownloadTask) {
                    task.setName(I18n.i18n("download.java"));
                } else if (task instanceof JavaInstallTask) {
                    task.setName(I18n.i18n("java.installing"));
                }
                Platform.runLater(() -> {
                    ProgressListNode node = new ProgressListNode(task);
                    TaskListPane.this.nodes.put(task, node);
                    StageNode stageNode = TaskListPane.this.stageNodes.stream().filter(x -> ((StageNode)x).stage.equals(task.getInheritedStage())).findAny().orElse(null);
                    TaskListPane.this.listBox.add(TaskListPane.this.listBox.indexOf((Node)stageNode) + 1, (Node)node);
                });
            }

            @Override
            public void onFinished(Task<?> task) {
                if (task.getStage() != null) {
                    Platform.runLater(() -> TaskListPane.this.stageNodes.stream().filter(x -> ((StageNode)x).stage.equals(task.getStage())).findAny().ifPresent(StageNode::succeed));
                }
                Platform.runLater(() -> {
                    ProgressListNode node = (ProgressListNode)((Object)((Object)TaskListPane.this.nodes.remove(task)));
                    if (node == null) {
                        return;
                    }
                    node.unbind();
                    TaskListPane.this.listBox.remove((Node)node);
                });
            }

            @Override
            public void onFailed(Task<?> task, Throwable throwable) {
                ProgressListNode node;
                if (task.getStage() != null) {
                    Platform.runLater(() -> TaskListPane.this.stageNodes.stream().filter(x -> ((StageNode)x).stage.equals(task.getStage())).findAny().ifPresent(StageNode::fail));
                }
                if ((node = (ProgressListNode)((Object)TaskListPane.this.nodes.remove(task))) == null) {
                    return;
                }
                Platform.runLater(() -> node.setThrowable(throwable));
            }

            @Override
            public void onPropertiesUpdate(Task<?> task) {
                if (task instanceof Task.CountTask) {
                    FXUtils.runInFX(() -> TaskListPane.this.stageNodes.stream().filter(x -> ((StageNode)x).stage.equals(((Task.CountTask)task).getCountStage())).findAny().ifPresent(StageNode::count));
                    return;
                }
                if (task.getStage() != null) {
                    int total = Lang.tryCast(task.getProperties().get("total"), Integer.class).orElse(0);
                    FXUtils.runInFX(() -> TaskListPane.this.stageNodes.stream().filter(x -> ((StageNode)x).stage.equals(task.getStage())).findAny().ifPresent(stageNode -> stageNode.setTotal(total)));
                }
            }
        });
    }

    private class ProgressListNode
    extends BorderPane {
        private final JFXProgressBar bar = new JFXProgressBar();
        private final Label title = new Label();
        private final Label state = new Label();
        private final DoubleBinding binding = Bindings.createDoubleBinding(() -> this.getWidth() - this.getPadding().getLeft() - this.getPadding().getRight() - this.getInsets().getLeft() - this.getInsets().getRight(), (Observable[])new Observable[]{this.paddingProperty(), this.widthProperty()});

        public ProgressListNode(Task<?> task) {
            this.bar.progressProperty().bind((ObservableValue)task.progressProperty());
            this.title.setText(task.getName());
            this.state.textProperty().bind((ObservableValue)task.messageProperty());
            this.setLeft((Node)this.title);
            this.setRight((Node)this.state);
            this.setBottom((Node)this.bar);
            this.bar.minWidthProperty().bind((ObservableValue)this.binding);
            this.bar.prefWidthProperty().bind((ObservableValue)this.binding);
            this.bar.maxWidthProperty().bind((ObservableValue)this.binding);
            this.paddingProperty().bind((ObservableValue)TaskListPane.this.progressNodePadding);
        }

        public void unbind() {
            this.bar.progressProperty().unbind();
            this.state.textProperty().unbind();
        }

        public void setThrowable(Throwable throwable) {
            this.unbind();
            this.state.setText(throwable.getLocalizedMessage());
            this.bar.setProgress(0.0);
        }
    }

    private static class StageNode
    extends BorderPane {
        private final String stage;
        private final Label title = new Label();
        private final String message;
        private int count = 0;
        private int total = 0;
        private boolean started = false;

        public StageNode(String stage) {
            this.stage = stage;
            String stageKey = StringUtils.substringBefore(stage, ':');
            String stageValue = StringUtils.substringAfter(stage, ':');
            switch (stageKey) {
                case "hmcl.modpack": {
                    this.message = I18n.i18n("install.modpack");
                    break;
                }
                case "hmcl.modpack.download": {
                    this.message = I18n.i18n("launch.state.modpack");
                    break;
                }
                case "hmcl.install.assets": {
                    this.message = I18n.i18n("assets.download");
                    break;
                }
                case "hmcl.install.game": {
                    this.message = I18n.i18n("install.installer.install", I18n.i18n("install.installer.game") + " " + stageValue);
                    break;
                }
                case "hmcl.install.forge": {
                    this.message = I18n.i18n("install.installer.install", I18n.i18n("install.installer.forge") + " " + stageValue);
                    break;
                }
                case "hmcl.install.neoforge": {
                    this.message = I18n.i18n("install.installer.install", I18n.i18n("install.installer.neoforge") + " " + stageValue);
                    break;
                }
                case "hmcl.install.liteloader": {
                    this.message = I18n.i18n("install.installer.install", I18n.i18n("install.installer.liteloader") + " " + stageValue);
                    break;
                }
                case "hmcl.install.optifine": {
                    this.message = I18n.i18n("install.installer.install", I18n.i18n("install.installer.optifine") + " " + stageValue);
                    break;
                }
                case "hmcl.install.fabric": {
                    this.message = I18n.i18n("install.installer.install", I18n.i18n("install.installer.fabric") + " " + stageValue);
                    break;
                }
                case "hmcl.install.fabric-api": {
                    this.message = I18n.i18n("install.installer.install", I18n.i18n("install.installer.fabric-api") + " " + stageValue);
                    break;
                }
                case "hmcl.install.quilt": {
                    this.message = I18n.i18n("install.installer.install", I18n.i18n("install.installer.quilt") + " " + stageValue);
                    break;
                }
                case "hmcl.install.quilt-api": {
                    this.message = I18n.i18n("install.installer.install", I18n.i18n("install.installer.quilt-api") + " " + stageValue);
                    break;
                }
                default: {
                    this.message = I18n.i18n(stageKey);
                }
            }
            this.title.setText(this.message);
            BorderPane.setAlignment((Node)this.title, (Pos)Pos.CENTER_LEFT);
            BorderPane.setMargin((Node)this.title, (Insets)new Insets(0.0, 0.0, 0.0, 8.0));
            this.setPadding(new Insets(0.0, 0.0, 8.0, 4.0));
            this.setCenter((Node)this.title);
            this.setLeft(FXUtils.limitingSize(SVG.MORE_HORIZ.createIcon((Paint)Theme.blackFill(), 14.0), 14.0, 14.0));
        }

        public void begin() {
            if (this.started) {
                return;
            }
            this.started = true;
            this.setLeft(FXUtils.limitingSize(SVG.ARROW_FORWARD.createIcon((Paint)Theme.blackFill(), 14.0), 14.0, 14.0));
        }

        public void fail() {
            this.setLeft(FXUtils.limitingSize(SVG.CLOSE.createIcon((Paint)Theme.blackFill(), 14.0), 14.0, 14.0));
        }

        public void succeed() {
            this.setLeft(FXUtils.limitingSize(SVG.CHECK.createIcon((Paint)Theme.blackFill(), 14.0), 14.0, 14.0));
        }

        public void count() {
            this.updateCounter(++this.count, this.total);
        }

        public void setTotal(int total) {
            this.total = total;
            this.updateCounter(this.count, total);
        }

        public void updateCounter(int count, int total) {
            if (total > 0) {
                this.title.setText(String.format("%s - %d/%d", this.message, count, total));
            } else {
                this.title.setText(this.message);
            }
        }
    }
}

