/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.main;

import com.google.gson.annotations.SerializedName;
import java.util.Collections;
import java.util.List;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.VBox;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.ComponentList;
import org.jackhuang.hmcl.ui.construct.IconedTwoLineListItem;
import org.jackhuang.hmcl.ui.construct.SpinnerPane;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.HttpRequest;

public class HelpPage
extends SpinnerPane {
    private final VBox content = new VBox();

    public HelpPage() {
        this.content.setPadding(new Insets(10.0));
        this.content.setSpacing(10.0);
        this.content.setFillWidth(true);
        ScrollPane scrollPane = new ScrollPane((Node)this.content);
        scrollPane.setFitToWidth(true);
        FXUtils.smoothScrolling(scrollPane);
        this.setContent((Node)scrollPane);
        IconedTwoLineListItem docPane = new IconedTwoLineListItem();
        docPane.setTitle(I18n.i18n("help.doc"));
        docPane.setSubtitle(I18n.i18n("help.detail"));
        docPane.setExternalLink("https://docs.hmcl.net");
        ComponentList doc = new ComponentList();
        doc.getContent().setAll((Object[])new Node[]{docPane});
        this.content.getChildren().add((Object)doc);
        this.loadHelp();
    }

    private void loadHelp() {
        this.showSpinner();
        Task.supplyAsync(() -> HttpRequest.GET("https://docs.hmcl.net/index.json").getJson(JsonUtils.listTypeOf(HelpCategory.class))).thenAcceptAsync(Schedulers.javafx(), helpCategories -> {
            for (HelpCategory category : helpCategories) {
                ComponentList categoryPane = new ComponentList();
                for (Help help : category.getItems()) {
                    IconedTwoLineListItem item = new IconedTwoLineListItem();
                    item.setTitle(help.getTitle());
                    item.setSubtitle(help.getSubtitle());
                    item.setExternalLink(help.getUrl());
                    categoryPane.getContent().add((Object)item);
                }
                this.content.getChildren().add((Object)ComponentList.createComponentListTitle(category.title));
                this.content.getChildren().add((Object)categoryPane);
            }
            this.hideSpinner();
        }).start();
    }

    private static class Help {
        @SerializedName(value="title")
        private final String title;
        @SerializedName(value="subtitle")
        private final String subtitle;
        @SerializedName(value="url")
        private final String url;

        public Help() {
            this("", "", "");
        }

        public Help(String title, String subtitle, String url) {
            this.title = title;
            this.subtitle = subtitle;
            this.url = url;
        }

        public String getTitle() {
            return this.title;
        }

        public String getSubtitle() {
            return this.subtitle;
        }

        public String getUrl() {
            return this.url;
        }
    }

    private static class HelpCategory {
        @SerializedName(value="title")
        private final String title;
        @SerializedName(value="items")
        private final List<Help> items;

        public HelpCategory() {
            this("", Collections.emptyList());
        }

        public HelpCategory(String title, List<Help> items) {
            this.title = title;
            this.items = items;
        }

        public String getTitle() {
            return this.title;
        }

        public List<Help> getItems() {
            return this.items;
        }
    }
}

