/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXDialogLayout;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Paint;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.jackhuang.hmcl.schematic.LitematicFile;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.setting.Theme;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.ListPageBase;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.ToolbarListPageSkin;
import org.jackhuang.hmcl.ui.construct.ComponentList;
import org.jackhuang.hmcl.ui.construct.DialogCloseEvent;
import org.jackhuang.hmcl.ui.construct.InputDialogPane;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.construct.RipplerContainer;
import org.jackhuang.hmcl.ui.construct.TwoLineListItem;
import org.jackhuang.hmcl.ui.versions.VersionPage;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.platform.OperatingSystem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SchematicsPage
extends ListPageBase<Item>
implements VersionPage.VersionLoadable {
    private Path schematicsDirectory;
    private DirItem currentDirectory;

    private static String translateAuthorName(String author) {
        if (I18n.isUseChinese() && "hsds".equals(author)) {
            return "\u9ed1\u5c71\u5927\u53d4";
        }
        return author;
    }

    public SchematicsPage() {
        FXUtils.applyDragListener((Node)this, file -> this.currentDirectory != null && file.isFile() && file.getName().endsWith(".litematic"), files -> this.addFiles(files.stream().map(File::toPath).collect(Collectors.toList())));
    }

    protected Skin<?> createDefaultSkin() {
        return new SchematicsPageSkin();
    }

    @Override
    public void loadVersion(Profile profile, String version) {
        this.schematicsDirectory = profile.getRepository().getSchematicsDirectory(version);
        this.refresh();
    }

    public void refresh() {
        Path schematicsDirectory = this.schematicsDirectory;
        if (schematicsDirectory == null) {
            return;
        }
        this.setLoading(true);
        Task.supplyAsync(() -> this.loadAll(schematicsDirectory, null)).whenComplete(Schedulers.javafx(), (result, exception) -> {
            this.setLoading(false);
            if (exception == null) {
                DirItem target = result;
                if (this.currentDirectory != null) {
                    block0: for (int i = 0; i < this.currentDirectory.relativePath.size(); ++i) {
                        String dirName = this.currentDirectory.relativePath.get(i);
                        for (Item child : target.children) {
                            if (!(child instanceof DirItem) || !child.getName().equals(dirName)) continue;
                            target = (DirItem)child;
                            continue block0;
                        }
                    }
                }
                this.navigateTo(target);
            } else {
                Logger.LOG.warning("Failed to load schematics", exception);
            }
        }).start();
    }

    public void addFiles(List<Path> files) {
        if (this.currentDirectory == null) {
            return;
        }
        Path dir = this.currentDirectory.path;
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
            for (Path file : files) {
                Files.copy(file, dir.resolve(file.getFileName()), new CopyOption[0]);
            }
            this.refresh();
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException e) {
            Controllers.dialog(I18n.i18n("schematics.add.failed"), I18n.i18n("message.error"), MessageDialogPane.MessageType.ERROR);
            Logger.LOG.warning("Failed to add schematics to " + dir, e);
        }
    }

    public void onAddFiles() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(I18n.i18n("schematics.add"));
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(I18n.i18n("schematics"), new String[]{"*.litematic"}));
        List files = fileChooser.showOpenMultipleDialog((Window)Controllers.getStage());
        if (files != null && !files.isEmpty()) {
            this.addFiles(files.stream().map(File::toPath).collect(Collectors.toList()));
        }
    }

    public void onCreateDirectory() {
        if (this.currentDirectory == null) {
            return;
        }
        Path parent = this.currentDirectory.path;
        Controllers.dialog((Region)new InputDialogPane(I18n.i18n("schematics.create_directory.prompt"), "", (result, resolve, reject) -> {
            if (StringUtils.isBlank(result)) {
                reject.accept(I18n.i18n("schematics.create_directory.failed.empty_name"));
                return;
            }
            if (result.contains("/") || result.contains("\\") || !OperatingSystem.isNameValid(result)) {
                reject.accept(I18n.i18n("schematics.create_directory.failed.invalid_name"));
                return;
            }
            Path targetDir = parent.resolve((String)result);
            if (Files.exists(targetDir, new LinkOption[0])) {
                reject.accept(I18n.i18n("schematics.create_directory.failed.already_exists"));
                return;
            }
            try {
                Files.createDirectories(targetDir, new FileAttribute[0]);
                resolve.run();
                this.refresh();
            }
            catch (IOException e) {
                Logger.LOG.warning("Failed to create directory: " + targetDir, e);
                reject.accept(I18n.i18n("schematics.create_directory.failed", targetDir));
            }
        }));
    }

    private DirItem loadAll(Path dir, @Nullable DirItem parent) {
        DirItem item = new DirItem(dir, parent);
        try (Stream<Path> stream2 = Files.list(dir);){
            for (Path path : Lang.toIterable(stream2)) {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    item.children.add(this.loadAll(path, item));
                    continue;
                }
                if (!path.getFileName().toString().endsWith(".litematic") || !Files.isRegularFile(path, new LinkOption[0])) continue;
                try {
                    item.children.add(new LitematicFileItem(LitematicFile.load(path)));
                }
                catch (IOException e) {
                    Logger.LOG.warning("Failed to load litematic file: " + path, e);
                }
            }
        }
        catch (NoSuchFileException stream2) {
        }
        catch (IOException e) {
            Logger.LOG.warning("Failed to load schematics in " + dir, e);
        }
        item.children.sort(Comparator.naturalOrder());
        return item;
    }

    private void navigateTo(DirItem item) {
        this.currentDirectory = item;
        this.getItems().clear();
        if (item.parent != null) {
            this.getItems().add((Object)new BackItem(item.parent));
        }
        this.getItems().addAll(item.children);
    }

    private final class SchematicsPageSkin
    extends ToolbarListPageSkin<SchematicsPage> {
        SchematicsPageSkin() {
            super(SchematicsPage.this);
        }

        @Override
        protected List<Node> initializeToolbar(SchematicsPage skinnable) {
            Node[] nodeArray = new Node[3];
            nodeArray[0] = SchematicsPageSkin.createToolbarButton2(I18n.i18n("button.refresh"), SVG.REFRESH, skinnable::refresh);
            nodeArray[1] = SchematicsPageSkin.createToolbarButton2(I18n.i18n("schematics.add"), SVG.ADD, skinnable::onAddFiles);
            nodeArray[2] = SchematicsPageSkin.createToolbarButton2(I18n.i18n("schematics.create_directory"), SVG.CREATE_NEW_FOLDER, skinnable::onCreateDirectory);
            return Arrays.asList(nodeArray);
        }
    }

    private static final class ItemSkin
    extends SkinBase<Item> {
        public ItemSkin(Item item) {
            super((Control)item);
            BorderPane root = new BorderPane();
            root.getStyleClass().add((Object)"md-list-cell");
            root.setPadding(new Insets(8.0));
            StackPane left = new StackPane();
            left.setMaxSize(32.0, 32.0);
            left.setPrefSize(32.0, 32.0);
            left.getChildren().add((Object)item.getIcon(24));
            left.setPadding(new Insets(0.0, 8.0, 0.0, 0.0));
            Path path = item.getPath();
            if (path != null) {
                FXUtils.installSlowTooltip((Node)left, path.toAbsolutePath().normalize().toString());
            }
            BorderPane.setAlignment((Node)left, (Pos)Pos.CENTER);
            root.setLeft((Node)left);
            TwoLineListItem center = new TwoLineListItem();
            center.setTitle(item.getName());
            center.setSubtitle(item.getDescription());
            root.setCenter((Node)center);
            if (!(item instanceof BackItem)) {
                HBox right = new HBox(8.0);
                right.setAlignment(Pos.CENTER_RIGHT);
                JFXButton btnReveal = new JFXButton();
                FXUtils.installFastTooltip((Node)btnReveal, I18n.i18n("reveal.in_file_manager"));
                btnReveal.getStyleClass().add((Object)"toggle-icon4");
                btnReveal.setGraphic(SVG.FOLDER_OPEN.createIcon((Paint)Theme.blackFill(), -1.0));
                btnReveal.setOnAction(event -> item.onReveal());
                JFXButton btnDelete = new JFXButton();
                btnDelete.getStyleClass().add((Object)"toggle-icon4");
                btnDelete.setGraphic(SVG.DELETE_FOREVER.createIcon((Paint)Theme.blackFill(), -1.0));
                btnDelete.setOnAction(event -> Controllers.confirm(I18n.i18n("button.remove.confirm"), I18n.i18n("button.remove"), item::onDelete, null));
                right.getChildren().setAll((Object[])new Node[]{btnReveal, btnDelete});
                root.setRight((Node)right);
            }
            RipplerContainer container = new RipplerContainer((Node)root);
            FXUtils.onClicked((Node)container, item::onClick);
            this.getChildren().add((Object)container);
        }
    }

    private final class LitematicFileItem
    extends Item {
        final LitematicFile file;
        final String name;
        final Image image;

        private LitematicFileItem(LitematicFile file) {
            int size;
            this.file = file;
            String name = file.getName();
            this.name = name != null && !"Unnamed".equals(name) ? name : StringUtils.removeSuffix(file.getFile().getFileName().toString(), ".litematic");
            WritableImage image = null;
            int[] previewImageData = file.getPreviewImageData();
            if (previewImageData != null && previewImageData.length > 0 && (size = (int)Math.sqrt(previewImageData.length)) * size == previewImageData.length) {
                image = new WritableImage(size, size);
                PixelWriter pixelWriter = image.getPixelWriter();
                int i = 0;
                for (int y = 0; y < size; ++y) {
                    for (int x = 0; x < size; ++x) {
                        pixelWriter.setArgb(x, y, previewImageData[i++]);
                    }
                }
            }
            this.image = image;
        }

        @Override
        int order() {
            return 2;
        }

        @Override
        Path getPath() {
            return this.file.getFile();
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        String getDescription() {
            return this.file.getFile().getFileName().toString();
        }

        @Override
        SVG getIcon() {
            return SVG.SCHEMA;
        }

        @Override
        Node getIcon(int size) {
            if (this.image == null) {
                return super.getIcon(size);
            }
            ImageView imageView = new ImageView();
            imageView.setFitHeight((double)size);
            imageView.setFitWidth((double)size);
            imageView.setImage(this.image);
            return imageView;
        }

        @Override
        void onClick() {
            Controllers.dialog((Region)new LitematicInfoDialog());
        }

        @Override
        void onReveal() {
            FXUtils.showFileInExplorer(this.file.getFile());
        }

        @Override
        void onDelete() {
            try {
                Files.deleteIfExists(this.file.getFile());
                SchematicsPage.this.refresh();
            }
            catch (IOException e) {
                Logger.LOG.warning("Failed to delete litematic file: " + this.file.getFile(), e);
            }
        }

        private final class LitematicInfoDialog
        extends JFXDialogLayout {
            private final ComponentList details;

            private void addDetailItem(String key, Object detail) {
                BorderPane borderPane = new BorderPane();
                borderPane.setLeft((Node)new Label(key));
                borderPane.setRight((Node)new Label(detail.toString()));
                this.details.getContent().add((Object)borderPane);
            }

            private void updateContent(LitematicFile file) {
                this.details.getContent().clear();
                this.addDetailItem(I18n.i18n("schematics.info.name"), file.getName());
                if (StringUtils.isNotBlank(file.getAuthor())) {
                    this.addDetailItem(I18n.i18n("schematics.info.schematic_author"), SchematicsPage.translateAuthorName(file.getAuthor()));
                }
                if (file.getTimeCreated() != null) {
                    this.addDetailItem(I18n.i18n("schematics.info.time_created"), I18n.formatDateTime(file.getTimeCreated()));
                }
                if (file.getTimeModified() != null && !file.getTimeModified().equals(file.getTimeCreated())) {
                    this.addDetailItem(I18n.i18n("schematics.info.time_modified"), I18n.formatDateTime(file.getTimeModified()));
                }
                if (file.getRegionCount() > 0) {
                    this.addDetailItem(I18n.i18n("schematics.info.region_count"), String.valueOf(file.getRegionCount()));
                }
                if (file.getTotalVolume() > 0) {
                    this.addDetailItem(I18n.i18n("schematics.info.total_volume"), file.getTotalVolume());
                }
                if (file.getTotalBlocks() > 0) {
                    this.addDetailItem(I18n.i18n("schematics.info.total_blocks"), file.getTotalBlocks());
                }
                if (file.getEnclosingSize() != null) {
                    this.addDetailItem(I18n.i18n("schematics.info.enclosing_size"), String.format("%d x %d x %d", (int)file.getEnclosingSize().getX(), (int)file.getEnclosingSize().getY(), (int)file.getEnclosingSize().getZ()));
                }
                this.addDetailItem(I18n.i18n("schematics.info.version"), file.getVersion());
            }

            LitematicInfoDialog() {
                HBox titleBox = new HBox(8.0);
                Node icon = LitematicFileItem.this.getIcon(40);
                TwoLineListItem title = new TwoLineListItem();
                title.setTitle(LitematicFileItem.this.getName());
                title.setSubtitle(LitematicFileItem.this.file.getFile().getFileName().toString());
                titleBox.getChildren().setAll((Object[])new Node[]{icon, title});
                this.setHeading(new Node[]{titleBox});
                this.details = new ComponentList();
                StackPane detailsContainer = new StackPane();
                detailsContainer.setPadding(new Insets(10.0, 0.0, 0.0, 0.0));
                detailsContainer.getChildren().add((Object)this.details);
                this.setBody(new Node[]{detailsContainer});
                JFXButton okButton = new JFXButton();
                okButton.getStyleClass().add((Object)"dialog-accept");
                okButton.setText(I18n.i18n("button.ok"));
                okButton.setOnAction(e -> this.fireEvent(new DialogCloseEvent()));
                this.getActions().add((Object)okButton);
                FXUtils.onEscPressed((Node)this, () -> ((JFXButton)okButton).fire());
                this.updateContent(LitematicFileItem.this.file);
            }
        }
    }

    private final class DirItem
    extends Item {
        final Path path;
        @Nullable
        final DirItem parent;
        final List<Item> children;
        final List<String> relativePath;

        DirItem(@Nullable Path path, DirItem parent) {
            this.children = new ArrayList<Item>();
            this.path = path;
            this.parent = parent;
            if (parent != null) {
                this.relativePath = new ArrayList<String>(parent.relativePath);
                this.relativePath.add(path.getFileName().toString());
            } else {
                this.relativePath = Collections.emptyList();
            }
        }

        @Override
        int order() {
            return 1;
        }

        @Override
        Path getPath() {
            return this.path;
        }

        @Override
        public String getName() {
            return this.path.getFileName().toString();
        }

        @Override
        String getDescription() {
            return I18n.i18n("schematics.sub_items", this.children.size());
        }

        @Override
        SVG getIcon() {
            return SVG.FOLDER;
        }

        @Override
        void onClick() {
            SchematicsPage.this.navigateTo(this);
        }

        @Override
        void onReveal() {
            FXUtils.openFolder(this.path.toFile());
        }

        @Override
        void onDelete() {
            try {
                FileUtils.cleanDirectory(this.path.toFile());
                Files.deleteIfExists(this.path);
                SchematicsPage.this.refresh();
            }
            catch (IOException e) {
                Logger.LOG.warning("Failed to delete directory: " + this.path, e);
            }
        }
    }

    private final class BackItem
    extends Item {
        private final DirItem parent;

        BackItem(DirItem parent) {
            this.parent = parent;
        }

        @Override
        int order() {
            return 0;
        }

        @Override
        Path getPath() {
            return null;
        }

        @Override
        String getName() {
            return "..";
        }

        @Override
        String getDescription() {
            return I18n.i18n("schematics.back_to", this.parent.getName());
        }

        @Override
        SVG getIcon() {
            return SVG.FOLDER;
        }

        @Override
        void onClick() {
            SchematicsPage.this.navigateTo(this.parent);
        }

        @Override
        void onReveal() {
            throw new UnsupportedOperationException("Unreachable");
        }

        @Override
        void onDelete() {
            throw new UnsupportedOperationException("Unreachable");
        }
    }

    abstract class Item
    extends Control
    implements Comparable<Item> {
        Item() {
        }

        boolean isDirectory() {
            return this instanceof DirItem;
        }

        abstract Path getPath();

        abstract String getName();

        abstract String getDescription();

        abstract SVG getIcon();

        Node getIcon(int size) {
            StackPane icon = new StackPane();
            icon.setPrefSize((double)size, (double)size);
            icon.setMaxSize((double)size, (double)size);
            icon.getChildren().add((Object)this.getIcon().createIcon((Paint)Theme.blackFill(), (double)size));
            return icon;
        }

        abstract int order();

        abstract void onClick();

        abstract void onReveal();

        abstract void onDelete();

        @Override
        public int compareTo(@NotNull Item o) {
            if (this.order() != o.order()) {
                return Integer.compare(this.order(), o.order());
            }
            return this.getName().compareTo(o.getName());
        }

        protected Skin<?> createDefaultSkin() {
            return new ItemSkin(this);
        }
    }
}

