/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class ServerAddress {
    private static final int UNKNOWN_PORT = -1;
    private final String host;
    private final int port;

    private static IllegalArgumentException illegalAddress(String address) {
        return new IllegalArgumentException("Invalid server address: " + address);
    }

    @NotNull
    public static ServerAddress parse(@NotNull String address) {
        int port;
        Objects.requireNonNull(address);
        if (!address.startsWith("[")) {
            int colonPos = address.indexOf(58);
            if (colonPos >= 0) {
                int port2;
                if (colonPos == address.length() - 1) {
                    throw ServerAddress.illegalAddress(address);
                }
                String host = address.substring(0, colonPos);
                try {
                    port2 = Integer.parseInt(address.substring(colonPos + 1));
                }
                catch (NumberFormatException e) {
                    throw ServerAddress.illegalAddress(address);
                }
                if (port2 < 0 || port2 > 65535) {
                    throw ServerAddress.illegalAddress(address);
                }
                return new ServerAddress(host, port2);
            }
            return new ServerAddress(address);
        }
        int colonIndex = address.indexOf(58);
        int closeBracketIndex = address.lastIndexOf(93);
        if (colonIndex < 0 || closeBracketIndex < colonIndex) {
            throw ServerAddress.illegalAddress(address);
        }
        String host = address.substring(1, closeBracketIndex);
        if (closeBracketIndex == address.length() - 1) {
            return new ServerAddress(host);
        }
        if (address.length() < closeBracketIndex + 3 || address.charAt(closeBracketIndex + 1) != ':') {
            throw ServerAddress.illegalAddress(address);
        }
        try {
            port = Integer.parseInt(address.substring(closeBracketIndex + 2));
        }
        catch (NumberFormatException e) {
            throw ServerAddress.illegalAddress(address);
        }
        if (port < 0 || port > 65535) {
            throw ServerAddress.illegalAddress(address);
        }
        return new ServerAddress(host, port);
    }

    public ServerAddress(@NotNull String host) {
        this(host, -1);
    }

    public ServerAddress(@NotNull String host, int port) {
        this.host = Objects.requireNonNull(host);
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ServerAddress)) {
            return false;
        }
        ServerAddress that = (ServerAddress)o;
        return this.port == that.port && Objects.equals(this.host, that.host);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port);
    }

    public String toString() {
        return String.format("ServerAddress[host='%s', port=%d]", this.host, this.port);
    }
}

