/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import org.jackhuang.hmcl.util.InfiniteSizeList;
import org.jetbrains.annotations.NotNull;

public final class CSVTable {
    private int columnCount = 0;
    private int rowCount = 0;
    private final InfiniteSizeList<InfiniteSizeList<String>> table = new InfiniteSizeList();

    public int getColumnCount() {
        return this.columnCount;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    @NotNull
    public String get(int x, int y) {
        List row = this.table.get(y);
        if (row == null) {
            return "";
        }
        String value = (String)row.get(x);
        return value != null ? value : "";
    }

    public void set(int x, int y, String txt) {
        if (x < 0 || y < 0) {
            throw new IllegalArgumentException("x or y must be greater than or equal to 0");
        }
        InfiniteSizeList<String> row = this.table.get(y);
        if (row == null) {
            row = new InfiniteSizeList(x);
            this.table.set(y, row);
        }
        row.set(x, txt);
        this.columnCount = Integer.max(this.columnCount, x + 1);
        this.rowCount = Integer.max(this.rowCount, y + 1);
    }

    public void write(Path file) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);){
            this.write(writer);
        }
    }

    public void write(Appendable out) throws IOException {
        for (int rowIndex = 0; rowIndex < this.rowCount; ++rowIndex) {
            int columnIndex;
            List row = this.table.get(rowIndex);
            if (row != null) {
                for (columnIndex = 0; columnIndex < this.columnCount; ++columnIndex) {
                    String txt = (String)row.get(columnIndex);
                    if (txt != null) {
                        if (txt.indexOf(34) < 0 && txt.indexOf(44) < 0 && txt.indexOf(10) < 0 && txt.indexOf(13) < 0) {
                            out.append(txt);
                        } else {
                            out.append('\"');
                            block7: for (int i = 0; i < txt.length(); ++i) {
                                char c = txt.charAt(i);
                                switch (c) {
                                    case '\"': {
                                        out.append("\\\"");
                                        continue block7;
                                    }
                                    case '\r': {
                                        out.append("\\r");
                                        continue block7;
                                    }
                                    case '\n': {
                                        out.append("\\n");
                                        continue block7;
                                    }
                                    default: {
                                        out.append(c);
                                    }
                                }
                            }
                            out.append('\"');
                        }
                    }
                    if (columnIndex >= this.columnCount - 1) continue;
                    out.append(',');
                }
            } else {
                for (columnIndex = 0; columnIndex < this.columnCount - 1; ++columnIndex) {
                    out.append(',');
                }
            }
            out.append('\n');
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        try {
            this.write(builder);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return builder.toString();
    }
}

