/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.io;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.zip.GZIPInputStream;
import org.glavo.chardet.DetectedCharset;
import org.glavo.chardet.UniversalDetector;
import org.jackhuang.hmcl.util.platform.OperatingSystem;

public final class IOUtils {
    public static final int DEFAULT_BUFFER_SIZE = 8192;

    private IOUtils() {
    }

    public static BufferedReader newBufferedReaderMaybeNativeEncoding(Path file) throws IOException {
        if (OperatingSystem.NATIVE_CHARSET == StandardCharsets.UTF_8) {
            return Files.newBufferedReader(file);
        }
        FileChannel channel = FileChannel.open(file, new OpenOption[0]);
        try {
            long oldPosition = channel.position();
            DetectedCharset detectedCharset = UniversalDetector.detectCharset(channel);
            Charset charset = detectedCharset != null && detectedCharset.isSupported() && (detectedCharset.getCharset() == StandardCharsets.UTF_8 || detectedCharset.getCharset() == StandardCharsets.US_ASCII) ? StandardCharsets.UTF_8 : OperatingSystem.NATIVE_CHARSET;
            channel.position(oldPosition);
            return new BufferedReader(new InputStreamReader(Channels.newInputStream(channel), charset));
        }
        catch (Throwable e) {
            IOUtils.closeQuietly(channel, e);
            throw e;
        }
    }

    public static byte[] readFullyWithoutClosing(InputStream stream) throws IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream(Math.max(stream.available(), 32));
        IOUtils.copyTo(stream, result);
        return result.toByteArray();
    }

    public static String readFullyAsStringWithClosing(InputStream stream) throws IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream(Math.max(stream.available(), 32));
        IOUtils.copyTo(stream, result);
        return result.toString("UTF-8");
    }

    public static ByteArrayOutputStream readFully(InputStream stream) throws IOException {
        try (InputStream is = stream;){
            ByteArrayOutputStream result = new ByteArrayOutputStream(Math.max(is.available(), 32));
            IOUtils.copyTo(is, result);
            ByteArrayOutputStream byteArrayOutputStream = result;
            return byteArrayOutputStream;
        }
    }

    public static byte[] readFullyAsByteArray(InputStream stream) throws IOException {
        return IOUtils.readFully(stream).toByteArray();
    }

    public static String readFullyAsString(InputStream stream) throws IOException {
        return IOUtils.readFully(stream).toString("UTF-8");
    }

    public static String readFullyAsString(InputStream stream, Charset charset) throws IOException {
        return IOUtils.readFully(stream).toString(charset.name());
    }

    public static void copyTo(InputStream src, OutputStream dest) throws IOException {
        IOUtils.copyTo(src, dest, new byte[8192]);
    }

    public static void copyTo(InputStream src, OutputStream dest, byte[] buf) throws IOException {
        int len;
        while ((len = src.read(buf)) != -1) {
            dest.write(buf, 0, len);
        }
    }

    public static InputStream wrapFromGZip(InputStream inputStream) throws IOException {
        return new GZIPInputStream(inputStream);
    }

    public static void closeQuietly(AutoCloseable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void closeQuietly(AutoCloseable closeable, Throwable exception) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Throwable e) {
            exception.addSuppressed(e);
        }
    }
}

