/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.platform;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jackhuang.hmcl.java.JavaRuntime;
import org.jackhuang.hmcl.launch.StreamPump;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.platform.OperatingSystem;

public final class ManagedProcess {
    private final Process process;
    private final List<String> commands;
    private final String classpath;
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final List<String> lines = new ArrayList<String>();
    private final List<Thread> relatedThreads = new ArrayList<Thread>();

    public ManagedProcess(ProcessBuilder processBuilder) throws IOException {
        this.process = processBuilder.start();
        this.commands = processBuilder.command();
        this.classpath = null;
    }

    public ManagedProcess(Process process, List<String> commands) {
        this.process = process;
        this.commands = Collections.unmodifiableList(new ArrayList<String>(commands));
        this.classpath = null;
    }

    public ManagedProcess(Process process, List<String> commands, String classpath) {
        this.process = process;
        this.commands = Collections.unmodifiableList(new ArrayList<String>(commands));
        this.classpath = classpath;
    }

    public Process getProcess() {
        return this.process;
    }

    public long getPID() throws UnsupportedOperationException {
        if (JavaRuntime.CURRENT_VERSION >= 9) {
            try {
                return MethodHandles.publicLookup().findVirtual(Process.class, "pid", MethodType.methodType(Long.TYPE)).invokeExact(this.process);
            }
            catch (Throwable e) {
                throw new UnsupportedOperationException("Cannot get the pid", e);
            }
        }
        if (OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS) {
            throw new UnsupportedOperationException("Cannot get the pid of a Process on Java 8 on Windows.");
        }
        if (OperatingSystem.CURRENT_OS == OperatingSystem.MACOS || OperatingSystem.CURRENT_OS.isLinuxOrBSD()) {
            try {
                Field pidField = this.process.getClass().getDeclaredField("pid");
                pidField.setAccessible(true);
                return pidField.getInt(this.process);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new UnsupportedOperationException("Cannot get the pid of a Process on Java 8 on macOS/Linux.", e);
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot get the pid of a Process on Java 8 on Unknown Operating System (%s).", System.getProperty("os.name")));
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public String getClasspath() {
        return this.classpath;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public synchronized List<String> getLines(Predicate<String> lineFilter) {
        if (lineFilter == null) {
            return Collections.unmodifiableList(Arrays.asList(this.lines.toArray(new String[0])));
        }
        ArrayList<String> res = new ArrayList<String>();
        for (String line : this.lines) {
            if (!lineFilter.test(line)) continue;
            res.add(line);
        }
        return Collections.unmodifiableList(res);
    }

    public synchronized void addLine(String line) {
        this.lines.add(line);
    }

    public synchronized void addRelatedThread(Thread thread) {
        this.relatedThreads.add(thread);
    }

    public synchronized void pumpInputStream(Consumer<String> onLogLine) {
        this.addRelatedThread(Lang.thread(new StreamPump(this.process.getInputStream(), onLogLine, OperatingSystem.NATIVE_CHARSET), "ProcessInputStreamPump", true));
    }

    public synchronized void pumpErrorStream(Consumer<String> onLogLine) {
        this.addRelatedThread(Lang.thread(new StreamPump(this.process.getErrorStream(), onLogLine, OperatingSystem.NATIVE_CHARSET), "ProcessErrorStreamPump", true));
    }

    public boolean isRunning() {
        try {
            this.process.exitValue();
            return false;
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
    }

    public int getExitCode() {
        return this.process.exitValue();
    }

    public void stop() {
        this.process.destroy();
        this.destroyRelatedThreads();
    }

    public synchronized void destroyRelatedThreads() {
        this.relatedThreads.forEach(Thread::interrupt);
    }

    public String toString() {
        return "ManagedProcess[commands=" + this.commands + ", isRunning=" + this.isRunning() + "]";
    }
}

