/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.platform.windows;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.platform.NativeUtils;
import org.jackhuang.hmcl.util.platform.windows.Advapi32;

public abstract class WinReg {
    public static final WinReg INSTANCE = NativeUtils.USE_JNA && Advapi32.INSTANCE != null ? new JNAWinReg(Advapi32.INSTANCE) : null;

    public abstract boolean exists(HKEY var1, String var2);

    public abstract Object queryValue(HKEY var1, String var2, String var3);

    public abstract List<String> querySubKeyNames(HKEY var1, String var2);

    public List<String> querySubKeys(HKEY root, String key) {
        List<String> list = this.querySubKeyNames(root, key);
        if (list.isEmpty()) {
            return list;
        }
        if (!(list instanceof ArrayList)) {
            list = new ArrayList<String>(list);
        }
        String prefix = key.endsWith("\\") ? key : key + "\\";
        list.replaceAll(str -> prefix + str);
        return list;
    }

    private static final class JNAWinReg
    extends WinReg {
        private final Advapi32 advapi32;

        JNAWinReg(Advapi32 advapi32) {
            this.advapi32 = advapi32;
        }

        @Override
        public boolean exists(HKEY root, String key) {
            PointerByReference phkKey = new PointerByReference();
            int status = this.advapi32.RegOpenKeyExW(root.toPointer(), new WString(key), 0, 131097, phkKey);
            if (status == 0) {
                this.advapi32.RegCloseKey(phkKey.getValue());
                return true;
            }
            return false;
        }

        private static void checkLength(int expected, int actual) {
            if (expected != actual) {
                throw new IllegalStateException("Expected " + expected + " bytes, but got " + actual);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Object queryValue(HKEY root, String key, String valueName) {
            PointerByReference phkKey = new PointerByReference();
            if (this.advapi32.RegOpenKeyExW(root.toPointer(), new WString(key), 0, 131097, phkKey) != 0) {
                return null;
            }
            Pointer hkey = phkKey.getValue();
            try {
                IntByReference lpType = new IntByReference();
                IntByReference lpcbData = new IntByReference();
                int status = this.advapi32.RegQueryValueExW(hkey, new WString(valueName), null, lpType, null, lpcbData);
                if (status != 0) {
                    if (status != 2) throw new RuntimeException("Failed to query value: " + status);
                    Object var9_10 = null;
                    return var9_10;
                }
                int type = lpType.getValue();
                int cbData = lpcbData.getValue();
                Memory lpData = new Memory(cbData);
                status = this.advapi32.RegQueryValueExW(hkey, new WString(valueName), null, null, lpData, lpcbData);
                if (status != 0) {
                    if (status == 2) {
                        Object var12_14 = null;
                        lpData.close();
                        return var12_14;
                    }
                    throw new RuntimeException("Failed to query value: " + status);
                }
                JNAWinReg.checkLength(cbData, lpcbData.getValue());
                switch (type) {
                    case 0: 
                    case 3: {
                        byte[] byArray = lpData.getByteArray(0L, cbData);
                        lpData.close();
                        return byArray;
                    }
                    case 4: 
                    case 5: {
                        ByteOrder expectedOrder;
                        JNAWinReg.checkLength(4, cbData);
                        int value = lpData.getInt(0L);
                        ByteOrder byteOrder = expectedOrder = type == 4 ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
                        if (expectedOrder != ByteOrder.nativeOrder()) {
                            value = Integer.reverseBytes(value);
                        }
                        Integer n = value;
                        return n;
                    }
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                {
                    case 11: {
                        JNAWinReg.checkLength(8, cbData);
                        long value = lpData.getLong(0L);
                        if (ByteOrder.nativeOrder() != ByteOrder.LITTLE_ENDIAN) {
                            value = Long.reverseBytes(value);
                        }
                        Long l = value;
                        lpData.close();
                        return l;
                    }
                    case 1: 
                    case 2: 
                    case 6: {
                        if (cbData < 2) {
                            throw new RuntimeException("Illegal length: " + cbData);
                        }
                        if (lpData.getChar(cbData - 2) != '\u0000') {
                            throw new RuntimeException("The string does not end with \\0");
                        }
                        String string = lpData.getWideString(0L);
                        lpData.close();
                        return string;
                    }
                }
                throw new RuntimeException("Unknown reg type: " + type);
            }
            catch (Throwable e) {
                Logger.LOG.warning("Failed to query value", e);
                return null;
            }
            finally {
                this.advapi32.RegCloseKey(hkey);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<String> querySubKeyNames(HKEY root, String key) {
            PointerByReference phkKey = new PointerByReference();
            if (this.advapi32.RegOpenKeyExW(root.toPointer(), new WString(key), 0, 131097, phkKey) != 0) {
                return Collections.emptyList();
            }
            Pointer hkey = phkKey.getValue();
            try {
                ArrayList<String> res = new ArrayList<String>();
                int maxKeyLength = 256;
                try (Memory lpName = new Memory(maxKeyLength * 2);){
                    int status;
                    IntByReference lpcchName = new IntByReference();
                    int i = 0;
                    while (true) {
                        lpcchName.setValue(maxKeyLength);
                        status = this.advapi32.RegEnumKeyExW(hkey, i, lpName, lpcchName, null, null, null, null);
                        if (status != 0) break;
                        res.add(lpName.getWideString(0L));
                        ++i;
                    }
                    if (status != 259) {
                        Logger.LOG.warning("Failed to enum key: " + status);
                    }
                }
                ArrayList<String> arrayList = res;
                return arrayList;
            }
            catch (Throwable e) {
                Logger.LOG.warning("Failed to query keys", e);
            }
            finally {
                this.advapi32.RegCloseKey(hkey);
            }
            return Collections.emptyList();
        }
    }

    public static enum HKEY {
        HKEY_CLASSES_ROOT(Integer.MIN_VALUE),
        HKEY_CURRENT_USER(-2147483647),
        HKEY_LOCAL_MACHINE(-2147483646),
        HKEY_USERS(-2147483645),
        HKEY_PERFORMANCE_DATA(-2147483644),
        HKEY_PERFORMANCE_TEXT(-2147483568),
        HKEY_PERFORMANCE_NLSTEXT(-2147483552),
        HKEY_CURRENT_CONFIG(-2147483643),
        HKEY_DYN_DATA(-2147483642),
        HKEY_CURRENT_USER_LOCAL_SETTINGS(-2147483641);

        private final int value;

        private HKEY(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public Pointer toPointer() {
            return Pointer.createConstant((long)this.value);
        }
    }
}

