# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: budgets
using AWS.Compat
using AWS.UUIDs

"""
    create_budget(account_id, budget)
    create_budget(account_id, budget, params::Dict{String,<:Any})

Creates a budget and, if included, notifications and subscribers.   Only one of BudgetLimit
or PlannedBudgetLimits can be present in the syntax at one time. Use the syntax that
matches your case. The Request Syntax section shows the BudgetLimit syntax. For
PlannedBudgetLimits, see the Examples section.

# Arguments
- `account_id`: The accountId that is associated with the budget.
- `budget`: The budget object that you want to create.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"NotificationsWithSubscribers"`: A notification that you want to associate with a
  budget. A budget can have up to five notifications, and each notification can have one SNS
  subscriber and up to 10 email subscribers. If you include notifications and subscribers in
  your CreateBudget call, Amazon Web Services creates the notifications and subscribers for
  you.
- `"ResourceTags"`: An optional list of tags to associate with the specified budget. Each
  tag consists of a key and a value, and each key must be unique for the resource.
"""
function create_budget(
    AccountId, Budget; aws_config::AbstractAWSConfig=current_aws_config()
)
    return budgets(
        "CreateBudget",
        Dict{String,Any}("AccountId" => AccountId, "Budget" => Budget);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_budget(
    AccountId,
    Budget,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return budgets(
        "CreateBudget",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("AccountId" => AccountId, "Budget" => Budget),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_budget_action(account_id, action_threshold, action_type, approval_model, budget_name, definition, execution_role_arn, notification_type, subscribers)
    create_budget_action(account_id, action_threshold, action_type, approval_model, budget_name, definition, execution_role_arn, notification_type, subscribers, params::Dict{String,<:Any})

 Creates a budget action.

# Arguments
- `account_id`:
- `action_threshold`:
- `action_type`:  The type of action. This defines the type of tasks that can be carried
  out by this action. This field also determines the format for definition.
- `approval_model`:  This specifies if the action needs manual or automatic approval.
- `budget_name`:
- `definition`:
- `execution_role_arn`:  The role passed for action execution and reversion. Roles and
  actions must be in the same account.
- `notification_type`:
- `subscribers`:

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ResourceTags"`: An optional list of tags to associate with the specified budget action.
  Each tag consists of a key and a value, and each key must be unique for the resource.
"""
function create_budget_action(
    AccountId,
    ActionThreshold,
    ActionType,
    ApprovalModel,
    BudgetName,
    Definition,
    ExecutionRoleArn,
    NotificationType,
    Subscribers;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return budgets(
        "CreateBudgetAction",
        Dict{String,Any}(
            "AccountId" => AccountId,
            "ActionThreshold" => ActionThreshold,
            "ActionType" => ActionType,
            "ApprovalModel" => ApprovalModel,
            "BudgetName" => BudgetName,
            "Definition" => Definition,
            "ExecutionRoleArn" => ExecutionRoleArn,
            "NotificationType" => NotificationType,
            "Subscribers" => Subscribers,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_budget_action(
    AccountId,
    ActionThreshold,
    ActionType,
    ApprovalModel,
    BudgetName,
    Definition,
    ExecutionRoleArn,
    NotificationType,
    Subscribers,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return budgets(
        "CreateBudgetAction",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AccountId" => AccountId,
                    "ActionThreshold" => ActionThreshold,
                    "ActionType" => ActionType,
                    "ApprovalModel" => ApprovalModel,
                    "BudgetName" => BudgetName,
                    "Definition" => Definition,
                    "ExecutionRoleArn" => ExecutionRoleArn,
                    "NotificationType" => NotificationType,
                    "Subscribers" => Subscribers,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_notification(account_id, budget_name, notification, subscribers)
    create_notification(account_id, budget_name, notification, subscribers, params::Dict{String,<:Any})

Creates a notification. You must create the budget before you create the associated
notification.

# Arguments
- `account_id`: The accountId that is associated with the budget that you want to create a
  notification for.
- `budget_name`: The name of the budget that you want Amazon Web Services to notify you
  about. Budget names must be unique within an account.
- `notification`: The notification that you want to create.
- `subscribers`: A list of subscribers that you want to associate with the notification.
  Each notification can have one SNS subscriber and up to 10 email subscribers.

"""
function create_notification(
    AccountId,
    BudgetName,
    Notification,
    Subscribers;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return budgets(
        "CreateNotification",
        Dict{String,Any}(
            "AccountId" => AccountId,
            "BudgetName" => BudgetName,
            "Notification" => Notification,
            "Subscribers" => Subscribers,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_notification(
    AccountId,
    BudgetName,
    Notification,
    Subscribers,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return budgets(
        "CreateNotification",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AccountId" => AccountId,
                    "BudgetName" => BudgetName,
                    "Notification" => Notification,
                    "Subscribers" => Subscribers,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_subscriber(account_id, budget_name, notification, subscriber)
    create_subscriber(account_id, budget_name, notification, subscriber, params::Dict{String,<:Any})

Creates a subscriber. You must create the associated budget and notification before you
create the subscriber.

# Arguments
- `account_id`: The accountId that is associated with the budget that you want to create a
  subscriber for.
- `budget_name`: The name of the budget that you want to subscribe to. Budget names must be
  unique within an account.
- `notification`: The notification that you want to create a subscriber for.
- `subscriber`: The subscriber that you want to associate with a budget notification.

"""
function create_subscriber(
    AccountId,
    BudgetName,
    Notification,
    Subscriber;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return budgets(
        "CreateSubscriber",
        Dict{String,Any}(
            "AccountId" => AccountId,
            "BudgetName" => BudgetName,
            "Notification" => Notification,
            "Subscriber" => Subscriber,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_subscriber(
    AccountId,
    BudgetName,
    Notification,
    Subscriber,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return budgets(
        "CreateSubscriber",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AccountId" => AccountId,
                    "BudgetName" => BudgetName,
                    "Notification" => Notification,
                    "Subscriber" => Subscriber,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_budget(account_id, budget_name)
    delete_budget(account_id, budget_name, params::Dict{String,<:Any})

Deletes a budget. You can delete your budget at any time.  Deleting a budget also deletes
the notifications and subscribers that are associated with that budget.

# Arguments
- `account_id`: The accountId that is associated with the budget that you want to delete.
- `budget_name`: The name of the budget that you want to delete.

"""
function delete_budget(
    AccountId, BudgetName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return budgets(
        "DeleteBudget",
        Dict{String,Any}("AccountId" => AccountId, "BudgetName" => BudgetName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_budget(
    AccountId,
    BudgetName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return budgets(
        "DeleteBudget",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("AccountId" => AccountId, "BudgetName" => BudgetName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_budget_action(account_id, action_id, budget_name)
    delete_budget_action(account_id, action_id, budget_name, params::Dict{String,<:Any})

 Deletes a budget action.

# Arguments
- `account_id`:
- `action_id`:  A system-generated universally unique identifier (UUID) for the action.
- `budget_name`:

"""
function delete_budget_action(
    AccountId, ActionId, BudgetName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return budgets(
        "DeleteBudgetAction",
        Dict{String,Any}(
            "AccountId" => AccountId, "ActionId" => ActionId, "BudgetName" => BudgetName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_budget_action(
    AccountId,
    ActionId,
    BudgetName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return budgets(
        "DeleteBudgetAction",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AccountId" => AccountId,
                    "ActionId" => ActionId,
                    "BudgetName" => BudgetName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_notification(account_id, budget_name, notification)
    delete_notification(account_id, budget_name, notification, params::Dict{String,<:Any})

Deletes a notification.  Deleting a notification also deletes the subscribers that are
associated with the notification.

# Arguments
- `account_id`: The accountId that is associated with the budget whose notification you
  want to delete.
- `budget_name`: The name of the budget whose notification you want to delete.
- `notification`: The notification that you want to delete.

"""
function delete_notification(
    AccountId, BudgetName, Notification; aws_config::AbstractAWSConfig=current_aws_config()
)
    return budgets(
        "DeleteNotification",
        Dict{String,Any}(
            "AccountId" => AccountId,
            "BudgetName" => BudgetName,
            "Notification" => Notification,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_notification(
    AccountId,
    BudgetName,
    Notification,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return budgets(
        "DeleteNotification",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AccountId" => AccountId,
                    "BudgetName" => BudgetName,
                    "Notification" => Notification,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_subscriber(account_id, budget_name, notification, subscriber)
    delete_subscriber(account_id, budget_name, notification, subscriber, params::Dict{String,<:Any})

Deletes a subscriber.  Deleting the last subscriber to a notification also deletes the
notification.

# Arguments
- `account_id`: The accountId that is associated with the budget whose subscriber you want
  to delete.
- `budget_name`: The name of the budget whose subscriber you want to delete.
- `notification`: The notification whose subscriber you want to delete.
- `subscriber`: The subscriber that you want to delete.

"""
function delete_subscriber(
    AccountId,
    BudgetName,
    Notification,
    Subscriber;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return budgets(
        "DeleteSubscriber",
        Dict{String,Any}(
            "AccountId" => AccountId,
            "BudgetName" => BudgetName,
            "Notification" => Notification,
            "Subscriber" => Subscriber,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_subscriber(
    AccountId,
    BudgetName,
    Notification,
    Subscriber,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return budgets(
        "DeleteSubscriber",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AccountId" => AccountId,
                    "BudgetName" => BudgetName,
                    "Notification" => Notification,
                    "Subscriber" => Subscriber,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_budget(account_id, budget_name)
    describe_budget(account_id, budget_name, params::Dict{String,<:Any})

Describes a budget.  The Request Syntax section shows the BudgetLimit syntax. For
PlannedBudgetLimits, see the Examples section.

# Arguments
- `account_id`: The accountId that is associated with the budget that you want a
  description of.
- `budget_name`: The name of the budget that you want a description of.

"""
function describe_budget(
    AccountId, BudgetName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return budgets(
        "DescribeBudget",
        Dict{String,Any}("AccountId" => AccountId, "BudgetName" => BudgetName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_budget(
    AccountId,
    BudgetName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return budgets(
        "DescribeBudget",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("AccountId" => AccountId, "BudgetName" => BudgetName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_budget_action(account_id, action_id, budget_name)
    describe_budget_action(account_id, action_id, budget_name, params::Dict{String,<:Any})

 Describes a budget action detail.

# Arguments
- `account_id`:
- `action_id`:  A system-generated universally unique identifier (UUID) for the action.
- `budget_name`:

"""
function describe_budget_action(
    AccountId, ActionId, BudgetName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return budgets(
        "DescribeBudgetAction",
        Dict{String,Any}(
            "AccountId" => AccountId, "ActionId" => ActionId, "BudgetName" => BudgetName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_budget_action(
    AccountId,
    ActionId,
    BudgetName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return budgets(
        "DescribeBudgetAction",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AccountId" => AccountId,
                    "ActionId" => ActionId,
                    "BudgetName" => BudgetName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_budget_action_histories(account_id, action_id, budget_name)
    describe_budget_action_histories(account_id, action_id, budget_name, params::Dict{String,<:Any})

 Describes a budget action history detail.

# Arguments
- `account_id`:
- `action_id`:  A system-generated universally unique identifier (UUID) for the action.
- `budget_name`:

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`:
- `"NextToken"`:
- `"TimePeriod"`:
"""
function describe_budget_action_histories(
    AccountId, ActionId, BudgetName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return budgets(
        "DescribeBudgetActionHistories",
        Dict{String,Any}(
            "AccountId" => AccountId, "ActionId" => ActionId, "BudgetName" => BudgetName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_budget_action_histories(
    AccountId,
    ActionId,
    BudgetName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return budgets(
        "DescribeBudgetActionHistories",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AccountId" => AccountId,
                    "ActionId" => ActionId,
                    "BudgetName" => BudgetName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_budget_actions_for_account(account_id)
    describe_budget_actions_for_account(account_id, params::Dict{String,<:Any})

 Describes all of the budget actions for an account.

# Arguments
- `account_id`:

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`:
- `"NextToken"`:
"""
function describe_budget_actions_for_account(
    AccountId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return budgets(
        "DescribeBudgetActionsForAccount",
        Dict{String,Any}("AccountId" => AccountId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_budget_actions_for_account(
    AccountId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return budgets(
        "DescribeBudgetActionsForAccount",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("AccountId" => AccountId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_budget_actions_for_budget(account_id, budget_name)
    describe_budget_actions_for_budget(account_id, budget_name, params::Dict{String,<:Any})

 Describes all of the budget actions for a budget.

# Arguments
- `account_id`:
- `budget_name`:

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`:
- `"NextToken"`:
"""
function describe_budget_actions_for_budget(
    AccountId, BudgetName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return budgets(
        "DescribeBudgetActionsForBudget",
        Dict{String,Any}("AccountId" => AccountId, "BudgetName" => BudgetName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_budget_actions_for_budget(
    AccountId,
    BudgetName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return budgets(
        "DescribeBudgetActionsForBudget",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("AccountId" => AccountId, "BudgetName" => BudgetName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_budget_notifications_for_account(account_id)
    describe_budget_notifications_for_account(account_id, params::Dict{String,<:Any})

 Lists the budget names and notifications that are associated with an account.

# Arguments
- `account_id`:

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`:  An integer that represents how many budgets a paginated response
  contains. The default is 50.
- `"NextToken"`:
"""
function describe_budget_notifications_for_account(
    AccountId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return budgets(
        "DescribeBudgetNotificationsForAccount",
        Dict{String,Any}("AccountId" => AccountId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_budget_notifications_for_account(
    AccountId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return budgets(
        "DescribeBudgetNotificationsForAccount",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("AccountId" => AccountId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_budget_performance_history(account_id, budget_name)
    describe_budget_performance_history(account_id, budget_name, params::Dict{String,<:Any})

Describes the history for DAILY, MONTHLY, and QUARTERLY budgets. Budget history isn't
available for ANNUAL budgets.

# Arguments
- `account_id`:
- `budget_name`:

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`:
- `"NextToken"`:
- `"TimePeriod"`: Retrieves how often the budget went into an ALARM state for the specified
  time period.
"""
function describe_budget_performance_history(
    AccountId, BudgetName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return budgets(
        "DescribeBudgetPerformanceHistory",
        Dict{String,Any}("AccountId" => AccountId, "BudgetName" => BudgetName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_budget_performance_history(
    AccountId,
    BudgetName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return budgets(
        "DescribeBudgetPerformanceHistory",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("AccountId" => AccountId, "BudgetName" => BudgetName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_budgets(account_id)
    describe_budgets(account_id, params::Dict{String,<:Any})

Lists the budgets that are associated with an account.  The Request Syntax section shows
the BudgetLimit syntax. For PlannedBudgetLimits, see the Examples section.

# Arguments
- `account_id`: The accountId that is associated with the budgets that you want to describe.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: An integer that represents how many budgets a paginated response
  contains. The default is 100.
- `"NextToken"`: The pagination token that you include in your request to indicate the next
  set of results that you want to retrieve.
"""
function describe_budgets(AccountId; aws_config::AbstractAWSConfig=current_aws_config())
    return budgets(
        "DescribeBudgets",
        Dict{String,Any}("AccountId" => AccountId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_budgets(
    AccountId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return budgets(
        "DescribeBudgets",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("AccountId" => AccountId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_notifications_for_budget(account_id, budget_name)
    describe_notifications_for_budget(account_id, budget_name, params::Dict{String,<:Any})

Lists the notifications that are associated with a budget.

# Arguments
- `account_id`: The accountId that is associated with the budget whose notifications you
  want descriptions of.
- `budget_name`: The name of the budget whose notifications you want descriptions of.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: An optional integer that represents how many entries a paginated response
  contains.
- `"NextToken"`: The pagination token that you include in your request to indicate the next
  set of results that you want to retrieve.
"""
function describe_notifications_for_budget(
    AccountId, BudgetName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return budgets(
        "DescribeNotificationsForBudget",
        Dict{String,Any}("AccountId" => AccountId, "BudgetName" => BudgetName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_notifications_for_budget(
    AccountId,
    BudgetName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return budgets(
        "DescribeNotificationsForBudget",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("AccountId" => AccountId, "BudgetName" => BudgetName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_subscribers_for_notification(account_id, budget_name, notification)
    describe_subscribers_for_notification(account_id, budget_name, notification, params::Dict{String,<:Any})

Lists the subscribers that are associated with a notification.

# Arguments
- `account_id`: The accountId that is associated with the budget whose subscribers you want
  descriptions of.
- `budget_name`: The name of the budget whose subscribers you want descriptions of.
- `notification`: The notification whose subscribers you want to list.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: An optional integer that represents how many entries a paginated response
  contains.
- `"NextToken"`: The pagination token that you include in your request to indicate the next
  set of results that you want to retrieve.
"""
function describe_subscribers_for_notification(
    AccountId, BudgetName, Notification; aws_config::AbstractAWSConfig=current_aws_config()
)
    return budgets(
        "DescribeSubscribersForNotification",
        Dict{String,Any}(
            "AccountId" => AccountId,
            "BudgetName" => BudgetName,
            "Notification" => Notification,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_subscribers_for_notification(
    AccountId,
    BudgetName,
    Notification,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return budgets(
        "DescribeSubscribersForNotification",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AccountId" => AccountId,
                    "BudgetName" => BudgetName,
                    "Notification" => Notification,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    execute_budget_action(account_id, action_id, budget_name, execution_type)
    execute_budget_action(account_id, action_id, budget_name, execution_type, params::Dict{String,<:Any})

 Executes a budget action.

# Arguments
- `account_id`:
- `action_id`:  A system-generated universally unique identifier (UUID) for the action.
- `budget_name`:
- `execution_type`:  The type of execution.

"""
function execute_budget_action(
    AccountId,
    ActionId,
    BudgetName,
    ExecutionType;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return budgets(
        "ExecuteBudgetAction",
        Dict{String,Any}(
            "AccountId" => AccountId,
            "ActionId" => ActionId,
            "BudgetName" => BudgetName,
            "ExecutionType" => ExecutionType,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function execute_budget_action(
    AccountId,
    ActionId,
    BudgetName,
    ExecutionType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return budgets(
        "ExecuteBudgetAction",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AccountId" => AccountId,
                    "ActionId" => ActionId,
                    "BudgetName" => BudgetName,
                    "ExecutionType" => ExecutionType,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

Lists tags associated with a budget or budget action resource.

# Arguments
- `resource_arn`: The unique identifier for the resource.

"""
function list_tags_for_resource(
    ResourceARN; aws_config::AbstractAWSConfig=current_aws_config()
)
    return budgets(
        "ListTagsForResource",
        Dict{String,Any}("ResourceARN" => ResourceARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    ResourceARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return budgets(
        "ListTagsForResource",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResourceARN" => ResourceARN), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, resource_tags)
    tag_resource(resource_arn, resource_tags, params::Dict{String,<:Any})

Creates tags for a budget or budget action resource.

# Arguments
- `resource_arn`: The unique identifier for the resource.
- `resource_tags`: The tags associated with the resource.

"""
function tag_resource(
    ResourceARN, ResourceTags; aws_config::AbstractAWSConfig=current_aws_config()
)
    return budgets(
        "TagResource",
        Dict{String,Any}("ResourceARN" => ResourceARN, "ResourceTags" => ResourceTags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    ResourceARN,
    ResourceTags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return budgets(
        "TagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ResourceARN" => ResourceARN, "ResourceTags" => ResourceTags
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, resource_tag_keys)
    untag_resource(resource_arn, resource_tag_keys, params::Dict{String,<:Any})

Deletes tags associated with a budget or budget action resource.

# Arguments
- `resource_arn`: The unique identifier for the resource.
- `resource_tag_keys`: The key that's associated with the tag.

"""
function untag_resource(
    ResourceARN, ResourceTagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return budgets(
        "UntagResource",
        Dict{String,Any}(
            "ResourceARN" => ResourceARN, "ResourceTagKeys" => ResourceTagKeys
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    ResourceARN,
    ResourceTagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return budgets(
        "UntagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ResourceARN" => ResourceARN, "ResourceTagKeys" => ResourceTagKeys
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_budget(account_id, new_budget)
    update_budget(account_id, new_budget, params::Dict{String,<:Any})

Updates a budget. You can change every part of a budget except for the budgetName and the
calculatedSpend. When you modify a budget, the calculatedSpend drops to zero until Amazon
Web Services has new usage data to use for forecasting.  Only one of BudgetLimit or
PlannedBudgetLimits can be present in the syntax at one time. Use the syntax that matches
your case. The Request Syntax section shows the BudgetLimit syntax. For
PlannedBudgetLimits, see the Examples section.

# Arguments
- `account_id`: The accountId that is associated with the budget that you want to update.
- `new_budget`: The budget that you want to update your budget to.

"""
function update_budget(
    AccountId, NewBudget; aws_config::AbstractAWSConfig=current_aws_config()
)
    return budgets(
        "UpdateBudget",
        Dict{String,Any}("AccountId" => AccountId, "NewBudget" => NewBudget);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_budget(
    AccountId,
    NewBudget,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return budgets(
        "UpdateBudget",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("AccountId" => AccountId, "NewBudget" => NewBudget),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_budget_action(account_id, action_id, budget_name)
    update_budget_action(account_id, action_id, budget_name, params::Dict{String,<:Any})

 Updates a budget action.

# Arguments
- `account_id`:
- `action_id`:  A system-generated universally unique identifier (UUID) for the action.
- `budget_name`:

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ActionThreshold"`:
- `"ApprovalModel"`:  This specifies if the action needs manual or automatic approval.
- `"Definition"`:
- `"ExecutionRoleArn"`:  The role passed for action execution and reversion. Roles and
  actions must be in the same account.
- `"NotificationType"`:
- `"Subscribers"`:
"""
function update_budget_action(
    AccountId, ActionId, BudgetName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return budgets(
        "UpdateBudgetAction",
        Dict{String,Any}(
            "AccountId" => AccountId, "ActionId" => ActionId, "BudgetName" => BudgetName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_budget_action(
    AccountId,
    ActionId,
    BudgetName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return budgets(
        "UpdateBudgetAction",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AccountId" => AccountId,
                    "ActionId" => ActionId,
                    "BudgetName" => BudgetName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_notification(account_id, budget_name, new_notification, old_notification)
    update_notification(account_id, budget_name, new_notification, old_notification, params::Dict{String,<:Any})

Updates a notification.

# Arguments
- `account_id`: The accountId that is associated with the budget whose notification you
  want to update.
- `budget_name`: The name of the budget whose notification you want to update.
- `new_notification`: The updated notification to be associated with a budget.
- `old_notification`: The previous notification that is associated with a budget.

"""
function update_notification(
    AccountId,
    BudgetName,
    NewNotification,
    OldNotification;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return budgets(
        "UpdateNotification",
        Dict{String,Any}(
            "AccountId" => AccountId,
            "BudgetName" => BudgetName,
            "NewNotification" => NewNotification,
            "OldNotification" => OldNotification,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_notification(
    AccountId,
    BudgetName,
    NewNotification,
    OldNotification,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return budgets(
        "UpdateNotification",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AccountId" => AccountId,
                    "BudgetName" => BudgetName,
                    "NewNotification" => NewNotification,
                    "OldNotification" => OldNotification,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_subscriber(account_id, budget_name, new_subscriber, notification, old_subscriber)
    update_subscriber(account_id, budget_name, new_subscriber, notification, old_subscriber, params::Dict{String,<:Any})

Updates a subscriber.

# Arguments
- `account_id`: The accountId that is associated with the budget whose subscriber you want
  to update.
- `budget_name`: The name of the budget whose subscriber you want to update.
- `new_subscriber`: The updated subscriber that is associated with a budget notification.
- `notification`: The notification whose subscriber you want to update.
- `old_subscriber`: The previous subscriber that is associated with a budget notification.

"""
function update_subscriber(
    AccountId,
    BudgetName,
    NewSubscriber,
    Notification,
    OldSubscriber;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return budgets(
        "UpdateSubscriber",
        Dict{String,Any}(
            "AccountId" => AccountId,
            "BudgetName" => BudgetName,
            "NewSubscriber" => NewSubscriber,
            "Notification" => Notification,
            "OldSubscriber" => OldSubscriber,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_subscriber(
    AccountId,
    BudgetName,
    NewSubscriber,
    Notification,
    OldSubscriber,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return budgets(
        "UpdateSubscriber",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AccountId" => AccountId,
                    "BudgetName" => BudgetName,
                    "NewSubscriber" => NewSubscriber,
                    "Notification" => Notification,
                    "OldSubscriber" => OldSubscriber,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
