# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: device_farm
using AWS.Compat
using AWS.UUIDs

"""
    create_device_pool(name, project_arn, rules)
    create_device_pool(name, project_arn, rules, params::Dict{String,<:Any})

Creates a device pool.

# Arguments
- `name`: The device pool's name.
- `project_arn`: The ARN of the project for the device pool.
- `rules`: The device pool's rules.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"description"`: The device pool's description.
- `"maxDevices"`: The number of devices that Device Farm can add to your device pool.
  Device Farm adds devices that are available and meet the criteria that you assign for the
  rules parameter. Depending on how many devices meet these constraints, your device pool
  might contain fewer devices than the value for this parameter. By specifying the maximum
  number of devices, you can control the costs that you incur by running tests.
"""
function create_device_pool(
    name, projectArn, rules; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "CreateDevicePool",
        Dict{String,Any}("name" => name, "projectArn" => projectArn, "rules" => rules);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_device_pool(
    name,
    projectArn,
    rules,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return device_farm(
        "CreateDevicePool",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "name" => name, "projectArn" => projectArn, "rules" => rules
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_instance_profile(name)
    create_instance_profile(name, params::Dict{String,<:Any})

Creates a profile that can be applied to one or more private fleet device instances.

# Arguments
- `name`: The name of your instance profile.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"description"`: The description of your instance profile.
- `"excludeAppPackagesFromCleanup"`: An array of strings that specifies the list of app
  packages that should not be cleaned up from the device after a test run. The list of
  packages is considered only if you set packageCleanup to true.
- `"packageCleanup"`: When set to true, Device Farm removes app packages after a test run.
  The default value is false for private devices.
- `"rebootAfterUse"`: When set to true, Device Farm reboots the instance after a test run.
  The default value is true.
"""
function create_instance_profile(name; aws_config::AbstractAWSConfig=current_aws_config())
    return device_farm(
        "CreateInstanceProfile",
        Dict{String,Any}("name" => name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_instance_profile(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "CreateInstanceProfile",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("name" => name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_network_profile(name, project_arn)
    create_network_profile(name, project_arn, params::Dict{String,<:Any})

Creates a network profile.

# Arguments
- `name`: The name for the new network profile.
- `project_arn`: The Amazon Resource Name (ARN) of the project for which you want to create
  a network profile.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"description"`: The description of the network profile.
- `"downlinkBandwidthBits"`: The data throughput rate in bits per second, as an integer
  from 0 to 104857600.
- `"downlinkDelayMs"`: Delay time for all packets to destination in milliseconds as an
  integer from 0 to 2000.
- `"downlinkJitterMs"`: Time variation in the delay of received packets in milliseconds as
  an integer from 0 to 2000.
- `"downlinkLossPercent"`: Proportion of received packets that fail to arrive from 0 to 100
  percent.
- `"type"`: The type of network profile to create. Valid values are listed here.
- `"uplinkBandwidthBits"`: The data throughput rate in bits per second, as an integer from
  0 to 104857600.
- `"uplinkDelayMs"`: Delay time for all packets to destination in milliseconds as an
  integer from 0 to 2000.
- `"uplinkJitterMs"`: Time variation in the delay of received packets in milliseconds as an
  integer from 0 to 2000.
- `"uplinkLossPercent"`: Proportion of transmitted packets that fail to arrive from 0 to
  100 percent.
"""
function create_network_profile(
    name, projectArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "CreateNetworkProfile",
        Dict{String,Any}("name" => name, "projectArn" => projectArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_network_profile(
    name,
    projectArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return device_farm(
        "CreateNetworkProfile",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("name" => name, "projectArn" => projectArn), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_project(name)
    create_project(name, params::Dict{String,<:Any})

Creates a project.

# Arguments
- `name`: The project's name.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"defaultJobTimeoutMinutes"`: Sets the execution timeout value (in minutes) for a
  project. All test runs in this project use the specified execution timeout value unless
  overridden when scheduling a run.
- `"vpcConfig"`: The VPC security groups and subnets that are attached to a project.
"""
function create_project(name; aws_config::AbstractAWSConfig=current_aws_config())
    return device_farm(
        "CreateProject",
        Dict{String,Any}("name" => name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_project(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "CreateProject",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("name" => name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_remote_access_session(device_arn, project_arn)
    create_remote_access_session(device_arn, project_arn, params::Dict{String,<:Any})

Specifies and starts a remote access session.

# Arguments
- `device_arn`: The ARN of the device for which you want to create a remote access session.
- `project_arn`: The Amazon Resource Name (ARN) of the project for which you want to create
  a remote access session.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientId"`: Unique identifier for the client. If you want access to multiple devices on
  the same client, you should pass the same clientId value in each call to
  CreateRemoteAccessSession. This identifier is required only if remoteDebugEnabled is set to
  true. Remote debugging is no longer supported.
- `"configuration"`: The configuration information for the remote access session request.
- `"instanceArn"`: The Amazon Resource Name (ARN) of the device instance for which you want
  to create a remote access session.
- `"interactionMode"`: The interaction mode of the remote access session. Valid values are:
    INTERACTIVE: You can interact with the iOS device by viewing, touching, and rotating the
  screen. You cannot run XCUITest framework-based tests in this mode.   NO_VIDEO: You are
  connected to the device, but cannot interact with it or view the screen. This mode has the
  fastest test execution speed. You can run XCUITest framework-based tests in this mode.
  VIDEO_ONLY: You can view the screen, but cannot touch or rotate it. You can run XCUITest
  framework-based tests and watch the screen in this mode.
- `"name"`: The name of the remote access session to create.
- `"remoteDebugEnabled"`: Set to true if you want to access devices remotely for debugging
  in your remote access session. Remote debugging is no longer supported.
- `"remoteRecordAppArn"`: The Amazon Resource Name (ARN) for the app to be recorded in the
  remote access session.
- `"remoteRecordEnabled"`: Set to true to enable remote recording for the remote access
  session.
- `"skipAppResign"`: When set to true, for private devices, Device Farm does not sign your
  app again. For public devices, Device Farm always signs your apps again. For more
  information on how Device Farm modifies your uploads during tests, see Do you modify my
  app?
- `"sshPublicKey"`: Ignored. The public key of the ssh key pair you want to use for
  connecting to remote devices in your remote debugging session. This key is required only if
  remoteDebugEnabled is set to true. Remote debugging is no longer supported.
"""
function create_remote_access_session(
    deviceArn, projectArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "CreateRemoteAccessSession",
        Dict{String,Any}("deviceArn" => deviceArn, "projectArn" => projectArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_remote_access_session(
    deviceArn,
    projectArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return device_farm(
        "CreateRemoteAccessSession",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("deviceArn" => deviceArn, "projectArn" => projectArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_test_grid_project(name)
    create_test_grid_project(name, params::Dict{String,<:Any})

Creates a Selenium testing project. Projects are used to track TestGridSession instances.

# Arguments
- `name`: Human-readable name of the Selenium testing project.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"description"`: Human-readable description of the project.
- `"vpcConfig"`: The VPC security groups and subnets that are attached to a project.
"""
function create_test_grid_project(name; aws_config::AbstractAWSConfig=current_aws_config())
    return device_farm(
        "CreateTestGridProject",
        Dict{String,Any}("name" => name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_test_grid_project(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "CreateTestGridProject",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("name" => name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_test_grid_url(expires_in_seconds, project_arn)
    create_test_grid_url(expires_in_seconds, project_arn, params::Dict{String,<:Any})

Creates a signed, short-term URL that can be passed to a Selenium RemoteWebDriver
constructor.

# Arguments
- `expires_in_seconds`: Lifetime, in seconds, of the URL.
- `project_arn`: ARN (from CreateTestGridProject or ListTestGridProjects) to associate with
  the short-term URL.

"""
function create_test_grid_url(
    expiresInSeconds, projectArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "CreateTestGridUrl",
        Dict{String,Any}(
            "expiresInSeconds" => expiresInSeconds, "projectArn" => projectArn
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_test_grid_url(
    expiresInSeconds,
    projectArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return device_farm(
        "CreateTestGridUrl",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "expiresInSeconds" => expiresInSeconds, "projectArn" => projectArn
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_upload(name, project_arn, type)
    create_upload(name, project_arn, type, params::Dict{String,<:Any})

Uploads an app or test scripts.

# Arguments
- `name`: The upload's file name. The name should not contain any forward slashes (/). If
  you are uploading an iOS app, the file name must end with the .ipa extension. If you are
  uploading an Android app, the file name must end with the .apk extension. For all others,
  the file name must end with the .zip file extension.
- `project_arn`: The ARN of the project for the upload.
- `type`: The upload's upload type. Must be one of the following values:   ANDROID_APP
  IOS_APP   WEB_APP   EXTERNAL_DATA   APPIUM_JAVA_JUNIT_TEST_PACKAGE
  APPIUM_JAVA_TESTNG_TEST_PACKAGE   APPIUM_PYTHON_TEST_PACKAGE   APPIUM_NODE_TEST_PACKAGE
  APPIUM_RUBY_TEST_PACKAGE   APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE
  APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE   APPIUM_WEB_PYTHON_TEST_PACKAGE
  APPIUM_WEB_NODE_TEST_PACKAGE   APPIUM_WEB_RUBY_TEST_PACKAGE   CALABASH_TEST_PACKAGE
  INSTRUMENTATION_TEST_PACKAGE   UIAUTOMATION_TEST_PACKAGE   UIAUTOMATOR_TEST_PACKAGE
  XCTEST_TEST_PACKAGE   XCTEST_UI_TEST_PACKAGE   APPIUM_JAVA_JUNIT_TEST_SPEC
  APPIUM_JAVA_TESTNG_TEST_SPEC   APPIUM_PYTHON_TEST_SPEC   APPIUM_NODE_TEST_SPEC
  APPIUM_RUBY_TEST_SPEC   APPIUM_WEB_JAVA_JUNIT_TEST_SPEC   APPIUM_WEB_JAVA_TESTNG_TEST_SPEC
   APPIUM_WEB_PYTHON_TEST_SPEC   APPIUM_WEB_NODE_TEST_SPEC   APPIUM_WEB_RUBY_TEST_SPEC
  INSTRUMENTATION_TEST_SPEC   XCTEST_UI_TEST_SPEC    If you call CreateUpload with WEB_APP
  specified, AWS Device Farm throws an ArgumentException error.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"contentType"`: The upload's content type (for example, application/octet-stream).
"""
function create_upload(
    name, projectArn, type; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "CreateUpload",
        Dict{String,Any}("name" => name, "projectArn" => projectArn, "type" => type);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_upload(
    name,
    projectArn,
    type,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return device_farm(
        "CreateUpload",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "name" => name, "projectArn" => projectArn, "type" => type
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_vpceconfiguration(service_dns_name, vpce_configuration_name, vpce_service_name)
    create_vpceconfiguration(service_dns_name, vpce_configuration_name, vpce_service_name, params::Dict{String,<:Any})

Creates a configuration record in Device Farm for your Amazon Virtual Private Cloud (VPC)
endpoint.

# Arguments
- `service_dns_name`: The DNS name of the service running in your VPC that you want Device
  Farm to test.
- `vpce_configuration_name`: The friendly name you give to your VPC endpoint configuration,
  to manage your configurations more easily.
- `vpce_service_name`: The name of the VPC endpoint service running in your AWS account
  that you want Device Farm to test.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"vpceConfigurationDescription"`: An optional description that provides details about
  your VPC endpoint configuration.
"""
function create_vpceconfiguration(
    serviceDnsName,
    vpceConfigurationName,
    vpceServiceName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return device_farm(
        "CreateVPCEConfiguration",
        Dict{String,Any}(
            "serviceDnsName" => serviceDnsName,
            "vpceConfigurationName" => vpceConfigurationName,
            "vpceServiceName" => vpceServiceName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_vpceconfiguration(
    serviceDnsName,
    vpceConfigurationName,
    vpceServiceName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return device_farm(
        "CreateVPCEConfiguration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "serviceDnsName" => serviceDnsName,
                    "vpceConfigurationName" => vpceConfigurationName,
                    "vpceServiceName" => vpceServiceName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_device_pool(arn)
    delete_device_pool(arn, params::Dict{String,<:Any})

Deletes a device pool given the pool ARN. Does not allow deletion of curated pools owned by
the system.

# Arguments
- `arn`: Represents the Amazon Resource Name (ARN) of the Device Farm device pool to delete.

"""
function delete_device_pool(arn; aws_config::AbstractAWSConfig=current_aws_config())
    return device_farm(
        "DeleteDevicePool",
        Dict{String,Any}("arn" => arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_device_pool(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "DeleteDevicePool",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("arn" => arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_instance_profile(arn)
    delete_instance_profile(arn, params::Dict{String,<:Any})

Deletes a profile that can be applied to one or more private device instances.

# Arguments
- `arn`: The Amazon Resource Name (ARN) of the instance profile you are requesting to
  delete.

"""
function delete_instance_profile(arn; aws_config::AbstractAWSConfig=current_aws_config())
    return device_farm(
        "DeleteInstanceProfile",
        Dict{String,Any}("arn" => arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_instance_profile(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "DeleteInstanceProfile",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("arn" => arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_network_profile(arn)
    delete_network_profile(arn, params::Dict{String,<:Any})

Deletes a network profile.

# Arguments
- `arn`: The ARN of the network profile to delete.

"""
function delete_network_profile(arn; aws_config::AbstractAWSConfig=current_aws_config())
    return device_farm(
        "DeleteNetworkProfile",
        Dict{String,Any}("arn" => arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_network_profile(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "DeleteNetworkProfile",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("arn" => arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_project(arn)
    delete_project(arn, params::Dict{String,<:Any})

Deletes an AWS Device Farm project, given the project ARN.  Deleting this resource does not
stop an in-progress run.

# Arguments
- `arn`: Represents the Amazon Resource Name (ARN) of the Device Farm project to delete.

"""
function delete_project(arn; aws_config::AbstractAWSConfig=current_aws_config())
    return device_farm(
        "DeleteProject",
        Dict{String,Any}("arn" => arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_project(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "DeleteProject",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("arn" => arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_remote_access_session(arn)
    delete_remote_access_session(arn, params::Dict{String,<:Any})

Deletes a completed remote access session and its results.

# Arguments
- `arn`: The Amazon Resource Name (ARN) of the session for which you want to delete remote
  access.

"""
function delete_remote_access_session(
    arn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "DeleteRemoteAccessSession",
        Dict{String,Any}("arn" => arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_remote_access_session(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "DeleteRemoteAccessSession",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("arn" => arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_run(arn)
    delete_run(arn, params::Dict{String,<:Any})

Deletes the run, given the run ARN.  Deleting this resource does not stop an in-progress
run.

# Arguments
- `arn`: The Amazon Resource Name (ARN) for the run to delete.

"""
function delete_run(arn; aws_config::AbstractAWSConfig=current_aws_config())
    return device_farm(
        "DeleteRun",
        Dict{String,Any}("arn" => arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_run(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "DeleteRun",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("arn" => arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_test_grid_project(project_arn)
    delete_test_grid_project(project_arn, params::Dict{String,<:Any})

 Deletes a Selenium testing project and all content generated under it.   You cannot undo
this operation.   You cannot delete a project if it has active sessions.

# Arguments
- `project_arn`: The ARN of the project to delete, from CreateTestGridProject or
  ListTestGridProjects.

"""
function delete_test_grid_project(
    projectArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "DeleteTestGridProject",
        Dict{String,Any}("projectArn" => projectArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_test_grid_project(
    projectArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return device_farm(
        "DeleteTestGridProject",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("projectArn" => projectArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_upload(arn)
    delete_upload(arn, params::Dict{String,<:Any})

Deletes an upload given the upload ARN.

# Arguments
- `arn`: Represents the Amazon Resource Name (ARN) of the Device Farm upload to delete.

"""
function delete_upload(arn; aws_config::AbstractAWSConfig=current_aws_config())
    return device_farm(
        "DeleteUpload",
        Dict{String,Any}("arn" => arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_upload(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "DeleteUpload",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("arn" => arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_vpceconfiguration(arn)
    delete_vpceconfiguration(arn, params::Dict{String,<:Any})

Deletes a configuration for your Amazon Virtual Private Cloud (VPC) endpoint.

# Arguments
- `arn`: The Amazon Resource Name (ARN) of the VPC endpoint configuration you want to
  delete.

"""
function delete_vpceconfiguration(arn; aws_config::AbstractAWSConfig=current_aws_config())
    return device_farm(
        "DeleteVPCEConfiguration",
        Dict{String,Any}("arn" => arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_vpceconfiguration(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "DeleteVPCEConfiguration",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("arn" => arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_account_settings()
    get_account_settings(params::Dict{String,<:Any})

Returns the number of unmetered iOS or unmetered Android devices that have been purchased
by the account.

"""
function get_account_settings(; aws_config::AbstractAWSConfig=current_aws_config())
    return device_farm(
        "GetAccountSettings"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_account_settings(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "GetAccountSettings", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    get_device(arn)
    get_device(arn, params::Dict{String,<:Any})

Gets information about a unique device type.

# Arguments
- `arn`: The device type's ARN.

"""
function get_device(arn; aws_config::AbstractAWSConfig=current_aws_config())
    return device_farm(
        "GetDevice",
        Dict{String,Any}("arn" => arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_device(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "GetDevice",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("arn" => arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_device_instance(arn)
    get_device_instance(arn, params::Dict{String,<:Any})

Returns information about a device instance that belongs to a private device fleet.

# Arguments
- `arn`: The Amazon Resource Name (ARN) of the instance you're requesting information about.

"""
function get_device_instance(arn; aws_config::AbstractAWSConfig=current_aws_config())
    return device_farm(
        "GetDeviceInstance",
        Dict{String,Any}("arn" => arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_device_instance(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "GetDeviceInstance",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("arn" => arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_device_pool(arn)
    get_device_pool(arn, params::Dict{String,<:Any})

Gets information about a device pool.

# Arguments
- `arn`: The device pool's ARN.

"""
function get_device_pool(arn; aws_config::AbstractAWSConfig=current_aws_config())
    return device_farm(
        "GetDevicePool",
        Dict{String,Any}("arn" => arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_device_pool(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "GetDevicePool",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("arn" => arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_device_pool_compatibility(device_pool_arn)
    get_device_pool_compatibility(device_pool_arn, params::Dict{String,<:Any})

Gets information about compatibility with a device pool.

# Arguments
- `device_pool_arn`: The device pool's ARN.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"appArn"`: The ARN of the app that is associated with the specified device pool.
- `"configuration"`: An object that contains information about the settings for a run.
- `"test"`: Information about the uploaded test to be run against the device pool.
- `"testType"`: The test type for the specified device pool. Allowed values include the
  following:   BUILTIN_FUZZ.   BUILTIN_EXPLORER. For Android, an app explorer that traverses
  an Android app, interacting with it and capturing screenshots at the same time.
  APPIUM_JAVA_JUNIT.   APPIUM_JAVA_TESTNG.   APPIUM_PYTHON.   APPIUM_NODE.   APPIUM_RUBY.
  APPIUM_WEB_JAVA_JUNIT.   APPIUM_WEB_JAVA_TESTNG.   APPIUM_WEB_PYTHON.   APPIUM_WEB_NODE.
  APPIUM_WEB_RUBY.   CALABASH.   INSTRUMENTATION.   UIAUTOMATION.   UIAUTOMATOR.   XCTEST.
  XCTEST_UI.
"""
function get_device_pool_compatibility(
    devicePoolArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "GetDevicePoolCompatibility",
        Dict{String,Any}("devicePoolArn" => devicePoolArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_device_pool_compatibility(
    devicePoolArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return device_farm(
        "GetDevicePoolCompatibility",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("devicePoolArn" => devicePoolArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_instance_profile(arn)
    get_instance_profile(arn, params::Dict{String,<:Any})

Returns information about the specified instance profile.

# Arguments
- `arn`: The Amazon Resource Name (ARN) of an instance profile.

"""
function get_instance_profile(arn; aws_config::AbstractAWSConfig=current_aws_config())
    return device_farm(
        "GetInstanceProfile",
        Dict{String,Any}("arn" => arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_instance_profile(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "GetInstanceProfile",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("arn" => arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_job(arn)
    get_job(arn, params::Dict{String,<:Any})

Gets information about a job.

# Arguments
- `arn`: The job's ARN.

"""
function get_job(arn; aws_config::AbstractAWSConfig=current_aws_config())
    return device_farm(
        "GetJob",
        Dict{String,Any}("arn" => arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_job(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "GetJob",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("arn" => arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_network_profile(arn)
    get_network_profile(arn, params::Dict{String,<:Any})

Returns information about a network profile.

# Arguments
- `arn`: The ARN of the network profile to return information about.

"""
function get_network_profile(arn; aws_config::AbstractAWSConfig=current_aws_config())
    return device_farm(
        "GetNetworkProfile",
        Dict{String,Any}("arn" => arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_network_profile(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "GetNetworkProfile",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("arn" => arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_offering_status()
    get_offering_status(params::Dict{String,<:Any})

Gets the current status and future status of all offerings purchased by an AWS account. The
response indicates how many offerings are currently available and the offerings that will
be available in the next period. The API returns a NotEligible error if the user is not
permitted to invoke the operation. If you must be able to invoke this operation, contact
aws-devicefarm-support@amazon.com.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"nextToken"`: An identifier that was returned from the previous call to this operation,
  which can be used to return the next set of items in the list.
"""
function get_offering_status(; aws_config::AbstractAWSConfig=current_aws_config())
    return device_farm(
        "GetOfferingStatus"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_offering_status(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "GetOfferingStatus", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    get_project(arn)
    get_project(arn, params::Dict{String,<:Any})

Gets information about a project.

# Arguments
- `arn`: The project's ARN.

"""
function get_project(arn; aws_config::AbstractAWSConfig=current_aws_config())
    return device_farm(
        "GetProject",
        Dict{String,Any}("arn" => arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_project(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "GetProject",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("arn" => arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_remote_access_session(arn)
    get_remote_access_session(arn, params::Dict{String,<:Any})

Returns a link to a currently running remote access session.

# Arguments
- `arn`: The Amazon Resource Name (ARN) of the remote access session about which you want
  to get session information.

"""
function get_remote_access_session(arn; aws_config::AbstractAWSConfig=current_aws_config())
    return device_farm(
        "GetRemoteAccessSession",
        Dict{String,Any}("arn" => arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_remote_access_session(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "GetRemoteAccessSession",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("arn" => arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_run(arn)
    get_run(arn, params::Dict{String,<:Any})

Gets information about a run.

# Arguments
- `arn`: The run's ARN.

"""
function get_run(arn; aws_config::AbstractAWSConfig=current_aws_config())
    return device_farm(
        "GetRun",
        Dict{String,Any}("arn" => arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_run(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "GetRun",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("arn" => arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_suite(arn)
    get_suite(arn, params::Dict{String,<:Any})

Gets information about a suite.

# Arguments
- `arn`: The suite's ARN.

"""
function get_suite(arn; aws_config::AbstractAWSConfig=current_aws_config())
    return device_farm(
        "GetSuite",
        Dict{String,Any}("arn" => arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_suite(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "GetSuite",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("arn" => arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_test(arn)
    get_test(arn, params::Dict{String,<:Any})

Gets information about a test.

# Arguments
- `arn`: The test's ARN.

"""
function get_test(arn; aws_config::AbstractAWSConfig=current_aws_config())
    return device_farm(
        "GetTest",
        Dict{String,Any}("arn" => arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_test(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "GetTest",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("arn" => arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_test_grid_project(project_arn)
    get_test_grid_project(project_arn, params::Dict{String,<:Any})

Retrieves information about a Selenium testing project.

# Arguments
- `project_arn`: The ARN of the Selenium testing project, from either CreateTestGridProject
  or ListTestGridProjects.

"""
function get_test_grid_project(
    projectArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "GetTestGridProject",
        Dict{String,Any}("projectArn" => projectArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_test_grid_project(
    projectArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return device_farm(
        "GetTestGridProject",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("projectArn" => projectArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_test_grid_session()
    get_test_grid_session(params::Dict{String,<:Any})

A session is an instance of a browser created through a RemoteWebDriver with the URL from
CreateTestGridUrlResulturl. You can use the following to look up sessions:   The session
ARN (GetTestGridSessionRequestsessionArn).   The project ARN and a session ID
(GetTestGridSessionRequestprojectArn and GetTestGridSessionRequestsessionId).

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"projectArn"`: The ARN for the project that this session belongs to. See
  CreateTestGridProject and ListTestGridProjects.
- `"sessionArn"`: An ARN that uniquely identifies a TestGridSession.
- `"sessionId"`: An ID associated with this session.
"""
function get_test_grid_session(; aws_config::AbstractAWSConfig=current_aws_config())
    return device_farm(
        "GetTestGridSession"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_test_grid_session(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "GetTestGridSession", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    get_upload(arn)
    get_upload(arn, params::Dict{String,<:Any})

Gets information about an upload.

# Arguments
- `arn`: The upload's ARN.

"""
function get_upload(arn; aws_config::AbstractAWSConfig=current_aws_config())
    return device_farm(
        "GetUpload",
        Dict{String,Any}("arn" => arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_upload(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "GetUpload",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("arn" => arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_vpceconfiguration(arn)
    get_vpceconfiguration(arn, params::Dict{String,<:Any})

Returns information about the configuration settings for your Amazon Virtual Private Cloud
(VPC) endpoint.

# Arguments
- `arn`: The Amazon Resource Name (ARN) of the VPC endpoint configuration you want to
  describe.

"""
function get_vpceconfiguration(arn; aws_config::AbstractAWSConfig=current_aws_config())
    return device_farm(
        "GetVPCEConfiguration",
        Dict{String,Any}("arn" => arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_vpceconfiguration(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "GetVPCEConfiguration",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("arn" => arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    install_to_remote_access_session(app_arn, remote_access_session_arn)
    install_to_remote_access_session(app_arn, remote_access_session_arn, params::Dict{String,<:Any})

Installs an application to the device in a remote access session. For Android applications,
the file must be in .apk format. For iOS applications, the file must be in .ipa format.

# Arguments
- `app_arn`: The ARN of the app about which you are requesting information.
- `remote_access_session_arn`: The Amazon Resource Name (ARN) of the remote access session
  about which you are requesting information.

"""
function install_to_remote_access_session(
    appArn, remoteAccessSessionArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "InstallToRemoteAccessSession",
        Dict{String,Any}(
            "appArn" => appArn, "remoteAccessSessionArn" => remoteAccessSessionArn
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function install_to_remote_access_session(
    appArn,
    remoteAccessSessionArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return device_farm(
        "InstallToRemoteAccessSession",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "appArn" => appArn, "remoteAccessSessionArn" => remoteAccessSessionArn
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_artifacts(arn, type)
    list_artifacts(arn, type, params::Dict{String,<:Any})

Gets information about artifacts.

# Arguments
- `arn`: The run, job, suite, or test ARN.
- `type`: The artifacts' type. Allowed values include:   FILE   LOG   SCREENSHOT

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"nextToken"`: An identifier that was returned from the previous call to this operation,
  which can be used to return the next set of items in the list.
"""
function list_artifacts(arn, type; aws_config::AbstractAWSConfig=current_aws_config())
    return device_farm(
        "ListArtifacts",
        Dict{String,Any}("arn" => arn, "type" => type);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_artifacts(
    arn,
    type,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return device_farm(
        "ListArtifacts",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("arn" => arn, "type" => type), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_device_instances()
    list_device_instances(params::Dict{String,<:Any})

Returns information about the private device instances associated with one or more AWS
accounts.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: An integer that specifies the maximum number of items you want to return
  in the API response.
- `"nextToken"`: An identifier that was returned from the previous call to this operation,
  which can be used to return the next set of items in the list.
"""
function list_device_instances(; aws_config::AbstractAWSConfig=current_aws_config())
    return device_farm(
        "ListDeviceInstances"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_device_instances(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "ListDeviceInstances",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_device_pools(arn)
    list_device_pools(arn, params::Dict{String,<:Any})

Gets information about device pools.

# Arguments
- `arn`: The project ARN.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"nextToken"`: An identifier that was returned from the previous call to this operation,
  which can be used to return the next set of items in the list.
- `"type"`: The device pools' type. Allowed values include:   CURATED: A device pool that
  is created and managed by AWS Device Farm.   PRIVATE: A device pool that is created and
  managed by the device pool developer.
"""
function list_device_pools(arn; aws_config::AbstractAWSConfig=current_aws_config())
    return device_farm(
        "ListDevicePools",
        Dict{String,Any}("arn" => arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_device_pools(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "ListDevicePools",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("arn" => arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_devices()
    list_devices(params::Dict{String,<:Any})

Gets information about unique device types.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"arn"`: The Amazon Resource Name (ARN) of the project.
- `"filters"`: Used to select a set of devices. A filter is made up of an attribute, an
  operator, and one or more values.   Attribute: The aspect of a device such as platform or
  model used as the selection criteria in a device filter. Allowed values include:   ARN: The
  Amazon Resource Name (ARN) of the device (for example,
  arn:aws:devicefarm:us-west-2::device:12345Example).   PLATFORM: The device platform. Valid
  values are ANDROID or IOS.   OS_VERSION: The operating system version (for example,
  10.3.2).   MODEL: The device model (for example, iPad 5th Gen).   AVAILABILITY: The current
  availability of the device. Valid values are AVAILABLE, HIGHLY_AVAILABLE, BUSY, or
  TEMPORARY_NOT_AVAILABLE.   FORM_FACTOR: The device form factor. Valid values are PHONE or
  TABLET.   MANUFACTURER: The device manufacturer (for example, Apple).
  REMOTE_ACCESS_ENABLED: Whether the device is enabled for remote access. Valid values are
  TRUE or FALSE.   REMOTE_DEBUG_ENABLED: Whether the device is enabled for remote debugging.
  Valid values are TRUE or FALSE. Because remote debugging is no longer supported, this
  attribute is ignored.   INSTANCE_ARN: The Amazon Resource Name (ARN) of the device
  instance.   INSTANCE_LABELS: The label of the device instance.   FLEET_TYPE: The fleet
  type. Valid values are PUBLIC or PRIVATE.     Operator: The filter operator.   The EQUALS
  operator is available for every attribute except INSTANCE_LABELS.   The CONTAINS operator
  is available for the INSTANCE_LABELS and MODEL attributes.   The IN and NOT_IN operators
  are available for the ARN, OS_VERSION, MODEL, MANUFACTURER, and INSTANCE_ARN attributes.
  The LESS_THAN, GREATER_THAN, LESS_THAN_OR_EQUALS, and GREATER_THAN_OR_EQUALS operators are
  also available for the OS_VERSION attribute.     Values: An array of one or more filter
  values.   The IN and NOT_IN operators take a values array that has one or more elements.
  The other operators require an array with a single element.   In a request, the
  AVAILABILITY attribute takes the following values: AVAILABLE, HIGHLY_AVAILABLE, BUSY, or
  TEMPORARY_NOT_AVAILABLE.
- `"nextToken"`: An identifier that was returned from the previous call to this operation,
  which can be used to return the next set of items in the list.
"""
function list_devices(; aws_config::AbstractAWSConfig=current_aws_config())
    return device_farm(
        "ListDevices"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_devices(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "ListDevices", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_instance_profiles()
    list_instance_profiles(params::Dict{String,<:Any})

Returns information about all the instance profiles in an AWS account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: An integer that specifies the maximum number of items you want to return
  in the API response.
- `"nextToken"`: An identifier that was returned from the previous call to this operation,
  which can be used to return the next set of items in the list.
"""
function list_instance_profiles(; aws_config::AbstractAWSConfig=current_aws_config())
    return device_farm(
        "ListInstanceProfiles"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_instance_profiles(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "ListInstanceProfiles",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_jobs(arn)
    list_jobs(arn, params::Dict{String,<:Any})

Gets information about jobs for a given test run.

# Arguments
- `arn`: The run's Amazon Resource Name (ARN).

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"nextToken"`: An identifier that was returned from the previous call to this operation,
  which can be used to return the next set of items in the list.
"""
function list_jobs(arn; aws_config::AbstractAWSConfig=current_aws_config())
    return device_farm(
        "ListJobs",
        Dict{String,Any}("arn" => arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_jobs(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "ListJobs",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("arn" => arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_network_profiles(arn)
    list_network_profiles(arn, params::Dict{String,<:Any})

Returns the list of available network profiles.

# Arguments
- `arn`: The Amazon Resource Name (ARN) of the project for which you want to list network
  profiles.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"nextToken"`: An identifier that was returned from the previous call to this operation,
  which can be used to return the next set of items in the list.
- `"type"`: The type of network profile to return information about. Valid values are
  listed here.
"""
function list_network_profiles(arn; aws_config::AbstractAWSConfig=current_aws_config())
    return device_farm(
        "ListNetworkProfiles",
        Dict{String,Any}("arn" => arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_network_profiles(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "ListNetworkProfiles",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("arn" => arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_offering_promotions()
    list_offering_promotions(params::Dict{String,<:Any})

Returns a list of offering promotions. Each offering promotion record contains the ID and
description of the promotion. The API returns a NotEligible error if the caller is not
permitted to invoke the operation. Contact aws-devicefarm-support@amazon.com if you must be
able to invoke this operation.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"nextToken"`: An identifier that was returned from the previous call to this operation,
  which can be used to return the next set of items in the list.
"""
function list_offering_promotions(; aws_config::AbstractAWSConfig=current_aws_config())
    return device_farm(
        "ListOfferingPromotions"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_offering_promotions(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "ListOfferingPromotions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_offering_transactions()
    list_offering_transactions(params::Dict{String,<:Any})

Returns a list of all historical purchases, renewals, and system renewal transactions for
an AWS account. The list is paginated and ordered by a descending timestamp (most recent
transactions are first). The API returns a NotEligible error if the user is not permitted
to invoke the operation. If you must be able to invoke this operation, contact
aws-devicefarm-support@amazon.com.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"nextToken"`: An identifier that was returned from the previous call to this operation,
  which can be used to return the next set of items in the list.
"""
function list_offering_transactions(; aws_config::AbstractAWSConfig=current_aws_config())
    return device_farm(
        "ListOfferingTransactions"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_offering_transactions(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "ListOfferingTransactions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_offerings()
    list_offerings(params::Dict{String,<:Any})

Returns a list of products or offerings that the user can manage through the API. Each
offering record indicates the recurring price per unit and the frequency for that offering.
The API returns a NotEligible error if the user is not permitted to invoke the operation.
If you must be able to invoke this operation, contact aws-devicefarm-support@amazon.com.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"nextToken"`: An identifier that was returned from the previous call to this operation,
  which can be used to return the next set of items in the list.
"""
function list_offerings(; aws_config::AbstractAWSConfig=current_aws_config())
    return device_farm(
        "ListOfferings"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_offerings(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "ListOfferings", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_projects()
    list_projects(params::Dict{String,<:Any})

Gets information about projects.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"arn"`: Optional. If no Amazon Resource Name (ARN) is specified, then AWS Device Farm
  returns a list of all projects for the AWS account. You can also specify a project ARN.
- `"nextToken"`: An identifier that was returned from the previous call to this operation,
  which can be used to return the next set of items in the list.
"""
function list_projects(; aws_config::AbstractAWSConfig=current_aws_config())
    return device_farm(
        "ListProjects"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_projects(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "ListProjects", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_remote_access_sessions(arn)
    list_remote_access_sessions(arn, params::Dict{String,<:Any})

Returns a list of all currently running remote access sessions.

# Arguments
- `arn`: The Amazon Resource Name (ARN) of the project about which you are requesting
  information.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"nextToken"`: An identifier that was returned from the previous call to this operation,
  which can be used to return the next set of items in the list.
"""
function list_remote_access_sessions(
    arn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "ListRemoteAccessSessions",
        Dict{String,Any}("arn" => arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_remote_access_sessions(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "ListRemoteAccessSessions",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("arn" => arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_runs(arn)
    list_runs(arn, params::Dict{String,<:Any})

Gets information about runs, given an AWS Device Farm project ARN.

# Arguments
- `arn`: The Amazon Resource Name (ARN) of the project for which you want to list runs.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"nextToken"`: An identifier that was returned from the previous call to this operation,
  which can be used to return the next set of items in the list.
"""
function list_runs(arn; aws_config::AbstractAWSConfig=current_aws_config())
    return device_farm(
        "ListRuns",
        Dict{String,Any}("arn" => arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_runs(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "ListRuns",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("arn" => arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_samples(arn)
    list_samples(arn, params::Dict{String,<:Any})

Gets information about samples, given an AWS Device Farm job ARN.

# Arguments
- `arn`: The Amazon Resource Name (ARN) of the job used to list samples.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"nextToken"`: An identifier that was returned from the previous call to this operation,
  which can be used to return the next set of items in the list.
"""
function list_samples(arn; aws_config::AbstractAWSConfig=current_aws_config())
    return device_farm(
        "ListSamples",
        Dict{String,Any}("arn" => arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_samples(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "ListSamples",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("arn" => arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_suites(arn)
    list_suites(arn, params::Dict{String,<:Any})

Gets information about test suites for a given job.

# Arguments
- `arn`: The job's Amazon Resource Name (ARN).

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"nextToken"`: An identifier that was returned from the previous call to this operation,
  which can be used to return the next set of items in the list.
"""
function list_suites(arn; aws_config::AbstractAWSConfig=current_aws_config())
    return device_farm(
        "ListSuites",
        Dict{String,Any}("arn" => arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_suites(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "ListSuites",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("arn" => arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

List the tags for an AWS Device Farm resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource or resources for which to
  list tags. You can associate tags with the following Device Farm resources: PROJECT, RUN,
  NETWORK_PROFILE, INSTANCE_PROFILE, DEVICE_INSTANCE, SESSION, DEVICE_POOL, DEVICE, and
  VPCE_CONFIGURATION.

"""
function list_tags_for_resource(
    ResourceARN; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "ListTagsForResource",
        Dict{String,Any}("ResourceARN" => ResourceARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    ResourceARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return device_farm(
        "ListTagsForResource",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResourceARN" => ResourceARN), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_test_grid_projects()
    list_test_grid_projects(params::Dict{String,<:Any})

Gets a list of all Selenium testing projects in your account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResult"`: Return no more than this number of results.
- `"nextToken"`: From a response, used to continue a paginated listing.
"""
function list_test_grid_projects(; aws_config::AbstractAWSConfig=current_aws_config())
    return device_farm(
        "ListTestGridProjects"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_test_grid_projects(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "ListTestGridProjects",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_test_grid_session_actions(session_arn)
    list_test_grid_session_actions(session_arn, params::Dict{String,<:Any})

Returns a list of the actions taken in a TestGridSession.

# Arguments
- `session_arn`: The ARN of the session to retrieve.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResult"`: The maximum number of sessions to return per response.
- `"nextToken"`: Pagination token.
"""
function list_test_grid_session_actions(
    sessionArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "ListTestGridSessionActions",
        Dict{String,Any}("sessionArn" => sessionArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_test_grid_session_actions(
    sessionArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return device_farm(
        "ListTestGridSessionActions",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("sessionArn" => sessionArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_test_grid_session_artifacts(session_arn)
    list_test_grid_session_artifacts(session_arn, params::Dict{String,<:Any})

Retrieves a list of artifacts created during the session.

# Arguments
- `session_arn`: The ARN of a TestGridSession.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResult"`: The maximum number of results to be returned by a request.
- `"nextToken"`: Pagination token.
- `"type"`: Limit results to a specified type of artifact.
"""
function list_test_grid_session_artifacts(
    sessionArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "ListTestGridSessionArtifacts",
        Dict{String,Any}("sessionArn" => sessionArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_test_grid_session_artifacts(
    sessionArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return device_farm(
        "ListTestGridSessionArtifacts",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("sessionArn" => sessionArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_test_grid_sessions(project_arn)
    list_test_grid_sessions(project_arn, params::Dict{String,<:Any})

Retrieves a list of sessions for a TestGridProject.

# Arguments
- `project_arn`: ARN of a TestGridProject.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"creationTimeAfter"`: Return only sessions created after this time.
- `"creationTimeBefore"`: Return only sessions created before this time.
- `"endTimeAfter"`: Return only sessions that ended after this time.
- `"endTimeBefore"`: Return only sessions that ended before this time.
- `"maxResult"`: Return only this many results at a time.
- `"nextToken"`: Pagination token.
- `"status"`: Return only sessions in this state.
"""
function list_test_grid_sessions(
    projectArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "ListTestGridSessions",
        Dict{String,Any}("projectArn" => projectArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_test_grid_sessions(
    projectArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return device_farm(
        "ListTestGridSessions",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("projectArn" => projectArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tests(arn)
    list_tests(arn, params::Dict{String,<:Any})

Gets information about tests in a given test suite.

# Arguments
- `arn`: The test suite's Amazon Resource Name (ARN).

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"nextToken"`: An identifier that was returned from the previous call to this operation,
  which can be used to return the next set of items in the list.
"""
function list_tests(arn; aws_config::AbstractAWSConfig=current_aws_config())
    return device_farm(
        "ListTests",
        Dict{String,Any}("arn" => arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tests(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "ListTests",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("arn" => arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_unique_problems(arn)
    list_unique_problems(arn, params::Dict{String,<:Any})

Gets information about unique problems, such as exceptions or crashes. Unique problems are
defined as a single instance of an error across a run, job, or suite. For example, if a
call in your application consistently raises an exception (OutOfBoundsException in
MyActivity.java:386), ListUniqueProblems returns a single entry instead of many individual
entries for that exception.

# Arguments
- `arn`: The unique problems' ARNs.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"nextToken"`: An identifier that was returned from the previous call to this operation,
  which can be used to return the next set of items in the list.
"""
function list_unique_problems(arn; aws_config::AbstractAWSConfig=current_aws_config())
    return device_farm(
        "ListUniqueProblems",
        Dict{String,Any}("arn" => arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_unique_problems(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "ListUniqueProblems",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("arn" => arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_uploads(arn)
    list_uploads(arn, params::Dict{String,<:Any})

Gets information about uploads, given an AWS Device Farm project ARN.

# Arguments
- `arn`: The Amazon Resource Name (ARN) of the project for which you want to list uploads.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"nextToken"`: An identifier that was returned from the previous call to this operation,
  which can be used to return the next set of items in the list.
- `"type"`: The type of upload. Must be one of the following values:   ANDROID_APP
  IOS_APP   WEB_APP   EXTERNAL_DATA   APPIUM_JAVA_JUNIT_TEST_PACKAGE
  APPIUM_JAVA_TESTNG_TEST_PACKAGE   APPIUM_PYTHON_TEST_PACKAGE   APPIUM_NODE_TEST_PACKAGE
  APPIUM_RUBY_TEST_PACKAGE   APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE
  APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE   APPIUM_WEB_PYTHON_TEST_PACKAGE
  APPIUM_WEB_NODE_TEST_PACKAGE   APPIUM_WEB_RUBY_TEST_PACKAGE   CALABASH_TEST_PACKAGE
  INSTRUMENTATION_TEST_PACKAGE   UIAUTOMATION_TEST_PACKAGE   UIAUTOMATOR_TEST_PACKAGE
  XCTEST_TEST_PACKAGE   XCTEST_UI_TEST_PACKAGE   APPIUM_JAVA_JUNIT_TEST_SPEC
  APPIUM_JAVA_TESTNG_TEST_SPEC   APPIUM_PYTHON_TEST_SPEC   APPIUM_NODE_TEST_SPEC
  APPIUM_RUBY_TEST_SPEC   APPIUM_WEB_JAVA_JUNIT_TEST_SPEC   APPIUM_WEB_JAVA_TESTNG_TEST_SPEC
   APPIUM_WEB_PYTHON_TEST_SPEC   APPIUM_WEB_NODE_TEST_SPEC   APPIUM_WEB_RUBY_TEST_SPEC
  INSTRUMENTATION_TEST_SPEC   XCTEST_UI_TEST_SPEC
"""
function list_uploads(arn; aws_config::AbstractAWSConfig=current_aws_config())
    return device_farm(
        "ListUploads",
        Dict{String,Any}("arn" => arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_uploads(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "ListUploads",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("arn" => arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_vpceconfigurations()
    list_vpceconfigurations(params::Dict{String,<:Any})

Returns information about all Amazon Virtual Private Cloud (VPC) endpoint configurations in
the AWS account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: An integer that specifies the maximum number of items you want to return
  in the API response.
- `"nextToken"`: An identifier that was returned from the previous call to this operation,
  which can be used to return the next set of items in the list.
"""
function list_vpceconfigurations(; aws_config::AbstractAWSConfig=current_aws_config())
    return device_farm(
        "ListVPCEConfigurations"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_vpceconfigurations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "ListVPCEConfigurations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    purchase_offering(offering_id, quantity)
    purchase_offering(offering_id, quantity, params::Dict{String,<:Any})

Immediately purchases offerings for an AWS account. Offerings renew with the latest total
purchased quantity for an offering, unless the renewal was overridden. The API returns a
NotEligible error if the user is not permitted to invoke the operation. If you must be able
to invoke this operation, contact aws-devicefarm-support@amazon.com.

# Arguments
- `offering_id`: The ID of the offering.
- `quantity`: The number of device slots to purchase in an offering request.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"offeringPromotionId"`: The ID of the offering promotion to be applied to the purchase.
"""
function purchase_offering(
    offeringId, quantity; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "PurchaseOffering",
        Dict{String,Any}("offeringId" => offeringId, "quantity" => quantity);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function purchase_offering(
    offeringId,
    quantity,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return device_farm(
        "PurchaseOffering",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("offeringId" => offeringId, "quantity" => quantity),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    renew_offering(offering_id, quantity)
    renew_offering(offering_id, quantity, params::Dict{String,<:Any})

Explicitly sets the quantity of devices to renew for an offering, starting from the
effectiveDate of the next period. The API returns a NotEligible error if the user is not
permitted to invoke the operation. If you must be able to invoke this operation, contact
aws-devicefarm-support@amazon.com.

# Arguments
- `offering_id`: The ID of a request to renew an offering.
- `quantity`: The quantity requested in an offering renewal.

"""
function renew_offering(
    offeringId, quantity; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "RenewOffering",
        Dict{String,Any}("offeringId" => offeringId, "quantity" => quantity);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function renew_offering(
    offeringId,
    quantity,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return device_farm(
        "RenewOffering",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("offeringId" => offeringId, "quantity" => quantity),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    schedule_run(project_arn, test)
    schedule_run(project_arn, test, params::Dict{String,<:Any})

Schedules a run.

# Arguments
- `project_arn`: The ARN of the project for the run to be scheduled.
- `test`: Information about the test for the run to be scheduled.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"appArn"`: The ARN of an application package to run tests against, created with
  CreateUpload. See ListUploads.
- `"configuration"`: Information about the settings for the run to be scheduled.
- `"devicePoolArn"`: The ARN of the device pool for the run to be scheduled.
- `"deviceSelectionConfiguration"`: The filter criteria used to dynamically select a set of
  devices for a test run and the maximum number of devices to be included in the run. Either
  devicePoolArn  or  deviceSelectionConfiguration  is required in a request.
- `"executionConfiguration"`: Specifies configuration information about a test run, such as
  the execution timeout (in minutes).
- `"name"`: The name for the run to be scheduled.
"""
function schedule_run(projectArn, test; aws_config::AbstractAWSConfig=current_aws_config())
    return device_farm(
        "ScheduleRun",
        Dict{String,Any}("projectArn" => projectArn, "test" => test);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function schedule_run(
    projectArn,
    test,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return device_farm(
        "ScheduleRun",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("projectArn" => projectArn, "test" => test), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    stop_job(arn)
    stop_job(arn, params::Dict{String,<:Any})

Initiates a stop request for the current job. AWS Device Farm immediately stops the job on
the device where tests have not started. You are not billed for this device. On the device
where tests have started, setup suite and teardown suite tests run to completion on the
device. You are billed for setup, teardown, and any tests that were in progress or already
completed.

# Arguments
- `arn`: Represents the Amazon Resource Name (ARN) of the Device Farm job to stop.

"""
function stop_job(arn; aws_config::AbstractAWSConfig=current_aws_config())
    return device_farm(
        "StopJob",
        Dict{String,Any}("arn" => arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function stop_job(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "StopJob",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("arn" => arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    stop_remote_access_session(arn)
    stop_remote_access_session(arn, params::Dict{String,<:Any})

Ends a specified remote access session.

# Arguments
- `arn`: The Amazon Resource Name (ARN) of the remote access session to stop.

"""
function stop_remote_access_session(arn; aws_config::AbstractAWSConfig=current_aws_config())
    return device_farm(
        "StopRemoteAccessSession",
        Dict{String,Any}("arn" => arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function stop_remote_access_session(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "StopRemoteAccessSession",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("arn" => arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    stop_run(arn)
    stop_run(arn, params::Dict{String,<:Any})

Initiates a stop request for the current test run. AWS Device Farm immediately stops the
run on devices where tests have not started. You are not billed for these devices. On
devices where tests have started executing, setup suite and teardown suite tests run to
completion on those devices. You are billed for setup, teardown, and any tests that were in
progress or already completed.

# Arguments
- `arn`: Represents the Amazon Resource Name (ARN) of the Device Farm run to stop.

"""
function stop_run(arn; aws_config::AbstractAWSConfig=current_aws_config())
    return device_farm(
        "StopRun",
        Dict{String,Any}("arn" => arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function stop_run(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "StopRun",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("arn" => arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Associates the specified tags to a resource with the specified resourceArn. If existing
tags on a resource are not specified in the request parameters, they are not changed. When
a resource is deleted, the tags associated with that resource are also deleted.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource or resources to which to
  add tags. You can associate tags with the following Device Farm resources: PROJECT, RUN,
  NETWORK_PROFILE, INSTANCE_PROFILE, DEVICE_INSTANCE, SESSION, DEVICE_POOL, DEVICE, and
  VPCE_CONFIGURATION.
- `tags`: The tags to add to the resource. A tag is an array of key-value pairs. Tag keys
  can have a maximum character length of 128 characters. Tag values can have a maximum length
  of 256 characters.

"""
function tag_resource(ResourceARN, Tags; aws_config::AbstractAWSConfig=current_aws_config())
    return device_farm(
        "TagResource",
        Dict{String,Any}("ResourceARN" => ResourceARN, "Tags" => Tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    ResourceARN,
    Tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return device_farm(
        "TagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceARN" => ResourceARN, "Tags" => Tags),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Deletes the specified tags from a resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource or resources from which to
  delete tags. You can associate tags with the following Device Farm resources: PROJECT, RUN,
  NETWORK_PROFILE, INSTANCE_PROFILE, DEVICE_INSTANCE, SESSION, DEVICE_POOL, DEVICE, and
  VPCE_CONFIGURATION.
- `tag_keys`: The keys of the tags to be removed.

"""
function untag_resource(
    ResourceARN, TagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "UntagResource",
        Dict{String,Any}("ResourceARN" => ResourceARN, "TagKeys" => TagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    ResourceARN,
    TagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return device_farm(
        "UntagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceARN" => ResourceARN, "TagKeys" => TagKeys),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_device_instance(arn)
    update_device_instance(arn, params::Dict{String,<:Any})

Updates information about a private device instance.

# Arguments
- `arn`: The Amazon Resource Name (ARN) of the device instance.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"labels"`: An array of strings that you want to associate with the device instance.
- `"profileArn"`: The ARN of the profile that you want to associate with the device
  instance.
"""
function update_device_instance(arn; aws_config::AbstractAWSConfig=current_aws_config())
    return device_farm(
        "UpdateDeviceInstance",
        Dict{String,Any}("arn" => arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_device_instance(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "UpdateDeviceInstance",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("arn" => arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_device_pool(arn)
    update_device_pool(arn, params::Dict{String,<:Any})

Modifies the name, description, and rules in a device pool given the attributes and the
pool ARN. Rule updates are all-or-nothing, meaning they can only be updated as a whole (or
not at all).

# Arguments
- `arn`: The Amazon Resource Name (ARN) of the Device Farm device pool to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clearMaxDevices"`: Sets whether the maxDevices parameter applies to your device pool.
  If you set this parameter to true, the maxDevices parameter does not apply, and Device Farm
  does not limit the number of devices that it adds to your device pool. In this case, Device
  Farm adds all available devices that meet the criteria specified in the rules parameter. If
  you use this parameter in your request, you cannot use the maxDevices parameter in the same
  request.
- `"description"`: A description of the device pool to update.
- `"maxDevices"`: The number of devices that Device Farm can add to your device pool.
  Device Farm adds devices that are available and that meet the criteria that you assign for
  the rules parameter. Depending on how many devices meet these constraints, your device pool
  might contain fewer devices than the value for this parameter. By specifying the maximum
  number of devices, you can control the costs that you incur by running tests. If you use
  this parameter in your request, you cannot use the clearMaxDevices parameter in the same
  request.
- `"name"`: A string that represents the name of the device pool to update.
- `"rules"`: Represents the rules to modify for the device pool. Updating rules is
  optional. If you update rules for your request, the update replaces the existing rules.
"""
function update_device_pool(arn; aws_config::AbstractAWSConfig=current_aws_config())
    return device_farm(
        "UpdateDevicePool",
        Dict{String,Any}("arn" => arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_device_pool(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "UpdateDevicePool",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("arn" => arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_instance_profile(arn)
    update_instance_profile(arn, params::Dict{String,<:Any})

Updates information about an existing private device instance profile.

# Arguments
- `arn`: The Amazon Resource Name (ARN) of the instance profile.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"description"`: The updated description for your instance profile.
- `"excludeAppPackagesFromCleanup"`: An array of strings that specifies the list of app
  packages that should not be cleaned up from the device after a test run is over. The list
  of packages is only considered if you set packageCleanup to true.
- `"name"`: The updated name for your instance profile.
- `"packageCleanup"`: The updated choice for whether you want to specify package cleanup.
  The default value is false for private devices.
- `"rebootAfterUse"`: The updated choice for whether you want to reboot the device after
  use. The default value is true.
"""
function update_instance_profile(arn; aws_config::AbstractAWSConfig=current_aws_config())
    return device_farm(
        "UpdateInstanceProfile",
        Dict{String,Any}("arn" => arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_instance_profile(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "UpdateInstanceProfile",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("arn" => arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_network_profile(arn)
    update_network_profile(arn, params::Dict{String,<:Any})

Updates the network profile.

# Arguments
- `arn`: The Amazon Resource Name (ARN) of the project for which you want to update network
  profile settings.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"description"`: The description of the network profile about which you are returning
  information.
- `"downlinkBandwidthBits"`: The data throughput rate in bits per second, as an integer
  from 0 to 104857600.
- `"downlinkDelayMs"`: Delay time for all packets to destination in milliseconds as an
  integer from 0 to 2000.
- `"downlinkJitterMs"`: Time variation in the delay of received packets in milliseconds as
  an integer from 0 to 2000.
- `"downlinkLossPercent"`: Proportion of received packets that fail to arrive from 0 to 100
  percent.
- `"name"`: The name of the network profile about which you are returning information.
- `"type"`: The type of network profile to return information about. Valid values are
  listed here.
- `"uplinkBandwidthBits"`: The data throughput rate in bits per second, as an integer from
  0 to 104857600.
- `"uplinkDelayMs"`: Delay time for all packets to destination in milliseconds as an
  integer from 0 to 2000.
- `"uplinkJitterMs"`: Time variation in the delay of received packets in milliseconds as an
  integer from 0 to 2000.
- `"uplinkLossPercent"`: Proportion of transmitted packets that fail to arrive from 0 to
  100 percent.
"""
function update_network_profile(arn; aws_config::AbstractAWSConfig=current_aws_config())
    return device_farm(
        "UpdateNetworkProfile",
        Dict{String,Any}("arn" => arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_network_profile(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "UpdateNetworkProfile",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("arn" => arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_project(arn)
    update_project(arn, params::Dict{String,<:Any})

Modifies the specified project name, given the project ARN and a new name.

# Arguments
- `arn`: The Amazon Resource Name (ARN) of the project whose name to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"defaultJobTimeoutMinutes"`: The number of minutes a test run in the project executes
  before it times out.
- `"name"`: A string that represents the new name of the project that you are updating.
- `"vpcConfig"`: The VPC security groups and subnets that are attached to a project.
"""
function update_project(arn; aws_config::AbstractAWSConfig=current_aws_config())
    return device_farm(
        "UpdateProject",
        Dict{String,Any}("arn" => arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_project(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "UpdateProject",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("arn" => arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_test_grid_project(project_arn)
    update_test_grid_project(project_arn, params::Dict{String,<:Any})

Change details of a project.

# Arguments
- `project_arn`: ARN of the project to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"description"`: Human-readable description for the project.
- `"name"`: Human-readable name for the project.
- `"vpcConfig"`: The VPC security groups and subnets that are attached to a project.
"""
function update_test_grid_project(
    projectArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "UpdateTestGridProject",
        Dict{String,Any}("projectArn" => projectArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_test_grid_project(
    projectArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return device_farm(
        "UpdateTestGridProject",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("projectArn" => projectArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_upload(arn)
    update_upload(arn, params::Dict{String,<:Any})

Updates an uploaded test spec.

# Arguments
- `arn`: The Amazon Resource Name (ARN) of the uploaded test spec.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"contentType"`: The upload's content type (for example, application/x-yaml).
- `"editContent"`: Set to true if the YAML file has changed and must be updated. Otherwise,
  set to false.
- `"name"`: The upload's test spec file name. The name must not contain any forward slashes
  (/). The test spec file name must end with the .yaml or .yml file extension.
"""
function update_upload(arn; aws_config::AbstractAWSConfig=current_aws_config())
    return device_farm(
        "UpdateUpload",
        Dict{String,Any}("arn" => arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_upload(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "UpdateUpload",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("arn" => arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_vpceconfiguration(arn)
    update_vpceconfiguration(arn, params::Dict{String,<:Any})

Updates information about an Amazon Virtual Private Cloud (VPC) endpoint configuration.

# Arguments
- `arn`: The Amazon Resource Name (ARN) of the VPC endpoint configuration you want to
  update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"serviceDnsName"`: The DNS (domain) name used to connect to your private service in your
  VPC. The DNS name must not already be in use on the internet.
- `"vpceConfigurationDescription"`: An optional description that provides details about
  your VPC endpoint configuration.
- `"vpceConfigurationName"`: The friendly name you give to your VPC endpoint configuration
  to manage your configurations more easily.
- `"vpceServiceName"`: The name of the VPC endpoint service running in your AWS account
  that you want Device Farm to test.
"""
function update_vpceconfiguration(arn; aws_config::AbstractAWSConfig=current_aws_config())
    return device_farm(
        "UpdateVPCEConfiguration",
        Dict{String,Any}("arn" => arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_vpceconfiguration(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return device_farm(
        "UpdateVPCEConfiguration",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("arn" => arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
