# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: iotdeviceadvisor
using AWS.Compat
using AWS.UUIDs

"""
    create_suite_definition(suite_definition_configuration)
    create_suite_definition(suite_definition_configuration, params::Dict{String,<:Any})

Creates a Device Advisor test suite. Requires permission to access the
CreateSuiteDefinition action.

# Arguments
- `suite_definition_configuration`: Creates a Device Advisor test suite with suite
  definition configuration.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"tags"`: The tags to be attached to the suite definition.
"""
function create_suite_definition(
    suiteDefinitionConfiguration; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iotdeviceadvisor(
        "POST",
        "/suiteDefinitions",
        Dict{String,Any}("suiteDefinitionConfiguration" => suiteDefinitionConfiguration);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_suite_definition(
    suiteDefinitionConfiguration,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iotdeviceadvisor(
        "POST",
        "/suiteDefinitions",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "suiteDefinitionConfiguration" => suiteDefinitionConfiguration
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_suite_definition(suite_definition_id)
    delete_suite_definition(suite_definition_id, params::Dict{String,<:Any})

Deletes a Device Advisor test suite. Requires permission to access the
DeleteSuiteDefinition action.

# Arguments
- `suite_definition_id`: Suite definition ID of the test suite to be deleted.

"""
function delete_suite_definition(
    suiteDefinitionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iotdeviceadvisor(
        "DELETE",
        "/suiteDefinitions/$(suiteDefinitionId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_suite_definition(
    suiteDefinitionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iotdeviceadvisor(
        "DELETE",
        "/suiteDefinitions/$(suiteDefinitionId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_endpoint()
    get_endpoint(params::Dict{String,<:Any})

Gets information about an Device Advisor endpoint.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"authenticationMethod"`: The authentication method used during the device connection.
- `"certificateArn"`: The certificate ARN of the device. This is an optional parameter.
- `"deviceRoleArn"`: The device role ARN of the device. This is an optional parameter.
- `"thingArn"`: The thing ARN of the device. This is an optional parameter.
"""
function get_endpoint(; aws_config::AbstractAWSConfig=current_aws_config())
    return iotdeviceadvisor(
        "GET", "/endpoint"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_endpoint(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iotdeviceadvisor(
        "GET", "/endpoint", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    get_suite_definition(suite_definition_id)
    get_suite_definition(suite_definition_id, params::Dict{String,<:Any})

Gets information about a Device Advisor test suite. Requires permission to access the
GetSuiteDefinition action.

# Arguments
- `suite_definition_id`: Suite definition ID of the test suite to get.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"suiteDefinitionVersion"`: Suite definition version of the test suite to get.
"""
function get_suite_definition(
    suiteDefinitionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iotdeviceadvisor(
        "GET",
        "/suiteDefinitions/$(suiteDefinitionId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_suite_definition(
    suiteDefinitionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iotdeviceadvisor(
        "GET",
        "/suiteDefinitions/$(suiteDefinitionId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_suite_run(suite_definition_id, suite_run_id)
    get_suite_run(suite_definition_id, suite_run_id, params::Dict{String,<:Any})

Gets information about a Device Advisor test suite run. Requires permission to access the
GetSuiteRun action.

# Arguments
- `suite_definition_id`: Suite definition ID for the test suite run.
- `suite_run_id`: Suite run ID for the test suite run.

"""
function get_suite_run(
    suiteDefinitionId, suiteRunId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iotdeviceadvisor(
        "GET",
        "/suiteDefinitions/$(suiteDefinitionId)/suiteRuns/$(suiteRunId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_suite_run(
    suiteDefinitionId,
    suiteRunId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iotdeviceadvisor(
        "GET",
        "/suiteDefinitions/$(suiteDefinitionId)/suiteRuns/$(suiteRunId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_suite_run_report(suite_definition_id, suite_run_id)
    get_suite_run_report(suite_definition_id, suite_run_id, params::Dict{String,<:Any})

Gets a report download link for a successful Device Advisor qualifying test suite run.
Requires permission to access the GetSuiteRunReport action.

# Arguments
- `suite_definition_id`: Suite definition ID of the test suite.
- `suite_run_id`: Suite run ID of the test suite run.

"""
function get_suite_run_report(
    suiteDefinitionId, suiteRunId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iotdeviceadvisor(
        "GET",
        "/suiteDefinitions/$(suiteDefinitionId)/suiteRuns/$(suiteRunId)/report";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_suite_run_report(
    suiteDefinitionId,
    suiteRunId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iotdeviceadvisor(
        "GET",
        "/suiteDefinitions/$(suiteDefinitionId)/suiteRuns/$(suiteRunId)/report",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_suite_definitions()
    list_suite_definitions(params::Dict{String,<:Any})

Lists the Device Advisor test suites you have created. Requires permission to access the
ListSuiteDefinitions action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return at once.
- `"nextToken"`: A token used to get the next set of results.
"""
function list_suite_definitions(; aws_config::AbstractAWSConfig=current_aws_config())
    return iotdeviceadvisor(
        "GET", "/suiteDefinitions"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_suite_definitions(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iotdeviceadvisor(
        "GET",
        "/suiteDefinitions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_suite_runs()
    list_suite_runs(params::Dict{String,<:Any})

Lists runs of the specified Device Advisor test suite. You can list all runs of the test
suite, or the runs of a specific version of the test suite. Requires permission to access
the ListSuiteRuns action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return at once.
- `"nextToken"`: A token to retrieve the next set of results.
- `"suiteDefinitionId"`: Lists the test suite runs of the specified test suite based on
  suite definition ID.
- `"suiteDefinitionVersion"`: Must be passed along with suiteDefinitionId. Lists the test
  suite runs of the specified test suite based on suite definition version.
"""
function list_suite_runs(; aws_config::AbstractAWSConfig=current_aws_config())
    return iotdeviceadvisor(
        "GET", "/suiteRuns"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_suite_runs(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iotdeviceadvisor(
        "GET", "/suiteRuns", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

Lists the tags attached to an IoT Device Advisor resource. Requires permission to access
the ListTagsForResource action.

# Arguments
- `resource_arn`: The resource ARN of the IoT Device Advisor resource. This can be
  SuiteDefinition ARN or SuiteRun ARN.

"""
function list_tags_for_resource(
    resourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iotdeviceadvisor(
        "GET",
        "/tags/$(resourceArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    resourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iotdeviceadvisor(
        "GET",
        "/tags/$(resourceArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_suite_run(suite_definition_id, suite_run_configuration)
    start_suite_run(suite_definition_id, suite_run_configuration, params::Dict{String,<:Any})

Starts a Device Advisor test suite run. Requires permission to access the StartSuiteRun
action.

# Arguments
- `suite_definition_id`: Suite definition ID of the test suite.
- `suite_run_configuration`: Suite run configuration.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"suiteDefinitionVersion"`: Suite definition version of the test suite.
- `"tags"`: The tags to be attached to the suite run.
"""
function start_suite_run(
    suiteDefinitionId,
    suiteRunConfiguration;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iotdeviceadvisor(
        "POST",
        "/suiteDefinitions/$(suiteDefinitionId)/suiteRuns",
        Dict{String,Any}("suiteRunConfiguration" => suiteRunConfiguration);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_suite_run(
    suiteDefinitionId,
    suiteRunConfiguration,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iotdeviceadvisor(
        "POST",
        "/suiteDefinitions/$(suiteDefinitionId)/suiteRuns",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("suiteRunConfiguration" => suiteRunConfiguration),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    stop_suite_run(suite_definition_id, suite_run_id)
    stop_suite_run(suite_definition_id, suite_run_id, params::Dict{String,<:Any})

Stops a Device Advisor test suite run that is currently running. Requires permission to
access the StopSuiteRun action.

# Arguments
- `suite_definition_id`: Suite definition ID of the test suite run to be stopped.
- `suite_run_id`: Suite run ID of the test suite run to be stopped.

"""
function stop_suite_run(
    suiteDefinitionId, suiteRunId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iotdeviceadvisor(
        "POST",
        "/suiteDefinitions/$(suiteDefinitionId)/suiteRuns/$(suiteRunId)/stop";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function stop_suite_run(
    suiteDefinitionId,
    suiteRunId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iotdeviceadvisor(
        "POST",
        "/suiteDefinitions/$(suiteDefinitionId)/suiteRuns/$(suiteRunId)/stop",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Adds to and modifies existing tags of an IoT Device Advisor resource. Requires permission
to access the TagResource action.

# Arguments
- `resource_arn`: The resource ARN of an IoT Device Advisor resource. This can be
  SuiteDefinition ARN or SuiteRun ARN.
- `tags`: The tags to be attached to the IoT Device Advisor resource.

"""
function tag_resource(resourceArn, tags; aws_config::AbstractAWSConfig=current_aws_config())
    return iotdeviceadvisor(
        "POST",
        "/tags/$(resourceArn)",
        Dict{String,Any}("tags" => tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    resourceArn,
    tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iotdeviceadvisor(
        "POST",
        "/tags/$(resourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tags" => tags), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Removes tags from an IoT Device Advisor resource. Requires permission to access the
UntagResource action.

# Arguments
- `resource_arn`: The resource ARN of an IoT Device Advisor resource. This can be
  SuiteDefinition ARN or SuiteRun ARN.
- `tag_keys`: List of tag keys to remove from the IoT Device Advisor resource.

"""
function untag_resource(
    resourceArn, tagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iotdeviceadvisor(
        "DELETE",
        "/tags/$(resourceArn)",
        Dict{String,Any}("tagKeys" => tagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    resourceArn,
    tagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iotdeviceadvisor(
        "DELETE",
        "/tags/$(resourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tagKeys" => tagKeys), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_suite_definition(suite_definition_configuration, suite_definition_id)
    update_suite_definition(suite_definition_configuration, suite_definition_id, params::Dict{String,<:Any})

Updates a Device Advisor test suite. Requires permission to access the
UpdateSuiteDefinition action.

# Arguments
- `suite_definition_configuration`: Updates a Device Advisor test suite with suite
  definition configuration.
- `suite_definition_id`: Suite definition ID of the test suite to be updated.

"""
function update_suite_definition(
    suiteDefinitionConfiguration,
    suiteDefinitionId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iotdeviceadvisor(
        "PATCH",
        "/suiteDefinitions/$(suiteDefinitionId)",
        Dict{String,Any}("suiteDefinitionConfiguration" => suiteDefinitionConfiguration);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_suite_definition(
    suiteDefinitionConfiguration,
    suiteDefinitionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iotdeviceadvisor(
        "PATCH",
        "/suiteDefinitions/$(suiteDefinitionId)",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "suiteDefinitionConfiguration" => suiteDefinitionConfiguration
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
