# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: opensearchserverless
using AWS.Compat
using AWS.UUIDs

"""
    batch_get_collection()
    batch_get_collection(params::Dict{String,<:Any})

Returns attributes for one or more collections, including the collection endpoint and the
OpenSearch Dashboards endpoint. For more information, see Creating and managing Amazon
OpenSearch Serverless collections.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ids"`: A list of collection IDs. You can't provide names and IDs in the same request.
  The ID is part of the collection endpoint. You can also retrieve it using the
  ListCollections API.
- `"names"`: A list of collection names. You can't provide names and IDs in the same
  request.
"""
function batch_get_collection(; aws_config::AbstractAWSConfig=current_aws_config())
    return opensearchserverless(
        "BatchGetCollection"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function batch_get_collection(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearchserverless(
        "BatchGetCollection", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    batch_get_effective_lifecycle_policy(resource_identifiers)
    batch_get_effective_lifecycle_policy(resource_identifiers, params::Dict{String,<:Any})

Returns a list of successful and failed retrievals for the OpenSearch Serverless indexes.
For more information, see Viewing data lifecycle policies.

# Arguments
- `resource_identifiers`: The unique identifiers of policy types and resource names.

"""
function batch_get_effective_lifecycle_policy(
    resourceIdentifiers; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearchserverless(
        "BatchGetEffectiveLifecyclePolicy",
        Dict{String,Any}("resourceIdentifiers" => resourceIdentifiers);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_get_effective_lifecycle_policy(
    resourceIdentifiers,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearchserverless(
        "BatchGetEffectiveLifecyclePolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("resourceIdentifiers" => resourceIdentifiers),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    batch_get_lifecycle_policy(identifiers)
    batch_get_lifecycle_policy(identifiers, params::Dict{String,<:Any})

Returns one or more configured OpenSearch Serverless lifecycle policies. For more
information, see Viewing data lifecycle policies.

# Arguments
- `identifiers`: The unique identifiers of policy types and policy names.

"""
function batch_get_lifecycle_policy(
    identifiers; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearchserverless(
        "BatchGetLifecyclePolicy",
        Dict{String,Any}("identifiers" => identifiers);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_get_lifecycle_policy(
    identifiers,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearchserverless(
        "BatchGetLifecyclePolicy",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("identifiers" => identifiers), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    batch_get_vpc_endpoint(ids)
    batch_get_vpc_endpoint(ids, params::Dict{String,<:Any})

Returns attributes for one or more VPC endpoints associated with the current account. For
more information, see Access Amazon OpenSearch Serverless using an interface endpoint.

# Arguments
- `ids`: A list of VPC endpoint identifiers.

"""
function batch_get_vpc_endpoint(ids; aws_config::AbstractAWSConfig=current_aws_config())
    return opensearchserverless(
        "BatchGetVpcEndpoint",
        Dict{String,Any}("ids" => ids);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_get_vpc_endpoint(
    ids, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearchserverless(
        "BatchGetVpcEndpoint",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("ids" => ids), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_access_policy(name, policy, type)
    create_access_policy(name, policy, type, params::Dict{String,<:Any})

Creates a data access policy for OpenSearch Serverless. Access policies limit access to
collections and the resources within them, and allow a user to access that data
irrespective of the access mechanism or network source. For more information, see Data
access control for Amazon OpenSearch Serverless.

# Arguments
- `name`: The name of the policy.
- `policy`: The JSON policy document to use as the content for the policy.
- `type`: The type of policy.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: Unique, case-sensitive identifier to ensure idempotency of the request.
- `"description"`: A description of the policy. Typically used to store information about
  the permissions defined in the policy.
"""
function create_access_policy(
    name, policy, type; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearchserverless(
        "CreateAccessPolicy",
        Dict{String,Any}(
            "name" => name,
            "policy" => policy,
            "type" => type,
            "clientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_access_policy(
    name,
    policy,
    type,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearchserverless(
        "CreateAccessPolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "name" => name,
                    "policy" => policy,
                    "type" => type,
                    "clientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_collection(name)
    create_collection(name, params::Dict{String,<:Any})

Creates a new OpenSearch Serverless collection. For more information, see Creating and
managing Amazon OpenSearch Serverless collections.

# Arguments
- `name`: Name of the collection.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: Unique, case-sensitive identifier to ensure idempotency of the request.
- `"description"`: Description of the collection.
- `"standbyReplicas"`: Indicates whether standby replicas should be used for a collection.
- `"tags"`: An arbitrary set of tags (key–value pairs) to associate with the OpenSearch
  Serverless collection.
- `"type"`: The type of collection.
"""
function create_collection(name; aws_config::AbstractAWSConfig=current_aws_config())
    return opensearchserverless(
        "CreateCollection",
        Dict{String,Any}("name" => name, "clientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_collection(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearchserverless(
        "CreateCollection",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("name" => name, "clientToken" => string(uuid4())),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_lifecycle_policy(name, policy, type)
    create_lifecycle_policy(name, policy, type, params::Dict{String,<:Any})

Creates a lifecyle policy to be applied to OpenSearch Serverless indexes. Lifecycle
policies define the number of days or hours to retain the data on an OpenSearch Serverless
index. For more information, see Creating data lifecycle policies.

# Arguments
- `name`: The name of the lifecycle policy.
- `policy`: The JSON policy document to use as the content for the lifecycle policy.
- `type`: The type of lifecycle policy.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: A unique, case-sensitive identifier to ensure idempotency of the request.
- `"description"`: A description of the lifecycle policy.
"""
function create_lifecycle_policy(
    name, policy, type; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearchserverless(
        "CreateLifecyclePolicy",
        Dict{String,Any}(
            "name" => name,
            "policy" => policy,
            "type" => type,
            "clientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_lifecycle_policy(
    name,
    policy,
    type,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearchserverless(
        "CreateLifecyclePolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "name" => name,
                    "policy" => policy,
                    "type" => type,
                    "clientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_security_config(name, type)
    create_security_config(name, type, params::Dict{String,<:Any})

Specifies a security configuration for OpenSearch Serverless. For more information, see
SAML authentication for Amazon OpenSearch Serverless.

# Arguments
- `name`: The name of the security configuration.
- `type`: The type of security configuration.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: Unique, case-sensitive identifier to ensure idempotency of the request.
- `"description"`: A description of the security configuration.
- `"samlOptions"`: Describes SAML options in in the form of a key-value map. This field is
  required if you specify saml for the type parameter.
"""
function create_security_config(
    name, type; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearchserverless(
        "CreateSecurityConfig",
        Dict{String,Any}("name" => name, "type" => type, "clientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_security_config(
    name,
    type,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearchserverless(
        "CreateSecurityConfig",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "name" => name, "type" => type, "clientToken" => string(uuid4())
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_security_policy(name, policy, type)
    create_security_policy(name, policy, type, params::Dict{String,<:Any})

Creates a security policy to be used by one or more OpenSearch Serverless collections.
Security policies provide access to a collection and its OpenSearch Dashboards endpoint
from public networks or specific VPC endpoints. They also allow you to secure a collection
with a KMS encryption key. For more information, see Network access for Amazon OpenSearch
Serverless and Encryption at rest for Amazon OpenSearch Serverless.

# Arguments
- `name`: The name of the policy.
- `policy`: The JSON policy document to use as the content for the new policy.
- `type`: The type of security policy.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: Unique, case-sensitive identifier to ensure idempotency of the request.
- `"description"`: A description of the policy. Typically used to store information about
  the permissions defined in the policy.
"""
function create_security_policy(
    name, policy, type; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearchserverless(
        "CreateSecurityPolicy",
        Dict{String,Any}(
            "name" => name,
            "policy" => policy,
            "type" => type,
            "clientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_security_policy(
    name,
    policy,
    type,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearchserverless(
        "CreateSecurityPolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "name" => name,
                    "policy" => policy,
                    "type" => type,
                    "clientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_vpc_endpoint(name, subnet_ids, vpc_id)
    create_vpc_endpoint(name, subnet_ids, vpc_id, params::Dict{String,<:Any})

Creates an OpenSearch Serverless-managed interface VPC endpoint. For more information, see
Access Amazon OpenSearch Serverless using an interface endpoint.

# Arguments
- `name`: The name of the interface endpoint.
- `subnet_ids`: The ID of one or more subnets from which you'll access OpenSearch
  Serverless.
- `vpc_id`: The ID of the VPC from which you'll access OpenSearch Serverless.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: Unique, case-sensitive identifier to ensure idempotency of the request.
- `"securityGroupIds"`: The unique identifiers of the security groups that define the
  ports, protocols, and sources for inbound traffic that you are authorizing into your
  endpoint.
"""
function create_vpc_endpoint(
    name, subnetIds, vpcId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearchserverless(
        "CreateVpcEndpoint",
        Dict{String,Any}(
            "name" => name,
            "subnetIds" => subnetIds,
            "vpcId" => vpcId,
            "clientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_vpc_endpoint(
    name,
    subnetIds,
    vpcId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearchserverless(
        "CreateVpcEndpoint",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "name" => name,
                    "subnetIds" => subnetIds,
                    "vpcId" => vpcId,
                    "clientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_access_policy(name, type)
    delete_access_policy(name, type, params::Dict{String,<:Any})

Deletes an OpenSearch Serverless access policy. For more information, see Data access
control for Amazon OpenSearch Serverless.

# Arguments
- `name`: The name of the policy to delete.
- `type`: The type of policy.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: Unique, case-sensitive identifier to ensure idempotency of the request.
"""
function delete_access_policy(
    name, type; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearchserverless(
        "DeleteAccessPolicy",
        Dict{String,Any}("name" => name, "type" => type, "clientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_access_policy(
    name,
    type,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearchserverless(
        "DeleteAccessPolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "name" => name, "type" => type, "clientToken" => string(uuid4())
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_collection(id)
    delete_collection(id, params::Dict{String,<:Any})

Deletes an OpenSearch Serverless collection. For more information, see Creating and
managing Amazon OpenSearch Serverless collections.

# Arguments
- `id`: The unique identifier of the collection. For example, 1iu5usc406kd. The ID is part
  of the collection endpoint. You can also retrieve it using the ListCollections API.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: A unique, case-sensitive identifier to ensure idempotency of the request.
"""
function delete_collection(id; aws_config::AbstractAWSConfig=current_aws_config())
    return opensearchserverless(
        "DeleteCollection",
        Dict{String,Any}("id" => id, "clientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_collection(
    id, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearchserverless(
        "DeleteCollection",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("id" => id, "clientToken" => string(uuid4())),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_lifecycle_policy(name, type)
    delete_lifecycle_policy(name, type, params::Dict{String,<:Any})

Deletes an OpenSearch Serverless lifecycle policy. For more information, see Deleting data
lifecycle policies.

# Arguments
- `name`: The name of the policy to delete.
- `type`: The type of lifecycle policy.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: Unique, case-sensitive identifier to ensure idempotency of the request.
"""
function delete_lifecycle_policy(
    name, type; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearchserverless(
        "DeleteLifecyclePolicy",
        Dict{String,Any}("name" => name, "type" => type, "clientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_lifecycle_policy(
    name,
    type,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearchserverless(
        "DeleteLifecyclePolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "name" => name, "type" => type, "clientToken" => string(uuid4())
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_security_config(id)
    delete_security_config(id, params::Dict{String,<:Any})

Deletes a security configuration for OpenSearch Serverless. For more information, see SAML
authentication for Amazon OpenSearch Serverless.

# Arguments
- `id`: The security configuration identifier. For SAML the ID will be
  saml/&lt;accountId&gt;/&lt;idpProviderName&gt;. For example, saml/123456789123/OKTADev.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: Unique, case-sensitive identifier to ensure idempotency of the request.
"""
function delete_security_config(id; aws_config::AbstractAWSConfig=current_aws_config())
    return opensearchserverless(
        "DeleteSecurityConfig",
        Dict{String,Any}("id" => id, "clientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_security_config(
    id, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearchserverless(
        "DeleteSecurityConfig",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("id" => id, "clientToken" => string(uuid4())),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_security_policy(name, type)
    delete_security_policy(name, type, params::Dict{String,<:Any})

Deletes an OpenSearch Serverless security policy.

# Arguments
- `name`: The name of the policy to delete.
- `type`: The type of policy.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: Unique, case-sensitive identifier to ensure idempotency of the request.
"""
function delete_security_policy(
    name, type; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearchserverless(
        "DeleteSecurityPolicy",
        Dict{String,Any}("name" => name, "type" => type, "clientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_security_policy(
    name,
    type,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearchserverless(
        "DeleteSecurityPolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "name" => name, "type" => type, "clientToken" => string(uuid4())
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_vpc_endpoint(id)
    delete_vpc_endpoint(id, params::Dict{String,<:Any})

Deletes an OpenSearch Serverless-managed interface endpoint. For more information, see
Access Amazon OpenSearch Serverless using an interface endpoint.

# Arguments
- `id`: The VPC endpoint identifier.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: Unique, case-sensitive identifier to ensure idempotency of the request.
"""
function delete_vpc_endpoint(id; aws_config::AbstractAWSConfig=current_aws_config())
    return opensearchserverless(
        "DeleteVpcEndpoint",
        Dict{String,Any}("id" => id, "clientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_vpc_endpoint(
    id, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearchserverless(
        "DeleteVpcEndpoint",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("id" => id, "clientToken" => string(uuid4())),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_access_policy(name, type)
    get_access_policy(name, type, params::Dict{String,<:Any})

Returns an OpenSearch Serverless access policy. For more information, see Data access
control for Amazon OpenSearch Serverless.

# Arguments
- `name`: The name of the access policy.
- `type`: Tye type of policy. Currently, the only supported value is data.

"""
function get_access_policy(name, type; aws_config::AbstractAWSConfig=current_aws_config())
    return opensearchserverless(
        "GetAccessPolicy",
        Dict{String,Any}("name" => name, "type" => type);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_access_policy(
    name,
    type,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearchserverless(
        "GetAccessPolicy",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("name" => name, "type" => type), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_account_settings()
    get_account_settings(params::Dict{String,<:Any})

Returns account-level settings related to OpenSearch Serverless.

"""
function get_account_settings(; aws_config::AbstractAWSConfig=current_aws_config())
    return opensearchserverless(
        "GetAccountSettings"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_account_settings(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearchserverless(
        "GetAccountSettings", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    get_policies_stats()
    get_policies_stats(params::Dict{String,<:Any})

Returns statistical information about your OpenSearch Serverless access policies, security
configurations, and security policies.

"""
function get_policies_stats(; aws_config::AbstractAWSConfig=current_aws_config())
    return opensearchserverless(
        "GetPoliciesStats"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_policies_stats(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearchserverless(
        "GetPoliciesStats", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    get_security_config(id)
    get_security_config(id, params::Dict{String,<:Any})

Returns information about an OpenSearch Serverless security configuration. For more
information, see SAML authentication for Amazon OpenSearch Serverless.

# Arguments
- `id`: The unique identifier of the security configuration.

"""
function get_security_config(id; aws_config::AbstractAWSConfig=current_aws_config())
    return opensearchserverless(
        "GetSecurityConfig",
        Dict{String,Any}("id" => id);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_security_config(
    id, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearchserverless(
        "GetSecurityConfig",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("id" => id), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_security_policy(name, type)
    get_security_policy(name, type, params::Dict{String,<:Any})

Returns information about a configured OpenSearch Serverless security policy. For more
information, see Network access for Amazon OpenSearch Serverless and Encryption at rest for
Amazon OpenSearch Serverless.

# Arguments
- `name`: The name of the security policy.
- `type`: The type of security policy.

"""
function get_security_policy(name, type; aws_config::AbstractAWSConfig=current_aws_config())
    return opensearchserverless(
        "GetSecurityPolicy",
        Dict{String,Any}("name" => name, "type" => type);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_security_policy(
    name,
    type,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearchserverless(
        "GetSecurityPolicy",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("name" => name, "type" => type), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_access_policies(type)
    list_access_policies(type, params::Dict{String,<:Any})

Returns information about a list of OpenSearch Serverless access policies.

# Arguments
- `type`: The type of access policy.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: An optional parameter that specifies the maximum number of results to
  return. You can use nextToken to get the next page of results. The default is 20.
- `"nextToken"`: If your initial ListAccessPolicies operation returns a nextToken, you can
  include the returned nextToken in subsequent ListAccessPolicies operations, which returns
  results in the next page.
- `"resource"`: Resource filters (can be collections or indexes) that policies can apply to.
"""
function list_access_policies(type; aws_config::AbstractAWSConfig=current_aws_config())
    return opensearchserverless(
        "ListAccessPolicies",
        Dict{String,Any}("type" => type);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_access_policies(
    type, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearchserverless(
        "ListAccessPolicies",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("type" => type), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_collections()
    list_collections(params::Dict{String,<:Any})

Lists all OpenSearch Serverless collections. For more information, see Creating and
managing Amazon OpenSearch Serverless collections.  Make sure to include an empty request
body {} if you don't include any collection filters in the request.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"collectionFilters"`:  A list of filter names and values that you can use for requests.
- `"maxResults"`: The maximum number of results to return. Default is 20. You can use
  nextToken to get the next page of results.
- `"nextToken"`: If your initial ListCollections operation returns a nextToken, you can
  include the returned nextToken in subsequent ListCollections operations, which returns
  results in the next page.
"""
function list_collections(; aws_config::AbstractAWSConfig=current_aws_config())
    return opensearchserverless(
        "ListCollections"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_collections(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearchserverless(
        "ListCollections", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_lifecycle_policies(type)
    list_lifecycle_policies(type, params::Dict{String,<:Any})

Returns a list of OpenSearch Serverless lifecycle policies. For more information, see
Viewing data lifecycle policies.

# Arguments
- `type`: The type of lifecycle policy.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: An optional parameter that specifies the maximum number of results to
  return. You can use use nextToken to get the next page of results. The default is 10.
- `"nextToken"`: If your initial ListLifecyclePolicies operation returns a nextToken, you
  can include the returned nextToken in subsequent ListLifecyclePolicies operations, which
  returns results in the next page.
- `"resources"`: Resource filters that policies can apply to. Currently, the only supported
  resource type is index.
"""
function list_lifecycle_policies(type; aws_config::AbstractAWSConfig=current_aws_config())
    return opensearchserverless(
        "ListLifecyclePolicies",
        Dict{String,Any}("type" => type);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_lifecycle_policies(
    type, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearchserverless(
        "ListLifecyclePolicies",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("type" => type), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_security_configs(type)
    list_security_configs(type, params::Dict{String,<:Any})

Returns information about configured OpenSearch Serverless security configurations. For
more information, see SAML authentication for Amazon OpenSearch Serverless.

# Arguments
- `type`: The type of security configuration.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: An optional parameter that specifies the maximum number of results to
  return. You can use nextToken to get the next page of results. The default is 20.
- `"nextToken"`: If your initial ListSecurityConfigs operation returns a nextToken, you can
  include the returned nextToken in subsequent ListSecurityConfigs operations, which returns
  results in the next page.
"""
function list_security_configs(type; aws_config::AbstractAWSConfig=current_aws_config())
    return opensearchserverless(
        "ListSecurityConfigs",
        Dict{String,Any}("type" => type);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_security_configs(
    type, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearchserverless(
        "ListSecurityConfigs",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("type" => type), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_security_policies(type)
    list_security_policies(type, params::Dict{String,<:Any})

Returns information about configured OpenSearch Serverless security policies.

# Arguments
- `type`: The type of policy.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: An optional parameter that specifies the maximum number of results to
  return. You can use nextToken to get the next page of results. The default is 20.
- `"nextToken"`: If your initial ListSecurityPolicies operation returns a nextToken, you
  can include the returned nextToken in subsequent ListSecurityPolicies operations, which
  returns results in the next page.
- `"resource"`: Resource filters (can be collection or indexes) that policies can apply to.
"""
function list_security_policies(type; aws_config::AbstractAWSConfig=current_aws_config())
    return opensearchserverless(
        "ListSecurityPolicies",
        Dict{String,Any}("type" => type);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_security_policies(
    type, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearchserverless(
        "ListSecurityPolicies",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("type" => type), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

Returns the tags for an OpenSearch Serverless resource. For more information, see Tagging
Amazon OpenSearch Serverless collections.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource. The resource must be
  active (not in the DELETING state), and must be owned by the account ID included in the
  request.

"""
function list_tags_for_resource(
    resourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearchserverless(
        "ListTagsForResource",
        Dict{String,Any}("resourceArn" => resourceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    resourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearchserverless(
        "ListTagsForResource",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("resourceArn" => resourceArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_vpc_endpoints()
    list_vpc_endpoints(params::Dict{String,<:Any})

Returns the OpenSearch Serverless-managed interface VPC endpoints associated with the
current account. For more information, see Access Amazon OpenSearch Serverless using an
interface endpoint.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: An optional parameter that specifies the maximum number of results to
  return. You can use nextToken to get the next page of results. The default is 20.
- `"nextToken"`: If your initial ListVpcEndpoints operation returns a nextToken, you can
  include the returned nextToken in subsequent ListVpcEndpoints operations, which returns
  results in the next page.
- `"vpcEndpointFilters"`: Filter the results according to the current status of the VPC
  endpoint. Possible statuses are CREATING, DELETING, UPDATING, ACTIVE, and FAILED.
"""
function list_vpc_endpoints(; aws_config::AbstractAWSConfig=current_aws_config())
    return opensearchserverless(
        "ListVpcEndpoints"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_vpc_endpoints(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearchserverless(
        "ListVpcEndpoints", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Associates tags with an OpenSearch Serverless resource. For more information, see Tagging
Amazon OpenSearch Serverless collections.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource. The resource must be
  active (not in the DELETING state), and must be owned by the account ID included in the
  request.
- `tags`: A list of tags (key-value pairs) to add to the resource. All tag keys in the
  request must be unique.

"""
function tag_resource(resourceArn, tags; aws_config::AbstractAWSConfig=current_aws_config())
    return opensearchserverless(
        "TagResource",
        Dict{String,Any}("resourceArn" => resourceArn, "tags" => tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    resourceArn,
    tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearchserverless(
        "TagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("resourceArn" => resourceArn, "tags" => tags),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Removes a tag or set of tags from an OpenSearch Serverless resource. For more information,
see Tagging Amazon OpenSearch Serverless collections.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource to remove tags from. The
  resource must be active (not in the DELETING state), and must be owned by the account ID
  included in the request.
- `tag_keys`: The tag or set of tags to remove from the resource. All tag keys in the
  request must be unique.

"""
function untag_resource(
    resourceArn, tagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearchserverless(
        "UntagResource",
        Dict{String,Any}("resourceArn" => resourceArn, "tagKeys" => tagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    resourceArn,
    tagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearchserverless(
        "UntagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("resourceArn" => resourceArn, "tagKeys" => tagKeys),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_access_policy(name, policy_version, type)
    update_access_policy(name, policy_version, type, params::Dict{String,<:Any})

Updates an OpenSearch Serverless access policy. For more information, see Data access
control for Amazon OpenSearch Serverless.

# Arguments
- `name`: The name of the policy.
- `policy_version`: The version of the policy being updated.
- `type`: The type of policy.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: Unique, case-sensitive identifier to ensure idempotency of the request.
- `"description"`: A description of the policy. Typically used to store information about
  the permissions defined in the policy.
- `"policy"`: The JSON policy document to use as the content for the policy.
"""
function update_access_policy(
    name, policyVersion, type; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearchserverless(
        "UpdateAccessPolicy",
        Dict{String,Any}(
            "name" => name,
            "policyVersion" => policyVersion,
            "type" => type,
            "clientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_access_policy(
    name,
    policyVersion,
    type,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearchserverless(
        "UpdateAccessPolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "name" => name,
                    "policyVersion" => policyVersion,
                    "type" => type,
                    "clientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_account_settings()
    update_account_settings(params::Dict{String,<:Any})

Update the OpenSearch Serverless settings for the current Amazon Web Services account. For
more information, see Managing capacity limits for Amazon OpenSearch Serverless.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"capacityLimits"`:
"""
function update_account_settings(; aws_config::AbstractAWSConfig=current_aws_config())
    return opensearchserverless(
        "UpdateAccountSettings"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function update_account_settings(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearchserverless(
        "UpdateAccountSettings",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_collection(id)
    update_collection(id, params::Dict{String,<:Any})

Updates an OpenSearch Serverless collection.

# Arguments
- `id`: The unique identifier of the collection.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: Unique, case-sensitive identifier to ensure idempotency of the request.
- `"description"`: A description of the collection.
"""
function update_collection(id; aws_config::AbstractAWSConfig=current_aws_config())
    return opensearchserverless(
        "UpdateCollection",
        Dict{String,Any}("id" => id, "clientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_collection(
    id, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearchserverless(
        "UpdateCollection",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("id" => id, "clientToken" => string(uuid4())),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_lifecycle_policy(name, policy_version, type)
    update_lifecycle_policy(name, policy_version, type, params::Dict{String,<:Any})

Updates an OpenSearch Serverless access policy. For more information, see Updating data
lifecycle policies.

# Arguments
- `name`: The name of the policy.
- `policy_version`: The version of the policy being updated.
- `type`:  The type of lifecycle policy.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: A unique, case-sensitive identifier to ensure idempotency of the request.
- `"description"`: A description of the lifecycle policy.
- `"policy"`: The JSON policy document to use as the content for the lifecycle policy.
"""
function update_lifecycle_policy(
    name, policyVersion, type; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearchserverless(
        "UpdateLifecyclePolicy",
        Dict{String,Any}(
            "name" => name,
            "policyVersion" => policyVersion,
            "type" => type,
            "clientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_lifecycle_policy(
    name,
    policyVersion,
    type,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearchserverless(
        "UpdateLifecyclePolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "name" => name,
                    "policyVersion" => policyVersion,
                    "type" => type,
                    "clientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_security_config(config_version, id)
    update_security_config(config_version, id, params::Dict{String,<:Any})

Updates a security configuration for OpenSearch Serverless. For more information, see SAML
authentication for Amazon OpenSearch Serverless.

# Arguments
- `config_version`: The version of the security configuration to be updated. You can find
  the most recent version of a security configuration using the GetSecurityPolicy command.
- `id`: The security configuration identifier. For SAML the ID will be
  saml/&lt;accountId&gt;/&lt;idpProviderName&gt;. For example, saml/123456789123/OKTADev.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: Unique, case-sensitive identifier to ensure idempotency of the request.
- `"description"`: A description of the security configuration.
- `"samlOptions"`: SAML options in in the form of a key-value map.
"""
function update_security_config(
    configVersion, id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearchserverless(
        "UpdateSecurityConfig",
        Dict{String,Any}(
            "configVersion" => configVersion, "id" => id, "clientToken" => string(uuid4())
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_security_config(
    configVersion,
    id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearchserverless(
        "UpdateSecurityConfig",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "configVersion" => configVersion,
                    "id" => id,
                    "clientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_security_policy(name, policy_version, type)
    update_security_policy(name, policy_version, type, params::Dict{String,<:Any})

Updates an OpenSearch Serverless security policy. For more information, see Network access
for Amazon OpenSearch Serverless and Encryption at rest for Amazon OpenSearch Serverless.

# Arguments
- `name`: The name of the policy.
- `policy_version`: The version of the policy being updated.
- `type`: The type of access policy.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: Unique, case-sensitive identifier to ensure idempotency of the request.
- `"description"`: A description of the policy. Typically used to store information about
  the permissions defined in the policy.
- `"policy"`: The JSON policy document to use as the content for the new policy.
"""
function update_security_policy(
    name, policyVersion, type; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearchserverless(
        "UpdateSecurityPolicy",
        Dict{String,Any}(
            "name" => name,
            "policyVersion" => policyVersion,
            "type" => type,
            "clientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_security_policy(
    name,
    policyVersion,
    type,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearchserverless(
        "UpdateSecurityPolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "name" => name,
                    "policyVersion" => policyVersion,
                    "type" => type,
                    "clientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_vpc_endpoint(id)
    update_vpc_endpoint(id, params::Dict{String,<:Any})

Updates an OpenSearch Serverless-managed interface endpoint. For more information, see
Access Amazon OpenSearch Serverless using an interface endpoint.

# Arguments
- `id`: The unique identifier of the interface endpoint to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"addSecurityGroupIds"`: The unique identifiers of the security groups to add to the
  endpoint. Security groups define the ports, protocols, and sources for inbound traffic that
  you are authorizing into your endpoint.
- `"addSubnetIds"`: The ID of one or more subnets to add to the endpoint.
- `"clientToken"`: Unique, case-sensitive identifier to ensure idempotency of the request.
- `"removeSecurityGroupIds"`: The unique identifiers of the security groups to remove from
  the endpoint.
- `"removeSubnetIds"`: The unique identifiers of the subnets to remove from the endpoint.
"""
function update_vpc_endpoint(id; aws_config::AbstractAWSConfig=current_aws_config())
    return opensearchserverless(
        "UpdateVpcEndpoint",
        Dict{String,Any}("id" => id, "clientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_vpc_endpoint(
    id, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearchserverless(
        "UpdateVpcEndpoint",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("id" => id, "clientToken" => string(uuid4())),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
