# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: opsworks
using AWS.Compat
using AWS.UUIDs

"""
    assign_instance(instance_id, layer_ids)
    assign_instance(instance_id, layer_ids, params::Dict{String,<:Any})

Assign a registered instance to a layer.   You can assign registered on-premises instances
to any layer type.   You can assign registered Amazon EC2 instances only to custom layers.
 You cannot use this action with instances that were created with OpsWorks Stacks.
Required Permissions: To use this action, an Identity and Access Management (IAM) user must
have a Manage permissions level for the stack or an attached policy that explicitly grants
permissions. For more information on user permissions, see Managing User Permissions.

# Arguments
- `instance_id`: The instance ID.
- `layer_ids`: The layer ID, which must correspond to a custom layer. You cannot assign a
  registered instance to a built-in layer.

"""
function assign_instance(
    InstanceId, LayerIds; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opsworks(
        "AssignInstance",
        Dict{String,Any}("InstanceId" => InstanceId, "LayerIds" => LayerIds);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function assign_instance(
    InstanceId,
    LayerIds,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opsworks(
        "AssignInstance",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("InstanceId" => InstanceId, "LayerIds" => LayerIds),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    assign_volume(volume_id)
    assign_volume(volume_id, params::Dict{String,<:Any})

Assigns one of the stack's registered Amazon EBS volumes to a specified instance. The
volume must first be registered with the stack by calling RegisterVolume. After you
register the volume, you must call UpdateVolume to specify a mount point before calling
AssignVolume. For more information, see Resource Management.  Required Permissions: To use
this action, an IAM user must have a Manage permissions level for the stack, or an attached
policy that explicitly grants permissions. For more information on user permissions, see
Managing User Permissions.

# Arguments
- `volume_id`: The volume ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"InstanceId"`: The instance ID.
"""
function assign_volume(VolumeId; aws_config::AbstractAWSConfig=current_aws_config())
    return opsworks(
        "AssignVolume",
        Dict{String,Any}("VolumeId" => VolumeId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function assign_volume(
    VolumeId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opsworks(
        "AssignVolume",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("VolumeId" => VolumeId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    associate_elastic_ip(elastic_ip)
    associate_elastic_ip(elastic_ip, params::Dict{String,<:Any})

Associates one of the stack's registered Elastic IP addresses with a specified instance.
The address must first be registered with the stack by calling RegisterElasticIp. For more
information, see Resource Management.  Required Permissions: To use this action, an IAM
user must have a Manage permissions level for the stack, or an attached policy that
explicitly grants permissions. For more information on user permissions, see Managing User
Permissions.

# Arguments
- `elastic_ip`: The Elastic IP address.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"InstanceId"`: The instance ID.
"""
function associate_elastic_ip(ElasticIp; aws_config::AbstractAWSConfig=current_aws_config())
    return opsworks(
        "AssociateElasticIp",
        Dict{String,Any}("ElasticIp" => ElasticIp);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_elastic_ip(
    ElasticIp,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opsworks(
        "AssociateElasticIp",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ElasticIp" => ElasticIp), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    attach_elastic_load_balancer(elastic_load_balancer_name, layer_id)
    attach_elastic_load_balancer(elastic_load_balancer_name, layer_id, params::Dict{String,<:Any})

Attaches an Elastic Load Balancing load balancer to a specified layer. OpsWorks Stacks does
not support Application Load Balancer. You can only use Classic Load Balancer with OpsWorks
Stacks. For more information, see Elastic Load Balancing.  You must create the Elastic Load
Balancing instance separately, by using the Elastic Load Balancing console, API, or CLI.
For more information, see the Elastic Load Balancing Developer Guide.   Required
Permissions: To use this action, an IAM user must have a Manage permissions level for the
stack, or an attached policy that explicitly grants permissions. For more information on
user permissions, see Managing User Permissions.

# Arguments
- `elastic_load_balancer_name`: The Elastic Load Balancing instance's name.
- `layer_id`: The ID of the layer to which the Elastic Load Balancing instance is to be
  attached.

"""
function attach_elastic_load_balancer(
    ElasticLoadBalancerName, LayerId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opsworks(
        "AttachElasticLoadBalancer",
        Dict{String,Any}(
            "ElasticLoadBalancerName" => ElasticLoadBalancerName, "LayerId" => LayerId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function attach_elastic_load_balancer(
    ElasticLoadBalancerName,
    LayerId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opsworks(
        "AttachElasticLoadBalancer",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ElasticLoadBalancerName" => ElasticLoadBalancerName,
                    "LayerId" => LayerId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    clone_stack(service_role_arn, source_stack_id)
    clone_stack(service_role_arn, source_stack_id, params::Dict{String,<:Any})

Creates a clone of a specified stack. For more information, see Clone a Stack. By default,
all parameters are set to the values used by the parent stack.  Required Permissions: To
use this action, an IAM user must have an attached policy that explicitly grants
permissions. For more information about user permissions, see Managing User Permissions.

# Arguments
- `service_role_arn`: The stack Identity and Access Management (IAM) role, which allows
  OpsWorks Stacks to work with Amazon Web Services resources on your behalf. You must set
  this parameter to the Amazon Resource Name (ARN) for an existing IAM role. If you create a
  stack by using the OpsWorkss Stacks console, it creates the role for you. You can obtain an
  existing stack's IAM ARN programmatically by calling DescribePermissions. For more
  information about IAM ARNs, see Using Identifiers.  You must set this parameter to a valid
  service role ARN or the action will fail; there is no default value. You can specify the
  source stack's service role ARN, if you prefer, but you must do so explicitly.
- `source_stack_id`: The source stack ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AgentVersion"`: The default OpsWorks Stacks agent version. You have the following
  options:   Auto-update - Set this parameter to LATEST. OpsWorks Stacks automatically
  installs new agent versions on the stack's instances as soon as they are available.   Fixed
  version - Set this parameter to your preferred agent version. To update the agent version,
  you must edit the stack configuration and specify a new version. OpsWorks Stacks
  automatically installs that version on the stack's instances.   The default setting is
  LATEST. To specify an agent version, you must use the complete version number, not the
  abbreviated number shown on the console. For a list of available agent version numbers,
  call DescribeAgentVersions. AgentVersion cannot be set to Chef 12.2.  You can also specify
  an agent version when you create or update an instance, which overrides the stack's default
  setting.
- `"Attributes"`: A list of stack attributes and values as key/value pairs to be added to
  the cloned stack.
- `"ChefConfiguration"`: A ChefConfiguration object that specifies whether to enable
  Berkshelf and the Berkshelf version on Chef 11.10 stacks. For more information, see Create
  a New Stack.
- `"CloneAppIds"`: A list of source stack app IDs to be included in the cloned stack.
- `"ClonePermissions"`: Whether to clone the source stack's permissions.
- `"ConfigurationManager"`: The configuration manager. When you clone a stack we recommend
  that you use the configuration manager to specify the Chef version: 12, 11.10, or 11.4 for
  Linux stacks, or 12.2 for Windows stacks. The default value for Linux stacks is currently
  12.
- `"CustomCookbooksSource"`: Contains the information required to retrieve an app or
  cookbook from a repository. For more information, see Adding Apps or Cookbooks and Recipes.
- `"CustomJson"`: A string that contains user-defined, custom JSON. It is used to override
  the corresponding default stack configuration JSON values. The string should be in the
  following format:  \"{\"key1\": \"value1\", \"key2\": \"value2\",...}\"  For more
  information about custom JSON, see Use Custom JSON to Modify the Stack Configuration
  Attributes
- `"DefaultAvailabilityZone"`: The cloned stack's default Availability Zone, which must be
  in the specified region. For more information, see Regions and Endpoints. If you also
  specify a value for DefaultSubnetId, the subnet must be in the same zone. For more
  information, see the VpcId parameter description.
- `"DefaultInstanceProfileArn"`: The Amazon Resource Name (ARN) of an IAM profile that is
  the default profile for all of the stack's EC2 instances. For more information about IAM
  ARNs, see Using Identifiers.
- `"DefaultOs"`: The stack's operating system, which must be set to one of the following.
  A supported Linux operating system: An Amazon Linux version, such as Amazon Linux 2, Amazon
  Linux 2018.03, Amazon Linux 2017.09, Amazon Linux 2017.03, Amazon Linux 2016.09, Amazon
  Linux 2016.03, Amazon Linux 2015.09, or Amazon Linux 2015.03.   A supported Ubuntu
  operating system, such as Ubuntu 18.04 LTS, Ubuntu 16.04 LTS, Ubuntu 14.04 LTS, or Ubuntu
  12.04 LTS.    CentOS Linux 7     Red Hat Enterprise Linux 7     Microsoft Windows Server
  2012 R2 Base, Microsoft Windows Server 2012 R2 with SQL Server Express, Microsoft Windows
  Server 2012 R2 with SQL Server Standard, or Microsoft Windows Server 2012 R2 with SQL
  Server Web.   A custom AMI: Custom. You specify the custom AMI you want to use when you
  create instances. For more information about how to use custom AMIs with OpsWorks, see
  Using Custom AMIs.   The default option is the parent stack's operating system. Not all
  operating systems are supported with all versions of Chef. For more information about
  supported operating systems, see OpsWorks Stacks Operating Systems.  You can specify a
  different Linux operating system for the cloned stack, but you cannot change from Linux to
  Windows or Windows to Linux.
- `"DefaultRootDeviceType"`: The default root device type. This value is used by default
  for all instances in the cloned stack, but you can override it when you create an instance.
  For more information, see Storage for the Root Device.
- `"DefaultSshKeyName"`: A default Amazon EC2 key pair name. The default value is none. If
  you specify a key pair name, OpsWorks installs the public key on the instance and you can
  use the private key with an SSH client to log in to the instance. For more information, see
   Using SSH to Communicate with an Instance and  Managing SSH Access. You can override this
  setting by specifying a different key pair, or no key pair, when you  create an instance.
- `"DefaultSubnetId"`: The stack's default VPC subnet ID. This parameter is required if you
  specify a value for the VpcId parameter. All instances are launched into this subnet unless
  you specify otherwise when you create the instance. If you also specify a value for
  DefaultAvailabilityZone, the subnet must be in that zone. For information on default values
  and when this parameter is required, see the VpcId parameter description.
- `"HostnameTheme"`: The stack's host name theme, with spaces are replaced by underscores.
  The theme is used to generate host names for the stack's instances. By default,
  HostnameTheme is set to Layer_Dependent, which creates host names by appending integers to
  the layer's short name. The other themes are:    Baked_Goods     Clouds     Europe_Cities
    Fruits     Greek_Deities_and_Titans     Legendary_creatures_from_Japan
  Planets_and_Moons     Roman_Deities     Scottish_Islands     US_Cities     Wild_Cats    To
  obtain a generated host name, call GetHostNameSuggestion, which returns a host name based
  on the current theme.
- `"Name"`: The cloned stack name. Stack names can be a maximum of 64 characters.
- `"Region"`: The cloned stack Amazon Web Services Region, such as ap-northeast-2. For more
  information about Amazon Web Services Regions, see Regions and Endpoints.
- `"UseCustomCookbooks"`: Whether to use custom cookbooks.
- `"UseOpsworksSecurityGroups"`: Whether to associate the OpsWorks Stacks built-in security
  groups with the stack's layers. OpsWorks Stacks provides a standard set of security groups,
  one for each layer, which are associated with layers by default. With
  UseOpsworksSecurityGroups you can instead provide your own custom security groups.
  UseOpsworksSecurityGroups has the following settings:    True - OpsWorks Stacks
  automatically associates the appropriate built-in security group with each layer (default
  setting). You can associate additional security groups with a layer after you create it but
  you cannot delete the built-in security group.   False - OpsWorks Stacks does not associate
  built-in security groups with layers. You must create appropriate Amazon EC2 security
  groups and associate a security group with each layer that you create. However, you can
  still manually associate a built-in security group with a layer on creation; custom
  security groups are required only for those layers that need custom settings.   For more
  information, see Create a New Stack.
- `"VpcId"`: The ID of the VPC that the cloned stack is to be launched into. It must be in
  the specified region. All instances are launched into this VPC, and you cannot change the
  ID later.   If your account supports EC2 Classic, the default value is no VPC.   If your
  account does not support EC2 Classic, the default value is the default VPC for the
  specified region.   If the VPC ID corresponds to a default VPC and you have specified
  either the DefaultAvailabilityZone or the DefaultSubnetId parameter only, OpsWorks Stacks
  infers the value of the other parameter. If you specify neither parameter, OpsWorks Stacks
  sets these parameters to the first valid Availability Zone for the specified region and the
  corresponding default VPC subnet ID, respectively.  If you specify a nondefault VPC ID,
  note the following:   It must belong to a VPC in your account that is in the specified
  region.   You must specify a value for DefaultSubnetId.   For more information about how to
  use OpsWorks Stacks with a VPC, see Running a Stack in a VPC. For more information about
  default VPC and EC2 Classic, see Supported Platforms.
"""
function clone_stack(
    ServiceRoleArn, SourceStackId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opsworks(
        "CloneStack",
        Dict{String,Any}(
            "ServiceRoleArn" => ServiceRoleArn, "SourceStackId" => SourceStackId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function clone_stack(
    ServiceRoleArn,
    SourceStackId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opsworks(
        "CloneStack",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ServiceRoleArn" => ServiceRoleArn, "SourceStackId" => SourceStackId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_app(name, stack_id, type)
    create_app(name, stack_id, type, params::Dict{String,<:Any})

Creates an app for a specified stack. For more information, see Creating Apps.  Required
Permissions: To use this action, an IAM user must have a Manage permissions level for the
stack, or an attached policy that explicitly grants permissions. For more information on
user permissions, see Managing User Permissions.

# Arguments
- `name`: The app name.
- `stack_id`: The stack ID.
- `type`: The app type. Each supported type is associated with a particular layer. For
  example, PHP applications are associated with a PHP layer. OpsWorks Stacks deploys an
  application to those instances that are members of the corresponding layer. If your app
  isn't one of the standard types, or you prefer to implement your own Deploy recipes,
  specify other.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AppSource"`: A Source object that specifies the app repository.
- `"Attributes"`: One or more user-defined key/value pairs to be added to the stack
  attributes.
- `"DataSources"`: The app's data source.
- `"Description"`: A description of the app.
- `"Domains"`: The app virtual host settings, with multiple domains separated by commas.
  For example: 'www.example.com, example.com'
- `"EnableSsl"`: Whether to enable SSL for the app.
- `"Environment"`: An array of EnvironmentVariable objects that specify environment
  variables to be associated with the app. After you deploy the app, these variables are
  defined on the associated app server instance. For more information, see  Environment
  Variables. There is no specific limit on the number of environment variables. However, the
  size of the associated data structure - which includes the variables' names, values, and
  protected flag values - cannot exceed 20 KB. This limit should accommodate most if not all
  use cases. Exceeding it will cause an exception with the message, \"Environment: is too
  large (maximum is 20KB).\"  If you have specified one or more environment variables, you
  cannot modify the stack's Chef version.
- `"Shortname"`: The app's short name.
- `"SslConfiguration"`: An SslConfiguration object with the SSL configuration.
"""
function create_app(Name, StackId, Type; aws_config::AbstractAWSConfig=current_aws_config())
    return opsworks(
        "CreateApp",
        Dict{String,Any}("Name" => Name, "StackId" => StackId, "Type" => Type);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_app(
    Name,
    StackId,
    Type,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opsworks(
        "CreateApp",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Name" => Name, "StackId" => StackId, "Type" => Type),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_deployment(command, stack_id)
    create_deployment(command, stack_id, params::Dict{String,<:Any})

Runs deployment or stack commands. For more information, see Deploying Apps and Run Stack
Commands.  Required Permissions: To use this action, an IAM user must have a Deploy or
Manage permissions level for the stack, or an attached policy that explicitly grants
permissions. For more information on user permissions, see Managing User Permissions.

# Arguments
- `command`: A DeploymentCommand object that specifies the deployment command and any
  associated arguments.
- `stack_id`: The stack ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AppId"`: The app ID. This parameter is required for app deployments, but not for other
  deployment commands.
- `"Comment"`: A user-defined comment.
- `"CustomJson"`: A string that contains user-defined, custom JSON. You can use this
  parameter to override some corresponding default stack configuration JSON values. The
  string should be in the following format:  \"{\"key1\": \"value1\", \"key2\":
  \"value2\",...}\"  For more information about custom JSON, see Use Custom JSON to Modify
  the Stack Configuration Attributes and Overriding Attributes With Custom JSON.
- `"InstanceIds"`: The instance IDs for the deployment targets.
- `"LayerIds"`: The layer IDs for the deployment targets.
"""
function create_deployment(
    Command, StackId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opsworks(
        "CreateDeployment",
        Dict{String,Any}("Command" => Command, "StackId" => StackId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_deployment(
    Command,
    StackId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opsworks(
        "CreateDeployment",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("Command" => Command, "StackId" => StackId), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_instance(instance_type, layer_ids, stack_id)
    create_instance(instance_type, layer_ids, stack_id, params::Dict{String,<:Any})

Creates an instance in a specified stack. For more information, see Adding an Instance to a
Layer.  Required Permissions: To use this action, an IAM user must have a Manage
permissions level for the stack, or an attached policy that explicitly grants permissions.
For more information on user permissions, see Managing User Permissions.

# Arguments
- `instance_type`: The instance type, such as t2.micro. For a list of supported instance
  types, open the stack in the console, choose Instances, and choose + Instance. The Size
  list contains the currently supported types. For more information, see Instance Families
  and Types. The parameter values that you use to specify the various types are in the API
  Name column of the Available Instance Types table.
- `layer_ids`: An array that contains the instance's layer IDs.
- `stack_id`: The stack ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AgentVersion"`: The default OpsWorks Stacks agent version. You have the following
  options:    INHERIT - Use the stack's default agent version setting.    version_number -
  Use the specified agent version. This value overrides the stack's default setting. To
  update the agent version, edit the instance configuration and specify a new version.
  OpsWorks Stacks installs that version on the instance.   The default setting is INHERIT. To
  specify an agent version, you must use the complete version number, not the abbreviated
  number shown on the console. For a list of available agent version numbers, call
  DescribeAgentVersions. AgentVersion cannot be set to Chef 12.2.
- `"AmiId"`: A custom AMI ID to be used to create the instance. The AMI should be based on
  one of the supported operating systems. For more information, see Using Custom AMIs.  If
  you specify a custom AMI, you must set Os to Custom.
- `"Architecture"`: The instance architecture. The default option is x86_64. Instance types
  do not necessarily support both architectures. For a list of the architectures that are
  supported by the different instance types, see Instance Families and Types.
- `"AutoScalingType"`: For load-based or time-based instances, the type. Windows stacks can
  use only time-based instances.
- `"AvailabilityZone"`: The instance Availability Zone. For more information, see Regions
  and Endpoints.
- `"BlockDeviceMappings"`: An array of BlockDeviceMapping objects that specify the
  instance's block devices. For more information, see Block Device Mapping. Note that block
  device mappings are not supported for custom AMIs.
- `"EbsOptimized"`: Whether to create an Amazon EBS-optimized instance.
- `"Hostname"`: The instance host name. The following are character limits for instance
  host names.   Linux-based instances: 63 characters   Windows-based instances: 15 characters
  
- `"InstallUpdatesOnBoot"`: Whether to install operating system and package updates when
  the instance boots. The default value is true. To control when updates are installed, set
  this value to false. You must then update your instances manually by using CreateDeployment
  to run the update_dependencies stack command or by manually running yum (Amazon Linux) or
  apt-get (Ubuntu) on the instances.   We strongly recommend using the default value of true
  to ensure that your instances have the latest security updates.
- `"Os"`: The instance's operating system, which must be set to one of the following.   A
  supported Linux operating system: An Amazon Linux version, such as Amazon Linux 2, Amazon
  Linux 2018.03, Amazon Linux 2017.09, Amazon Linux 2017.03, Amazon Linux 2016.09, Amazon
  Linux 2016.03, Amazon Linux 2015.09, or Amazon Linux 2015.03.   A supported Ubuntu
  operating system, such as Ubuntu 18.04 LTS, Ubuntu 16.04 LTS, Ubuntu 14.04 LTS, or Ubuntu
  12.04 LTS.    CentOS Linux 7     Red Hat Enterprise Linux 7    A supported Windows
  operating system, such as Microsoft Windows Server 2012 R2 Base, Microsoft Windows Server
  2012 R2 with SQL Server Express, Microsoft Windows Server 2012 R2 with SQL Server Standard,
  or Microsoft Windows Server 2012 R2 with SQL Server Web.   A custom AMI: Custom.   Not all
  operating systems are supported with all versions of Chef. For more information about the
  supported operating systems, see OpsWorks Stacks Operating Systems. The default option is
  the current Amazon Linux version. If you set this parameter to Custom, you must use the
  CreateInstance action's AmiId parameter to specify the custom AMI that you want to use.
  Block device mappings are not supported if the value is Custom. For more information about
  how to use custom AMIs with OpsWorks Stacks, see Using Custom AMIs.
- `"RootDeviceType"`: The instance root device type. For more information, see Storage for
  the Root Device.
- `"SshKeyName"`: The instance's Amazon EC2 key-pair name.
- `"SubnetId"`: The ID of the instance's subnet. If the stack is running in a VPC, you can
  use this parameter to override the stack's default subnet ID value and direct OpsWorks
  Stacks to launch the instance in a different subnet.
- `"Tenancy"`: The instance's tenancy option. The default option is no tenancy, or if the
  instance is running in a VPC, inherit tenancy settings from the VPC. The following are
  valid values for this parameter: dedicated, default, or host. Because there are costs
  associated with changes in tenancy options, we recommend that you research tenancy options
  before choosing them for your instances. For more information about dedicated hosts, see
  Dedicated Hosts Overview and Amazon EC2 Dedicated Hosts. For more information about
  dedicated instances, see Dedicated Instances and Amazon EC2 Dedicated Instances.
- `"VirtualizationType"`: The instance's virtualization type, paravirtual or hvm.
"""
function create_instance(
    InstanceType, LayerIds, StackId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opsworks(
        "CreateInstance",
        Dict{String,Any}(
            "InstanceType" => InstanceType, "LayerIds" => LayerIds, "StackId" => StackId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_instance(
    InstanceType,
    LayerIds,
    StackId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opsworks(
        "CreateInstance",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "InstanceType" => InstanceType,
                    "LayerIds" => LayerIds,
                    "StackId" => StackId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_layer(name, shortname, stack_id, type)
    create_layer(name, shortname, stack_id, type, params::Dict{String,<:Any})

Creates a layer. For more information, see How to Create a Layer.  You should use
CreateLayer for noncustom layer types such as PHP App Server only if the stack does not
have an existing layer of that type. A stack can have at most one instance of each
noncustom layer; if you attempt to create a second instance, CreateLayer fails. A stack can
have an arbitrary number of custom layers, so you can call CreateLayer as many times as you
like for that layer type.   Required Permissions: To use this action, an IAM user must have
a Manage permissions level for the stack, or an attached policy that explicitly grants
permissions. For more information on user permissions, see Managing User Permissions.

# Arguments
- `name`: The layer name, which is used by the console. Layer names can be a maximum of 32
  characters.
- `shortname`: For custom layers only, use this parameter to specify the layer's short
  name, which is used internally by OpsWorks Stacks and by Chef recipes. The short name is
  also used as the name for the directory where your app files are installed. It can have a
  maximum of 32 characters, which are limited to the alphanumeric characters, '-', '_', and
  '.'. Built-in layer short names are defined by OpsWorks Stacks. For more information, see
  the Layer Reference.
- `stack_id`: The layer stack ID.
- `type`: The layer type. A stack cannot have more than one built-in layer of the same
  type. It can have any number of custom layers. Built-in layers are not available in Chef 12
  stacks.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Attributes"`: One or more user-defined key-value pairs to be added to the stack
  attributes. To create a cluster layer, set the EcsClusterArn attribute to the cluster's ARN.
- `"AutoAssignElasticIps"`: Whether to automatically assign an Elastic IP address to the
  layer's instances. For more information, see How to Edit a Layer.
- `"AutoAssignPublicIps"`: For stacks that are running in a VPC, whether to automatically
  assign a public IP address to the layer's instances. For more information, see How to Edit
  a Layer.
- `"CloudWatchLogsConfiguration"`: Specifies CloudWatch Logs configuration options for the
  layer. For more information, see CloudWatchLogsLogStream.
- `"CustomInstanceProfileArn"`: The ARN of an IAM profile to be used for the layer's EC2
  instances. For more information about IAM ARNs, see Using Identifiers.
- `"CustomJson"`: A JSON-formatted string containing custom stack configuration and
  deployment attributes to be installed on the layer's instances. For more information, see
  Using Custom JSON. This feature is supported as of version 1.7.42 of the CLI.
- `"CustomRecipes"`: A LayerCustomRecipes object that specifies the layer custom recipes.
- `"CustomSecurityGroupIds"`: An array containing the layer custom security group IDs.
- `"EnableAutoHealing"`: Whether to disable auto healing for the layer.
- `"InstallUpdatesOnBoot"`: Whether to install operating system and package updates when
  the instance boots. The default value is true. To control when updates are installed, set
  this value to false. You must then update your instances manually by using CreateDeployment
  to run the update_dependencies stack command or by manually running yum (Amazon Linux) or
  apt-get (Ubuntu) on the instances.   To ensure that your instances have the latest security
  updates, we strongly recommend using the default value of true.
- `"LifecycleEventConfiguration"`: A LifeCycleEventConfiguration object that you can use to
  configure the Shutdown event to specify an execution timeout and enable or disable Elastic
  Load Balancer connection draining.
- `"Packages"`: An array of Package objects that describes the layer packages.
- `"UseEbsOptimizedInstances"`: Whether to use Amazon EBS-optimized instances.
- `"VolumeConfigurations"`: A VolumeConfigurations object that describes the layer's Amazon
  EBS volumes.
"""
function create_layer(
    Name, Shortname, StackId, Type; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opsworks(
        "CreateLayer",
        Dict{String,Any}(
            "Name" => Name, "Shortname" => Shortname, "StackId" => StackId, "Type" => Type
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_layer(
    Name,
    Shortname,
    StackId,
    Type,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opsworks(
        "CreateLayer",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Name" => Name,
                    "Shortname" => Shortname,
                    "StackId" => StackId,
                    "Type" => Type,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_stack(default_instance_profile_arn, name, region, service_role_arn)
    create_stack(default_instance_profile_arn, name, region, service_role_arn, params::Dict{String,<:Any})

Creates a new stack. For more information, see Create a New Stack.  Required Permissions:
To use this action, an IAM user must have an attached policy that explicitly grants
permissions. For more information about user permissions, see Managing User Permissions.

# Arguments
- `default_instance_profile_arn`: The Amazon Resource Name (ARN) of an IAM profile that is
  the default profile for all of the stack's EC2 instances. For more information about IAM
  ARNs, see Using Identifiers.
- `name`: The stack name. Stack names can be a maximum of 64 characters.
- `region`: The stack's Amazon Web Services Region, such as ap-south-1. For more
  information about Amazon Web Services Regions, see Regions and Endpoints.  In the CLI, this
  API maps to the --stack-region parameter. If the --stack-region parameter and the CLI
  common parameter --region are set to the same value, the stack uses a regional endpoint. If
  the --stack-region parameter is not set, but the CLI --region parameter is, this also
  results in a stack with a regional endpoint. However, if the --region parameter is set to
  us-east-1, and the --stack-region parameter is set to one of the following, then the stack
  uses a legacy or classic region: us-west-1, us-west-2, sa-east-1, eu-central-1, eu-west-1,
  ap-northeast-1, ap-southeast-1, ap-southeast-2. In this case, the actual API endpoint of
  the stack is in us-east-1. Only the preceding regions are supported as classic regions in
  the us-east-1 API endpoint. Because it is a best practice to choose the regional endpoint
  that is closest to where you manage Amazon Web Services, we recommend that you use regional
  endpoints for new stacks. The CLI common --region parameter always specifies a regional API
  endpoint; it cannot be used to specify a classic OpsWorks Stacks region.
- `service_role_arn`: The stack's IAM role, which allows OpsWorks Stacks to work with
  Amazon Web Services resources on your behalf. You must set this parameter to the Amazon
  Resource Name (ARN) for an existing IAM role. For more information about IAM ARNs, see
  Using Identifiers.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AgentVersion"`: The default OpsWorks Stacks agent version. You have the following
  options:   Auto-update - Set this parameter to LATEST. OpsWorks Stacks automatically
  installs new agent versions on the stack's instances as soon as they are available.   Fixed
  version - Set this parameter to your preferred agent version. To update the agent version,
  you must edit the stack configuration and specify a new version. OpsWorks Stacks installs
  that version on the stack's instances.   The default setting is the most recent release of
  the agent. To specify an agent version, you must use the complete version number, not the
  abbreviated number shown on the console. For a list of available agent version numbers,
  call DescribeAgentVersions. AgentVersion cannot be set to Chef 12.2.  You can also specify
  an agent version when you create or update an instance, which overrides the stack's default
  setting.
- `"Attributes"`: One or more user-defined key-value pairs to be added to the stack
  attributes.
- `"ChefConfiguration"`: A ChefConfiguration object that specifies whether to enable
  Berkshelf and the Berkshelf version on Chef 11.10 stacks. For more information, see Create
  a New Stack.
- `"ConfigurationManager"`: The configuration manager. When you create a stack we recommend
  that you use the configuration manager to specify the Chef version: 12, 11.10, or 11.4 for
  Linux stacks, or 12.2 for Windows stacks. The default value for Linux stacks is currently
  12.
- `"CustomCookbooksSource"`: Contains the information required to retrieve an app or
  cookbook from a repository. For more information, see Adding Apps or Cookbooks and Recipes.
- `"CustomJson"`: A string that contains user-defined, custom JSON. It can be used to
  override the corresponding default stack configuration attribute values or to pass data to
  recipes. The string should be in the following format:  \"{\"key1\": \"value1\", \"key2\":
  \"value2\",...}\"  For more information about custom JSON, see Use Custom JSON to Modify
  the Stack Configuration Attributes.
- `"DefaultAvailabilityZone"`: The stack's default Availability Zone, which must be in the
  specified region. For more information, see Regions and Endpoints. If you also specify a
  value for DefaultSubnetId, the subnet must be in the same zone. For more information, see
  the VpcId parameter description.
- `"DefaultOs"`: The stack's default operating system, which is installed on every instance
  unless you specify a different operating system when you create the instance. You can
  specify one of the following.   A supported Linux operating system: An Amazon Linux
  version, such as Amazon Linux 2, Amazon Linux 2018.03, Amazon Linux 2017.09, Amazon Linux
  2017.03, Amazon Linux 2016.09, Amazon Linux 2016.03, Amazon Linux 2015.09, or Amazon Linux
  2015.03.   A supported Ubuntu operating system, such as Ubuntu 18.04 LTS, Ubuntu 16.04 LTS,
  Ubuntu 14.04 LTS, or Ubuntu 12.04 LTS.    CentOS Linux 7     Red Hat Enterprise Linux 7
  A supported Windows operating system, such as Microsoft Windows Server 2012 R2 Base,
  Microsoft Windows Server 2012 R2 with SQL Server Express, Microsoft Windows Server 2012 R2
  with SQL Server Standard, or Microsoft Windows Server 2012 R2 with SQL Server Web.   A
  custom AMI: Custom. You specify the custom AMI you want to use when you create instances.
  For more information, see  Using Custom AMIs.   The default option is the current Amazon
  Linux version. Not all operating systems are supported with all versions of Chef. For more
  information about supported operating systems, see OpsWorks Stacks Operating Systems.
- `"DefaultRootDeviceType"`: The default root device type. This value is the default for
  all instances in the stack, but you can override it when you create an instance. The
  default option is instance-store. For more information, see Storage for the Root Device.
- `"DefaultSshKeyName"`: A default Amazon EC2 key pair name. The default value is none. If
  you specify a key pair name, OpsWorks installs the public key on the instance and you can
  use the private key with an SSH client to log in to the instance. For more information, see
   Using SSH to Communicate with an Instance and  Managing SSH Access. You can override this
  setting by specifying a different key pair, or no key pair, when you  create an instance.
- `"DefaultSubnetId"`: The stack's default VPC subnet ID. This parameter is required if you
  specify a value for the VpcId parameter. All instances are launched into this subnet unless
  you specify otherwise when you create the instance. If you also specify a value for
  DefaultAvailabilityZone, the subnet must be in that zone. For information on default values
  and when this parameter is required, see the VpcId parameter description.
- `"HostnameTheme"`: The stack's host name theme, with spaces replaced by underscores. The
  theme is used to generate host names for the stack's instances. By default, HostnameTheme
  is set to Layer_Dependent, which creates host names by appending integers to the layer's
  short name. The other themes are:    Baked_Goods     Clouds     Europe_Cities     Fruits
   Greek_Deities_and_Titans     Legendary_creatures_from_Japan     Planets_and_Moons
  Roman_Deities     Scottish_Islands     US_Cities     Wild_Cats    To obtain a generated
  host name, call GetHostNameSuggestion, which returns a host name based on the current theme.
- `"UseCustomCookbooks"`: Whether the stack uses custom cookbooks.
- `"UseOpsworksSecurityGroups"`: Whether to associate the OpsWorks Stacks built-in security
  groups with the stack's layers. OpsWorks Stacks provides a standard set of built-in
  security groups, one for each layer, which are associated with layers by default. With
  UseOpsworksSecurityGroups you can instead provide your own custom security groups.
  UseOpsworksSecurityGroups has the following settings:    True - OpsWorks Stacks
  automatically associates the appropriate built-in security group with each layer (default
  setting). You can associate additional security groups with a layer after you create it,
  but you cannot delete the built-in security group.   False - OpsWorks Stacks does not
  associate built-in security groups with layers. You must create appropriate EC2 security
  groups and associate a security group with each layer that you create. However, you can
  still manually associate a built-in security group with a layer on creation; custom
  security groups are required only for those layers that need custom settings.   For more
  information, see Create a New Stack.
- `"VpcId"`: The ID of the VPC that the stack is to be launched into. The VPC must be in
  the stack's region. All instances are launched into this VPC. You cannot change the ID
  later.   If your account supports EC2-Classic, the default value is no VPC.   If your
  account does not support EC2-Classic, the default value is the default VPC for the
  specified region.   If the VPC ID corresponds to a default VPC and you have specified
  either the DefaultAvailabilityZone or the DefaultSubnetId parameter only, OpsWorks Stacks
  infers the value of the other parameter. If you specify neither parameter, OpsWorks Stacks
  sets these parameters to the first valid Availability Zone for the specified region and the
  corresponding default VPC subnet ID, respectively. If you specify a nondefault VPC ID, note
  the following:   It must belong to a VPC in your account that is in the specified region.
  You must specify a value for DefaultSubnetId.   For more information about how to use
  OpsWorks Stacks with a VPC, see Running a Stack in a VPC. For more information about
  default VPC and EC2-Classic, see Supported Platforms.
"""
function create_stack(
    DefaultInstanceProfileArn,
    Name,
    Region,
    ServiceRoleArn;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opsworks(
        "CreateStack",
        Dict{String,Any}(
            "DefaultInstanceProfileArn" => DefaultInstanceProfileArn,
            "Name" => Name,
            "Region" => Region,
            "ServiceRoleArn" => ServiceRoleArn,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_stack(
    DefaultInstanceProfileArn,
    Name,
    Region,
    ServiceRoleArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opsworks(
        "CreateStack",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DefaultInstanceProfileArn" => DefaultInstanceProfileArn,
                    "Name" => Name,
                    "Region" => Region,
                    "ServiceRoleArn" => ServiceRoleArn,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_user_profile(iam_user_arn)
    create_user_profile(iam_user_arn, params::Dict{String,<:Any})

Creates a new user profile.  Required Permissions: To use this action, an IAM user must
have an attached policy that explicitly grants permissions. For more information about user
permissions, see Managing User Permissions.

# Arguments
- `iam_user_arn`: The user's IAM ARN; this can also be a federated user's ARN.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AllowSelfManagement"`: Whether users can specify their own SSH public key through the
  My Settings page. For more information, see Setting an IAM User's Public SSH Key.
- `"SshPublicKey"`: The user's public SSH key.
- `"SshUsername"`: The user's SSH user name. The allowable characters are [a-z], [A-Z],
  [0-9], '-', and '_'. If the specified name includes other punctuation marks, OpsWorks
  Stacks removes them. For example, my.name is changed to myname. If you do not specify an
  SSH user name, OpsWorks Stacks generates one from the IAM user name.
"""
function create_user_profile(IamUserArn; aws_config::AbstractAWSConfig=current_aws_config())
    return opsworks(
        "CreateUserProfile",
        Dict{String,Any}("IamUserArn" => IamUserArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_user_profile(
    IamUserArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opsworks(
        "CreateUserProfile",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("IamUserArn" => IamUserArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_app(app_id)
    delete_app(app_id, params::Dict{String,<:Any})

Deletes a specified app.  Required Permissions: To use this action, an IAM user must have a
Manage permissions level for the stack, or an attached policy that explicitly grants
permissions. For more information on user permissions, see Managing User Permissions.

# Arguments
- `app_id`: The app ID.

"""
function delete_app(AppId; aws_config::AbstractAWSConfig=current_aws_config())
    return opsworks(
        "DeleteApp",
        Dict{String,Any}("AppId" => AppId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_app(
    AppId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opsworks(
        "DeleteApp",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("AppId" => AppId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_instance(instance_id)
    delete_instance(instance_id, params::Dict{String,<:Any})

Deletes a specified instance, which terminates the associated Amazon EC2 instance. You must
stop an instance before you can delete it. For more information, see Deleting Instances.
Required Permissions: To use this action, an IAM user must have a Manage permissions level
for the stack, or an attached policy that explicitly grants permissions. For more
information on user permissions, see Managing User Permissions.

# Arguments
- `instance_id`: The instance ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DeleteElasticIp"`: Whether to delete the instance Elastic IP address.
- `"DeleteVolumes"`: Whether to delete the instance's Amazon EBS volumes.
"""
function delete_instance(InstanceId; aws_config::AbstractAWSConfig=current_aws_config())
    return opsworks(
        "DeleteInstance",
        Dict{String,Any}("InstanceId" => InstanceId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_instance(
    InstanceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opsworks(
        "DeleteInstance",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("InstanceId" => InstanceId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_layer(layer_id)
    delete_layer(layer_id, params::Dict{String,<:Any})

Deletes a specified layer. You must first stop and then delete all associated instances or
unassign registered instances. For more information, see How to Delete a Layer.  Required
Permissions: To use this action, an IAM user must have a Manage permissions level for the
stack, or an attached policy that explicitly grants permissions. For more information on
user permissions, see Managing User Permissions.

# Arguments
- `layer_id`: The layer ID.

"""
function delete_layer(LayerId; aws_config::AbstractAWSConfig=current_aws_config())
    return opsworks(
        "DeleteLayer",
        Dict{String,Any}("LayerId" => LayerId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_layer(
    LayerId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opsworks(
        "DeleteLayer",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("LayerId" => LayerId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_stack(stack_id)
    delete_stack(stack_id, params::Dict{String,<:Any})

Deletes a specified stack. You must first delete all instances, layers, and apps or
deregister registered instances. For more information, see Shut Down a Stack.  Required
Permissions: To use this action, an IAM user must have a Manage permissions level for the
stack, or an attached policy that explicitly grants permissions. For more information on
user permissions, see Managing User Permissions.

# Arguments
- `stack_id`: The stack ID.

"""
function delete_stack(StackId; aws_config::AbstractAWSConfig=current_aws_config())
    return opsworks(
        "DeleteStack",
        Dict{String,Any}("StackId" => StackId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_stack(
    StackId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opsworks(
        "DeleteStack",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("StackId" => StackId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_user_profile(iam_user_arn)
    delete_user_profile(iam_user_arn, params::Dict{String,<:Any})

Deletes a user profile.  Required Permissions: To use this action, an IAM user must have an
attached policy that explicitly grants permissions. For more information about user
permissions, see Managing User Permissions.

# Arguments
- `iam_user_arn`: The user's IAM ARN. This can also be a federated user's ARN.

"""
function delete_user_profile(IamUserArn; aws_config::AbstractAWSConfig=current_aws_config())
    return opsworks(
        "DeleteUserProfile",
        Dict{String,Any}("IamUserArn" => IamUserArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_user_profile(
    IamUserArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opsworks(
        "DeleteUserProfile",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("IamUserArn" => IamUserArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    deregister_ecs_cluster(ecs_cluster_arn)
    deregister_ecs_cluster(ecs_cluster_arn, params::Dict{String,<:Any})

Deregisters a specified Amazon ECS cluster from a stack. For more information, see
Resource Management.  Required Permissions: To use this action, an IAM user must have a
Manage permissions level for the stack or an attached policy that explicitly grants
permissions. For more information on user permissions, see
https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html.

# Arguments
- `ecs_cluster_arn`: The cluster's Amazon Resource Number (ARN).

"""
function deregister_ecs_cluster(
    EcsClusterArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opsworks(
        "DeregisterEcsCluster",
        Dict{String,Any}("EcsClusterArn" => EcsClusterArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function deregister_ecs_cluster(
    EcsClusterArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opsworks(
        "DeregisterEcsCluster",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("EcsClusterArn" => EcsClusterArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    deregister_elastic_ip(elastic_ip)
    deregister_elastic_ip(elastic_ip, params::Dict{String,<:Any})

Deregisters a specified Elastic IP address. The address can be registered by another stack
after it is deregistered. For more information, see Resource Management.  Required
Permissions: To use this action, an IAM user must have a Manage permissions level for the
stack, or an attached policy that explicitly grants permissions. For more information on
user permissions, see Managing User Permissions.

# Arguments
- `elastic_ip`: The Elastic IP address.

"""
function deregister_elastic_ip(
    ElasticIp; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opsworks(
        "DeregisterElasticIp",
        Dict{String,Any}("ElasticIp" => ElasticIp);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function deregister_elastic_ip(
    ElasticIp,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opsworks(
        "DeregisterElasticIp",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ElasticIp" => ElasticIp), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    deregister_instance(instance_id)
    deregister_instance(instance_id, params::Dict{String,<:Any})

Deregister an instance from OpsWorks Stacks. The instance can be a registered instance
(Amazon EC2 or on-premises) or an instance created with OpsWorks. This action removes the
instance from the stack and returns it to your control.  Required Permissions: To use this
action, an IAM user must have a Manage permissions level for the stack or an attached
policy that explicitly grants permissions. For more information on user permissions, see
Managing User Permissions.

# Arguments
- `instance_id`: The instance ID.

"""
function deregister_instance(InstanceId; aws_config::AbstractAWSConfig=current_aws_config())
    return opsworks(
        "DeregisterInstance",
        Dict{String,Any}("InstanceId" => InstanceId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function deregister_instance(
    InstanceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opsworks(
        "DeregisterInstance",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("InstanceId" => InstanceId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    deregister_rds_db_instance(rds_db_instance_arn)
    deregister_rds_db_instance(rds_db_instance_arn, params::Dict{String,<:Any})

Deregisters an Amazon RDS instance.  Required Permissions: To use this action, an IAM user
must have a Manage permissions level for the stack, or an attached policy that explicitly
grants permissions. For more information on user permissions, see Managing User Permissions.

# Arguments
- `rds_db_instance_arn`: The Amazon RDS instance's ARN.

"""
function deregister_rds_db_instance(
    RdsDbInstanceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opsworks(
        "DeregisterRdsDbInstance",
        Dict{String,Any}("RdsDbInstanceArn" => RdsDbInstanceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function deregister_rds_db_instance(
    RdsDbInstanceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opsworks(
        "DeregisterRdsDbInstance",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("RdsDbInstanceArn" => RdsDbInstanceArn), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    deregister_volume(volume_id)
    deregister_volume(volume_id, params::Dict{String,<:Any})

Deregisters an Amazon EBS volume. The volume can then be registered by another stack. For
more information, see Resource Management.  Required Permissions: To use this action, an
IAM user must have a Manage permissions level for the stack, or an attached policy that
explicitly grants permissions. For more information on user permissions, see Managing User
Permissions.

# Arguments
- `volume_id`: The OpsWorks Stacks volume ID, which is the GUID that OpsWorks Stacks
  assigned to the instance when you registered the volume with the stack, not the Amazon EC2
  volume ID.

"""
function deregister_volume(VolumeId; aws_config::AbstractAWSConfig=current_aws_config())
    return opsworks(
        "DeregisterVolume",
        Dict{String,Any}("VolumeId" => VolumeId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function deregister_volume(
    VolumeId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opsworks(
        "DeregisterVolume",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("VolumeId" => VolumeId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_agent_versions()
    describe_agent_versions(params::Dict{String,<:Any})

Describes the available OpsWorks Stacks agent versions. You must specify a stack ID or a
configuration manager. DescribeAgentVersions returns a list of available agent versions for
the specified stack or configuration manager.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ConfigurationManager"`: The configuration manager.
- `"StackId"`: The stack ID.
"""
function describe_agent_versions(; aws_config::AbstractAWSConfig=current_aws_config())
    return opsworks(
        "DescribeAgentVersions"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_agent_versions(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opsworks(
        "DescribeAgentVersions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_apps()
    describe_apps(params::Dict{String,<:Any})

Requests a description of a specified set of apps.  This call accepts only one
resource-identifying parameter.   Required Permissions: To use this action, an IAM user
must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy
that explicitly grants permissions. For more information about user permissions, see
Managing User Permissions.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AppIds"`: An array of app IDs for the apps to be described. If you use this parameter,
  DescribeApps returns a description of the specified apps. Otherwise, it returns a
  description of every app.
- `"StackId"`: The app stack ID. If you use this parameter, DescribeApps returns a
  description of the apps in the specified stack.
"""
function describe_apps(; aws_config::AbstractAWSConfig=current_aws_config())
    return opsworks("DescribeApps"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function describe_apps(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opsworks(
        "DescribeApps", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_commands()
    describe_commands(params::Dict{String,<:Any})

Describes the results of specified commands.  This call accepts only one
resource-identifying parameter.   Required Permissions: To use this action, an IAM user
must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy
that explicitly grants permissions. For more information about user permissions, see
Managing User Permissions.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CommandIds"`: An array of command IDs. If you include this parameter, DescribeCommands
  returns a description of the specified commands. Otherwise, it returns a description of
  every command.
- `"DeploymentId"`: The deployment ID. If you include this parameter, DescribeCommands
  returns a description of the commands associated with the specified deployment.
- `"InstanceId"`: The instance ID. If you include this parameter, DescribeCommands returns
  a description of the commands associated with the specified instance.
"""
function describe_commands(; aws_config::AbstractAWSConfig=current_aws_config())
    return opsworks(
        "DescribeCommands"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_commands(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opsworks(
        "DescribeCommands", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_deployments()
    describe_deployments(params::Dict{String,<:Any})

Requests a description of a specified set of deployments.  This call accepts only one
resource-identifying parameter.   Required Permissions: To use this action, an IAM user
must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy
that explicitly grants permissions. For more information about user permissions, see
Managing User Permissions.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AppId"`: The app ID. If you include this parameter, the command returns a description
  of the commands associated with the specified app.
- `"DeploymentIds"`: An array of deployment IDs to be described. If you include this
  parameter, the command returns a description of the specified deployments. Otherwise, it
  returns a description of every deployment.
- `"StackId"`: The stack ID. If you include this parameter, the command returns a
  description of the commands associated with the specified stack.
"""
function describe_deployments(; aws_config::AbstractAWSConfig=current_aws_config())
    return opsworks(
        "DescribeDeployments"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_deployments(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opsworks(
        "DescribeDeployments",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_ecs_clusters()
    describe_ecs_clusters(params::Dict{String,<:Any})

Describes Amazon ECS clusters that are registered with a stack. If you specify only a stack
ID, you can use the MaxResults and NextToken parameters to paginate the response. However,
OpsWorks Stacks currently supports only one cluster per layer, so the result set has a
maximum of one element.  Required Permissions: To use this action, an IAM user must have a
Show, Deploy, or Manage permissions level for the stack or an attached policy that
explicitly grants permission. For more information about user permissions, see Managing
User Permissions. This call accepts only one resource-identifying parameter.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"EcsClusterArns"`: A list of ARNs, one for each cluster to be described.
- `"MaxResults"`: To receive a paginated response, use this parameter to specify the
  maximum number of results to be returned with a single call. If the number of available
  results exceeds this maximum, the response includes a NextToken value that you can assign
  to the NextToken request parameter to get the next set of results.
- `"NextToken"`: If the previous paginated request did not return all of the remaining
  results, the response object'sNextToken parameter value is set to a token. To retrieve the
  next set of results, call DescribeEcsClusters again and assign that token to the request
  object's NextToken parameter. If there are no remaining results, the previous response
  object's NextToken parameter is set to null.
- `"StackId"`: A stack ID. DescribeEcsClusters returns a description of the cluster that is
  registered with the stack.
"""
function describe_ecs_clusters(; aws_config::AbstractAWSConfig=current_aws_config())
    return opsworks(
        "DescribeEcsClusters"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_ecs_clusters(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opsworks(
        "DescribeEcsClusters",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_elastic_ips()
    describe_elastic_ips(params::Dict{String,<:Any})

Describes Elastic IP addresses.  This call accepts only one resource-identifying parameter.
  Required Permissions: To use this action, an IAM user must have a Show, Deploy, or Manage
permissions level for the stack, or an attached policy that explicitly grants permissions.
For more information about user permissions, see Managing User Permissions.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"InstanceId"`: The instance ID. If you include this parameter, DescribeElasticIps
  returns a description of the Elastic IP addresses associated with the specified instance.
- `"Ips"`: An array of Elastic IP addresses to be described. If you include this parameter,
  DescribeElasticIps returns a description of the specified Elastic IP addresses. Otherwise,
  it returns a description of every Elastic IP address.
- `"StackId"`: A stack ID. If you include this parameter, DescribeElasticIps returns a
  description of the Elastic IP addresses that are registered with the specified stack.
"""
function describe_elastic_ips(; aws_config::AbstractAWSConfig=current_aws_config())
    return opsworks(
        "DescribeElasticIps"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_elastic_ips(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opsworks(
        "DescribeElasticIps", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_elastic_load_balancers()
    describe_elastic_load_balancers(params::Dict{String,<:Any})

Describes a stack's Elastic Load Balancing instances.  This call accepts only one
resource-identifying parameter.   Required Permissions: To use this action, an IAM user
must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy
that explicitly grants permissions. For more information about user permissions, see
Managing User Permissions.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"LayerIds"`: A list of layer IDs. The action describes the Elastic Load Balancing
  instances for the specified layers.
- `"StackId"`: A stack ID. The action describes the stack's Elastic Load Balancing
  instances.
"""
function describe_elastic_load_balancers(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return opsworks(
        "DescribeElasticLoadBalancers";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_elastic_load_balancers(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opsworks(
        "DescribeElasticLoadBalancers",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_instances()
    describe_instances(params::Dict{String,<:Any})

Requests a description of a set of instances.  This call accepts only one
resource-identifying parameter.   Required Permissions: To use this action, an IAM user
must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy
that explicitly grants permissions. For more information about user permissions, see
Managing User Permissions.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"InstanceIds"`: An array of instance IDs to be described. If you use this parameter,
  DescribeInstances returns a description of the specified instances. Otherwise, it returns a
  description of every instance.
- `"LayerId"`: A layer ID. If you use this parameter, DescribeInstances returns
  descriptions of the instances associated with the specified layer.
- `"StackId"`: A stack ID. If you use this parameter, DescribeInstances returns
  descriptions of the instances associated with the specified stack.
"""
function describe_instances(; aws_config::AbstractAWSConfig=current_aws_config())
    return opsworks(
        "DescribeInstances"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_instances(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opsworks(
        "DescribeInstances", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_layers()
    describe_layers(params::Dict{String,<:Any})

Requests a description of one or more layers in a specified stack.  This call accepts only
one resource-identifying parameter.   Required Permissions: To use this action, an IAM user
must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy
that explicitly grants permissions. For more information about user permissions, see
Managing User Permissions.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"LayerIds"`: An array of layer IDs that specify the layers to be described. If you omit
  this parameter, DescribeLayers returns a description of every layer in the specified stack.
- `"StackId"`: The stack ID.
"""
function describe_layers(; aws_config::AbstractAWSConfig=current_aws_config())
    return opsworks(
        "DescribeLayers"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_layers(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opsworks(
        "DescribeLayers", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_load_based_auto_scaling(layer_ids)
    describe_load_based_auto_scaling(layer_ids, params::Dict{String,<:Any})

Describes load-based auto scaling configurations for specified layers.  You must specify at
least one of the parameters.   Required Permissions: To use this action, an IAM user must
have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that
explicitly grants permissions. For more information about user permissions, see Managing
User Permissions.

# Arguments
- `layer_ids`: An array of layer IDs.

"""
function describe_load_based_auto_scaling(
    LayerIds; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opsworks(
        "DescribeLoadBasedAutoScaling",
        Dict{String,Any}("LayerIds" => LayerIds);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_load_based_auto_scaling(
    LayerIds,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opsworks(
        "DescribeLoadBasedAutoScaling",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("LayerIds" => LayerIds), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_my_user_profile()
    describe_my_user_profile(params::Dict{String,<:Any})

Describes a user's SSH information.  Required Permissions: To use this action, an IAM user
must have self-management enabled or an attached policy that explicitly grants permissions.
For more information about user permissions, see Managing User Permissions.

"""
function describe_my_user_profile(; aws_config::AbstractAWSConfig=current_aws_config())
    return opsworks(
        "DescribeMyUserProfile"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_my_user_profile(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opsworks(
        "DescribeMyUserProfile",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_operating_systems()
    describe_operating_systems(params::Dict{String,<:Any})

Describes the operating systems that are supported by OpsWorks Stacks.

"""
function describe_operating_systems(; aws_config::AbstractAWSConfig=current_aws_config())
    return opsworks(
        "DescribeOperatingSystems"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_operating_systems(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opsworks(
        "DescribeOperatingSystems",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_permissions()
    describe_permissions(params::Dict{String,<:Any})

Describes the permissions for a specified stack.  Required Permissions: To use this action,
an IAM user must have a Manage permissions level for the stack, or an attached policy that
explicitly grants permissions. For more information on user permissions, see Managing User
Permissions.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"IamUserArn"`: The user's IAM ARN. This can also be a federated user's ARN. For more
  information about IAM ARNs, see Using Identifiers.
- `"StackId"`: The stack ID.
"""
function describe_permissions(; aws_config::AbstractAWSConfig=current_aws_config())
    return opsworks(
        "DescribePermissions"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_permissions(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opsworks(
        "DescribePermissions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_raid_arrays()
    describe_raid_arrays(params::Dict{String,<:Any})

Describe an instance's RAID arrays.  This call accepts only one resource-identifying
parameter.   Required Permissions: To use this action, an IAM user must have a Show,
Deploy, or Manage permissions level for the stack, or an attached policy that explicitly
grants permissions. For more information about user permissions, see Managing User
Permissions.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"InstanceId"`: The instance ID. If you use this parameter, DescribeRaidArrays returns
  descriptions of the RAID arrays associated with the specified instance.
- `"RaidArrayIds"`: An array of RAID array IDs. If you use this parameter,
  DescribeRaidArrays returns descriptions of the specified arrays. Otherwise, it returns a
  description of every array.
- `"StackId"`: The stack ID.
"""
function describe_raid_arrays(; aws_config::AbstractAWSConfig=current_aws_config())
    return opsworks(
        "DescribeRaidArrays"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_raid_arrays(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opsworks(
        "DescribeRaidArrays", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_rds_db_instances(stack_id)
    describe_rds_db_instances(stack_id, params::Dict{String,<:Any})

Describes Amazon RDS instances.  Required Permissions: To use this action, an IAM user must
have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that
explicitly grants permissions. For more information about user permissions, see Managing
User Permissions. This call accepts only one resource-identifying parameter.

# Arguments
- `stack_id`: The ID of the stack with which the instances are registered. The operation
  returns descriptions of all registered Amazon RDS instances.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"RdsDbInstanceArns"`: An array containing the ARNs of the instances to be described.
"""
function describe_rds_db_instances(
    StackId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opsworks(
        "DescribeRdsDbInstances",
        Dict{String,Any}("StackId" => StackId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_rds_db_instances(
    StackId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opsworks(
        "DescribeRdsDbInstances",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("StackId" => StackId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_service_errors()
    describe_service_errors(params::Dict{String,<:Any})

Describes OpsWorks Stacks service errors.  Required Permissions: To use this action, an IAM
user must have a Show, Deploy, or Manage permissions level for the stack, or an attached
policy that explicitly grants permissions. For more information about user permissions, see
Managing User Permissions. This call accepts only one resource-identifying parameter.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"InstanceId"`: The instance ID. If you use this parameter, DescribeServiceErrors returns
  descriptions of the errors associated with the specified instance.
- `"ServiceErrorIds"`: An array of service error IDs. If you use this parameter,
  DescribeServiceErrors returns descriptions of the specified errors. Otherwise, it returns a
  description of every error.
- `"StackId"`: The stack ID. If you use this parameter, DescribeServiceErrors returns
  descriptions of the errors associated with the specified stack.
"""
function describe_service_errors(; aws_config::AbstractAWSConfig=current_aws_config())
    return opsworks(
        "DescribeServiceErrors"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_service_errors(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opsworks(
        "DescribeServiceErrors",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_stack_provisioning_parameters(stack_id)
    describe_stack_provisioning_parameters(stack_id, params::Dict{String,<:Any})

Requests a description of a stack's provisioning parameters.  Required Permissions: To use
this action, an IAM user must have a Show, Deploy, or Manage permissions level for the
stack or an attached policy that explicitly grants permissions. For more information about
user permissions, see Managing User Permissions.

# Arguments
- `stack_id`: The stack ID.

"""
function describe_stack_provisioning_parameters(
    StackId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opsworks(
        "DescribeStackProvisioningParameters",
        Dict{String,Any}("StackId" => StackId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_stack_provisioning_parameters(
    StackId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opsworks(
        "DescribeStackProvisioningParameters",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("StackId" => StackId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_stack_summary(stack_id)
    describe_stack_summary(stack_id, params::Dict{String,<:Any})

Describes the number of layers and apps in a specified stack, and the number of instances
in each state, such as running_setup or online.  Required Permissions: To use this action,
an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an
attached policy that explicitly grants permissions. For more information about user
permissions, see Managing User Permissions.

# Arguments
- `stack_id`: The stack ID.

"""
function describe_stack_summary(StackId; aws_config::AbstractAWSConfig=current_aws_config())
    return opsworks(
        "DescribeStackSummary",
        Dict{String,Any}("StackId" => StackId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_stack_summary(
    StackId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opsworks(
        "DescribeStackSummary",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("StackId" => StackId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_stacks()
    describe_stacks(params::Dict{String,<:Any})

Requests a description of one or more stacks.  Required Permissions: To use this action, an
IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an
attached policy that explicitly grants permissions. For more information about user
permissions, see Managing User Permissions.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"StackIds"`: An array of stack IDs that specify the stacks to be described. If you omit
  this parameter, and have permissions to get information about all stacks, DescribeStacks
  returns a description of every stack. If the IAM policy that is attached to an IAM user
  limits the DescribeStacks action to specific stack ARNs, this parameter is required, and
  the user must specify a stack ARN that is allowed by the policy. Otherwise, DescribeStacks
  returns an AccessDenied error.
"""
function describe_stacks(; aws_config::AbstractAWSConfig=current_aws_config())
    return opsworks(
        "DescribeStacks"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_stacks(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opsworks(
        "DescribeStacks", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_time_based_auto_scaling(instance_ids)
    describe_time_based_auto_scaling(instance_ids, params::Dict{String,<:Any})

Describes time-based auto scaling configurations for specified instances.  You must specify
at least one of the parameters.   Required Permissions: To use this action, an IAM user
must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy
that explicitly grants permissions. For more information about user permissions, see
Managing User Permissions.

# Arguments
- `instance_ids`: An array of instance IDs.

"""
function describe_time_based_auto_scaling(
    InstanceIds; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opsworks(
        "DescribeTimeBasedAutoScaling",
        Dict{String,Any}("InstanceIds" => InstanceIds);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_time_based_auto_scaling(
    InstanceIds,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opsworks(
        "DescribeTimeBasedAutoScaling",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("InstanceIds" => InstanceIds), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_user_profiles()
    describe_user_profiles(params::Dict{String,<:Any})

Describe specified users.  Required Permissions: To use this action, an IAM user must have
an attached policy that explicitly grants permissions. For more information about user
permissions, see Managing User Permissions.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"IamUserArns"`: An array of IAM or federated user ARNs that identify the users to be
  described.
"""
function describe_user_profiles(; aws_config::AbstractAWSConfig=current_aws_config())
    return opsworks(
        "DescribeUserProfiles"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_user_profiles(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opsworks(
        "DescribeUserProfiles",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_volumes()
    describe_volumes(params::Dict{String,<:Any})

Describes an instance's Amazon EBS volumes.  This call accepts only one
resource-identifying parameter.   Required Permissions: To use this action, an IAM user
must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy
that explicitly grants permissions. For more information about user permissions, see
Managing User Permissions.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"InstanceId"`: The instance ID. If you use this parameter, DescribeVolumes returns
  descriptions of the volumes associated with the specified instance.
- `"RaidArrayId"`: The RAID array ID. If you use this parameter, DescribeVolumes returns
  descriptions of the volumes associated with the specified RAID array.
- `"StackId"`: A stack ID. The action describes the stack's registered Amazon EBS volumes.
- `"VolumeIds"`: Am array of volume IDs. If you use this parameter, DescribeVolumes returns
  descriptions of the specified volumes. Otherwise, it returns a description of every volume.
"""
function describe_volumes(; aws_config::AbstractAWSConfig=current_aws_config())
    return opsworks(
        "DescribeVolumes"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_volumes(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opsworks(
        "DescribeVolumes", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    detach_elastic_load_balancer(elastic_load_balancer_name, layer_id)
    detach_elastic_load_balancer(elastic_load_balancer_name, layer_id, params::Dict{String,<:Any})

Detaches a specified Elastic Load Balancing instance from its layer.  Required Permissions:
To use this action, an IAM user must have a Manage permissions level for the stack, or an
attached policy that explicitly grants permissions. For more information on user
permissions, see Managing User Permissions.

# Arguments
- `elastic_load_balancer_name`: The Elastic Load Balancing instance's name.
- `layer_id`: The ID of the layer that the Elastic Load Balancing instance is attached to.

"""
function detach_elastic_load_balancer(
    ElasticLoadBalancerName, LayerId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opsworks(
        "DetachElasticLoadBalancer",
        Dict{String,Any}(
            "ElasticLoadBalancerName" => ElasticLoadBalancerName, "LayerId" => LayerId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function detach_elastic_load_balancer(
    ElasticLoadBalancerName,
    LayerId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opsworks(
        "DetachElasticLoadBalancer",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ElasticLoadBalancerName" => ElasticLoadBalancerName,
                    "LayerId" => LayerId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_elastic_ip(elastic_ip)
    disassociate_elastic_ip(elastic_ip, params::Dict{String,<:Any})

Disassociates an Elastic IP address from its instance. The address remains registered with
the stack. For more information, see Resource Management.  Required Permissions: To use
this action, an IAM user must have a Manage permissions level for the stack, or an attached
policy that explicitly grants permissions. For more information on user permissions, see
Managing User Permissions.

# Arguments
- `elastic_ip`: The Elastic IP address.

"""
function disassociate_elastic_ip(
    ElasticIp; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opsworks(
        "DisassociateElasticIp",
        Dict{String,Any}("ElasticIp" => ElasticIp);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_elastic_ip(
    ElasticIp,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opsworks(
        "DisassociateElasticIp",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ElasticIp" => ElasticIp), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_hostname_suggestion(layer_id)
    get_hostname_suggestion(layer_id, params::Dict{String,<:Any})

Gets a generated host name for the specified layer, based on the current host name theme.
Required Permissions: To use this action, an IAM user must have a Manage permissions level
for the stack, or an attached policy that explicitly grants permissions. For more
information on user permissions, see Managing User Permissions.

# Arguments
- `layer_id`: The layer ID.

"""
function get_hostname_suggestion(
    LayerId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opsworks(
        "GetHostnameSuggestion",
        Dict{String,Any}("LayerId" => LayerId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_hostname_suggestion(
    LayerId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opsworks(
        "GetHostnameSuggestion",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("LayerId" => LayerId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    grant_access(instance_id)
    grant_access(instance_id, params::Dict{String,<:Any})

 This action can be used only with Windows stacks.  Grants RDP access to a Windows instance
for a specified time period.

# Arguments
- `instance_id`: The instance's OpsWorks Stacks ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ValidForInMinutes"`: The length of time (in minutes) that the grant is valid. When the
  grant expires at the end of this period, the user will no longer be able to use the
  credentials to log in. If the user is logged in at the time, they are logged out.
"""
function grant_access(InstanceId; aws_config::AbstractAWSConfig=current_aws_config())
    return opsworks(
        "GrantAccess",
        Dict{String,Any}("InstanceId" => InstanceId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function grant_access(
    InstanceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opsworks(
        "GrantAccess",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("InstanceId" => InstanceId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags(resource_arn)
    list_tags(resource_arn, params::Dict{String,<:Any})

Returns a list of tags that are applied to the specified stack or layer.

# Arguments
- `resource_arn`: The stack or layer's Amazon Resource Number (ARN).

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: Do not use. A validation exception occurs if you add a MaxResults
  parameter to a ListTagsRequest call.
- `"NextToken"`: Do not use. A validation exception occurs if you add a NextToken parameter
  to a ListTagsRequest call.
"""
function list_tags(ResourceArn; aws_config::AbstractAWSConfig=current_aws_config())
    return opsworks(
        "ListTags",
        Dict{String,Any}("ResourceArn" => ResourceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags(
    ResourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opsworks(
        "ListTags",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResourceArn" => ResourceArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    reboot_instance(instance_id)
    reboot_instance(instance_id, params::Dict{String,<:Any})

Reboots a specified instance. For more information, see Starting, Stopping, and Rebooting
Instances.  Required Permissions: To use this action, an IAM user must have a Manage
permissions level for the stack, or an attached policy that explicitly grants permissions.
For more information on user permissions, see Managing User Permissions.

# Arguments
- `instance_id`: The instance ID.

"""
function reboot_instance(InstanceId; aws_config::AbstractAWSConfig=current_aws_config())
    return opsworks(
        "RebootInstance",
        Dict{String,Any}("InstanceId" => InstanceId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function reboot_instance(
    InstanceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opsworks(
        "RebootInstance",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("InstanceId" => InstanceId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    register_ecs_cluster(ecs_cluster_arn, stack_id)
    register_ecs_cluster(ecs_cluster_arn, stack_id, params::Dict{String,<:Any})

Registers a specified Amazon ECS cluster with a stack. You can register only one cluster
with a stack. A cluster can be registered with only one stack. For more information, see
Resource Management.  Required Permissions: To use this action, an IAM user must have a
Manage permissions level for the stack or an attached policy that explicitly grants
permissions. For more information on user permissions, see  Managing User Permissions.

# Arguments
- `ecs_cluster_arn`: The cluster's ARN.
- `stack_id`: The stack ID.

"""
function register_ecs_cluster(
    EcsClusterArn, StackId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opsworks(
        "RegisterEcsCluster",
        Dict{String,Any}("EcsClusterArn" => EcsClusterArn, "StackId" => StackId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function register_ecs_cluster(
    EcsClusterArn,
    StackId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opsworks(
        "RegisterEcsCluster",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("EcsClusterArn" => EcsClusterArn, "StackId" => StackId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    register_elastic_ip(elastic_ip, stack_id)
    register_elastic_ip(elastic_ip, stack_id, params::Dict{String,<:Any})

Registers an Elastic IP address with a specified stack. An address can be registered with
only one stack at a time. If the address is already registered, you must first deregister
it by calling DeregisterElasticIp. For more information, see Resource Management.  Required
Permissions: To use this action, an IAM user must have a Manage permissions level for the
stack, or an attached policy that explicitly grants permissions. For more information on
user permissions, see Managing User Permissions.

# Arguments
- `elastic_ip`: The Elastic IP address.
- `stack_id`: The stack ID.

"""
function register_elastic_ip(
    ElasticIp, StackId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opsworks(
        "RegisterElasticIp",
        Dict{String,Any}("ElasticIp" => ElasticIp, "StackId" => StackId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function register_elastic_ip(
    ElasticIp,
    StackId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opsworks(
        "RegisterElasticIp",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ElasticIp" => ElasticIp, "StackId" => StackId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    register_instance(stack_id)
    register_instance(stack_id, params::Dict{String,<:Any})

Registers instances that were created outside of OpsWorks Stacks with a specified stack.
We do not recommend using this action to register instances. The complete registration
operation includes two tasks: installing the OpsWorks Stacks agent on the instance, and
registering the instance with the stack. RegisterInstance handles only the second step. You
should instead use the CLI register command, which performs the entire registration
operation. For more information, see  Registering an Instance with an OpsWorks Stacks
Stack.  Registered instances have the same requirements as instances that are created by
using the CreateInstance API. For example, registered instances must be running a supported
Linux-based operating system, and they must have a supported instance type. For more
information about requirements for instances that you want to register, see  Preparing the
Instance.  Required Permissions: To use this action, an IAM user must have a Manage
permissions level for the stack or an attached policy that explicitly grants permissions.
For more information on user permissions, see Managing User Permissions.

# Arguments
- `stack_id`: The ID of the stack that the instance is to be registered with.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Hostname"`: The instance's host name. The following are character limits for instance
  host names.   Linux-based instances: 63 characters   Windows-based instances: 15 characters
  
- `"InstanceIdentity"`: An InstanceIdentity object that contains the instance's identity.
- `"PrivateIp"`: The instance's private IP address.
- `"PublicIp"`: The instance's public IP address.
- `"RsaPublicKey"`: The instances public RSA key. This key is used to encrypt communication
  between the instance and the service.
- `"RsaPublicKeyFingerprint"`: The instances public RSA key fingerprint.
"""
function register_instance(StackId; aws_config::AbstractAWSConfig=current_aws_config())
    return opsworks(
        "RegisterInstance",
        Dict{String,Any}("StackId" => StackId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function register_instance(
    StackId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opsworks(
        "RegisterInstance",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("StackId" => StackId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    register_rds_db_instance(db_password, db_user, rds_db_instance_arn, stack_id)
    register_rds_db_instance(db_password, db_user, rds_db_instance_arn, stack_id, params::Dict{String,<:Any})

Registers an Amazon RDS instance with a stack.  Required Permissions: To use this action,
an IAM user must have a Manage permissions level for the stack, or an attached policy that
explicitly grants permissions. For more information on user permissions, see Managing User
Permissions.

# Arguments
- `db_password`: The database password.
- `db_user`: The database's master user name.
- `rds_db_instance_arn`: The Amazon RDS instance's ARN.
- `stack_id`: The stack ID.

"""
function register_rds_db_instance(
    DbPassword,
    DbUser,
    RdsDbInstanceArn,
    StackId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opsworks(
        "RegisterRdsDbInstance",
        Dict{String,Any}(
            "DbPassword" => DbPassword,
            "DbUser" => DbUser,
            "RdsDbInstanceArn" => RdsDbInstanceArn,
            "StackId" => StackId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function register_rds_db_instance(
    DbPassword,
    DbUser,
    RdsDbInstanceArn,
    StackId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opsworks(
        "RegisterRdsDbInstance",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DbPassword" => DbPassword,
                    "DbUser" => DbUser,
                    "RdsDbInstanceArn" => RdsDbInstanceArn,
                    "StackId" => StackId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    register_volume(stack_id)
    register_volume(stack_id, params::Dict{String,<:Any})

Registers an Amazon EBS volume with a specified stack. A volume can be registered with only
one stack at a time. If the volume is already registered, you must first deregister it by
calling DeregisterVolume. For more information, see Resource Management.  Required
Permissions: To use this action, an IAM user must have a Manage permissions level for the
stack, or an attached policy that explicitly grants permissions. For more information on
user permissions, see Managing User Permissions.

# Arguments
- `stack_id`: The stack ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Ec2VolumeId"`: The Amazon EBS volume ID.
"""
function register_volume(StackId; aws_config::AbstractAWSConfig=current_aws_config())
    return opsworks(
        "RegisterVolume",
        Dict{String,Any}("StackId" => StackId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function register_volume(
    StackId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opsworks(
        "RegisterVolume",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("StackId" => StackId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    set_load_based_auto_scaling(layer_id)
    set_load_based_auto_scaling(layer_id, params::Dict{String,<:Any})

Specify the load-based auto scaling configuration for a specified layer. For more
information, see Managing Load with Time-based and Load-based Instances.  To use load-based
auto scaling, you must create a set of load-based auto scaling instances. Load-based auto
scaling operates only on the instances from that set, so you must ensure that you have
created enough instances to handle the maximum anticipated load.   Required Permissions: To
use this action, an IAM user must have a Manage permissions level for the stack, or an
attached policy that explicitly grants permissions. For more information on user
permissions, see Managing User Permissions.

# Arguments
- `layer_id`: The layer ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DownScaling"`: An AutoScalingThresholds object with the downscaling threshold
  configuration. If the load falls below these thresholds for a specified amount of time,
  OpsWorks Stacks stops a specified number of instances.
- `"Enable"`: Enables load-based auto scaling for the layer.
- `"UpScaling"`: An AutoScalingThresholds object with the upscaling threshold
  configuration. If the load exceeds these thresholds for a specified amount of time,
  OpsWorks Stacks starts a specified number of instances.
"""
function set_load_based_auto_scaling(
    LayerId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opsworks(
        "SetLoadBasedAutoScaling",
        Dict{String,Any}("LayerId" => LayerId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function set_load_based_auto_scaling(
    LayerId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opsworks(
        "SetLoadBasedAutoScaling",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("LayerId" => LayerId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    set_permission(iam_user_arn, stack_id)
    set_permission(iam_user_arn, stack_id, params::Dict{String,<:Any})

Specifies a user's permissions. For more information, see Security and Permissions.
Required Permissions: To use this action, an IAM user must have a Manage permissions level
for the stack, or an attached policy that explicitly grants permissions. For more
information on user permissions, see Managing User Permissions.

# Arguments
- `iam_user_arn`: The user's IAM ARN. This can also be a federated user's ARN.
- `stack_id`: The stack ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AllowSsh"`: The user is allowed to use SSH to communicate with the instance.
- `"AllowSudo"`: The user is allowed to use sudo to elevate privileges.
- `"Level"`: The user's permission level, which must be set to one of the following
  strings. You cannot set your own permissions level.    deny     show     deploy     manage
     iam_only    For more information about the permissions associated with these levels, see
  Managing User Permissions.
"""
function set_permission(
    IamUserArn, StackId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opsworks(
        "SetPermission",
        Dict{String,Any}("IamUserArn" => IamUserArn, "StackId" => StackId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function set_permission(
    IamUserArn,
    StackId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opsworks(
        "SetPermission",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("IamUserArn" => IamUserArn, "StackId" => StackId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    set_time_based_auto_scaling(instance_id)
    set_time_based_auto_scaling(instance_id, params::Dict{String,<:Any})

Specify the time-based auto scaling configuration for a specified instance. For more
information, see Managing Load with Time-based and Load-based Instances.  Required
Permissions: To use this action, an IAM user must have a Manage permissions level for the
stack, or an attached policy that explicitly grants permissions. For more information on
user permissions, see Managing User Permissions.

# Arguments
- `instance_id`: The instance ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AutoScalingSchedule"`: An AutoScalingSchedule with the instance schedule.
"""
function set_time_based_auto_scaling(
    InstanceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opsworks(
        "SetTimeBasedAutoScaling",
        Dict{String,Any}("InstanceId" => InstanceId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function set_time_based_auto_scaling(
    InstanceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opsworks(
        "SetTimeBasedAutoScaling",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("InstanceId" => InstanceId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_instance(instance_id)
    start_instance(instance_id, params::Dict{String,<:Any})

Starts a specified instance. For more information, see Starting, Stopping, and Rebooting
Instances.  Required Permissions: To use this action, an IAM user must have a Manage
permissions level for the stack, or an attached policy that explicitly grants permissions.
For more information on user permissions, see Managing User Permissions.

# Arguments
- `instance_id`: The instance ID.

"""
function start_instance(InstanceId; aws_config::AbstractAWSConfig=current_aws_config())
    return opsworks(
        "StartInstance",
        Dict{String,Any}("InstanceId" => InstanceId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_instance(
    InstanceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opsworks(
        "StartInstance",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("InstanceId" => InstanceId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_stack(stack_id)
    start_stack(stack_id, params::Dict{String,<:Any})

Starts a stack's instances.  Required Permissions: To use this action, an IAM user must
have a Manage permissions level for the stack, or an attached policy that explicitly grants
permissions. For more information on user permissions, see Managing User Permissions.

# Arguments
- `stack_id`: The stack ID.

"""
function start_stack(StackId; aws_config::AbstractAWSConfig=current_aws_config())
    return opsworks(
        "StartStack",
        Dict{String,Any}("StackId" => StackId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_stack(
    StackId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opsworks(
        "StartStack",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("StackId" => StackId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    stop_instance(instance_id)
    stop_instance(instance_id, params::Dict{String,<:Any})

Stops a specified instance. When you stop a standard instance, the data disappears and must
be reinstalled when you restart the instance. You can stop an Amazon EBS-backed instance
without losing data. For more information, see Starting, Stopping, and Rebooting Instances.
 Required Permissions: To use this action, an IAM user must have a Manage permissions level
for the stack, or an attached policy that explicitly grants permissions. For more
information on user permissions, see Managing User Permissions.

# Arguments
- `instance_id`: The instance ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Force"`: Specifies whether to force an instance to stop. If the instance's root device
  type is ebs, or EBS-backed, adding the Force parameter to the StopInstances API call
  disassociates the OpsWorks Stacks instance from EC2, and forces deletion of only the
  OpsWorks Stacks instance. You must also delete the formerly-associated instance in EC2
  after troubleshooting and replacing the OpsWorks Stacks instance with a new one.
"""
function stop_instance(InstanceId; aws_config::AbstractAWSConfig=current_aws_config())
    return opsworks(
        "StopInstance",
        Dict{String,Any}("InstanceId" => InstanceId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function stop_instance(
    InstanceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opsworks(
        "StopInstance",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("InstanceId" => InstanceId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    stop_stack(stack_id)
    stop_stack(stack_id, params::Dict{String,<:Any})

Stops a specified stack.  Required Permissions: To use this action, an IAM user must have a
Manage permissions level for the stack, or an attached policy that explicitly grants
permissions. For more information on user permissions, see Managing User Permissions.

# Arguments
- `stack_id`: The stack ID.

"""
function stop_stack(StackId; aws_config::AbstractAWSConfig=current_aws_config())
    return opsworks(
        "StopStack",
        Dict{String,Any}("StackId" => StackId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function stop_stack(
    StackId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opsworks(
        "StopStack",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("StackId" => StackId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Apply cost-allocation tags to a specified stack or layer in OpsWorks Stacks. For more
information about how tagging works, see Tags in the OpsWorks User Guide.

# Arguments
- `resource_arn`: The stack or layer's Amazon Resource Number (ARN).
- `tags`: A map that contains tag keys and tag values that are attached to a stack or
  layer.   The key cannot be empty.   The key can be a maximum of 127 characters, and can
  contain only Unicode letters, numbers, or separators, or the following special characters:
  + - = . _ : /    The value can be a maximum 255 characters, and contain only Unicode
  letters, numbers, or separators, or the following special characters: + - = . _ : /
  Leading and trailing white spaces are trimmed from both the key and value.   A maximum of
  40 tags is allowed for any resource.

"""
function tag_resource(ResourceArn, Tags; aws_config::AbstractAWSConfig=current_aws_config())
    return opsworks(
        "TagResource",
        Dict{String,Any}("ResourceArn" => ResourceArn, "Tags" => Tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    ResourceArn,
    Tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opsworks(
        "TagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceArn" => ResourceArn, "Tags" => Tags),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    unassign_instance(instance_id)
    unassign_instance(instance_id, params::Dict{String,<:Any})

Unassigns a registered instance from all layers that are using the instance. The instance
remains in the stack as an unassigned instance, and can be assigned to another layer as
needed. You cannot use this action with instances that were created with OpsWorks Stacks.
Required Permissions: To use this action, an IAM user must have a Manage permissions level
for the stack or an attached policy that explicitly grants permissions. For more
information about user permissions, see Managing User Permissions.

# Arguments
- `instance_id`: The instance ID.

"""
function unassign_instance(InstanceId; aws_config::AbstractAWSConfig=current_aws_config())
    return opsworks(
        "UnassignInstance",
        Dict{String,Any}("InstanceId" => InstanceId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function unassign_instance(
    InstanceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opsworks(
        "UnassignInstance",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("InstanceId" => InstanceId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    unassign_volume(volume_id)
    unassign_volume(volume_id, params::Dict{String,<:Any})

Unassigns an assigned Amazon EBS volume. The volume remains registered with the stack. For
more information, see Resource Management.  Required Permissions: To use this action, an
IAM user must have a Manage permissions level for the stack, or an attached policy that
explicitly grants permissions. For more information on user permissions, see Managing User
Permissions.

# Arguments
- `volume_id`: The volume ID.

"""
function unassign_volume(VolumeId; aws_config::AbstractAWSConfig=current_aws_config())
    return opsworks(
        "UnassignVolume",
        Dict{String,Any}("VolumeId" => VolumeId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function unassign_volume(
    VolumeId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opsworks(
        "UnassignVolume",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("VolumeId" => VolumeId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Removes tags from a specified stack or layer.

# Arguments
- `resource_arn`: The stack or layer's Amazon Resource Number (ARN).
- `tag_keys`: A list of the keys of tags to be removed from a stack or layer.

"""
function untag_resource(
    ResourceArn, TagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opsworks(
        "UntagResource",
        Dict{String,Any}("ResourceArn" => ResourceArn, "TagKeys" => TagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    ResourceArn,
    TagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opsworks(
        "UntagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceArn" => ResourceArn, "TagKeys" => TagKeys),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_app(app_id)
    update_app(app_id, params::Dict{String,<:Any})

Updates a specified app.  Required Permissions: To use this action, an IAM user must have a
Deploy or Manage permissions level for the stack, or an attached policy that explicitly
grants permissions. For more information on user permissions, see Managing User Permissions.

# Arguments
- `app_id`: The app ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AppSource"`: A Source object that specifies the app repository.
- `"Attributes"`: One or more user-defined key/value pairs to be added to the stack
  attributes.
- `"DataSources"`: The app's data sources.
- `"Description"`: A description of the app.
- `"Domains"`: The app's virtual host settings, with multiple domains separated by commas.
  For example: 'www.example.com, example.com'
- `"EnableSsl"`: Whether SSL is enabled for the app.
- `"Environment"`: An array of EnvironmentVariable objects that specify environment
  variables to be associated with the app. After you deploy the app, these variables are
  defined on the associated app server instances.For more information, see  Environment
  Variables. There is no specific limit on the number of environment variables. However, the
  size of the associated data structure - which includes the variables' names, values, and
  protected flag values - cannot exceed 20 KB. This limit should accommodate most if not all
  use cases. Exceeding it will cause an exception with the message, \"Environment: is too
  large (maximum is 20 KB).\"  If you have specified one or more environment variables, you
  cannot modify the stack's Chef version.
- `"Name"`: The app name.
- `"SslConfiguration"`: An SslConfiguration object with the SSL configuration.
- `"Type"`: The app type.
"""
function update_app(AppId; aws_config::AbstractAWSConfig=current_aws_config())
    return opsworks(
        "UpdateApp",
        Dict{String,Any}("AppId" => AppId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_app(
    AppId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opsworks(
        "UpdateApp",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("AppId" => AppId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_elastic_ip(elastic_ip)
    update_elastic_ip(elastic_ip, params::Dict{String,<:Any})

Updates a registered Elastic IP address's name. For more information, see Resource
Management.  Required Permissions: To use this action, an IAM user must have a Manage
permissions level for the stack, or an attached policy that explicitly grants permissions.
For more information on user permissions, see Managing User Permissions.

# Arguments
- `elastic_ip`: The IP address for which you want to update the name.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Name"`: The new name, which can be a maximum of 32 characters.
"""
function update_elastic_ip(ElasticIp; aws_config::AbstractAWSConfig=current_aws_config())
    return opsworks(
        "UpdateElasticIp",
        Dict{String,Any}("ElasticIp" => ElasticIp);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_elastic_ip(
    ElasticIp,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opsworks(
        "UpdateElasticIp",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ElasticIp" => ElasticIp), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_instance(instance_id)
    update_instance(instance_id, params::Dict{String,<:Any})

Updates a specified instance.  Required Permissions: To use this action, an IAM user must
have a Manage permissions level for the stack, or an attached policy that explicitly grants
permissions. For more information on user permissions, see Managing User Permissions.

# Arguments
- `instance_id`: The instance ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AgentVersion"`: The default OpsWorks Stacks agent version. You have the following
  options:    INHERIT - Use the stack's default agent version setting.    version_number -
  Use the specified agent version. This value overrides the stack's default setting. To
  update the agent version, you must edit the instance configuration and specify a new
  version. OpsWorks Stacks installs that version on the instance.   The default setting is
  INHERIT. To specify an agent version, you must use the complete version number, not the
  abbreviated number shown on the console. For a list of available agent version numbers,
  call DescribeAgentVersions. AgentVersion cannot be set to Chef 12.2.
- `"AmiId"`: The ID of the AMI that was used to create the instance. The value of this
  parameter must be the same AMI ID that the instance is already using. You cannot apply a
  new AMI to an instance by running UpdateInstance. UpdateInstance does not work on instances
  that are using custom AMIs.
- `"Architecture"`: The instance architecture. Instance types do not necessarily support
  both architectures. For a list of the architectures that are supported by the different
  instance types, see Instance Families and Types.
- `"AutoScalingType"`: For load-based or time-based instances, the type. Windows stacks can
  use only time-based instances.
- `"EbsOptimized"`: This property cannot be updated.
- `"Hostname"`: The instance host name. The following are character limits for instance
  host names.   Linux-based instances: 63 characters   Windows-based instances: 15 characters
  
- `"InstallUpdatesOnBoot"`: Whether to install operating system and package updates when
  the instance boots. The default value is true. To control when updates are installed, set
  this value to false. You must then update your instances manually by using CreateDeployment
  to run the update_dependencies stack command or by manually running yum (Amazon Linux) or
  apt-get (Ubuntu) on the instances.   We strongly recommend using the default value of true,
  to ensure that your instances have the latest security updates.
- `"InstanceType"`: The instance type, such as t2.micro. For a list of supported instance
  types, open the stack in the console, choose Instances, and choose + Instance. The Size
  list contains the currently supported types. For more information, see Instance Families
  and Types. The parameter values that you use to specify the various types are in the API
  Name column of the Available Instance Types table.
- `"LayerIds"`: The instance's layer IDs.
- `"Os"`: The instance's operating system, which must be set to one of the following. You
  cannot update an instance that is using a custom AMI.   A supported Linux operating system:
  An Amazon Linux version, such as Amazon Linux 2, Amazon Linux 2018.03, Amazon Linux
  2017.09, Amazon Linux 2017.03, Amazon Linux 2016.09, Amazon Linux 2016.03, Amazon Linux
  2015.09, or Amazon Linux 2015.03.   A supported Ubuntu operating system, such as Ubuntu
  18.04 LTS, Ubuntu 16.04 LTS, Ubuntu 14.04 LTS, or Ubuntu 12.04 LTS.    CentOS Linux 7
  Red Hat Enterprise Linux 7    A supported Windows operating system, such as Microsoft
  Windows Server 2012 R2 Base, Microsoft Windows Server 2012 R2 with SQL Server Express,
  Microsoft Windows Server 2012 R2 with SQL Server Standard, or Microsoft Windows Server 2012
  R2 with SQL Server Web.   Not all operating systems are supported with all versions of
  Chef. For more information about supported operating systems, see OpsWorks Stacks Operating
  Systems. The default option is the current Amazon Linux version. If you set this parameter
  to Custom, you must use the AmiId parameter to specify the custom AMI that you want to use.
  For more information about how to use custom AMIs with OpsWorks, see Using Custom AMIs.
  You can specify a different Linux operating system for the updated stack, but you cannot
  change from Linux to Windows or Windows to Linux.
- `"SshKeyName"`: The instance's Amazon EC2 key name.
"""
function update_instance(InstanceId; aws_config::AbstractAWSConfig=current_aws_config())
    return opsworks(
        "UpdateInstance",
        Dict{String,Any}("InstanceId" => InstanceId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_instance(
    InstanceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opsworks(
        "UpdateInstance",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("InstanceId" => InstanceId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_layer(layer_id)
    update_layer(layer_id, params::Dict{String,<:Any})

Updates a specified layer.  Required Permissions: To use this action, an IAM user must have
a Manage permissions level for the stack, or an attached policy that explicitly grants
permissions. For more information on user permissions, see Managing User Permissions.

# Arguments
- `layer_id`: The layer ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Attributes"`: One or more user-defined key/value pairs to be added to the stack
  attributes.
- `"AutoAssignElasticIps"`: Whether to automatically assign an Elastic IP address to the
  layer's instances. For more information, see How to Edit a Layer.
- `"AutoAssignPublicIps"`: For stacks that are running in a VPC, whether to automatically
  assign a public IP address to the layer's instances. For more information, see How to Edit
  a Layer.
- `"CloudWatchLogsConfiguration"`: Specifies CloudWatch Logs configuration options for the
  layer. For more information, see CloudWatchLogsLogStream.
- `"CustomInstanceProfileArn"`: The ARN of an IAM profile to be used for all of the layer's
  EC2 instances. For more information about IAM ARNs, see Using Identifiers.
- `"CustomJson"`: A JSON-formatted string containing custom stack configuration and
  deployment attributes to be installed on the layer's instances. For more information, see
  Using Custom JSON.
- `"CustomRecipes"`: A LayerCustomRecipes object that specifies the layer's custom recipes.
- `"CustomSecurityGroupIds"`: An array containing the layer's custom security group IDs.
- `"EnableAutoHealing"`: Whether to disable auto healing for the layer.
- `"InstallUpdatesOnBoot"`: Whether to install operating system and package updates when
  the instance boots. The default value is true. To control when updates are installed, set
  this value to false. You must then update your instances manually by using CreateDeployment
  to run the update_dependencies stack command or manually running yum (Amazon Linux) or
  apt-get (Ubuntu) on the instances.   We strongly recommend using the default value of true,
  to ensure that your instances have the latest security updates.
- `"LifecycleEventConfiguration"`:
- `"Name"`: The layer name, which is used by the console. Layer names can be a maximum of
  32 characters.
- `"Packages"`: An array of Package objects that describe the layer's packages.
- `"Shortname"`: For custom layers only, use this parameter to specify the layer's short
  name, which is used internally by OpsWorks Stacks and by Chef. The short name is also used
  as the name for the directory where your app files are installed. It can have a maximum of
  32 characters and must be in the following format: /A[a-z0-9-_.]+Z/. Built-in layer short
  names are defined by OpsWorks Stacks. For more information, see the Layer reference in the
  OpsWorks User Guide.
- `"UseEbsOptimizedInstances"`: Whether to use Amazon EBS-optimized instances.
- `"VolumeConfigurations"`: A VolumeConfigurations object that describes the layer's Amazon
  EBS volumes.
"""
function update_layer(LayerId; aws_config::AbstractAWSConfig=current_aws_config())
    return opsworks(
        "UpdateLayer",
        Dict{String,Any}("LayerId" => LayerId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_layer(
    LayerId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opsworks(
        "UpdateLayer",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("LayerId" => LayerId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_my_user_profile()
    update_my_user_profile(params::Dict{String,<:Any})

Updates a user's SSH public key.  Required Permissions: To use this action, an IAM user
must have self-management enabled or an attached policy that explicitly grants permissions.
For more information about user permissions, see Managing User Permissions.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"SshPublicKey"`: The user's SSH public key.
"""
function update_my_user_profile(; aws_config::AbstractAWSConfig=current_aws_config())
    return opsworks(
        "UpdateMyUserProfile"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function update_my_user_profile(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opsworks(
        "UpdateMyUserProfile",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_rds_db_instance(rds_db_instance_arn)
    update_rds_db_instance(rds_db_instance_arn, params::Dict{String,<:Any})

Updates an Amazon RDS instance.  Required Permissions: To use this action, an IAM user must
have a Manage permissions level for the stack, or an attached policy that explicitly grants
permissions. For more information on user permissions, see Managing User Permissions.

# Arguments
- `rds_db_instance_arn`: The Amazon RDS instance's ARN.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DbPassword"`: The database password.
- `"DbUser"`: The master user name.
"""
function update_rds_db_instance(
    RdsDbInstanceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opsworks(
        "UpdateRdsDbInstance",
        Dict{String,Any}("RdsDbInstanceArn" => RdsDbInstanceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_rds_db_instance(
    RdsDbInstanceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opsworks(
        "UpdateRdsDbInstance",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("RdsDbInstanceArn" => RdsDbInstanceArn), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_stack(stack_id)
    update_stack(stack_id, params::Dict{String,<:Any})

Updates a specified stack.  Required Permissions: To use this action, an IAM user must have
a Manage permissions level for the stack, or an attached policy that explicitly grants
permissions. For more information on user permissions, see Managing User Permissions.

# Arguments
- `stack_id`: The stack ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AgentVersion"`: The default OpsWorks Stacks agent version. You have the following
  options:   Auto-update - Set this parameter to LATEST. OpsWorks Stacks automatically
  installs new agent versions on the stack's instances as soon as they are available.   Fixed
  version - Set this parameter to your preferred agent version. To update the agent version,
  you must edit the stack configuration and specify a new version. OpsWorks Stacks installs
  that version on the stack's instances.   The default setting is LATEST. To specify an agent
  version, you must use the complete version number, not the abbreviated number shown on the
  console. For a list of available agent version numbers, call DescribeAgentVersions.
  AgentVersion cannot be set to Chef 12.2.  You can also specify an agent version when you
  create or update an instance, which overrides the stack's default setting.
- `"Attributes"`: One or more user-defined key-value pairs to be added to the stack
  attributes.
- `"ChefConfiguration"`: A ChefConfiguration object that specifies whether to enable
  Berkshelf and the Berkshelf version on Chef 11.10 stacks. For more information, see Create
  a New Stack.
- `"ConfigurationManager"`: The configuration manager. When you update a stack, we
  recommend that you use the configuration manager to specify the Chef version: 12, 11.10, or
  11.4 for Linux stacks, or 12.2 for Windows stacks. The default value for Linux stacks is
  currently 12.
- `"CustomCookbooksSource"`: Contains the information required to retrieve an app or
  cookbook from a repository. For more information, see Adding Apps or Cookbooks and Recipes.
- `"CustomJson"`: A string that contains user-defined, custom JSON. It can be used to
  override the corresponding default stack configuration JSON values or to pass data to
  recipes. The string should be in the following format:  \"{\"key1\": \"value1\", \"key2\":
  \"value2\",...}\"  For more information about custom JSON, see Use Custom JSON to Modify
  the Stack Configuration Attributes.
- `"DefaultAvailabilityZone"`: The stack's default Availability Zone, which must be in the
  stack's region. For more information, see Regions and Endpoints. If you also specify a
  value for DefaultSubnetId, the subnet must be in the same zone. For more information, see
  CreateStack.
- `"DefaultInstanceProfileArn"`: The ARN of an IAM profile that is the default profile for
  all of the stack's EC2 instances. For more information about IAM ARNs, see Using
  Identifiers.
- `"DefaultOs"`: The stack's operating system, which must be set to one of the following:
  A supported Linux operating system: An Amazon Linux version, such as Amazon Linux 2, Amazon
  Linux 2018.03, Amazon Linux 2017.09, Amazon Linux 2017.03, Amazon Linux 2016.09, Amazon
  Linux 2016.03, Amazon Linux 2015.09, or Amazon Linux 2015.03.   A supported Ubuntu
  operating system, such as Ubuntu 18.04 LTS, Ubuntu 16.04 LTS, Ubuntu 14.04 LTS, or Ubuntu
  12.04 LTS.    CentOS Linux 7     Red Hat Enterprise Linux 7    A supported Windows
  operating system, such as Microsoft Windows Server 2012 R2 Base, Microsoft Windows Server
  2012 R2 with SQL Server Express, Microsoft Windows Server 2012 R2 with SQL Server Standard,
  or Microsoft Windows Server 2012 R2 with SQL Server Web.   A custom AMI: Custom. You
  specify the custom AMI you want to use when you create instances. For more information
  about how to use custom AMIs with OpsWorks, see Using Custom AMIs.   The default option is
  the stack's current operating system. Not all operating systems are supported with all
  versions of Chef. For more information about supported operating systems, see OpsWorks
  Stacks Operating Systems.
- `"DefaultRootDeviceType"`: The default root device type. This value is used by default
  for all instances in the stack, but you can override it when you create an instance. For
  more information, see Storage for the Root Device.
- `"DefaultSshKeyName"`: A default Amazon EC2 key-pair name. The default value is none. If
  you specify a key-pair name, OpsWorks Stacks installs the public key on the instance and
  you can use the private key with an SSH client to log in to the instance. For more
  information, see  Using SSH to Communicate with an Instance and  Managing SSH Access. You
  can override this setting by specifying a different key pair, or no key pair, when you
  create an instance.
- `"DefaultSubnetId"`: The stack's default VPC subnet ID. This parameter is required if you
  specify a value for the VpcId parameter. All instances are launched into this subnet unless
  you specify otherwise when you create the instance. If you also specify a value for
  DefaultAvailabilityZone, the subnet must be in that zone. For information on default values
  and when this parameter is required, see the VpcId parameter description.
- `"HostnameTheme"`: The stack's new host name theme, with spaces replaced by underscores.
  The theme is used to generate host names for the stack's instances. By default,
  HostnameTheme is set to Layer_Dependent, which creates host names by appending integers to
  the layer's short name. The other themes are:    Baked_Goods     Clouds     Europe_Cities
    Fruits     Greek_Deities_and_Titans     Legendary_creatures_from_Japan
  Planets_and_Moons     Roman_Deities     Scottish_Islands     US_Cities     Wild_Cats    To
  obtain a generated host name, call GetHostNameSuggestion, which returns a host name based
  on the current theme.
- `"Name"`: The stack's new name. Stack names can be a maximum of 64 characters.
- `"ServiceRoleArn"`: Do not use this parameter. You cannot update a stack's service role.
- `"UseCustomCookbooks"`: Whether the stack uses custom cookbooks.
- `"UseOpsworksSecurityGroups"`: Whether to associate the OpsWorks Stacks built-in security
  groups with the stack's layers. OpsWorks Stacks provides a standard set of built-in
  security groups, one for each layer, which are associated with layers by default.
  UseOpsworksSecurityGroups allows you to provide your own custom security groups instead of
  using the built-in groups. UseOpsworksSecurityGroups has the following settings:    True -
  OpsWorks Stacks automatically associates the appropriate built-in security group with each
  layer (default setting). You can associate additional security groups with a layer after
  you create it, but you cannot delete the built-in security group.   False - OpsWorks Stacks
  does not associate built-in security groups with layers. You must create appropriate EC2
  security groups and associate a security group with each layer that you create. However,
  you can still manually associate a built-in security group with a layer on. Custom security
  groups are required only for those layers that need custom settings.   For more
  information, see Create a New Stack.
"""
function update_stack(StackId; aws_config::AbstractAWSConfig=current_aws_config())
    return opsworks(
        "UpdateStack",
        Dict{String,Any}("StackId" => StackId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_stack(
    StackId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opsworks(
        "UpdateStack",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("StackId" => StackId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_user_profile(iam_user_arn)
    update_user_profile(iam_user_arn, params::Dict{String,<:Any})

Updates a specified user profile.  Required Permissions: To use this action, an IAM user
must have an attached policy that explicitly grants permissions. For more information about
user permissions, see Managing User Permissions.

# Arguments
- `iam_user_arn`: The user IAM ARN. This can also be a federated user's ARN.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AllowSelfManagement"`: Whether users can specify their own SSH public key through the
  My Settings page. For more information, see Managing User Permissions.
- `"SshPublicKey"`: The user's new SSH public key.
- `"SshUsername"`: The user's SSH user name. The allowable characters are [a-z], [A-Z],
  [0-9], '-', and '_'. If the specified name includes other punctuation marks, OpsWorks
  Stacks removes them. For example, my.name will be changed to myname. If you do not specify
  an SSH user name, OpsWorks Stacks generates one from the IAM user name.
"""
function update_user_profile(IamUserArn; aws_config::AbstractAWSConfig=current_aws_config())
    return opsworks(
        "UpdateUserProfile",
        Dict{String,Any}("IamUserArn" => IamUserArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_user_profile(
    IamUserArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opsworks(
        "UpdateUserProfile",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("IamUserArn" => IamUserArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_volume(volume_id)
    update_volume(volume_id, params::Dict{String,<:Any})

Updates an Amazon EBS volume's name or mount point. For more information, see Resource
Management.  Required Permissions: To use this action, an IAM user must have a Manage
permissions level for the stack, or an attached policy that explicitly grants permissions.
For more information on user permissions, see Managing User Permissions.

# Arguments
- `volume_id`: The volume ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MountPoint"`: The new mount point.
- `"Name"`: The new name. Volume names can be a maximum of 128 characters.
"""
function update_volume(VolumeId; aws_config::AbstractAWSConfig=current_aws_config())
    return opsworks(
        "UpdateVolume",
        Dict{String,Any}("VolumeId" => VolumeId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_volume(
    VolumeId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opsworks(
        "UpdateVolume",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("VolumeId" => VolumeId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
