# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: emr
using AWS.Compat
using AWS.UUIDs

"""
    add_instance_fleet(cluster_id, instance_fleet)
    add_instance_fleet(cluster_id, instance_fleet, params::Dict{String,<:Any})

Adds an instance fleet to a running cluster.  The instance fleet configuration is available
only in Amazon EMR releases 4.8.0 and later, excluding 5.0.x.

# Arguments
- `cluster_id`: The unique identifier of the cluster.
- `instance_fleet`: Specifies the configuration of the instance fleet.

"""
function add_instance_fleet(
    ClusterId, InstanceFleet; aws_config::AbstractAWSConfig=current_aws_config()
)
    return emr(
        "AddInstanceFleet",
        Dict{String,Any}("ClusterId" => ClusterId, "InstanceFleet" => InstanceFleet);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function add_instance_fleet(
    ClusterId,
    InstanceFleet,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return emr(
        "AddInstanceFleet",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ClusterId" => ClusterId, "InstanceFleet" => InstanceFleet
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    add_instance_groups(instance_groups, job_flow_id)
    add_instance_groups(instance_groups, job_flow_id, params::Dict{String,<:Any})

Adds one or more instance groups to a running cluster.

# Arguments
- `instance_groups`: Instance groups to add.
- `job_flow_id`: Job flow in which to add the instance groups.

"""
function add_instance_groups(
    InstanceGroups, JobFlowId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return emr(
        "AddInstanceGroups",
        Dict{String,Any}("InstanceGroups" => InstanceGroups, "JobFlowId" => JobFlowId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function add_instance_groups(
    InstanceGroups,
    JobFlowId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return emr(
        "AddInstanceGroups",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "InstanceGroups" => InstanceGroups, "JobFlowId" => JobFlowId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    add_job_flow_steps(job_flow_id, steps)
    add_job_flow_steps(job_flow_id, steps, params::Dict{String,<:Any})

AddJobFlowSteps adds new steps to a running cluster. A maximum of 256 steps are allowed in
each job flow. If your cluster is long-running (such as a Hive data warehouse) or complex,
you may require more than 256 steps to process your data. You can bypass the 256-step
limitation in various ways, including using SSH to connect to the master node and
submitting queries directly to the software running on the master node, such as Hive and
Hadoop. A step specifies the location of a JAR file stored either on the master node of the
cluster or in Amazon S3. Each step is performed by the main function of the main class of
the JAR file. The main class can be specified either in the manifest of the JAR or by using
the MainFunction parameter of the step. Amazon EMR executes each step in the order listed.
For a step to be considered complete, the main function must exit with a zero exit code and
all Hadoop jobs started while the step was running must have completed and run
successfully. You can only add steps to a cluster that is in one of the following states:
STARTING, BOOTSTRAPPING, RUNNING, or WAITING.  The string values passed into HadoopJarStep
object cannot exceed a total of 10240 characters.

# Arguments
- `job_flow_id`: A string that uniquely identifies the job flow. This identifier is
  returned by RunJobFlow and can also be obtained from ListClusters.
- `steps`:  A list of StepConfig to be executed by the job flow.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ExecutionRoleArn"`: The Amazon Resource Name (ARN) of the runtime role for a step on
  the cluster. The runtime role can be a cross-account IAM role. The runtime role ARN is a
  combination of account ID, role name, and role type using the following format:
  arn:partition:service:region:account:resource.  For example,
  arn:aws:IAM::1234567890:role/ReadOnly is a correctly formatted runtime role ARN.
"""
function add_job_flow_steps(
    JobFlowId, Steps; aws_config::AbstractAWSConfig=current_aws_config()
)
    return emr(
        "AddJobFlowSteps",
        Dict{String,Any}("JobFlowId" => JobFlowId, "Steps" => Steps);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function add_job_flow_steps(
    JobFlowId,
    Steps,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return emr(
        "AddJobFlowSteps",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("JobFlowId" => JobFlowId, "Steps" => Steps), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    add_tags(resource_id, tags)
    add_tags(resource_id, tags, params::Dict{String,<:Any})

Adds tags to an Amazon EMR resource, such as a cluster or an Amazon EMR Studio. Tags make
it easier to associate resources in various ways, such as grouping clusters to track your
Amazon EMR resource allocation costs. For more information, see Tag Clusters.

# Arguments
- `resource_id`: The Amazon EMR resource identifier to which tags will be added. For
  example, a cluster identifier or an Amazon EMR Studio ID.
- `tags`: A list of tags to associate with a resource. Tags are user-defined key-value
  pairs that consist of a required key string with a maximum of 128 characters, and an
  optional value string with a maximum of 256 characters.

"""
function add_tags(ResourceId, Tags; aws_config::AbstractAWSConfig=current_aws_config())
    return emr(
        "AddTags",
        Dict{String,Any}("ResourceId" => ResourceId, "Tags" => Tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function add_tags(
    ResourceId,
    Tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return emr(
        "AddTags",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ResourceId" => ResourceId, "Tags" => Tags), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    cancel_steps(cluster_id, step_ids)
    cancel_steps(cluster_id, step_ids, params::Dict{String,<:Any})

Cancels a pending step or steps in a running cluster. Available only in Amazon EMR versions
4.8.0 and later, excluding version 5.0.0. A maximum of 256 steps are allowed in each
CancelSteps request. CancelSteps is idempotent but asynchronous; it does not guarantee that
a step will be canceled, even if the request is successfully submitted. When you use Amazon
EMR releases 5.28.0 and later, you can cancel steps that are in a PENDING or RUNNING state.
In earlier versions of Amazon EMR, you can only cancel steps that are in a PENDING state.

# Arguments
- `cluster_id`: The ClusterID for the specified steps that will be canceled. Use RunJobFlow
  and ListClusters to get ClusterIDs.
- `step_ids`: The list of StepIDs to cancel. Use ListSteps to get steps and their states
  for the specified cluster.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"StepCancellationOption"`: The option to choose to cancel RUNNING steps. By default, the
  value is SEND_INTERRUPT.
"""
function cancel_steps(
    ClusterId, StepIds; aws_config::AbstractAWSConfig=current_aws_config()
)
    return emr(
        "CancelSteps",
        Dict{String,Any}("ClusterId" => ClusterId, "StepIds" => StepIds);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function cancel_steps(
    ClusterId,
    StepIds,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return emr(
        "CancelSteps",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ClusterId" => ClusterId, "StepIds" => StepIds),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_security_configuration(name, security_configuration)
    create_security_configuration(name, security_configuration, params::Dict{String,<:Any})

Creates a security configuration, which is stored in the service and can be specified when
a cluster is created.

# Arguments
- `name`: The name of the security configuration.
- `security_configuration`: The security configuration details in JSON format. For JSON
  parameters and examples, see Use Security Configurations to Set Up Cluster Security in the
  Amazon EMR Management Guide.

"""
function create_security_configuration(
    Name, SecurityConfiguration; aws_config::AbstractAWSConfig=current_aws_config()
)
    return emr(
        "CreateSecurityConfiguration",
        Dict{String,Any}("Name" => Name, "SecurityConfiguration" => SecurityConfiguration);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_security_configuration(
    Name,
    SecurityConfiguration,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return emr(
        "CreateSecurityConfiguration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Name" => Name, "SecurityConfiguration" => SecurityConfiguration
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_studio(auth_mode, default_s3_location, engine_security_group_id, name, service_role, subnet_ids, vpc_id, workspace_security_group_id)
    create_studio(auth_mode, default_s3_location, engine_security_group_id, name, service_role, subnet_ids, vpc_id, workspace_security_group_id, params::Dict{String,<:Any})

Creates a new Amazon EMR Studio.

# Arguments
- `auth_mode`: Specifies whether the Studio authenticates users using IAM or IAM Identity
  Center.
- `default_s3_location`: The Amazon S3 location to back up Amazon EMR Studio Workspaces and
  notebook files.
- `engine_security_group_id`: The ID of the Amazon EMR Studio Engine security group. The
  Engine security group allows inbound network traffic from the Workspace security group, and
  it must be in the same VPC specified by VpcId.
- `name`: A descriptive name for the Amazon EMR Studio.
- `service_role`: The IAM role that the Amazon EMR Studio assumes. The service role
  provides a way for Amazon EMR Studio to interoperate with other Amazon Web Services
  services.
- `subnet_ids`: A list of subnet IDs to associate with the Amazon EMR Studio. A Studio can
  have a maximum of 5 subnets. The subnets must belong to the VPC specified by VpcId. Studio
  users can create a Workspace in any of the specified subnets.
- `vpc_id`: The ID of the Amazon Virtual Private Cloud (Amazon VPC) to associate with the
  Studio.
- `workspace_security_group_id`: The ID of the Amazon EMR Studio Workspace security group.
  The Workspace security group allows outbound network traffic to resources in the Engine
  security group, and it must be in the same VPC specified by VpcId.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: A detailed description of the Amazon EMR Studio.
- `"EncryptionKeyArn"`: The KMS key identifier (ARN) used to encrypt Amazon EMR Studio
  workspace and notebook files when backed up to Amazon S3.
- `"IdcInstanceArn"`:  The ARN of the IAM Identity Center instance to create the Studio
  application.
- `"IdcUserAssignment"`:  Specifies whether IAM Identity Center user assignment is REQUIRED
  or OPTIONAL. If the value is set to REQUIRED, users must be explicitly assigned to the
  Studio application to access the Studio.
- `"IdpAuthUrl"`: The authentication endpoint of your identity provider (IdP). Specify this
  value when you use IAM authentication and want to let federated users log in to a Studio
  with the Studio URL and credentials from your IdP. Amazon EMR Studio redirects users to
  this endpoint to enter credentials.
- `"IdpRelayStateParameterName"`: The name that your identity provider (IdP) uses for its
  RelayState parameter. For example, RelayState or TargetSource. Specify this value when you
  use IAM authentication and want to let federated users log in to a Studio using the Studio
  URL. The RelayState parameter differs by IdP.
- `"Tags"`: A list of tags to associate with the Amazon EMR Studio. Tags are user-defined
  key-value pairs that consist of a required key string with a maximum of 128 characters, and
  an optional value string with a maximum of 256 characters.
- `"TrustedIdentityPropagationEnabled"`:  A Boolean indicating whether to enable Trusted
  identity propagation for the Studio. The default value is false.
- `"UserRole"`: The IAM user role that users and groups assume when logged in to an Amazon
  EMR Studio. Only specify a UserRole when you use IAM Identity Center authentication. The
  permissions attached to the UserRole can be scoped down for each user or group using
  session policies.
"""
function create_studio(
    AuthMode,
    DefaultS3Location,
    EngineSecurityGroupId,
    Name,
    ServiceRole,
    SubnetIds,
    VpcId,
    WorkspaceSecurityGroupId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return emr(
        "CreateStudio",
        Dict{String,Any}(
            "AuthMode" => AuthMode,
            "DefaultS3Location" => DefaultS3Location,
            "EngineSecurityGroupId" => EngineSecurityGroupId,
            "Name" => Name,
            "ServiceRole" => ServiceRole,
            "SubnetIds" => SubnetIds,
            "VpcId" => VpcId,
            "WorkspaceSecurityGroupId" => WorkspaceSecurityGroupId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_studio(
    AuthMode,
    DefaultS3Location,
    EngineSecurityGroupId,
    Name,
    ServiceRole,
    SubnetIds,
    VpcId,
    WorkspaceSecurityGroupId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return emr(
        "CreateStudio",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AuthMode" => AuthMode,
                    "DefaultS3Location" => DefaultS3Location,
                    "EngineSecurityGroupId" => EngineSecurityGroupId,
                    "Name" => Name,
                    "ServiceRole" => ServiceRole,
                    "SubnetIds" => SubnetIds,
                    "VpcId" => VpcId,
                    "WorkspaceSecurityGroupId" => WorkspaceSecurityGroupId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_studio_session_mapping(identity_type, session_policy_arn, studio_id)
    create_studio_session_mapping(identity_type, session_policy_arn, studio_id, params::Dict{String,<:Any})

Maps a user or group to the Amazon EMR Studio specified by StudioId, and applies a session
policy to refine Studio permissions for that user or group. Use CreateStudioSessionMapping
to assign users to a Studio when you use IAM Identity Center authentication. For
instructions on how to assign users to a Studio when you use IAM authentication, see Assign
a user or group to your EMR Studio.

# Arguments
- `identity_type`: Specifies whether the identity to map to the Amazon EMR Studio is a user
  or a group.
- `session_policy_arn`: The Amazon Resource Name (ARN) for the session policy that will be
  applied to the user or group. You should specify the ARN for the session policy that you
  want to apply, not the ARN of your user role. For more information, see Create an Amazon
  EMR Studio User Role with Session Policies.
- `studio_id`: The ID of the Amazon EMR Studio to which the user or group will be mapped.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"IdentityId"`: The globally unique identifier (GUID) of the user or group from the IAM
  Identity Center Identity Store. For more information, see UserId and GroupId in the IAM
  Identity Center Identity Store API Reference. Either IdentityName or IdentityId must be
  specified, but not both.
- `"IdentityName"`: The name of the user or group. For more information, see UserName and
  DisplayName in the IAM Identity Center Identity Store API Reference. Either IdentityName or
  IdentityId must be specified, but not both.
"""
function create_studio_session_mapping(
    IdentityType,
    SessionPolicyArn,
    StudioId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return emr(
        "CreateStudioSessionMapping",
        Dict{String,Any}(
            "IdentityType" => IdentityType,
            "SessionPolicyArn" => SessionPolicyArn,
            "StudioId" => StudioId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_studio_session_mapping(
    IdentityType,
    SessionPolicyArn,
    StudioId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return emr(
        "CreateStudioSessionMapping",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "IdentityType" => IdentityType,
                    "SessionPolicyArn" => SessionPolicyArn,
                    "StudioId" => StudioId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_security_configuration(name)
    delete_security_configuration(name, params::Dict{String,<:Any})

Deletes a security configuration.

# Arguments
- `name`: The name of the security configuration.

"""
function delete_security_configuration(
    Name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return emr(
        "DeleteSecurityConfiguration",
        Dict{String,Any}("Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_security_configuration(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return emr(
        "DeleteSecurityConfiguration",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Name" => Name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_studio(studio_id)
    delete_studio(studio_id, params::Dict{String,<:Any})

Removes an Amazon EMR Studio from the Studio metadata store.

# Arguments
- `studio_id`: The ID of the Amazon EMR Studio.

"""
function delete_studio(StudioId; aws_config::AbstractAWSConfig=current_aws_config())
    return emr(
        "DeleteStudio",
        Dict{String,Any}("StudioId" => StudioId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_studio(
    StudioId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return emr(
        "DeleteStudio",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("StudioId" => StudioId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_studio_session_mapping(identity_type, studio_id)
    delete_studio_session_mapping(identity_type, studio_id, params::Dict{String,<:Any})

Removes a user or group from an Amazon EMR Studio.

# Arguments
- `identity_type`: Specifies whether the identity to delete from the Amazon EMR Studio is a
  user or a group.
- `studio_id`: The ID of the Amazon EMR Studio.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"IdentityId"`: The globally unique identifier (GUID) of the user or group to remove from
  the Amazon EMR Studio. For more information, see UserId and GroupId in the IAM Identity
  Center Identity Store API Reference. Either IdentityName or IdentityId must be specified.
- `"IdentityName"`: The name of the user name or group to remove from the Amazon EMR
  Studio. For more information, see UserName and DisplayName in the IAM Identity Center Store
  API Reference. Either IdentityName or IdentityId must be specified.
"""
function delete_studio_session_mapping(
    IdentityType, StudioId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return emr(
        "DeleteStudioSessionMapping",
        Dict{String,Any}("IdentityType" => IdentityType, "StudioId" => StudioId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_studio_session_mapping(
    IdentityType,
    StudioId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return emr(
        "DeleteStudioSessionMapping",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("IdentityType" => IdentityType, "StudioId" => StudioId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_cluster(cluster_id)
    describe_cluster(cluster_id, params::Dict{String,<:Any})

Provides cluster-level details including status, hardware and software configuration, VPC
settings, and so on.

# Arguments
- `cluster_id`: The identifier of the cluster to describe.

"""
function describe_cluster(ClusterId; aws_config::AbstractAWSConfig=current_aws_config())
    return emr(
        "DescribeCluster",
        Dict{String,Any}("ClusterId" => ClusterId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_cluster(
    ClusterId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return emr(
        "DescribeCluster",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ClusterId" => ClusterId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_job_flows()
    describe_job_flows(params::Dict{String,<:Any})

This API is no longer supported and will eventually be removed. We recommend you use
ListClusters, DescribeCluster, ListSteps, ListInstanceGroups and ListBootstrapActions
instead. DescribeJobFlows returns a list of job flows that match all of the supplied
parameters. The parameters can include a list of job flow IDs, job flow states, and
restrictions on job flow creation date and time. Regardless of supplied parameters, only
job flows created within the last two months are returned. If no parameters are supplied,
then job flows matching either of the following criteria are returned:   Job flows created
and completed in the last two weeks    Job flows created within the last two months that
are in one of the following states: RUNNING, WAITING, SHUTTING_DOWN, STARTING    Amazon EMR
can return a maximum of 512 job flow descriptions.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CreatedAfter"`: Return only job flows created after this date and time.
- `"CreatedBefore"`: Return only job flows created before this date and time.
- `"JobFlowIds"`: Return only job flows whose job flow ID is contained in this list.
- `"JobFlowStates"`: Return only job flows whose state is contained in this list.
"""
function describe_job_flows(; aws_config::AbstractAWSConfig=current_aws_config())
    return emr("DescribeJobFlows"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function describe_job_flows(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return emr(
        "DescribeJobFlows", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_notebook_execution(notebook_execution_id)
    describe_notebook_execution(notebook_execution_id, params::Dict{String,<:Any})

Provides details of a notebook execution.

# Arguments
- `notebook_execution_id`: The unique identifier of the notebook execution.

"""
function describe_notebook_execution(
    NotebookExecutionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return emr(
        "DescribeNotebookExecution",
        Dict{String,Any}("NotebookExecutionId" => NotebookExecutionId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_notebook_execution(
    NotebookExecutionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return emr(
        "DescribeNotebookExecution",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("NotebookExecutionId" => NotebookExecutionId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_release_label()
    describe_release_label(params::Dict{String,<:Any})

Provides Amazon EMR release label details, such as the releases available the Region where
the API request is run, and the available applications for a specific Amazon EMR release
label. Can also list Amazon EMR releases that support a specified version of Spark.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: Reserved for future use. Currently set to null.
- `"NextToken"`: The pagination token. Reserved for future use. Currently set to null.
- `"ReleaseLabel"`: The target release label to be described.
"""
function describe_release_label(; aws_config::AbstractAWSConfig=current_aws_config())
    return emr(
        "DescribeReleaseLabel"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_release_label(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return emr(
        "DescribeReleaseLabel",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_security_configuration(name)
    describe_security_configuration(name, params::Dict{String,<:Any})

Provides the details of a security configuration by returning the configuration JSON.

# Arguments
- `name`: The name of the security configuration.

"""
function describe_security_configuration(
    Name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return emr(
        "DescribeSecurityConfiguration",
        Dict{String,Any}("Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_security_configuration(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return emr(
        "DescribeSecurityConfiguration",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Name" => Name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_step(cluster_id, step_id)
    describe_step(cluster_id, step_id, params::Dict{String,<:Any})

Provides more detail about the cluster step.

# Arguments
- `cluster_id`: The identifier of the cluster with steps to describe.
- `step_id`: The identifier of the step to describe.

"""
function describe_step(
    ClusterId, StepId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return emr(
        "DescribeStep",
        Dict{String,Any}("ClusterId" => ClusterId, "StepId" => StepId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_step(
    ClusterId,
    StepId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return emr(
        "DescribeStep",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ClusterId" => ClusterId, "StepId" => StepId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_studio(studio_id)
    describe_studio(studio_id, params::Dict{String,<:Any})

Returns details for the specified Amazon EMR Studio including ID, Name, VPC, Studio access
URL, and so on.

# Arguments
- `studio_id`: The Amazon EMR Studio ID.

"""
function describe_studio(StudioId; aws_config::AbstractAWSConfig=current_aws_config())
    return emr(
        "DescribeStudio",
        Dict{String,Any}("StudioId" => StudioId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_studio(
    StudioId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return emr(
        "DescribeStudio",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("StudioId" => StudioId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_auto_termination_policy(cluster_id)
    get_auto_termination_policy(cluster_id, params::Dict{String,<:Any})

Returns the auto-termination policy for an Amazon EMR cluster.

# Arguments
- `cluster_id`: Specifies the ID of the Amazon EMR cluster for which the auto-termination
  policy will be fetched.

"""
function get_auto_termination_policy(
    ClusterId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return emr(
        "GetAutoTerminationPolicy",
        Dict{String,Any}("ClusterId" => ClusterId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_auto_termination_policy(
    ClusterId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return emr(
        "GetAutoTerminationPolicy",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ClusterId" => ClusterId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_block_public_access_configuration()
    get_block_public_access_configuration(params::Dict{String,<:Any})

Returns the Amazon EMR block public access configuration for your Amazon Web Services
account in the current Region. For more information see Configure Block Public Access for
Amazon EMR in the Amazon EMR Management Guide.

"""
function get_block_public_access_configuration(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return emr(
        "GetBlockPublicAccessConfiguration";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_block_public_access_configuration(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return emr(
        "GetBlockPublicAccessConfiguration",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_cluster_session_credentials(cluster_id)
    get_cluster_session_credentials(cluster_id, params::Dict{String,<:Any})

Provides temporary, HTTP basic credentials that are associated with a given runtime IAM
role and used by a cluster with fine-grained access control activated. You can use these
credentials to connect to cluster endpoints that support username and password
authentication.

# Arguments
- `cluster_id`: The unique identifier of the cluster.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ExecutionRoleArn"`: The Amazon Resource Name (ARN) of the runtime role for interactive
  workload submission on the cluster. The runtime role can be a cross-account IAM role. The
  runtime role ARN is a combination of account ID, role name, and role type using the
  following format: arn:partition:service:region:account:resource.
"""
function get_cluster_session_credentials(
    ClusterId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return emr(
        "GetClusterSessionCredentials",
        Dict{String,Any}("ClusterId" => ClusterId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_cluster_session_credentials(
    ClusterId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return emr(
        "GetClusterSessionCredentials",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ClusterId" => ClusterId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_managed_scaling_policy(cluster_id)
    get_managed_scaling_policy(cluster_id, params::Dict{String,<:Any})

Fetches the attached managed scaling policy for an Amazon EMR cluster.

# Arguments
- `cluster_id`: Specifies the ID of the cluster for which the managed scaling policy will
  be fetched.

"""
function get_managed_scaling_policy(
    ClusterId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return emr(
        "GetManagedScalingPolicy",
        Dict{String,Any}("ClusterId" => ClusterId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_managed_scaling_policy(
    ClusterId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return emr(
        "GetManagedScalingPolicy",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ClusterId" => ClusterId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_studio_session_mapping(identity_type, studio_id)
    get_studio_session_mapping(identity_type, studio_id, params::Dict{String,<:Any})

Fetches mapping details for the specified Amazon EMR Studio and identity (user or group).

# Arguments
- `identity_type`: Specifies whether the identity to fetch is a user or a group.
- `studio_id`: The ID of the Amazon EMR Studio.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"IdentityId"`: The globally unique identifier (GUID) of the user or group. For more
  information, see UserId and GroupId in the IAM Identity Center Identity Store API
  Reference. Either IdentityName or IdentityId must be specified.
- `"IdentityName"`: The name of the user or group to fetch. For more information, see
  UserName and DisplayName in the IAM Identity Center Identity Store API Reference. Either
  IdentityName or IdentityId must be specified.
"""
function get_studio_session_mapping(
    IdentityType, StudioId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return emr(
        "GetStudioSessionMapping",
        Dict{String,Any}("IdentityType" => IdentityType, "StudioId" => StudioId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_studio_session_mapping(
    IdentityType,
    StudioId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return emr(
        "GetStudioSessionMapping",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("IdentityType" => IdentityType, "StudioId" => StudioId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_bootstrap_actions(cluster_id)
    list_bootstrap_actions(cluster_id, params::Dict{String,<:Any})

Provides information about the bootstrap actions associated with a cluster.

# Arguments
- `cluster_id`: The cluster identifier for the bootstrap actions to list.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: The pagination token that indicates the next set of results to retrieve.
"""
function list_bootstrap_actions(
    ClusterId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return emr(
        "ListBootstrapActions",
        Dict{String,Any}("ClusterId" => ClusterId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_bootstrap_actions(
    ClusterId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return emr(
        "ListBootstrapActions",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ClusterId" => ClusterId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_clusters()
    list_clusters(params::Dict{String,<:Any})

Provides the status of all clusters visible to this Amazon Web Services account. Allows you
to filter the list of clusters based on certain criteria; for example, filtering by cluster
creation date and time or by status. This call returns a maximum of 50 clusters in unsorted
order per call, but returns a marker to track the paging of the cluster list across
multiple ListClusters calls.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClusterStates"`: The cluster state filters to apply when listing clusters. Clusters
  that change state while this action runs may be not be returned as expected in the list of
  clusters.
- `"CreatedAfter"`: The creation date and time beginning value filter for listing clusters.
- `"CreatedBefore"`: The creation date and time end value filter for listing clusters.
- `"Marker"`: The pagination token that indicates the next set of results to retrieve.
"""
function list_clusters(; aws_config::AbstractAWSConfig=current_aws_config())
    return emr("ListClusters"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_clusters(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return emr(
        "ListClusters", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_instance_fleets(cluster_id)
    list_instance_fleets(cluster_id, params::Dict{String,<:Any})

Lists all available details about the instance fleets in a cluster.  The instance fleet
configuration is available only in Amazon EMR releases 4.8.0 and later, excluding 5.0.x
versions.

# Arguments
- `cluster_id`: The unique identifier of the cluster.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: The pagination token that indicates the next set of results to retrieve.
"""
function list_instance_fleets(ClusterId; aws_config::AbstractAWSConfig=current_aws_config())
    return emr(
        "ListInstanceFleets",
        Dict{String,Any}("ClusterId" => ClusterId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_instance_fleets(
    ClusterId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return emr(
        "ListInstanceFleets",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ClusterId" => ClusterId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_instance_groups(cluster_id)
    list_instance_groups(cluster_id, params::Dict{String,<:Any})

Provides all available details about the instance groups in a cluster.

# Arguments
- `cluster_id`: The identifier of the cluster for which to list the instance groups.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: The pagination token that indicates the next set of results to retrieve.
"""
function list_instance_groups(ClusterId; aws_config::AbstractAWSConfig=current_aws_config())
    return emr(
        "ListInstanceGroups",
        Dict{String,Any}("ClusterId" => ClusterId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_instance_groups(
    ClusterId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return emr(
        "ListInstanceGroups",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ClusterId" => ClusterId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_instances(cluster_id)
    list_instances(cluster_id, params::Dict{String,<:Any})

Provides information for all active Amazon EC2 instances and Amazon EC2 instances
terminated in the last 30 days, up to a maximum of 2,000. Amazon EC2 instances in any of
the following states are considered active: AWAITING_FULFILLMENT, PROVISIONING,
BOOTSTRAPPING, RUNNING.

# Arguments
- `cluster_id`: The identifier of the cluster for which to list the instances.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"InstanceFleetId"`: The unique identifier of the instance fleet.
- `"InstanceFleetType"`: The node type of the instance fleet. For example MASTER, CORE, or
  TASK.
- `"InstanceGroupId"`: The identifier of the instance group for which to list the instances.
- `"InstanceGroupTypes"`: The type of instance group for which to list the instances.
- `"InstanceStates"`: A list of instance states that will filter the instances returned
  with this request.
- `"Marker"`: The pagination token that indicates the next set of results to retrieve.
"""
function list_instances(ClusterId; aws_config::AbstractAWSConfig=current_aws_config())
    return emr(
        "ListInstances",
        Dict{String,Any}("ClusterId" => ClusterId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_instances(
    ClusterId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return emr(
        "ListInstances",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ClusterId" => ClusterId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_notebook_executions()
    list_notebook_executions(params::Dict{String,<:Any})

Provides summaries of all notebook executions. You can filter the list based on multiple
criteria such as status, time range, and editor id. Returns a maximum of 50 notebook
executions and a marker to track the paging of a longer notebook execution list across
multiple ListNotebookExecutions calls.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"EditorId"`: The unique ID of the editor associated with the notebook execution.
- `"ExecutionEngineId"`: The unique ID of the execution engine.
- `"From"`: The beginning of time range filter for listing notebook executions. The default
  is the timestamp of 30 days ago.
- `"Marker"`: The pagination token, returned by a previous ListNotebookExecutions call,
  that indicates the start of the list for this ListNotebookExecutions call.
- `"Status"`: The status filter for listing notebook executions.    START_PENDING indicates
  that the cluster has received the execution request but execution has not begun.
  STARTING indicates that the execution is starting on the cluster.    RUNNING indicates that
  the execution is being processed by the cluster.    FINISHING indicates that execution
  processing is in the final stages.    FINISHED indicates that the execution has completed
  without error.    FAILING indicates that the execution is failing and will not finish
  successfully.    FAILED indicates that the execution failed.    STOP_PENDING indicates that
  the cluster has received a StopNotebookExecution request and the stop is pending.
  STOPPING indicates that the cluster is in the process of stopping the execution as a result
  of a StopNotebookExecution request.    STOPPED indicates that the execution stopped because
  of a StopNotebookExecution request.
- `"To"`: The end of time range filter for listing notebook executions. The default is the
  current timestamp.
"""
function list_notebook_executions(; aws_config::AbstractAWSConfig=current_aws_config())
    return emr(
        "ListNotebookExecutions"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_notebook_executions(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return emr(
        "ListNotebookExecutions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_release_labels()
    list_release_labels(params::Dict{String,<:Any})

Retrieves release labels of Amazon EMR services in the Region where the API is called.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: Filters the results of the request. Prefix specifies the prefix of release
  labels to return. Application specifies the application (with/without version) of release
  labels to return.
- `"MaxResults"`: Defines the maximum number of release labels to return in a single
  response. The default is 100.
- `"NextToken"`: Specifies the next page of results. If NextToken is not specified, which
  is usually the case for the first request of ListReleaseLabels, the first page of results
  are determined by other filtering parameters or by the latest version. The
  ListReleaseLabels request fails if the identity (Amazon Web Services account ID) and all
  filtering parameters are different from the original request, or if the NextToken is
  expired or tampered with.
"""
function list_release_labels(; aws_config::AbstractAWSConfig=current_aws_config())
    return emr("ListReleaseLabels"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_release_labels(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return emr(
        "ListReleaseLabels", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_security_configurations()
    list_security_configurations(params::Dict{String,<:Any})

Lists all the security configurations visible to this account, providing their creation
dates and times, and their names. This call returns a maximum of 50 clusters per call, but
returns a marker to track the paging of the cluster list across multiple
ListSecurityConfigurations calls.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: The pagination token that indicates the set of results to retrieve.
"""
function list_security_configurations(; aws_config::AbstractAWSConfig=current_aws_config())
    return emr(
        "ListSecurityConfigurations"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_security_configurations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return emr(
        "ListSecurityConfigurations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_steps(cluster_id)
    list_steps(cluster_id, params::Dict{String,<:Any})

Provides a list of steps for the cluster in reverse order unless you specify stepIds with
the request or filter by StepStates. You can specify a maximum of 10 stepIDs. The CLI
automatically paginates results to return a list greater than 50 steps. To return more than
50 steps using the CLI, specify a Marker, which is a pagination token that indicates the
next set of steps to retrieve.

# Arguments
- `cluster_id`: The identifier of the cluster for which to list the steps.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: The maximum number of steps that a single ListSteps action returns is 50. To
  return a longer list of steps, use multiple ListSteps actions along with the Marker
  parameter, which is a pagination token that indicates the next set of results to retrieve.
- `"StepIds"`: The filter to limit the step list based on the identifier of the steps. You
  can specify a maximum of ten Step IDs. The character constraint applies to the overall
  length of the array.
- `"StepStates"`: The filter to limit the step list based on certain states.
"""
function list_steps(ClusterId; aws_config::AbstractAWSConfig=current_aws_config())
    return emr(
        "ListSteps",
        Dict{String,Any}("ClusterId" => ClusterId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_steps(
    ClusterId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return emr(
        "ListSteps",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ClusterId" => ClusterId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_studio_session_mappings()
    list_studio_session_mappings(params::Dict{String,<:Any})

Returns a list of all user or group session mappings for the Amazon EMR Studio specified by
StudioId.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"IdentityType"`: Specifies whether to return session mappings for users or groups. If
  not specified, the results include session mapping details for both users and groups.
- `"Marker"`: The pagination token that indicates the set of results to retrieve.
- `"StudioId"`: The ID of the Amazon EMR Studio.
"""
function list_studio_session_mappings(; aws_config::AbstractAWSConfig=current_aws_config())
    return emr(
        "ListStudioSessionMappings"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_studio_session_mappings(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return emr(
        "ListStudioSessionMappings",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_studios()
    list_studios(params::Dict{String,<:Any})

Returns a list of all Amazon EMR Studios associated with the Amazon Web Services account.
The list includes details such as ID, Studio Access URL, and creation time for each Studio.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: The pagination token that indicates the set of results to retrieve.
"""
function list_studios(; aws_config::AbstractAWSConfig=current_aws_config())
    return emr("ListStudios"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_studios(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return emr(
        "ListStudios", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_supported_instance_types(release_label)
    list_supported_instance_types(release_label, params::Dict{String,<:Any})

A list of the instance types that Amazon EMR supports. You can filter the list by Amazon
Web Services Region and Amazon EMR release.

# Arguments
- `release_label`: The Amazon EMR release label determines the versions of open-source
  application packages that Amazon EMR has installed on the cluster. Release labels are in
  the format emr-x.x.x, where x.x.x is an Amazon EMR release number such as emr-6.10.0. For
  more information about Amazon EMR releases and their included application versions and
  features, see the  Amazon EMR Release Guide .

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: The pagination token that marks the next set of results to retrieve.
"""
function list_supported_instance_types(
    ReleaseLabel; aws_config::AbstractAWSConfig=current_aws_config()
)
    return emr(
        "ListSupportedInstanceTypes",
        Dict{String,Any}("ReleaseLabel" => ReleaseLabel);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_supported_instance_types(
    ReleaseLabel,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return emr(
        "ListSupportedInstanceTypes",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ReleaseLabel" => ReleaseLabel), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_cluster(cluster_id)
    modify_cluster(cluster_id, params::Dict{String,<:Any})

Modifies the number of steps that can be executed concurrently for the cluster specified
using ClusterID.

# Arguments
- `cluster_id`: The unique identifier of the cluster.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"StepConcurrencyLevel"`: The number of steps that can be executed concurrently. You can
  specify a minimum of 1 step and a maximum of 256 steps. We recommend that you do not change
  this parameter while steps are running or the ActionOnFailure setting may not behave as
  expected. For more information see StepActionOnFailure.
"""
function modify_cluster(ClusterId; aws_config::AbstractAWSConfig=current_aws_config())
    return emr(
        "ModifyCluster",
        Dict{String,Any}("ClusterId" => ClusterId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function modify_cluster(
    ClusterId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return emr(
        "ModifyCluster",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ClusterId" => ClusterId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_instance_fleet(cluster_id, instance_fleet)
    modify_instance_fleet(cluster_id, instance_fleet, params::Dict{String,<:Any})

Modifies the target On-Demand and target Spot capacities for the instance fleet with the
specified InstanceFleetID within the cluster specified using ClusterID. The call either
succeeds or fails atomically.  The instance fleet configuration is available only in Amazon
EMR releases 4.8.0 and later, excluding 5.0.x versions.

# Arguments
- `cluster_id`: The unique identifier of the cluster.
- `instance_fleet`: The configuration parameters of the instance fleet.

"""
function modify_instance_fleet(
    ClusterId, InstanceFleet; aws_config::AbstractAWSConfig=current_aws_config()
)
    return emr(
        "ModifyInstanceFleet",
        Dict{String,Any}("ClusterId" => ClusterId, "InstanceFleet" => InstanceFleet);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function modify_instance_fleet(
    ClusterId,
    InstanceFleet,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return emr(
        "ModifyInstanceFleet",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ClusterId" => ClusterId, "InstanceFleet" => InstanceFleet
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_instance_groups()
    modify_instance_groups(params::Dict{String,<:Any})

ModifyInstanceGroups modifies the number of nodes and configuration settings of an instance
group. The input parameters include the new target instance count for the group and the
instance group ID. The call will either succeed or fail atomically.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClusterId"`: The ID of the cluster to which the instance group belongs.
- `"InstanceGroups"`: Instance groups to change.
"""
function modify_instance_groups(; aws_config::AbstractAWSConfig=current_aws_config())
    return emr(
        "ModifyInstanceGroups"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function modify_instance_groups(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return emr(
        "ModifyInstanceGroups",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_auto_scaling_policy(auto_scaling_policy, cluster_id, instance_group_id)
    put_auto_scaling_policy(auto_scaling_policy, cluster_id, instance_group_id, params::Dict{String,<:Any})

Creates or updates an automatic scaling policy for a core instance group or task instance
group in an Amazon EMR cluster. The automatic scaling policy defines how an instance group
dynamically adds and terminates Amazon EC2 instances in response to the value of a
CloudWatch metric.

# Arguments
- `auto_scaling_policy`: Specifies the definition of the automatic scaling policy.
- `cluster_id`: Specifies the ID of a cluster. The instance group to which the automatic
  scaling policy is applied is within this cluster.
- `instance_group_id`: Specifies the ID of the instance group to which the automatic
  scaling policy is applied.

"""
function put_auto_scaling_policy(
    AutoScalingPolicy,
    ClusterId,
    InstanceGroupId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return emr(
        "PutAutoScalingPolicy",
        Dict{String,Any}(
            "AutoScalingPolicy" => AutoScalingPolicy,
            "ClusterId" => ClusterId,
            "InstanceGroupId" => InstanceGroupId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_auto_scaling_policy(
    AutoScalingPolicy,
    ClusterId,
    InstanceGroupId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return emr(
        "PutAutoScalingPolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AutoScalingPolicy" => AutoScalingPolicy,
                    "ClusterId" => ClusterId,
                    "InstanceGroupId" => InstanceGroupId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_auto_termination_policy(cluster_id)
    put_auto_termination_policy(cluster_id, params::Dict{String,<:Any})

 Auto-termination is supported in Amazon EMR releases 5.30.0 and 6.1.0 and later. For more
information, see Using an auto-termination policy.  Creates or updates an auto-termination
policy for an Amazon EMR cluster. An auto-termination policy defines the amount of idle
time in seconds after which a cluster automatically terminates. For alternative cluster
termination options, see Control cluster termination.

# Arguments
- `cluster_id`: Specifies the ID of the Amazon EMR cluster to which the auto-termination
  policy will be attached.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AutoTerminationPolicy"`: Specifies the auto-termination policy to attach to the cluster.
"""
function put_auto_termination_policy(
    ClusterId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return emr(
        "PutAutoTerminationPolicy",
        Dict{String,Any}("ClusterId" => ClusterId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_auto_termination_policy(
    ClusterId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return emr(
        "PutAutoTerminationPolicy",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ClusterId" => ClusterId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_block_public_access_configuration(block_public_access_configuration)
    put_block_public_access_configuration(block_public_access_configuration, params::Dict{String,<:Any})

Creates or updates an Amazon EMR block public access configuration for your Amazon Web
Services account in the current Region. For more information see Configure Block Public
Access for Amazon EMR in the Amazon EMR Management Guide.

# Arguments
- `block_public_access_configuration`: A configuration for Amazon EMR block public access.
  The configuration applies to all clusters created in your account for the current Region.
  The configuration specifies whether block public access is enabled. If block public access
  is enabled, security groups associated with the cluster cannot have rules that allow
  inbound traffic from 0.0.0.0/0 or ::/0 on a port, unless the port is specified as an
  exception using PermittedPublicSecurityGroupRuleRanges in the
  BlockPublicAccessConfiguration. By default, Port 22 (SSH) is an exception, and public
  access is allowed on this port. You can change this by updating
  BlockPublicSecurityGroupRules to remove the exception.  For accounts that created clusters
  in a Region before November 25, 2019, block public access is disabled by default in that
  Region. To use this feature, you must manually enable and configure it. For accounts that
  did not create an Amazon EMR cluster in a Region before this date, block public access is
  enabled by default in that Region.

"""
function put_block_public_access_configuration(
    BlockPublicAccessConfiguration; aws_config::AbstractAWSConfig=current_aws_config()
)
    return emr(
        "PutBlockPublicAccessConfiguration",
        Dict{String,Any}(
            "BlockPublicAccessConfiguration" => BlockPublicAccessConfiguration
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_block_public_access_configuration(
    BlockPublicAccessConfiguration,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return emr(
        "PutBlockPublicAccessConfiguration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "BlockPublicAccessConfiguration" => BlockPublicAccessConfiguration
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_managed_scaling_policy(cluster_id, managed_scaling_policy)
    put_managed_scaling_policy(cluster_id, managed_scaling_policy, params::Dict{String,<:Any})

Creates or updates a managed scaling policy for an Amazon EMR cluster. The managed scaling
policy defines the limits for resources, such as Amazon EC2 instances that can be added or
terminated from a cluster. The policy only applies to the core and task nodes. The master
node cannot be scaled after initial configuration.

# Arguments
- `cluster_id`: Specifies the ID of an Amazon EMR cluster where the managed scaling policy
  is attached.
- `managed_scaling_policy`: Specifies the constraints for the managed scaling policy.

"""
function put_managed_scaling_policy(
    ClusterId, ManagedScalingPolicy; aws_config::AbstractAWSConfig=current_aws_config()
)
    return emr(
        "PutManagedScalingPolicy",
        Dict{String,Any}(
            "ClusterId" => ClusterId, "ManagedScalingPolicy" => ManagedScalingPolicy
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_managed_scaling_policy(
    ClusterId,
    ManagedScalingPolicy,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return emr(
        "PutManagedScalingPolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ClusterId" => ClusterId, "ManagedScalingPolicy" => ManagedScalingPolicy
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    remove_auto_scaling_policy(cluster_id, instance_group_id)
    remove_auto_scaling_policy(cluster_id, instance_group_id, params::Dict{String,<:Any})

Removes an automatic scaling policy from a specified instance group within an Amazon EMR
cluster.

# Arguments
- `cluster_id`: Specifies the ID of a cluster. The instance group to which the automatic
  scaling policy is applied is within this cluster.
- `instance_group_id`: Specifies the ID of the instance group to which the scaling policy
  is applied.

"""
function remove_auto_scaling_policy(
    ClusterId, InstanceGroupId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return emr(
        "RemoveAutoScalingPolicy",
        Dict{String,Any}("ClusterId" => ClusterId, "InstanceGroupId" => InstanceGroupId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function remove_auto_scaling_policy(
    ClusterId,
    InstanceGroupId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return emr(
        "RemoveAutoScalingPolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ClusterId" => ClusterId, "InstanceGroupId" => InstanceGroupId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    remove_auto_termination_policy(cluster_id)
    remove_auto_termination_policy(cluster_id, params::Dict{String,<:Any})

Removes an auto-termination policy from an Amazon EMR cluster.

# Arguments
- `cluster_id`: Specifies the ID of the Amazon EMR cluster from which the auto-termination
  policy will be removed.

"""
function remove_auto_termination_policy(
    ClusterId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return emr(
        "RemoveAutoTerminationPolicy",
        Dict{String,Any}("ClusterId" => ClusterId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function remove_auto_termination_policy(
    ClusterId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return emr(
        "RemoveAutoTerminationPolicy",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ClusterId" => ClusterId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    remove_managed_scaling_policy(cluster_id)
    remove_managed_scaling_policy(cluster_id, params::Dict{String,<:Any})

 Removes a managed scaling policy from a specified Amazon EMR cluster.

# Arguments
- `cluster_id`:  Specifies the ID of the cluster from which the managed scaling policy will
  be removed.

"""
function remove_managed_scaling_policy(
    ClusterId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return emr(
        "RemoveManagedScalingPolicy",
        Dict{String,Any}("ClusterId" => ClusterId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function remove_managed_scaling_policy(
    ClusterId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return emr(
        "RemoveManagedScalingPolicy",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ClusterId" => ClusterId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    remove_tags(resource_id, tag_keys)
    remove_tags(resource_id, tag_keys, params::Dict{String,<:Any})

Removes tags from an Amazon EMR resource, such as a cluster or Amazon EMR Studio. Tags make
it easier to associate resources in various ways, such as grouping clusters to track your
Amazon EMR resource allocation costs. For more information, see Tag Clusters.  The
following example removes the stack tag with value Prod from a cluster:

# Arguments
- `resource_id`: The Amazon EMR resource identifier from which tags will be removed. For
  example, a cluster identifier or an Amazon EMR Studio ID.
- `tag_keys`: A list of tag keys to remove from the resource.

"""
function remove_tags(
    ResourceId, TagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return emr(
        "RemoveTags",
        Dict{String,Any}("ResourceId" => ResourceId, "TagKeys" => TagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function remove_tags(
    ResourceId,
    TagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return emr(
        "RemoveTags",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceId" => ResourceId, "TagKeys" => TagKeys),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    run_job_flow(instances, name)
    run_job_flow(instances, name, params::Dict{String,<:Any})

RunJobFlow creates and starts running a new cluster (job flow). The cluster runs the steps
specified. After the steps complete, the cluster stops and the HDFS partition is lost. To
prevent loss of data, configure the last step of the job flow to store results in Amazon
S3. If the JobFlowInstancesConfig KeepJobFlowAliveWhenNoSteps parameter is set to TRUE, the
cluster transitions to the WAITING state rather than shutting down after the steps have
completed.  For additional protection, you can set the JobFlowInstancesConfig
TerminationProtected parameter to TRUE to lock the cluster and prevent it from being
terminated by API call, user intervention, or in the event of a job flow error. A maximum
of 256 steps are allowed in each job flow. If your cluster is long-running (such as a Hive
data warehouse) or complex, you may require more than 256 steps to process your data. You
can bypass the 256-step limitation in various ways, including using the SSH shell to
connect to the master node and submitting queries directly to the software running on the
master node, such as Hive and Hadoop. For long-running clusters, we recommend that you
periodically store your results.  The instance fleets configuration is available only in
Amazon EMR releases 4.8.0 and later, excluding 5.0.x versions. The RunJobFlow request can
contain InstanceFleets parameters or InstanceGroups parameters, but not both.

# Arguments
- `instances`: A specification of the number and type of Amazon EC2 instances.
- `name`: The name of the job flow.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AdditionalInfo"`: A JSON string for selecting additional features.
- `"AmiVersion"`: Applies only to Amazon EMR AMI versions 3.x and 2.x. For Amazon EMR
  releases 4.0 and later, ReleaseLabel is used. To specify a custom AMI, use CustomAmiID.
- `"Applications"`: Applies to Amazon EMR releases 4.0 and later. A case-insensitive list
  of applications for Amazon EMR to install and configure when launching the cluster. For a
  list of applications available for each Amazon EMR release version, see the Amazon
  EMRRelease Guide.
- `"AutoScalingRole"`: An IAM role for automatic scaling policies. The default role is
  EMR_AutoScaling_DefaultRole. The IAM role provides permissions that the automatic scaling
  feature requires to launch and terminate Amazon EC2 instances in an instance group.
- `"AutoTerminationPolicy"`:
- `"BootstrapActions"`: A list of bootstrap actions to run before Hadoop starts on the
  cluster nodes.
- `"Configurations"`: For Amazon EMR releases 4.0 and later. The list of configurations
  supplied for the Amazon EMR cluster that you are creating.
- `"CustomAmiId"`: Available only in Amazon EMR releases 5.7.0 and later. The ID of a
  custom Amazon EBS-backed Linux AMI. If specified, Amazon EMR uses this AMI when it launches
  cluster Amazon EC2 instances. For more information about custom AMIs in Amazon EMR, see
  Using a Custom AMI in the Amazon EMR Management Guide. If omitted, the cluster uses the
  base Linux AMI for the ReleaseLabel specified. For Amazon EMR releases 2.x and 3.x, use
  AmiVersion instead. For information about creating a custom AMI, see Creating an Amazon
  EBS-Backed Linux AMI in the Amazon Elastic Compute Cloud User Guide for Linux Instances.
  For information about finding an AMI ID, see Finding a Linux AMI.
- `"EbsRootVolumeIops"`: The IOPS, of the Amazon EBS root device volume of the Linux AMI
  that is used for each Amazon EC2 instance. Available in Amazon EMR releases 6.15.0 and
  later.
- `"EbsRootVolumeSize"`: The size, in GiB, of the Amazon EBS root device volume of the
  Linux AMI that is used for each Amazon EC2 instance. Available in Amazon EMR releases 4.x
  and later.
- `"EbsRootVolumeThroughput"`: The throughput, in MiB/s, of the Amazon EBS root device
  volume of the Linux AMI that is used for each Amazon EC2 instance. Available in Amazon EMR
  releases 6.15.0 and later.
- `"JobFlowRole"`: Also called instance profile and Amazon EC2 role. An IAM role for an
  Amazon EMR cluster. The Amazon EC2 instances of the cluster assume this role. The default
  role is EMR_EC2_DefaultRole. In order to use the default role, you must have already
  created it using the CLI or console.
- `"KerberosAttributes"`: Attributes for Kerberos configuration when Kerberos
  authentication is enabled using a security configuration. For more information see Use
  Kerberos Authentication in the Amazon EMR Management Guide.
- `"LogEncryptionKmsKeyId"`: The KMS key used for encrypting log files. If a value is not
  provided, the logs remain encrypted by AES-256. This attribute is only available with
  Amazon EMR releases 5.30.0 and later, excluding Amazon EMR 6.0.0.
- `"LogUri"`: The location in Amazon S3 to write the log files of the job flow. If a value
  is not provided, logs are not created.
- `"ManagedScalingPolicy"`:  The specified managed scaling policy for an Amazon EMR
  cluster.
- `"NewSupportedProducts"`:  For Amazon EMR releases 3.x and 2.x. For Amazon EMR releases
  4.x and later, use Applications.  A list of strings that indicates third-party software to
  use with the job flow that accepts a user argument list. Amazon EMR accepts and forwards
  the argument list to the corresponding installation script as bootstrap action arguments.
  For more information, see \"Launch a Job Flow on the MapR Distribution for Hadoop\" in the
  Amazon EMR Developer Guide. Supported values are:   \"mapr-m3\" - launch the cluster using
  MapR M3 Edition.   \"mapr-m5\" - launch the cluster using MapR M5 Edition.   \"mapr\" with
  the user arguments specifying \"--edition,m3\" or \"--edition,m5\" - launch the job flow
  using MapR M3 or M5 Edition respectively.   \"mapr-m7\" - launch the cluster using MapR M7
  Edition.   \"hunk\" - launch the cluster with the Hunk Big Data Analytics Platform.
  \"hue\"- launch the cluster with Hue installed.   \"spark\" - launch the cluster with
  Apache Spark installed.   \"ganglia\" - launch the cluster with the Ganglia Monitoring
  System installed.
- `"OSReleaseLabel"`: Specifies a particular Amazon Linux release for all nodes in a
  cluster launch RunJobFlow request. If a release is not specified, Amazon EMR uses the
  latest validated Amazon Linux release for cluster launch.
- `"PlacementGroupConfigs"`: The specified placement group configuration for an Amazon EMR
  cluster.
- `"ReleaseLabel"`: The Amazon EMR release label, which determines the version of
  open-source application packages installed on the cluster. Release labels are in the form
  emr-x.x.x, where x.x.x is an Amazon EMR release version such as emr-5.14.0. For more
  information about Amazon EMR release versions and included application versions and
  features, see https://docs.aws.amazon.com/emr/latest/ReleaseGuide/. The release label
  applies only to Amazon EMR releases version 4.0 and later. Earlier versions use AmiVersion.
- `"RepoUpgradeOnBoot"`: Applies only when CustomAmiID is used. Specifies which updates
  from the Amazon Linux AMI package repositories to apply automatically when the instance
  boots using the AMI. If omitted, the default is SECURITY, which indicates that only
  security updates are applied. If NONE is specified, no updates are applied, and all updates
  must be applied manually.
- `"ScaleDownBehavior"`: Specifies the way that individual Amazon EC2 instances terminate
  when an automatic scale-in activity occurs or an instance group is resized.
  TERMINATE_AT_INSTANCE_HOUR indicates that Amazon EMR terminates nodes at the instance-hour
  boundary, regardless of when the request to terminate the instance was submitted. This
  option is only available with Amazon EMR 5.1.0 and later and is the default for clusters
  created using that version. TERMINATE_AT_TASK_COMPLETION indicates that Amazon EMR adds
  nodes to a deny list and drains tasks from nodes before terminating the Amazon EC2
  instances, regardless of the instance-hour boundary. With either behavior, Amazon EMR
  removes the least active nodes first and blocks instance termination if it could lead to
  HDFS corruption. TERMINATE_AT_TASK_COMPLETION available only in Amazon EMR releases 4.1.0
  and later, and is the default for releases of Amazon EMR earlier than 5.1.0.
- `"SecurityConfiguration"`: The name of a security configuration to apply to the cluster.
- `"ServiceRole"`: The IAM role that Amazon EMR assumes in order to access Amazon Web
  Services resources on your behalf. If you've created a custom service role path, you must
  specify it for the service role when you launch your cluster.
- `"StepConcurrencyLevel"`: Specifies the number of steps that can be executed
  concurrently. The default value is 1. The maximum value is 256.
- `"Steps"`: A list of steps to run.
- `"SupportedProducts"`:  For Amazon EMR releases 3.x and 2.x. For Amazon EMR releases 4.x
  and later, use Applications.  A list of strings that indicates third-party software to use.
  For more information, see the Amazon EMR Developer Guide. Currently supported values are:
  \"mapr-m3\" - launch the job flow using MapR M3 Edition.   \"mapr-m5\" - launch the job
  flow using MapR M5 Edition.
- `"Tags"`: A list of tags to associate with a cluster and propagate to Amazon EC2
  instances.
- `"VisibleToAllUsers"`:  The VisibleToAllUsers parameter is no longer supported. By
  default, the value is set to true. Setting it to false now has no effect.  Set this value
  to true so that IAM principals in the Amazon Web Services account associated with the
  cluster can perform Amazon EMR actions on the cluster that their IAM policies allow. This
  value defaults to true for clusters created using the Amazon EMR API or the CLI
  create-cluster command. When set to false, only the IAM principal that created the cluster
  and the Amazon Web Services account root user can perform Amazon EMR actions for the
  cluster, regardless of the IAM permissions policies attached to other IAM principals. For
  more information, see Understanding the Amazon EMR cluster VisibleToAllUsers setting in the
  Amazon EMR Management Guide.
"""
function run_job_flow(Instances, Name; aws_config::AbstractAWSConfig=current_aws_config())
    return emr(
        "RunJobFlow",
        Dict{String,Any}("Instances" => Instances, "Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function run_job_flow(
    Instances,
    Name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return emr(
        "RunJobFlow",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("Instances" => Instances, "Name" => Name), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    set_keep_job_flow_alive_when_no_steps(job_flow_ids, keep_job_flow_alive_when_no_steps)
    set_keep_job_flow_alive_when_no_steps(job_flow_ids, keep_job_flow_alive_when_no_steps, params::Dict{String,<:Any})

You can use the SetKeepJobFlowAliveWhenNoSteps to configure a cluster (job flow) to
terminate after the step execution, i.e., all your steps are executed. If you want a
transient cluster that shuts down after the last of the current executing steps are
completed, you can configure SetKeepJobFlowAliveWhenNoSteps to false. If you want a long
running cluster, configure SetKeepJobFlowAliveWhenNoSteps to true. For more information,
see Managing Cluster Termination in the Amazon EMR Management Guide.

# Arguments
- `job_flow_ids`: A list of strings that uniquely identify the clusters to protect. This
  identifier is returned by RunJobFlow and can also be obtained from DescribeJobFlows.
- `keep_job_flow_alive_when_no_steps`: A Boolean that indicates whether to terminate the
  cluster after all steps are executed.

"""
function set_keep_job_flow_alive_when_no_steps(
    JobFlowIds,
    KeepJobFlowAliveWhenNoSteps;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return emr(
        "SetKeepJobFlowAliveWhenNoSteps",
        Dict{String,Any}(
            "JobFlowIds" => JobFlowIds,
            "KeepJobFlowAliveWhenNoSteps" => KeepJobFlowAliveWhenNoSteps,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function set_keep_job_flow_alive_when_no_steps(
    JobFlowIds,
    KeepJobFlowAliveWhenNoSteps,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return emr(
        "SetKeepJobFlowAliveWhenNoSteps",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "JobFlowIds" => JobFlowIds,
                    "KeepJobFlowAliveWhenNoSteps" => KeepJobFlowAliveWhenNoSteps,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    set_termination_protection(job_flow_ids, termination_protected)
    set_termination_protection(job_flow_ids, termination_protected, params::Dict{String,<:Any})

SetTerminationProtection locks a cluster (job flow) so the Amazon EC2 instances in the
cluster cannot be terminated by user intervention, an API call, or in the event of a
job-flow error. The cluster still terminates upon successful completion of the job flow.
Calling SetTerminationProtection on a cluster is similar to calling the Amazon EC2
DisableAPITermination API on all Amazon EC2 instances in a cluster.
SetTerminationProtection is used to prevent accidental termination of a cluster and to
ensure that in the event of an error, the instances persist so that you can recover any
data stored in their ephemeral instance storage.  To terminate a cluster that has been
locked by setting SetTerminationProtection to true, you must first unlock the job flow by a
subsequent call to SetTerminationProtection in which you set the value to false.   For more
information, see Managing Cluster Termination in the Amazon EMR Management Guide.

# Arguments
- `job_flow_ids`:  A list of strings that uniquely identify the clusters to protect. This
  identifier is returned by RunJobFlow and can also be obtained from DescribeJobFlows .
- `termination_protected`: A Boolean that indicates whether to protect the cluster and
  prevent the Amazon EC2 instances in the cluster from shutting down due to API calls, user
  intervention, or job-flow error.

"""
function set_termination_protection(
    JobFlowIds, TerminationProtected; aws_config::AbstractAWSConfig=current_aws_config()
)
    return emr(
        "SetTerminationProtection",
        Dict{String,Any}(
            "JobFlowIds" => JobFlowIds, "TerminationProtected" => TerminationProtected
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function set_termination_protection(
    JobFlowIds,
    TerminationProtected,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return emr(
        "SetTerminationProtection",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "JobFlowIds" => JobFlowIds,
                    "TerminationProtected" => TerminationProtected,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    set_unhealthy_node_replacement(job_flow_ids, unhealthy_node_replacement)
    set_unhealthy_node_replacement(job_flow_ids, unhealthy_node_replacement, params::Dict{String,<:Any})

Specify whether to enable unhealthy node replacement, which lets Amazon EMR gracefully
replace core nodes on a cluster if any nodes become unhealthy. For example, a node becomes
unhealthy if disk usage is above 90%. If unhealthy node replacement is on and
TerminationProtected are off, Amazon EMR immediately terminates the unhealthy core nodes.
To use unhealthy node replacement and retain unhealthy core nodes, use to turn on
termination protection. In such cases, Amazon EMR adds the unhealthy nodes to a denylist,
reducing job interruptions and failures. If unhealthy node replacement is on, Amazon EMR
notifies YARN and other applications on the cluster to stop scheduling tasks with these
nodes, moves the data, and then terminates the nodes. For more information, see graceful
node replacement in the Amazon EMR Management Guide.

# Arguments
- `job_flow_ids`: The list of strings that uniquely identify the clusters for which to turn
  on unhealthy node replacement. You can get these identifiers by running the RunJobFlow or
  the DescribeJobFlows operations.
- `unhealthy_node_replacement`: Indicates whether to turn on or turn off graceful unhealthy
  node replacement.

"""
function set_unhealthy_node_replacement(
    JobFlowIds, UnhealthyNodeReplacement; aws_config::AbstractAWSConfig=current_aws_config()
)
    return emr(
        "SetUnhealthyNodeReplacement",
        Dict{String,Any}(
            "JobFlowIds" => JobFlowIds,
            "UnhealthyNodeReplacement" => UnhealthyNodeReplacement,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function set_unhealthy_node_replacement(
    JobFlowIds,
    UnhealthyNodeReplacement,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return emr(
        "SetUnhealthyNodeReplacement",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "JobFlowIds" => JobFlowIds,
                    "UnhealthyNodeReplacement" => UnhealthyNodeReplacement,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    set_visible_to_all_users(job_flow_ids, visible_to_all_users)
    set_visible_to_all_users(job_flow_ids, visible_to_all_users, params::Dict{String,<:Any})

 The SetVisibleToAllUsers parameter is no longer supported. Your cluster may be visible to
all users in your account. To restrict cluster access using an IAM policy, see Identity and
Access Management for Amazon EMR.   Sets the ClusterVisibleToAllUsers value for an Amazon
EMR cluster. When true, IAM principals in the Amazon Web Services account can perform
Amazon EMR cluster actions that their IAM policies allow. When false, only the IAM
principal that created the cluster and the Amazon Web Services account root user can
perform Amazon EMR actions on the cluster, regardless of IAM permissions policies attached
to other IAM principals. This action works on running clusters. When you create a cluster,
use the RunJobFlowInputVisibleToAllUsers parameter. For more information, see Understanding
the Amazon EMR Cluster VisibleToAllUsers Setting in the Amazon EMR Management Guide.

# Arguments
- `job_flow_ids`: The unique identifier of the job flow (cluster).
- `visible_to_all_users`: A value of true indicates that an IAM principal in the Amazon Web
  Services account can perform Amazon EMR actions on the cluster that the IAM policies
  attached to the principal allow. A value of false indicates that only the IAM principal
  that created the cluster and the Amazon Web Services root user can perform Amazon EMR
  actions on the cluster.

"""
function set_visible_to_all_users(
    JobFlowIds, VisibleToAllUsers; aws_config::AbstractAWSConfig=current_aws_config()
)
    return emr(
        "SetVisibleToAllUsers",
        Dict{String,Any}(
            "JobFlowIds" => JobFlowIds, "VisibleToAllUsers" => VisibleToAllUsers
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function set_visible_to_all_users(
    JobFlowIds,
    VisibleToAllUsers,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return emr(
        "SetVisibleToAllUsers",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "JobFlowIds" => JobFlowIds, "VisibleToAllUsers" => VisibleToAllUsers
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_notebook_execution(execution_engine, service_role)
    start_notebook_execution(execution_engine, service_role, params::Dict{String,<:Any})

Starts a notebook execution.

# Arguments
- `execution_engine`: Specifies the execution engine (cluster) that runs the notebook
  execution.
- `service_role`: The name or ARN of the IAM role that is used as the service role for
  Amazon EMR (the Amazon EMR role) for the notebook execution.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"EditorId"`: The unique identifier of the Amazon EMR Notebook to use for notebook
  execution.
- `"EnvironmentVariables"`: The environment variables associated with the notebook
  execution.
- `"NotebookExecutionName"`: An optional name for the notebook execution.
- `"NotebookInstanceSecurityGroupId"`: The unique identifier of the Amazon EC2 security
  group to associate with the Amazon EMR Notebook for this notebook execution.
- `"NotebookParams"`: Input parameters in JSON format passed to the Amazon EMR Notebook at
  runtime for execution.
- `"NotebookS3Location"`: The Amazon S3 location for the notebook execution input.
- `"OutputNotebookFormat"`: The output format for the notebook execution.
- `"OutputNotebookS3Location"`: The Amazon S3 location for the notebook execution output.
- `"RelativePath"`: The path and file name of the notebook file for this execution,
  relative to the path specified for the Amazon EMR Notebook. For example, if you specify a
  path of s3://MyBucket/MyNotebooks when you create an Amazon EMR Notebook for a notebook
  with an ID of e-ABCDEFGHIJK1234567890ABCD (the EditorID of this request), and you specify a
  RelativePath of my_notebook_executions/notebook_execution.ipynb, the location of the file
  for the notebook execution is
  s3://MyBucket/MyNotebooks/e-ABCDEFGHIJK1234567890ABCD/my_notebook_executions/notebook_execut
  ion.ipynb.
- `"Tags"`: A list of tags associated with a notebook execution. Tags are user-defined
  key-value pairs that consist of a required key string with a maximum of 128 characters and
  an optional value string with a maximum of 256 characters.
"""
function start_notebook_execution(
    ExecutionEngine, ServiceRole; aws_config::AbstractAWSConfig=current_aws_config()
)
    return emr(
        "StartNotebookExecution",
        Dict{String,Any}(
            "ExecutionEngine" => ExecutionEngine, "ServiceRole" => ServiceRole
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_notebook_execution(
    ExecutionEngine,
    ServiceRole,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return emr(
        "StartNotebookExecution",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ExecutionEngine" => ExecutionEngine, "ServiceRole" => ServiceRole
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    stop_notebook_execution(notebook_execution_id)
    stop_notebook_execution(notebook_execution_id, params::Dict{String,<:Any})

Stops a notebook execution.

# Arguments
- `notebook_execution_id`: The unique identifier of the notebook execution.

"""
function stop_notebook_execution(
    NotebookExecutionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return emr(
        "StopNotebookExecution",
        Dict{String,Any}("NotebookExecutionId" => NotebookExecutionId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function stop_notebook_execution(
    NotebookExecutionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return emr(
        "StopNotebookExecution",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("NotebookExecutionId" => NotebookExecutionId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    terminate_job_flows(job_flow_ids)
    terminate_job_flows(job_flow_ids, params::Dict{String,<:Any})

TerminateJobFlows shuts a list of clusters (job flows) down. When a job flow is shut down,
any step not yet completed is canceled and the Amazon EC2 instances on which the cluster is
running are stopped. Any log files not already saved are uploaded to Amazon S3 if a LogUri
was specified when the cluster was created. The maximum number of clusters allowed is 10.
The call to TerminateJobFlows is asynchronous. Depending on the configuration of the
cluster, it may take up to 1-5 minutes for the cluster to completely terminate and release
allocated resources, such as Amazon EC2 instances.

# Arguments
- `job_flow_ids`: A list of job flows to be shut down.

"""
function terminate_job_flows(JobFlowIds; aws_config::AbstractAWSConfig=current_aws_config())
    return emr(
        "TerminateJobFlows",
        Dict{String,Any}("JobFlowIds" => JobFlowIds);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function terminate_job_flows(
    JobFlowIds,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return emr(
        "TerminateJobFlows",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("JobFlowIds" => JobFlowIds), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_studio(studio_id)
    update_studio(studio_id, params::Dict{String,<:Any})

Updates an Amazon EMR Studio configuration, including attributes such as name, description,
and subnets.

# Arguments
- `studio_id`: The ID of the Amazon EMR Studio to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DefaultS3Location"`: The Amazon S3 location to back up Workspaces and notebook files
  for the Amazon EMR Studio.
- `"Description"`: A detailed description to assign to the Amazon EMR Studio.
- `"EncryptionKeyArn"`: The KMS key identifier (ARN) used to encrypt Amazon EMR Studio
  workspace and notebook files when backed up to Amazon S3.
- `"Name"`: A descriptive name for the Amazon EMR Studio.
- `"SubnetIds"`: A list of subnet IDs to associate with the Amazon EMR Studio. The list can
  include new subnet IDs, but must also include all of the subnet IDs previously associated
  with the Studio. The list order does not matter. A Studio can have a maximum of 5 subnets.
  The subnets must belong to the same VPC as the Studio.
"""
function update_studio(StudioId; aws_config::AbstractAWSConfig=current_aws_config())
    return emr(
        "UpdateStudio",
        Dict{String,Any}("StudioId" => StudioId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_studio(
    StudioId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return emr(
        "UpdateStudio",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("StudioId" => StudioId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_studio_session_mapping(identity_type, session_policy_arn, studio_id)
    update_studio_session_mapping(identity_type, session_policy_arn, studio_id, params::Dict{String,<:Any})

Updates the session policy attached to the user or group for the specified Amazon EMR
Studio.

# Arguments
- `identity_type`: Specifies whether the identity to update is a user or a group.
- `session_policy_arn`: The Amazon Resource Name (ARN) of the session policy to associate
  with the specified user or group.
- `studio_id`: The ID of the Amazon EMR Studio.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"IdentityId"`: The globally unique identifier (GUID) of the user or group. For more
  information, see UserId and GroupId in the IAM Identity Center Identity Store API
  Reference. Either IdentityName or IdentityId must be specified.
- `"IdentityName"`: The name of the user or group to update. For more information, see
  UserName and DisplayName in the IAM Identity Center Identity Store API Reference. Either
  IdentityName or IdentityId must be specified.
"""
function update_studio_session_mapping(
    IdentityType,
    SessionPolicyArn,
    StudioId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return emr(
        "UpdateStudioSessionMapping",
        Dict{String,Any}(
            "IdentityType" => IdentityType,
            "SessionPolicyArn" => SessionPolicyArn,
            "StudioId" => StudioId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_studio_session_mapping(
    IdentityType,
    SessionPolicyArn,
    StudioId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return emr(
        "UpdateStudioSessionMapping",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "IdentityType" => IdentityType,
                    "SessionPolicyArn" => SessionPolicyArn,
                    "StudioId" => StudioId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
