# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: kendra
using AWS.Compat
using AWS.UUIDs

"""
    associate_entities_to_experience(entity_list, id, index_id)
    associate_entities_to_experience(entity_list, id, index_id, params::Dict{String,<:Any})

Grants users or groups in your IAM Identity Center identity source access to your Amazon
Kendra experience. You can create an Amazon Kendra experience such as a search application.
For more information on creating a search application experience, see Building a search
experience with no code.

# Arguments
- `entity_list`: Lists users or groups in your IAM Identity Center identity source.
- `id`: The identifier of your Amazon Kendra experience.
- `index_id`: The identifier of the index for your Amazon Kendra experience.

"""
function associate_entities_to_experience(
    EntityList, Id, IndexId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kendra(
        "AssociateEntitiesToExperience",
        Dict{String,Any}("EntityList" => EntityList, "Id" => Id, "IndexId" => IndexId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_entities_to_experience(
    EntityList,
    Id,
    IndexId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kendra(
        "AssociateEntitiesToExperience",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "EntityList" => EntityList, "Id" => Id, "IndexId" => IndexId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    associate_personas_to_entities(id, index_id, personas)
    associate_personas_to_entities(id, index_id, personas, params::Dict{String,<:Any})

Defines the specific permissions of users or groups in your IAM Identity Center identity
source with access to your Amazon Kendra experience. You can create an Amazon Kendra
experience such as a search application. For more information on creating a search
application experience, see Building a search experience with no code.

# Arguments
- `id`: The identifier of your Amazon Kendra experience.
- `index_id`: The identifier of the index for your Amazon Kendra experience.
- `personas`: The personas that define the specific permissions of users or groups in your
  IAM Identity Center identity source. The available personas or access roles are Owner and
  Viewer. For more information on these personas, see Providing access to your search page.

"""
function associate_personas_to_entities(
    Id, IndexId, Personas; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kendra(
        "AssociatePersonasToEntities",
        Dict{String,Any}("Id" => Id, "IndexId" => IndexId, "Personas" => Personas);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_personas_to_entities(
    Id,
    IndexId,
    Personas,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kendra(
        "AssociatePersonasToEntities",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Id" => Id, "IndexId" => IndexId, "Personas" => Personas),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    batch_delete_document(document_id_list, index_id)
    batch_delete_document(document_id_list, index_id, params::Dict{String,<:Any})

Removes one or more documents from an index. The documents must have been added with the
BatchPutDocument API. The documents are deleted asynchronously. You can see the progress of
the deletion by using Amazon Web Services CloudWatch. Any error messages related to the
processing of the batch are sent to your Amazon Web Services CloudWatch log. You can also
use the BatchGetDocumentStatus API to monitor the progress of deleting your documents.
Deleting documents from an index using BatchDeleteDocument could take up to an hour or
more, depending on the number of documents you want to delete.

# Arguments
- `document_id_list`: One or more identifiers for documents to delete from the index.
- `index_id`: The identifier of the index that contains the documents to delete.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DataSourceSyncJobMetricTarget"`:
"""
function batch_delete_document(
    DocumentIdList, IndexId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kendra(
        "BatchDeleteDocument",
        Dict{String,Any}("DocumentIdList" => DocumentIdList, "IndexId" => IndexId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_delete_document(
    DocumentIdList,
    IndexId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kendra(
        "BatchDeleteDocument",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DocumentIdList" => DocumentIdList, "IndexId" => IndexId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    batch_delete_featured_results_set(featured_results_set_ids, index_id)
    batch_delete_featured_results_set(featured_results_set_ids, index_id, params::Dict{String,<:Any})

Removes one or more sets of featured results. Features results are placed above all other
results for certain queries. If there's an exact match of a query, then one or more
specific documents are featured in the search results.

# Arguments
- `featured_results_set_ids`: The identifiers of the featured results sets that you want to
  delete.
- `index_id`: The identifier of the index used for featuring results.

"""
function batch_delete_featured_results_set(
    FeaturedResultsSetIds, IndexId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kendra(
        "BatchDeleteFeaturedResultsSet",
        Dict{String,Any}(
            "FeaturedResultsSetIds" => FeaturedResultsSetIds, "IndexId" => IndexId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_delete_featured_results_set(
    FeaturedResultsSetIds,
    IndexId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kendra(
        "BatchDeleteFeaturedResultsSet",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "FeaturedResultsSetIds" => FeaturedResultsSetIds, "IndexId" => IndexId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    batch_get_document_status(document_info_list, index_id)
    batch_get_document_status(document_info_list, index_id, params::Dict{String,<:Any})

Returns the indexing status for one or more documents submitted with the  BatchPutDocument
API. When you use the BatchPutDocument API, documents are indexed asynchronously. You can
use the BatchGetDocumentStatus API to get the current status of a list of documents so that
you can determine if they have been successfully indexed. You can also use the
BatchGetDocumentStatus API to check the status of the  BatchDeleteDocument API. When a
document is deleted from the index, Amazon Kendra returns NOT_FOUND as the status.

# Arguments
- `document_info_list`: A list of DocumentInfo objects that identify the documents for
  which to get the status. You identify the documents by their document ID and optional
  attributes.
- `index_id`: The identifier of the index to add documents to. The index ID is returned by
  the CreateIndex  API.

"""
function batch_get_document_status(
    DocumentInfoList, IndexId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kendra(
        "BatchGetDocumentStatus",
        Dict{String,Any}("DocumentInfoList" => DocumentInfoList, "IndexId" => IndexId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_get_document_status(
    DocumentInfoList,
    IndexId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kendra(
        "BatchGetDocumentStatus",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DocumentInfoList" => DocumentInfoList, "IndexId" => IndexId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    batch_put_document(documents, index_id)
    batch_put_document(documents, index_id, params::Dict{String,<:Any})

Adds one or more documents to an index. The BatchPutDocument API enables you to ingest
inline documents or a set of documents stored in an Amazon S3 bucket. Use this API to
ingest your text and unstructured text into an index, add custom attributes to the
documents, and to attach an access control list to the documents added to the index. The
documents are indexed asynchronously. You can see the progress of the batch using Amazon
Web Services CloudWatch. Any error messages related to processing the batch are sent to
your Amazon Web Services CloudWatch log. You can also use the BatchGetDocumentStatus API to
monitor the progress of indexing your documents. For an example of ingesting inline
documents using Python and Java SDKs, see Adding files directly to an index.

# Arguments
- `documents`: One or more documents to add to the index. Documents have the following file
  size limits.   50 MB total size for any file   5 MB extracted text for any file   For more
  information, see Quotas.
- `index_id`: The identifier of the index to add the documents to. You need to create the
  index first using the CreateIndex API.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CustomDocumentEnrichmentConfiguration"`: Configuration information for altering your
  document metadata and content during the document ingestion process when you use the
  BatchPutDocument API. For more information on how to create, modify and delete document
  metadata, or make other content alterations when you ingest documents into Amazon Kendra,
  see Customizing document metadata during the ingestion process.
- `"RoleArn"`: The Amazon Resource Name (ARN) of an IAM role with permission to access your
  S3 bucket. For more information, see IAM access roles for Amazon Kendra.
"""
function batch_put_document(
    Documents, IndexId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kendra(
        "BatchPutDocument",
        Dict{String,Any}("Documents" => Documents, "IndexId" => IndexId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_put_document(
    Documents,
    IndexId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kendra(
        "BatchPutDocument",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Documents" => Documents, "IndexId" => IndexId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    clear_query_suggestions(index_id)
    clear_query_suggestions(index_id, params::Dict{String,<:Any})

Clears existing query suggestions from an index. This deletes existing suggestions only,
not the queries in the query log. After you clear suggestions, Amazon Kendra learns new
suggestions based on new queries added to the query log from the time you cleared
suggestions. If you do not see any new suggestions, then please allow Amazon Kendra to
collect enough queries to learn new suggestions.  ClearQuerySuggestions is currently not
supported in the Amazon Web Services GovCloud (US-West) region.

# Arguments
- `index_id`: The identifier of the index you want to clear query suggestions from.

"""
function clear_query_suggestions(
    IndexId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kendra(
        "ClearQuerySuggestions",
        Dict{String,Any}("IndexId" => IndexId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function clear_query_suggestions(
    IndexId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kendra(
        "ClearQuerySuggestions",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("IndexId" => IndexId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_access_control_configuration(index_id, name)
    create_access_control_configuration(index_id, name, params::Dict{String,<:Any})

Creates an access configuration for your documents. This includes user and group access
information for your documents. This is useful for user context filtering, where search
results are filtered based on the user or their group access to documents. You can use this
to re-configure your existing document level access control without indexing all of your
documents again. For example, your index contains top-secret company documents that only
certain employees or users should access. One of these users leaves the company or switches
to a team that should be blocked from accessing top-secret documents. The user still has
access to top-secret documents because the user had access when your documents were
previously indexed. You can create a specific access control configuration for the user
with deny access. You can later update the access control configuration to allow access if
the user returns to the company and re-joins the 'top-secret' team. You can re-configure
access control for your documents as circumstances change. To apply your access control
configuration to certain documents, you call the BatchPutDocument API with the
AccessControlConfigurationId included in the Document object. If you use an S3 bucket as a
data source, you update the .metadata.json with the AccessControlConfigurationId and
synchronize your data source. Amazon Kendra currently only supports access control
configuration for S3 data sources and documents indexed using the BatchPutDocument API.

# Arguments
- `index_id`: The identifier of the index to create an access control configuration for
  your documents.
- `name`: A name for the access control configuration.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AccessControlList"`: Information on principals (users and/or groups) and which
  documents they should have access to. This is useful for user context filtering, where
  search results are filtered based on the user or their group access to documents.
- `"ClientToken"`: A token that you provide to identify the request to create an access
  control configuration. Multiple calls to the CreateAccessControlConfiguration API with the
  same client token will create only one access control configuration.
- `"Description"`: A description for the access control configuration.
- `"HierarchicalAccessControlList"`: The list of principal lists that define the hierarchy
  for which documents users should have access to.
"""
function create_access_control_configuration(
    IndexId, Name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kendra(
        "CreateAccessControlConfiguration",
        Dict{String,Any}(
            "IndexId" => IndexId, "Name" => Name, "ClientToken" => string(uuid4())
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_access_control_configuration(
    IndexId,
    Name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kendra(
        "CreateAccessControlConfiguration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "IndexId" => IndexId, "Name" => Name, "ClientToken" => string(uuid4())
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_data_source(index_id, name, type)
    create_data_source(index_id, name, type, params::Dict{String,<:Any})

Creates a data source connector that you want to use with an Amazon Kendra index. You
specify a name, data source connector type and description for your data source. You also
specify configuration information for the data source connector.  CreateDataSource is a
synchronous operation. The operation returns 200 if the data source was successfully
created. Otherwise, an exception is raised. For an example of creating an index and data
source using the Python SDK, see Getting started with Python SDK. For an example of
creating an index and data source using the Java SDK, see Getting started with Java SDK.

# Arguments
- `index_id`: The identifier of the index you want to use with the data source connector.
- `name`: A name for the data source connector.
- `type`: The type of data source repository. For example, SHAREPOINT.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: A token that you provide to identify the request to create a data source
  connector. Multiple calls to the CreateDataSource API with the same client token will
  create only one data source connector.
- `"Configuration"`: Configuration information to connect to your data source repository.
  You can't specify the Configuration parameter when the Type parameter is set to CUSTOM. If
  you do, you receive a ValidationException exception. The Configuration parameter is
  required for all other data sources.
- `"CustomDocumentEnrichmentConfiguration"`: Configuration information for altering
  document metadata and content during the document ingestion process. For more information
  on how to create, modify and delete document metadata, or make other content alterations
  when you ingest documents into Amazon Kendra, see Customizing document metadata during the
  ingestion process.
- `"Description"`: A description for the data source connector.
- `"LanguageCode"`: The code for a language. This allows you to support a language for all
  documents when creating the data source connector. English is supported by default. For
  more information on supported languages, including their codes, see Adding documents in
  languages other than English.
- `"RoleArn"`: The Amazon Resource Name (ARN) of an IAM role with permission to access the
  data source and required resources. For more information, see IAM access roles for Amazon
  Kendra.. You can't specify the RoleArn parameter when the Type parameter is set to CUSTOM.
  If you do, you receive a ValidationException exception. The RoleArn parameter is required
  for all other data sources.
- `"Schedule"`: Sets the frequency for Amazon Kendra to check the documents in your data
  source repository and update the index. If you don't set a schedule Amazon Kendra will not
  periodically update the index. You can call the StartDataSourceSyncJob API to update the
  index. Specify a cron- format schedule string or an empty string to indicate that the index
  is updated on demand. You can't specify the Schedule parameter when the Type parameter is
  set to CUSTOM. If you do, you receive a ValidationException exception.
- `"Tags"`: A list of key-value pairs that identify or categorize the data source
  connector. You can also use tags to help control access to the data source connector. Tag
  keys and values can consist of Unicode letters, digits, white space, and any of the
  following symbols: _ . : / = + - @.
- `"VpcConfiguration"`: Configuration information for an Amazon Virtual Private Cloud to
  connect to your data source. For more information, see Configuring a VPC.
"""
function create_data_source(
    IndexId, Name, Type; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kendra(
        "CreateDataSource",
        Dict{String,Any}(
            "IndexId" => IndexId,
            "Name" => Name,
            "Type" => Type,
            "ClientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_data_source(
    IndexId,
    Name,
    Type,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kendra(
        "CreateDataSource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "IndexId" => IndexId,
                    "Name" => Name,
                    "Type" => Type,
                    "ClientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_experience(index_id, name)
    create_experience(index_id, name, params::Dict{String,<:Any})

Creates an Amazon Kendra experience such as a search application. For more information on
creating a search application experience, including using the Python and Java SDKs, see
Building a search experience with no code.

# Arguments
- `index_id`: The identifier of the index for your Amazon Kendra experience.
- `name`: A name for your Amazon Kendra experience.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: A token that you provide to identify the request to create your Amazon
  Kendra experience. Multiple calls to the CreateExperience API with the same client token
  creates only one Amazon Kendra experience.
- `"Configuration"`: Configuration information for your Amazon Kendra experience. This
  includes ContentSourceConfiguration, which specifies the data source IDs and/or FAQ IDs,
  and UserIdentityConfiguration, which specifies the user or group information to grant
  access to your Amazon Kendra experience.
- `"Description"`: A description for your Amazon Kendra experience.
- `"RoleArn"`: The Amazon Resource Name (ARN) of an IAM role with permission to access
  Query API, GetQuerySuggestions API, and other required APIs. The role also must include
  permission to access IAM Identity Center that stores your user and group information. For
  more information, see IAM access roles for Amazon Kendra.
"""
function create_experience(
    IndexId, Name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kendra(
        "CreateExperience",
        Dict{String,Any}(
            "IndexId" => IndexId, "Name" => Name, "ClientToken" => string(uuid4())
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_experience(
    IndexId,
    Name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kendra(
        "CreateExperience",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "IndexId" => IndexId, "Name" => Name, "ClientToken" => string(uuid4())
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_faq(index_id, name, role_arn, s3_path)
    create_faq(index_id, name, role_arn, s3_path, params::Dict{String,<:Any})

Creates a set of frequently ask questions (FAQs) using a specified FAQ file stored in an
Amazon S3 bucket. Adding FAQs to an index is an asynchronous operation. For an example of
adding an FAQ to an index using Python and Java SDKs, see Using your FAQ file.

# Arguments
- `index_id`: The identifier of the index for the FAQ.
- `name`: A name for the FAQ.
- `role_arn`: The Amazon Resource Name (ARN) of an IAM role with permission to access the
  S3 bucket that contains the FAQs. For more information, see IAM access roles for Amazon
  Kendra.
- `s3_path`: The path to the FAQ file in S3.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: A token that you provide to identify the request to create a FAQ.
  Multiple calls to the CreateFaqRequest API with the same client token will create only one
  FAQ.
- `"Description"`: A description for the FAQ.
- `"FileFormat"`: The format of the FAQ input file. You can choose between a basic CSV
  format, a CSV format that includes customs attributes in a header, and a JSON format that
  includes custom attributes. The default format is CSV. The format must match the format of
  the file stored in the S3 bucket identified in the S3Path parameter. For more information,
  see Adding questions and answers.
- `"LanguageCode"`: The code for a language. This allows you to support a language for the
  FAQ document. English is supported by default. For more information on supported languages,
  including their codes, see Adding documents in languages other than English.
- `"Tags"`: A list of key-value pairs that identify the FAQ. You can use the tags to
  identify and organize your resources and to control access to resources.
"""
function create_faq(
    IndexId, Name, RoleArn, S3Path; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kendra(
        "CreateFaq",
        Dict{String,Any}(
            "IndexId" => IndexId,
            "Name" => Name,
            "RoleArn" => RoleArn,
            "S3Path" => S3Path,
            "ClientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_faq(
    IndexId,
    Name,
    RoleArn,
    S3Path,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kendra(
        "CreateFaq",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "IndexId" => IndexId,
                    "Name" => Name,
                    "RoleArn" => RoleArn,
                    "S3Path" => S3Path,
                    "ClientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_featured_results_set(featured_results_set_name, index_id)
    create_featured_results_set(featured_results_set_name, index_id, params::Dict{String,<:Any})

Creates a set of featured results to display at the top of the search results page.
Featured results are placed above all other results for certain queries. You map specific
queries to specific documents for featuring in the results. If a query contains an exact
match, then one or more specific documents are featured in the search results. You can
create up to 50 sets of featured results per index. You can request to increase this limit
by contacting Support.

# Arguments
- `featured_results_set_name`: A name for the set of featured results.
- `index_id`: The identifier of the index that you want to use for featuring results.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: A token that you provide to identify the request to create a set of
  featured results. Multiple calls to the CreateFeaturedResultsSet API with the same client
  token will create only one featured results set.
- `"Description"`: A description for the set of featured results.
- `"FeaturedDocuments"`: A list of document IDs for the documents you want to feature at
  the top of the search results page. For more information on the list of documents, see
  FeaturedResultsSet.
- `"QueryTexts"`: A list of queries for featuring results. For more information on the list
  of queries, see FeaturedResultsSet.
- `"Status"`: The current status of the set of featured results. When the value is ACTIVE,
  featured results are ready for use. You can still configure your settings before setting
  the status to ACTIVE. You can set the status to ACTIVE or INACTIVE using the
  UpdateFeaturedResultsSet API. The queries you specify for featured results must be unique
  per featured results set for each index, whether the status is ACTIVE or INACTIVE.
- `"Tags"`: A list of key-value pairs that identify or categorize the featured results set.
  You can also use tags to help control access to the featured results set. Tag keys and
  values can consist of Unicode letters, digits, white space, and any of the following
  symbols:_ . : / = + - @.
"""
function create_featured_results_set(
    FeaturedResultsSetName, IndexId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kendra(
        "CreateFeaturedResultsSet",
        Dict{String,Any}(
            "FeaturedResultsSetName" => FeaturedResultsSetName, "IndexId" => IndexId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_featured_results_set(
    FeaturedResultsSetName,
    IndexId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kendra(
        "CreateFeaturedResultsSet",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "FeaturedResultsSetName" => FeaturedResultsSetName, "IndexId" => IndexId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_index(name, role_arn)
    create_index(name, role_arn, params::Dict{String,<:Any})

Creates an Amazon Kendra index. Index creation is an asynchronous API. To determine if
index creation has completed, check the Status field returned from a call to DescribeIndex.
The Status field is set to ACTIVE when the index is ready to use. Once the index is active,
you can index your documents using the BatchPutDocument API or using one of the supported
data sources. For an example of creating an index and data source using the Python SDK, see
Getting started with Python SDK. For an example of creating an index and data source using
the Java SDK, see Getting started with Java SDK.

# Arguments
- `name`: A name for the index.
- `role_arn`: The Amazon Resource Name (ARN) of an IAM role with permission to access your
  Amazon CloudWatch logs and metrics. For more information, see IAM access roles for Amazon
  Kendra.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: A token that you provide to identify the request to create an index.
  Multiple calls to the CreateIndex API with the same client token will create only one index.
- `"Description"`: A description for the index.
- `"Edition"`: The Amazon Kendra edition to use for the index. Choose DEVELOPER_EDITION for
  indexes intended for development, testing, or proof of concept. Use ENTERPRISE_EDITION for
  production. Once you set the edition for an index, it can't be changed. The Edition
  parameter is optional. If you don't supply a value, the default is ENTERPRISE_EDITION. For
  more information on quota limits for Enterprise and Developer editions, see Quotas.
- `"ServerSideEncryptionConfiguration"`: The identifier of the KMS customer managed key
  (CMK) that's used to encrypt data indexed by Amazon Kendra. Amazon Kendra doesn't support
  asymmetric CMKs.
- `"Tags"`: A list of key-value pairs that identify or categorize the index. You can also
  use tags to help control access to the index. Tag keys and values can consist of Unicode
  letters, digits, white space, and any of the following symbols: _ . : / = + - @.
- `"UserContextPolicy"`: The user context policy.  ATTRIBUTE_FILTER  All indexed content is
  searchable and displayable for all users. If you want to filter search results on user
  context, you can use the attribute filters of _user_id and _group_ids or you can provide
  user and group information in UserContext.   USER_TOKEN  Enables token-based user access
  control to filter search results on user context. All documents with no access control and
  all documents accessible to the user will be searchable and displayable.
- `"UserGroupResolutionConfiguration"`: Gets users and groups from IAM Identity Center
  identity source. To configure this, see UserGroupResolutionConfiguration. This is useful
  for user context filtering, where search results are filtered based on the user or their
  group access to documents.
- `"UserTokenConfigurations"`: The user token configuration.
"""
function create_index(Name, RoleArn; aws_config::AbstractAWSConfig=current_aws_config())
    return kendra(
        "CreateIndex",
        Dict{String,Any}(
            "Name" => Name, "RoleArn" => RoleArn, "ClientToken" => string(uuid4())
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_index(
    Name,
    RoleArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kendra(
        "CreateIndex",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Name" => Name, "RoleArn" => RoleArn, "ClientToken" => string(uuid4())
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_query_suggestions_block_list(index_id, name, role_arn, source_s3_path)
    create_query_suggestions_block_list(index_id, name, role_arn, source_s3_path, params::Dict{String,<:Any})

Creates a block list to exlcude certain queries from suggestions. Any query that contains
words or phrases specified in the block list is blocked or filtered out from being shown as
a suggestion. You need to provide the file location of your block list text file in your S3
bucket. In your text file, enter each block word or phrase on a separate line. For
information on the current quota limits for block lists, see Quotas for Amazon Kendra.
CreateQuerySuggestionsBlockList is currently not supported in the Amazon Web Services
GovCloud (US-West) region. For an example of creating a block list for query suggestions
using the Python SDK, see Query suggestions block list.

# Arguments
- `index_id`: The identifier of the index you want to create a query suggestions block list
  for.
- `name`: A name for the block list. For example, the name 'offensive-words', which
  includes all offensive words that could appear in user queries and need to be blocked from
  suggestions.
- `role_arn`: The Amazon Resource Name (ARN) of an IAM role with permission to access your
  S3 bucket that contains the block list text file. For more information, see IAM access
  roles for Amazon Kendra.
- `source_s3_path`: The S3 path to your block list text file in your S3 bucket. Each block
  word or phrase should be on a separate line in a text file. For information on the current
  quota limits for block lists, see Quotas for Amazon Kendra.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: A token that you provide to identify the request to create a query
  suggestions block list.
- `"Description"`: A description for the block list. For example, the description \"List of
  all offensive words that can appear in user queries and need to be blocked from
  suggestions.\"
- `"Tags"`: A list of key-value pairs that identify or categorize the block list. Tag keys
  and values can consist of Unicode letters, digits, white space, and any of the following
  symbols: _ . : / = + - @.
"""
function create_query_suggestions_block_list(
    IndexId, Name, RoleArn, SourceS3Path; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kendra(
        "CreateQuerySuggestionsBlockList",
        Dict{String,Any}(
            "IndexId" => IndexId,
            "Name" => Name,
            "RoleArn" => RoleArn,
            "SourceS3Path" => SourceS3Path,
            "ClientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_query_suggestions_block_list(
    IndexId,
    Name,
    RoleArn,
    SourceS3Path,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kendra(
        "CreateQuerySuggestionsBlockList",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "IndexId" => IndexId,
                    "Name" => Name,
                    "RoleArn" => RoleArn,
                    "SourceS3Path" => SourceS3Path,
                    "ClientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_thesaurus(index_id, name, role_arn, source_s3_path)
    create_thesaurus(index_id, name, role_arn, source_s3_path, params::Dict{String,<:Any})

Creates a thesaurus for an index. The thesaurus contains a list of synonyms in Solr format.
For an example of adding a thesaurus file to an index, see Adding custom synonyms to an
index.

# Arguments
- `index_id`: The identifier of the index for the thesaurus.
- `name`: A name for the thesaurus.
- `role_arn`: The Amazon Resource Name (ARN) of an IAM role with permission to access your
  S3 bucket that contains the thesaurus file. For more information, see IAM access roles for
  Amazon Kendra.
- `source_s3_path`: The path to the thesaurus file in S3.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: A token that you provide to identify the request to create a thesaurus.
  Multiple calls to the CreateThesaurus API with the same client token will create only one
  thesaurus.
- `"Description"`: A description for the thesaurus.
- `"Tags"`: A list of key-value pairs that identify or categorize the thesaurus. You can
  also use tags to help control access to the thesaurus. Tag keys and values can consist of
  Unicode letters, digits, white space, and any of the following symbols: _ . : / = + - @.
"""
function create_thesaurus(
    IndexId, Name, RoleArn, SourceS3Path; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kendra(
        "CreateThesaurus",
        Dict{String,Any}(
            "IndexId" => IndexId,
            "Name" => Name,
            "RoleArn" => RoleArn,
            "SourceS3Path" => SourceS3Path,
            "ClientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_thesaurus(
    IndexId,
    Name,
    RoleArn,
    SourceS3Path,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kendra(
        "CreateThesaurus",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "IndexId" => IndexId,
                    "Name" => Name,
                    "RoleArn" => RoleArn,
                    "SourceS3Path" => SourceS3Path,
                    "ClientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_access_control_configuration(id, index_id)
    delete_access_control_configuration(id, index_id, params::Dict{String,<:Any})

Deletes an access control configuration that you created for your documents in an index.
This includes user and group access information for your documents. This is useful for user
context filtering, where search results are filtered based on the user or their group
access to documents.

# Arguments
- `id`: The identifier of the access control configuration you want to delete.
- `index_id`: The identifier of the index for an access control configuration.

"""
function delete_access_control_configuration(
    Id, IndexId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kendra(
        "DeleteAccessControlConfiguration",
        Dict{String,Any}("Id" => Id, "IndexId" => IndexId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_access_control_configuration(
    Id,
    IndexId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kendra(
        "DeleteAccessControlConfiguration",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Id" => Id, "IndexId" => IndexId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_data_source(id, index_id)
    delete_data_source(id, index_id, params::Dict{String,<:Any})

Deletes an Amazon Kendra data source connector. An exception is not thrown if the data
source is already being deleted. While the data source is being deleted, the Status field
returned by a call to the DescribeDataSource API is set to DELETING. For more information,
see Deleting Data Sources. Deleting an entire data source or re-syncing your index after
deleting specific documents from a data source could take up to an hour or more, depending
on the number of documents you want to delete.

# Arguments
- `id`: The identifier of the data source connector you want to delete.
- `index_id`: The identifier of the index used with the data source connector.

"""
function delete_data_source(Id, IndexId; aws_config::AbstractAWSConfig=current_aws_config())
    return kendra(
        "DeleteDataSource",
        Dict{String,Any}("Id" => Id, "IndexId" => IndexId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_data_source(
    Id,
    IndexId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kendra(
        "DeleteDataSource",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Id" => Id, "IndexId" => IndexId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_experience(id, index_id)
    delete_experience(id, index_id, params::Dict{String,<:Any})

Deletes your Amazon Kendra experience such as a search application. For more information on
creating a search application experience, see Building a search experience with no code.

# Arguments
- `id`: The identifier of your Amazon Kendra experience you want to delete.
- `index_id`: The identifier of the index for your Amazon Kendra experience.

"""
function delete_experience(Id, IndexId; aws_config::AbstractAWSConfig=current_aws_config())
    return kendra(
        "DeleteExperience",
        Dict{String,Any}("Id" => Id, "IndexId" => IndexId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_experience(
    Id,
    IndexId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kendra(
        "DeleteExperience",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Id" => Id, "IndexId" => IndexId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_faq(id, index_id)
    delete_faq(id, index_id, params::Dict{String,<:Any})

Removes an FAQ from an index.

# Arguments
- `id`: The identifier of the FAQ you want to remove.
- `index_id`: The identifier of the index for the FAQ.

"""
function delete_faq(Id, IndexId; aws_config::AbstractAWSConfig=current_aws_config())
    return kendra(
        "DeleteFaq",
        Dict{String,Any}("Id" => Id, "IndexId" => IndexId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_faq(
    Id,
    IndexId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kendra(
        "DeleteFaq",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Id" => Id, "IndexId" => IndexId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_index(id)
    delete_index(id, params::Dict{String,<:Any})

Deletes an Amazon Kendra index. An exception is not thrown if the index is already being
deleted. While the index is being deleted, the Status field returned by a call to the
DescribeIndex API is set to DELETING.

# Arguments
- `id`: The identifier of the index you want to delete.

"""
function delete_index(Id; aws_config::AbstractAWSConfig=current_aws_config())
    return kendra(
        "DeleteIndex",
        Dict{String,Any}("Id" => Id);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_index(
    Id, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kendra(
        "DeleteIndex",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Id" => Id), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_principal_mapping(group_id, index_id)
    delete_principal_mapping(group_id, index_id, params::Dict{String,<:Any})

Deletes a group so that all users and sub groups that belong to the group can no longer
access documents only available to that group. For example, after deleting the group
\"Summer Interns\", all interns who belonged to that group no longer see intern-only
documents in their search results. If you want to delete or replace users or sub groups of
a group, you need to use the PutPrincipalMapping operation. For example, if a user in the
group \"Engineering\" leaves the engineering team and another user takes their place, you
provide an updated list of users or sub groups that belong to the \"Engineering\" group
when calling PutPrincipalMapping. You can update your internal list of users or sub groups
and input this list when calling PutPrincipalMapping.  DeletePrincipalMapping is currently
not supported in the Amazon Web Services GovCloud (US-West) region.

# Arguments
- `group_id`: The identifier of the group you want to delete.
- `index_id`: The identifier of the index you want to delete a group from.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DataSourceId"`: The identifier of the data source you want to delete a group from. A
  group can be tied to multiple data sources. You can delete a group from accessing documents
  in a certain data source. For example, the groups \"Research\", \"Engineering\", and
  \"Sales and Marketing\" are all tied to the company's documents stored in the data sources
  Confluence and Salesforce. You want to delete \"Research\" and \"Engineering\" groups from
  Salesforce, so that these groups cannot access customer-related documents stored in
  Salesforce. Only \"Sales and Marketing\" should access documents in the Salesforce data
  source.
- `"OrderingId"`: The timestamp identifier you specify to ensure Amazon Kendra does not
  override the latest DELETE action with previous actions. The highest number ID, which is
  the ordering ID, is the latest action you want to process and apply on top of other actions
  with lower number IDs. This prevents previous actions with lower number IDs from possibly
  overriding the latest action. The ordering ID can be the Unix time of the last update you
  made to a group members list. You would then provide this list when calling
  PutPrincipalMapping. This ensures your DELETE action for that updated group with the latest
  members list doesn't get overwritten by earlier DELETE actions for the same group which are
  yet to be processed. The default ordering ID is the current Unix time in milliseconds that
  the action was received by Amazon Kendra.
"""
function delete_principal_mapping(
    GroupId, IndexId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kendra(
        "DeletePrincipalMapping",
        Dict{String,Any}("GroupId" => GroupId, "IndexId" => IndexId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_principal_mapping(
    GroupId,
    IndexId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kendra(
        "DeletePrincipalMapping",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("GroupId" => GroupId, "IndexId" => IndexId), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_query_suggestions_block_list(id, index_id)
    delete_query_suggestions_block_list(id, index_id, params::Dict{String,<:Any})

Deletes a block list used for query suggestions for an index. A deleted block list might
not take effect right away. Amazon Kendra needs to refresh the entire suggestions list to
add back the queries that were previously blocked.  DeleteQuerySuggestionsBlockList is
currently not supported in the Amazon Web Services GovCloud (US-West) region.

# Arguments
- `id`: The identifier of the block list you want to delete.
- `index_id`: The identifier of the index for the block list.

"""
function delete_query_suggestions_block_list(
    Id, IndexId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kendra(
        "DeleteQuerySuggestionsBlockList",
        Dict{String,Any}("Id" => Id, "IndexId" => IndexId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_query_suggestions_block_list(
    Id,
    IndexId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kendra(
        "DeleteQuerySuggestionsBlockList",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Id" => Id, "IndexId" => IndexId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_thesaurus(id, index_id)
    delete_thesaurus(id, index_id, params::Dict{String,<:Any})

Deletes an Amazon Kendra thesaurus.

# Arguments
- `id`: The identifier of the thesaurus you want to delete.
- `index_id`: The identifier of the index for the thesaurus.

"""
function delete_thesaurus(Id, IndexId; aws_config::AbstractAWSConfig=current_aws_config())
    return kendra(
        "DeleteThesaurus",
        Dict{String,Any}("Id" => Id, "IndexId" => IndexId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_thesaurus(
    Id,
    IndexId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kendra(
        "DeleteThesaurus",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Id" => Id, "IndexId" => IndexId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_access_control_configuration(id, index_id)
    describe_access_control_configuration(id, index_id, params::Dict{String,<:Any})

Gets information about an access control configuration that you created for your documents
in an index. This includes user and group access information for your documents. This is
useful for user context filtering, where search results are filtered based on the user or
their group access to documents.

# Arguments
- `id`: The identifier of the access control configuration you want to get information on.
- `index_id`: The identifier of the index for an access control configuration.

"""
function describe_access_control_configuration(
    Id, IndexId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kendra(
        "DescribeAccessControlConfiguration",
        Dict{String,Any}("Id" => Id, "IndexId" => IndexId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_access_control_configuration(
    Id,
    IndexId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kendra(
        "DescribeAccessControlConfiguration",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Id" => Id, "IndexId" => IndexId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_data_source(id, index_id)
    describe_data_source(id, index_id, params::Dict{String,<:Any})

Gets information about an Amazon Kendra data source connector.

# Arguments
- `id`: The identifier of the data source connector.
- `index_id`: The identifier of the index used with the data source connector.

"""
function describe_data_source(
    Id, IndexId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kendra(
        "DescribeDataSource",
        Dict{String,Any}("Id" => Id, "IndexId" => IndexId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_data_source(
    Id,
    IndexId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kendra(
        "DescribeDataSource",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Id" => Id, "IndexId" => IndexId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_experience(id, index_id)
    describe_experience(id, index_id, params::Dict{String,<:Any})

Gets information about your Amazon Kendra experience such as a search application. For more
information on creating a search application experience, see Building a search experience
with no code.

# Arguments
- `id`: The identifier of your Amazon Kendra experience you want to get information on.
- `index_id`: The identifier of the index for your Amazon Kendra experience.

"""
function describe_experience(
    Id, IndexId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kendra(
        "DescribeExperience",
        Dict{String,Any}("Id" => Id, "IndexId" => IndexId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_experience(
    Id,
    IndexId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kendra(
        "DescribeExperience",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Id" => Id, "IndexId" => IndexId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_faq(id, index_id)
    describe_faq(id, index_id, params::Dict{String,<:Any})

Gets information about an FAQ list.

# Arguments
- `id`: The identifier of the FAQ you want to get information on.
- `index_id`: The identifier of the index for the FAQ.

"""
function describe_faq(Id, IndexId; aws_config::AbstractAWSConfig=current_aws_config())
    return kendra(
        "DescribeFaq",
        Dict{String,Any}("Id" => Id, "IndexId" => IndexId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_faq(
    Id,
    IndexId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kendra(
        "DescribeFaq",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Id" => Id, "IndexId" => IndexId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_featured_results_set(featured_results_set_id, index_id)
    describe_featured_results_set(featured_results_set_id, index_id, params::Dict{String,<:Any})

Gets information about a set of featured results. Features results are placed above all
other results for certain queries. If there's an exact match of a query, then one or more
specific documents are featured in the search results.

# Arguments
- `featured_results_set_id`: The identifier of the set of featured results that you want to
  get information on.
- `index_id`: The identifier of the index used for featuring results.

"""
function describe_featured_results_set(
    FeaturedResultsSetId, IndexId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kendra(
        "DescribeFeaturedResultsSet",
        Dict{String,Any}(
            "FeaturedResultsSetId" => FeaturedResultsSetId, "IndexId" => IndexId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_featured_results_set(
    FeaturedResultsSetId,
    IndexId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kendra(
        "DescribeFeaturedResultsSet",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "FeaturedResultsSetId" => FeaturedResultsSetId, "IndexId" => IndexId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_index(id)
    describe_index(id, params::Dict{String,<:Any})

Gets information about an Amazon Kendra index.

# Arguments
- `id`: The identifier of the index you want to get information on.

"""
function describe_index(Id; aws_config::AbstractAWSConfig=current_aws_config())
    return kendra(
        "DescribeIndex",
        Dict{String,Any}("Id" => Id);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_index(
    Id, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kendra(
        "DescribeIndex",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Id" => Id), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_principal_mapping(group_id, index_id)
    describe_principal_mapping(group_id, index_id, params::Dict{String,<:Any})

Describes the processing of PUT and DELETE actions for mapping users to their groups. This
includes information on the status of actions currently processing or yet to be processed,
when actions were last updated, when actions were received by Amazon Kendra, the latest
action that should process and apply after other actions, and useful error messages if an
action could not be processed.  DescribePrincipalMapping is currently not supported in the
Amazon Web Services GovCloud (US-West) region.

# Arguments
- `group_id`: The identifier of the group required to check the processing of PUT and
  DELETE actions for mapping users to their groups.
- `index_id`: The identifier of the index required to check the processing of PUT and
  DELETE actions for mapping users to their groups.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DataSourceId"`: The identifier of the data source to check the processing of PUT and
  DELETE actions for mapping users to their groups.
"""
function describe_principal_mapping(
    GroupId, IndexId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kendra(
        "DescribePrincipalMapping",
        Dict{String,Any}("GroupId" => GroupId, "IndexId" => IndexId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_principal_mapping(
    GroupId,
    IndexId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kendra(
        "DescribePrincipalMapping",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("GroupId" => GroupId, "IndexId" => IndexId), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_query_suggestions_block_list(id, index_id)
    describe_query_suggestions_block_list(id, index_id, params::Dict{String,<:Any})

Gets information about a block list used for query suggestions for an index. This is used
to check the current settings that are applied to a block list.
DescribeQuerySuggestionsBlockList is currently not supported in the Amazon Web Services
GovCloud (US-West) region.

# Arguments
- `id`: The identifier of the block list you want to get information on.
- `index_id`: The identifier of the index for the block list.

"""
function describe_query_suggestions_block_list(
    Id, IndexId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kendra(
        "DescribeQuerySuggestionsBlockList",
        Dict{String,Any}("Id" => Id, "IndexId" => IndexId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_query_suggestions_block_list(
    Id,
    IndexId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kendra(
        "DescribeQuerySuggestionsBlockList",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Id" => Id, "IndexId" => IndexId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_query_suggestions_config(index_id)
    describe_query_suggestions_config(index_id, params::Dict{String,<:Any})

Gets information on the settings of query suggestions for an index. This is used to check
the current settings applied to query suggestions.  DescribeQuerySuggestionsConfig is
currently not supported in the Amazon Web Services GovCloud (US-West) region.

# Arguments
- `index_id`: The identifier of the index with query suggestions that you want to get
  information on.

"""
function describe_query_suggestions_config(
    IndexId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kendra(
        "DescribeQuerySuggestionsConfig",
        Dict{String,Any}("IndexId" => IndexId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_query_suggestions_config(
    IndexId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kendra(
        "DescribeQuerySuggestionsConfig",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("IndexId" => IndexId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_thesaurus(id, index_id)
    describe_thesaurus(id, index_id, params::Dict{String,<:Any})

Gets information about an Amazon Kendra thesaurus.

# Arguments
- `id`: The identifier of the thesaurus you want to get information on.
- `index_id`: The identifier of the index for the thesaurus.

"""
function describe_thesaurus(Id, IndexId; aws_config::AbstractAWSConfig=current_aws_config())
    return kendra(
        "DescribeThesaurus",
        Dict{String,Any}("Id" => Id, "IndexId" => IndexId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_thesaurus(
    Id,
    IndexId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kendra(
        "DescribeThesaurus",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Id" => Id, "IndexId" => IndexId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_entities_from_experience(entity_list, id, index_id)
    disassociate_entities_from_experience(entity_list, id, index_id, params::Dict{String,<:Any})

Prevents users or groups in your IAM Identity Center identity source from accessing your
Amazon Kendra experience. You can create an Amazon Kendra experience such as a search
application. For more information on creating a search application experience, see Building
a search experience with no code.

# Arguments
- `entity_list`: Lists users or groups in your IAM Identity Center identity source.
- `id`: The identifier of your Amazon Kendra experience.
- `index_id`: The identifier of the index for your Amazon Kendra experience.

"""
function disassociate_entities_from_experience(
    EntityList, Id, IndexId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kendra(
        "DisassociateEntitiesFromExperience",
        Dict{String,Any}("EntityList" => EntityList, "Id" => Id, "IndexId" => IndexId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_entities_from_experience(
    EntityList,
    Id,
    IndexId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kendra(
        "DisassociateEntitiesFromExperience",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "EntityList" => EntityList, "Id" => Id, "IndexId" => IndexId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_personas_from_entities(entity_ids, id, index_id)
    disassociate_personas_from_entities(entity_ids, id, index_id, params::Dict{String,<:Any})

Removes the specific permissions of users or groups in your IAM Identity Center identity
source with access to your Amazon Kendra experience. You can create an Amazon Kendra
experience such as a search application. For more information on creating a search
application experience, see Building a search experience with no code.

# Arguments
- `entity_ids`: The identifiers of users or groups in your IAM Identity Center identity
  source. For example, user IDs could be user emails.
- `id`: The identifier of your Amazon Kendra experience.
- `index_id`: The identifier of the index for your Amazon Kendra experience.

"""
function disassociate_personas_from_entities(
    EntityIds, Id, IndexId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kendra(
        "DisassociatePersonasFromEntities",
        Dict{String,Any}("EntityIds" => EntityIds, "Id" => Id, "IndexId" => IndexId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_personas_from_entities(
    EntityIds,
    Id,
    IndexId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kendra(
        "DisassociatePersonasFromEntities",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "EntityIds" => EntityIds, "Id" => Id, "IndexId" => IndexId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_query_suggestions(index_id, query_text)
    get_query_suggestions(index_id, query_text, params::Dict{String,<:Any})

Fetches the queries that are suggested to your users.  GetQuerySuggestions is currently not
supported in the Amazon Web Services GovCloud (US-West) region.

# Arguments
- `index_id`: The identifier of the index you want to get query suggestions from.
- `query_text`: The text of a user's query to generate query suggestions. A query is
  suggested if the query prefix matches what a user starts to type as their query. Amazon
  Kendra does not show any suggestions if a user types fewer than two characters or more than
  60 characters. A query must also have at least one search result and contain at least one
  word of more than four characters.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AttributeSuggestionsConfig"`: Configuration information for the document
  fields/attributes that you want to base query suggestions on.
- `"MaxSuggestionsCount"`: The maximum number of query suggestions you want to show to your
  users.
- `"SuggestionTypes"`: The suggestions type to base query suggestions on. The suggestion
  types are query history or document fields/attributes. You can set one type or the other.
  If you set query history as your suggestions type, Amazon Kendra suggests queries relevant
  to your users based on popular queries in the query history. If you set document
  fields/attributes as your suggestions type, Amazon Kendra suggests queries relevant to your
  users based on the contents of document fields.
"""
function get_query_suggestions(
    IndexId, QueryText; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kendra(
        "GetQuerySuggestions",
        Dict{String,Any}("IndexId" => IndexId, "QueryText" => QueryText);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_query_suggestions(
    IndexId,
    QueryText,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kendra(
        "GetQuerySuggestions",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("IndexId" => IndexId, "QueryText" => QueryText),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_snapshots(index_id, interval, metric_type)
    get_snapshots(index_id, interval, metric_type, params::Dict{String,<:Any})

Retrieves search metrics data. The data provides a snapshot of how your users interact with
your search application and how effective the application is.

# Arguments
- `index_id`: The identifier of the index to get search metrics data.
- `interval`: The time interval or time window to get search metrics data. The time
  interval uses the time zone of your index. You can view data in the following time windows:
     THIS_WEEK: The current week, starting on the Sunday and ending on the day before the
  current date.    ONE_WEEK_AGO: The previous week, starting on the Sunday and ending on the
  following Saturday.    TWO_WEEKS_AGO: The week before the previous week, starting on the
  Sunday and ending on the following Saturday.    THIS_MONTH: The current month, starting on
  the first day of the month and ending on the day before the current date.    ONE_MONTH_AGO:
  The previous month, starting on the first day of the month and ending on the last day of
  the month.    TWO_MONTHS_AGO: The month before the previous month, starting on the first
  day of the month and ending on last day of the month.
- `metric_type`: The metric you want to retrieve. You can specify only one metric per call.
  For more information about the metrics you can view, see Gaining insights with search
  analytics.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of returned data for the metric.
- `"NextToken"`: If the previous response was incomplete (because there is more data to
  retrieve), Amazon Kendra returns a pagination token in the response. You can use this
  pagination token to retrieve the next set of search metrics data.
"""
function get_snapshots(
    IndexId, Interval, MetricType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kendra(
        "GetSnapshots",
        Dict{String,Any}(
            "IndexId" => IndexId, "Interval" => Interval, "MetricType" => MetricType
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_snapshots(
    IndexId,
    Interval,
    MetricType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kendra(
        "GetSnapshots",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "IndexId" => IndexId, "Interval" => Interval, "MetricType" => MetricType
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_access_control_configurations(index_id)
    list_access_control_configurations(index_id, params::Dict{String,<:Any})

Lists one or more access control configurations for an index. This includes user and group
access information for your documents. This is useful for user context filtering, where
search results are filtered based on the user or their group access to documents.

# Arguments
- `index_id`: The identifier of the index for the access control configuration.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of access control configurations to return.
- `"NextToken"`: If the previous response was incomplete (because there's more data to
  retrieve), Amazon Kendra returns a pagination token in the response. You can use this
  pagination token to retrieve the next set of access control configurations.
"""
function list_access_control_configurations(
    IndexId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kendra(
        "ListAccessControlConfigurations",
        Dict{String,Any}("IndexId" => IndexId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_access_control_configurations(
    IndexId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kendra(
        "ListAccessControlConfigurations",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("IndexId" => IndexId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_data_source_sync_jobs(id, index_id)
    list_data_source_sync_jobs(id, index_id, params::Dict{String,<:Any})

Gets statistics about synchronizing a data source connector.

# Arguments
- `id`: The identifier of the data source connector.
- `index_id`: The identifier of the index used with the data source connector.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of synchronization jobs to return in the response. If
  there are fewer results in the list, this response contains only the actual results.
- `"NextToken"`: If the previous response was incomplete (because there is more data to
  retrieve), Amazon Kendra returns a pagination token in the response. You can use this
  pagination token to retrieve the next set of jobs.
- `"StartTimeFilter"`: When specified, the synchronization jobs returned in the list are
  limited to jobs between the specified dates.
- `"StatusFilter"`: Only returns synchronization jobs with the Status field equal to the
  specified status.
"""
function list_data_source_sync_jobs(
    Id, IndexId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kendra(
        "ListDataSourceSyncJobs",
        Dict{String,Any}("Id" => Id, "IndexId" => IndexId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_data_source_sync_jobs(
    Id,
    IndexId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kendra(
        "ListDataSourceSyncJobs",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Id" => Id, "IndexId" => IndexId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_data_sources(index_id)
    list_data_sources(index_id, params::Dict{String,<:Any})

Lists the data source connectors that you have created.

# Arguments
- `index_id`: The identifier of the index used with one or more data source connectors.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of data source connectors to return.
- `"NextToken"`: If the previous response was incomplete (because there is more data to
  retrieve), Amazon Kendra returns a pagination token in the response. You can use this
  pagination token to retrieve the next set of data source connectors.
"""
function list_data_sources(IndexId; aws_config::AbstractAWSConfig=current_aws_config())
    return kendra(
        "ListDataSources",
        Dict{String,Any}("IndexId" => IndexId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_data_sources(
    IndexId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kendra(
        "ListDataSources",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("IndexId" => IndexId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_entity_personas(id, index_id)
    list_entity_personas(id, index_id, params::Dict{String,<:Any})

Lists specific permissions of users and groups with access to your Amazon Kendra experience.

# Arguments
- `id`: The identifier of your Amazon Kendra experience.
- `index_id`: The identifier of the index for your Amazon Kendra experience.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of returned users or groups.
- `"NextToken"`: If the previous response was incomplete (because there is more data to
  retrieve), Amazon Kendra returns a pagination token in the response. You can use this
  pagination token to retrieve the next set of users or groups.
"""
function list_entity_personas(
    Id, IndexId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kendra(
        "ListEntityPersonas",
        Dict{String,Any}("Id" => Id, "IndexId" => IndexId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_entity_personas(
    Id,
    IndexId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kendra(
        "ListEntityPersonas",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Id" => Id, "IndexId" => IndexId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_experience_entities(id, index_id)
    list_experience_entities(id, index_id, params::Dict{String,<:Any})

Lists users or groups in your IAM Identity Center identity source that are granted access
to your Amazon Kendra experience. You can create an Amazon Kendra experience such as a
search application. For more information on creating a search application experience, see
Building a search experience with no code.

# Arguments
- `id`: The identifier of your Amazon Kendra experience.
- `index_id`: The identifier of the index for your Amazon Kendra experience.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"NextToken"`: If the previous response was incomplete (because there is more data to
  retrieve), Amazon Kendra returns a pagination token in the response. You can use this
  pagination token to retrieve the next set of users or groups.
"""
function list_experience_entities(
    Id, IndexId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kendra(
        "ListExperienceEntities",
        Dict{String,Any}("Id" => Id, "IndexId" => IndexId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_experience_entities(
    Id,
    IndexId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kendra(
        "ListExperienceEntities",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Id" => Id, "IndexId" => IndexId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_experiences(index_id)
    list_experiences(index_id, params::Dict{String,<:Any})

Lists one or more Amazon Kendra experiences. You can create an Amazon Kendra experience
such as a search application. For more information on creating a search application
experience, see Building a search experience with no code.

# Arguments
- `index_id`: The identifier of the index for your Amazon Kendra experience.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of returned Amazon Kendra experiences.
- `"NextToken"`: If the previous response was incomplete (because there is more data to
  retrieve), Amazon Kendra returns a pagination token in the response. You can use this
  pagination token to retrieve the next set of Amazon Kendra experiences.
"""
function list_experiences(IndexId; aws_config::AbstractAWSConfig=current_aws_config())
    return kendra(
        "ListExperiences",
        Dict{String,Any}("IndexId" => IndexId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_experiences(
    IndexId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kendra(
        "ListExperiences",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("IndexId" => IndexId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_faqs(index_id)
    list_faqs(index_id, params::Dict{String,<:Any})

Gets a list of FAQ lists associated with an index.

# Arguments
- `index_id`: The index that contains the FAQ lists.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of FAQs to return in the response. If there are fewer
  results in the list, this response contains only the actual results.
- `"NextToken"`: If the previous response was incomplete (because there is more data to
  retrieve), Amazon Kendra returns a pagination token in the response. You can use this
  pagination token to retrieve the next set of FAQs.
"""
function list_faqs(IndexId; aws_config::AbstractAWSConfig=current_aws_config())
    return kendra(
        "ListFaqs",
        Dict{String,Any}("IndexId" => IndexId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_faqs(
    IndexId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kendra(
        "ListFaqs",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("IndexId" => IndexId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_featured_results_sets(index_id)
    list_featured_results_sets(index_id, params::Dict{String,<:Any})

Lists all your sets of featured results for a given index. Features results are placed
above all other results for certain queries. If there's an exact match of a query, then one
or more specific documents are featured in the search results.

# Arguments
- `index_id`: The identifier of the index used for featuring results.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of featured results sets to return.
- `"NextToken"`: If the response is truncated, Amazon Kendra returns a pagination token in
  the response. You can use this pagination token to retrieve the next set of featured
  results sets.
"""
function list_featured_results_sets(
    IndexId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kendra(
        "ListFeaturedResultsSets",
        Dict{String,Any}("IndexId" => IndexId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_featured_results_sets(
    IndexId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kendra(
        "ListFeaturedResultsSets",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("IndexId" => IndexId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_groups_older_than_ordering_id(index_id, ordering_id)
    list_groups_older_than_ordering_id(index_id, ordering_id, params::Dict{String,<:Any})

Provides a list of groups that are mapped to users before a given ordering or timestamp
identifier.  ListGroupsOlderThanOrderingId is currently not supported in the Amazon Web
Services GovCloud (US-West) region.

# Arguments
- `index_id`: The identifier of the index for getting a list of groups mapped to users
  before a given ordering or timestamp identifier.
- `ordering_id`: The timestamp identifier used for the latest PUT or DELETE action for
  mapping users to their groups.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DataSourceId"`: The identifier of the data source for getting a list of groups mapped
  to users before a given ordering timestamp identifier.
- `"MaxResults"`:  The maximum number of returned groups that are mapped to users before a
  given ordering or timestamp identifier.
- `"NextToken"`:  If the previous response was incomplete (because there is more data to
  retrieve), Amazon Kendra returns a pagination token in the response. You can use this
  pagination token to retrieve the next set of groups that are mapped to users before a given
  ordering or timestamp identifier.
"""
function list_groups_older_than_ordering_id(
    IndexId, OrderingId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kendra(
        "ListGroupsOlderThanOrderingId",
        Dict{String,Any}("IndexId" => IndexId, "OrderingId" => OrderingId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_groups_older_than_ordering_id(
    IndexId,
    OrderingId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kendra(
        "ListGroupsOlderThanOrderingId",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("IndexId" => IndexId, "OrderingId" => OrderingId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_indices()
    list_indices(params::Dict{String,<:Any})

Lists the Amazon Kendra indexes that you created.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of indices to return.
- `"NextToken"`: If the previous response was incomplete (because there is more data to
  retrieve), Amazon Kendra returns a pagination token in the response. You can use this
  pagination token to retrieve the next set of indexes.
"""
function list_indices(; aws_config::AbstractAWSConfig=current_aws_config())
    return kendra("ListIndices"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_indices(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kendra(
        "ListIndices", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_query_suggestions_block_lists(index_id)
    list_query_suggestions_block_lists(index_id, params::Dict{String,<:Any})

Lists the block lists used for query suggestions for an index. For information on the
current quota limits for block lists, see Quotas for Amazon Kendra.
ListQuerySuggestionsBlockLists is currently not supported in the Amazon Web Services
GovCloud (US-West) region.

# Arguments
- `index_id`: The identifier of the index for a list of all block lists that exist for that
  index. For information on the current quota limits for block lists, see Quotas for Amazon
  Kendra.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of block lists to return.
- `"NextToken"`: If the previous response was incomplete (because there is more data to
  retrieve), Amazon Kendra returns a pagination token in the response. You can use this
  pagination token to retrieve the next set of block lists (BlockListSummaryItems).
"""
function list_query_suggestions_block_lists(
    IndexId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kendra(
        "ListQuerySuggestionsBlockLists",
        Dict{String,Any}("IndexId" => IndexId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_query_suggestions_block_lists(
    IndexId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kendra(
        "ListQuerySuggestionsBlockLists",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("IndexId" => IndexId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

Gets a list of tags associated with a specified resource. Indexes, FAQs, and data sources
can have tags associated with them.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the index, FAQ, or data source to get a
  list of tags for.

"""
function list_tags_for_resource(
    ResourceARN; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kendra(
        "ListTagsForResource",
        Dict{String,Any}("ResourceARN" => ResourceARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    ResourceARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kendra(
        "ListTagsForResource",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResourceARN" => ResourceARN), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_thesauri(index_id)
    list_thesauri(index_id, params::Dict{String,<:Any})

Lists the thesauri for an index.

# Arguments
- `index_id`: The identifier of the index with one or more thesauri.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of thesauri to return.
- `"NextToken"`: If the previous response was incomplete (because there is more data to
  retrieve), Amazon Kendra returns a pagination token in the response. You can use this
  pagination token to retrieve the next set of thesauri (ThesaurusSummaryItems).
"""
function list_thesauri(IndexId; aws_config::AbstractAWSConfig=current_aws_config())
    return kendra(
        "ListThesauri",
        Dict{String,Any}("IndexId" => IndexId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_thesauri(
    IndexId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kendra(
        "ListThesauri",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("IndexId" => IndexId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_principal_mapping(group_id, group_members, index_id)
    put_principal_mapping(group_id, group_members, index_id, params::Dict{String,<:Any})

Maps users to their groups so that you only need to provide the user ID when you issue the
query. You can also map sub groups to groups. For example, the group \"Company Intellectual
Property Teams\" includes sub groups \"Research\" and \"Engineering\". These sub groups
include their own list of users or people who work in these teams. Only users who work in
research and engineering, and therefore belong in the intellectual property group, can see
top-secret company documents in their search results. This is useful for user context
filtering, where search results are filtered based on the user or their group access to
documents. For more information, see Filtering on user context. If more than five PUT
actions for a group are currently processing, a validation exception is thrown.

# Arguments
- `group_id`: The identifier of the group you want to map its users to.
- `group_members`: The list that contains your users or sub groups that belong the same
  group. For example, the group \"Company\" includes the user \"CEO\" and the sub groups
  \"Research\", \"Engineering\", and \"Sales and Marketing\". If you have more than 1000
  users and/or sub groups for a single group, you need to provide the path to the S3 file
  that lists your users and sub groups for a group. Your sub groups can contain more than
  1000 users, but the list of sub groups that belong to a group (and/or users) must be no
  more than 1000.
- `index_id`: The identifier of the index you want to map users to their groups.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DataSourceId"`: The identifier of the data source you want to map users to their
  groups. This is useful if a group is tied to multiple data sources, but you only want the
  group to access documents of a certain data source. For example, the groups \"Research\",
  \"Engineering\", and \"Sales and Marketing\" are all tied to the company's documents stored
  in the data sources Confluence and Salesforce. However, \"Sales and Marketing\" team only
  needs access to customer-related documents stored in Salesforce.
- `"OrderingId"`: The timestamp identifier you specify to ensure Amazon Kendra does not
  override the latest PUT action with previous actions. The highest number ID, which is the
  ordering ID, is the latest action you want to process and apply on top of other actions
  with lower number IDs. This prevents previous actions with lower number IDs from possibly
  overriding the latest action. The ordering ID can be the Unix time of the last update you
  made to a group members list. You would then provide this list when calling
  PutPrincipalMapping. This ensures your PUT action for that updated group with the latest
  members list doesn't get overwritten by earlier PUT actions for the same group which are
  yet to be processed. The default ordering ID is the current Unix time in milliseconds that
  the action was received by Amazon Kendra.
- `"RoleArn"`: The Amazon Resource Name (ARN) of a role that has access to the S3 file that
  contains your list of users or sub groups that belong to a group. For more information, see
  IAM roles for Amazon Kendra.
"""
function put_principal_mapping(
    GroupId, GroupMembers, IndexId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kendra(
        "PutPrincipalMapping",
        Dict{String,Any}(
            "GroupId" => GroupId, "GroupMembers" => GroupMembers, "IndexId" => IndexId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_principal_mapping(
    GroupId,
    GroupMembers,
    IndexId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kendra(
        "PutPrincipalMapping",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "GroupId" => GroupId,
                    "GroupMembers" => GroupMembers,
                    "IndexId" => IndexId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    query(index_id)
    query(index_id, params::Dict{String,<:Any})

Searches an index given an input query.  If you are working with large language models
(LLMs) or implementing retrieval augmented generation (RAG) systems, you can use Amazon
Kendra's Retrieve API, which can return longer semantically relevant passages. We recommend
using the Retrieve API instead of filing a service limit increase to increase the Query API
document excerpt length.  You can configure boosting or relevance tuning at the query level
to override boosting at the index level, filter based on document fields/attributes and
faceted search, and filter based on the user or their group access to documents. You can
also include certain fields in the response that might provide useful additional
information. A query response contains three types of results.   Relevant suggested
answers. The answers can be either a text excerpt or table excerpt. The answer can be
highlighted in the excerpt.   Matching FAQs or questions-answer from your FAQ file.
Relevant documents. This result type includes an excerpt of the document with the document
title. The searched terms can be highlighted in the excerpt.   You can specify that the
query return only one type of result using the QueryResultTypeFilter parameter. Each query
returns the 100 most relevant results. If you filter result type to only question-answers,
a maximum of four results are returned. If you filter result type to only answers, a
maximum of three results are returned.

# Arguments
- `index_id`: The identifier of the index for the search.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AttributeFilter"`: Filters search results by document fields/attributes. You can only
  provide one attribute filter; however, the AndAllFilters, NotFilter, and OrAllFilters
  parameters contain a list of other filters. The AttributeFilter parameter means you can
  create a set of filtering rules that a document must satisfy to be included in the query
  results.
- `"CollapseConfiguration"`: Provides configuration to determine how to group results by
  document attribute value, and how to display them (collapsed or expanded) under a
  designated primary document for each group.
- `"DocumentRelevanceOverrideConfigurations"`: Overrides relevance tuning configurations of
  fields/attributes set at the index level. If you use this API to override the relevance
  tuning configured at the index level, but there is no relevance tuning configured at the
  index level, then Amazon Kendra does not apply any relevance tuning. If there is relevance
  tuning configured for fields at the index level, and you use this API to override only some
  of these fields, then for the fields you did not override, the importance is set to 1.
- `"Facets"`: An array of documents fields/attributes for faceted search. Amazon Kendra
  returns a count for each field key specified. This helps your users narrow their search.
- `"PageNumber"`: Query results are returned in pages the size of the PageSize parameter.
  By default, Amazon Kendra returns the first page of results. Use this parameter to get
  result pages after the first one.
- `"PageSize"`: Sets the number of results that are returned in each page of results. The
  default page size is 10. The maximum number of results returned is 100. If you ask for more
  than 100 results, only 100 are returned.
- `"QueryResultTypeFilter"`: Sets the type of query result or response. Only results for
  the specified type are returned.
- `"QueryText"`: The input query text for the search. Amazon Kendra truncates queries at 30
  token words, which excludes punctuation and stop words. Truncation still applies if you use
  Boolean or more advanced, complex queries. For example, Timeoff AND October AND Category:HR
  is counted as 3 tokens: timeoff, october, hr. For more information, see Searching with
  advanced query syntax in the Amazon Kendra Developer Guide.
- `"RequestedDocumentAttributes"`: An array of document fields/attributes to include in the
  response. You can limit the response to include certain document fields. By default, all
  document attributes are included in the response.
- `"SortingConfiguration"`: Provides information that determines how the results of the
  query are sorted. You can set the field that Amazon Kendra should sort the results on, and
  specify whether the results should be sorted in ascending or descending order. In the case
  of ties in sorting the results, the results are sorted by relevance. If you don't provide
  sorting configuration, the results are sorted by the relevance that Amazon Kendra
  determines for the result.
- `"SortingConfigurations"`: Provides configuration information to determine how the
  results of a query are sorted. You can set upto 3 fields that Amazon Kendra should sort the
  results on, and specify whether the results should be sorted in ascending or descending
  order. The sort field quota can be increased. If you don't provide a sorting configuration,
  the results are sorted by the relevance that Amazon Kendra determines for the result. In
  the case of ties in sorting the results, the results are sorted by relevance.
- `"SpellCorrectionConfiguration"`: Enables suggested spell corrections for queries.
- `"UserContext"`: The user context token or user and group information.
- `"VisitorId"`: Provides an identifier for a specific user. The VisitorId should be a
  unique identifier, such as a GUID. Don't use personally identifiable information, such as
  the user's email address, as the VisitorId.
"""
function query(IndexId; aws_config::AbstractAWSConfig=current_aws_config())
    return kendra(
        "Query",
        Dict{String,Any}("IndexId" => IndexId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function query(
    IndexId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kendra(
        "Query",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("IndexId" => IndexId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    retrieve(index_id, query_text)
    retrieve(index_id, query_text, params::Dict{String,<:Any})

Retrieves relevant passages or text excerpts given an input query. This API is similar to
the Query API. However, by default, the Query API only returns excerpt passages of up to
100 token words. With the Retrieve API, you can retrieve longer passages of up to 200 token
words and up to 100 semantically relevant passages. This doesn't include question-answer or
FAQ type responses from your index. The passages are text excerpts that can be semantically
extracted from multiple documents and multiple parts of the same document. If in extreme
cases your documents produce zero passages using the Retrieve API, you can alternatively
use the Query API and its types of responses. You can also do the following:   Override
boosting at the index level   Filter based on document fields or attributes   Filter based
on the user or their group access to documents   View the confidence score bucket for a
retrieved passage result. The confidence bucket provides a relative ranking that indicates
how confident Amazon Kendra is that the response is relevant to the query.  Confidence
score buckets are currently available only for English.    You can also include certain
fields in the response that might provide useful additional information. The Retrieve API
shares the number of query capacity units that you set for your index. For more information
on what's included in a single capacity unit and the default base capacity for an index,
see Adjusting capacity.

# Arguments
- `index_id`: The identifier of the index to retrieve relevant passages for the search.
- `query_text`: The input query text to retrieve relevant passages for the search. Amazon
  Kendra truncates queries at 30 token words, which excludes punctuation and stop words.
  Truncation still applies if you use Boolean or more advanced, complex queries. For example,
  Timeoff AND October AND Category:HR is counted as 3 tokens: timeoff, october, hr. For more
  information, see Searching with advanced query syntax in the Amazon Kendra Developer Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AttributeFilter"`: Filters search results by document fields/attributes. You can only
  provide one attribute filter; however, the AndAllFilters, NotFilter, and OrAllFilters
  parameters contain a list of other filters. The AttributeFilter parameter means you can
  create a set of filtering rules that a document must satisfy to be included in the query
  results.
- `"DocumentRelevanceOverrideConfigurations"`: Overrides relevance tuning configurations of
  fields/attributes set at the index level. If you use this API to override the relevance
  tuning configured at the index level, but there is no relevance tuning configured at the
  index level, then Amazon Kendra does not apply any relevance tuning. If there is relevance
  tuning configured for fields at the index level, and you use this API to override only some
  of these fields, then for the fields you did not override, the importance is set to 1.
- `"PageNumber"`: Retrieved relevant passages are returned in pages the size of the
  PageSize parameter. By default, Amazon Kendra returns the first page of results. Use this
  parameter to get result pages after the first one.
- `"PageSize"`: Sets the number of retrieved relevant passages that are returned in each
  page of results. The default page size is 10. The maximum number of results returned is
  100. If you ask for more than 100 results, only 100 are returned.
- `"RequestedDocumentAttributes"`: A list of document fields/attributes to include in the
  response. You can limit the response to include certain document fields. By default, all
  document fields are included in the response.
- `"UserContext"`: The user context token or user and group information.
"""
function retrieve(IndexId, QueryText; aws_config::AbstractAWSConfig=current_aws_config())
    return kendra(
        "Retrieve",
        Dict{String,Any}("IndexId" => IndexId, "QueryText" => QueryText);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function retrieve(
    IndexId,
    QueryText,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kendra(
        "Retrieve",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("IndexId" => IndexId, "QueryText" => QueryText),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_data_source_sync_job(id, index_id)
    start_data_source_sync_job(id, index_id, params::Dict{String,<:Any})

Starts a synchronization job for a data source connector. If a synchronization job is
already in progress, Amazon Kendra returns a ResourceInUseException exception. Re-syncing
your data source with your index after modifying, adding, or deleting documents from your
data source respository could take up to an hour or more, depending on the number of
documents to sync.

# Arguments
- `id`: The identifier of the data source connector to synchronize.
- `index_id`: The identifier of the index used with the data source connector.

"""
function start_data_source_sync_job(
    Id, IndexId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kendra(
        "StartDataSourceSyncJob",
        Dict{String,Any}("Id" => Id, "IndexId" => IndexId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_data_source_sync_job(
    Id,
    IndexId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kendra(
        "StartDataSourceSyncJob",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Id" => Id, "IndexId" => IndexId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    stop_data_source_sync_job(id, index_id)
    stop_data_source_sync_job(id, index_id, params::Dict{String,<:Any})

Stops a synchronization job that is currently running. You can't stop a scheduled
synchronization job.

# Arguments
- `id`: The identifier of the data source connector for which to stop the synchronization
  jobs.
- `index_id`: The identifier of the index used with the data source connector.

"""
function stop_data_source_sync_job(
    Id, IndexId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kendra(
        "StopDataSourceSyncJob",
        Dict{String,Any}("Id" => Id, "IndexId" => IndexId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function stop_data_source_sync_job(
    Id,
    IndexId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kendra(
        "StopDataSourceSyncJob",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Id" => Id, "IndexId" => IndexId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    submit_feedback(index_id, query_id)
    submit_feedback(index_id, query_id, params::Dict{String,<:Any})

Enables you to provide feedback to Amazon Kendra to improve the performance of your index.
SubmitFeedback is currently not supported in the Amazon Web Services GovCloud (US-West)
region.

# Arguments
- `index_id`: The identifier of the index that was queried.
- `query_id`: The identifier of the specific query for which you are submitting feedback.
  The query ID is returned in the response to the Query API.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClickFeedbackItems"`: Tells Amazon Kendra that a particular search result link was
  chosen by the user.
- `"RelevanceFeedbackItems"`: Provides Amazon Kendra with relevant or not relevant feedback
  for whether a particular item was relevant to the search.
"""
function submit_feedback(
    IndexId, QueryId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kendra(
        "SubmitFeedback",
        Dict{String,Any}("IndexId" => IndexId, "QueryId" => QueryId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function submit_feedback(
    IndexId,
    QueryId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kendra(
        "SubmitFeedback",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("IndexId" => IndexId, "QueryId" => QueryId), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Adds the specified tag to the specified index, FAQ, or data source resource. If the tag
already exists, the existing value is replaced with the new value.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the index, FAQ, or data source to tag.
- `tags`: A list of tag keys to add to the index, FAQ, or data source. If a tag already
  exists, the existing value is replaced with the new value.

"""
function tag_resource(ResourceARN, Tags; aws_config::AbstractAWSConfig=current_aws_config())
    return kendra(
        "TagResource",
        Dict{String,Any}("ResourceARN" => ResourceARN, "Tags" => Tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    ResourceARN,
    Tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kendra(
        "TagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceARN" => ResourceARN, "Tags" => Tags),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Removes a tag from an index, FAQ, or a data source.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the index, FAQ, or data source to
  remove the tag from.
- `tag_keys`: A list of tag keys to remove from the index, FAQ, or data source. If a tag
  key does not exist on the resource, it is ignored.

"""
function untag_resource(
    ResourceARN, TagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kendra(
        "UntagResource",
        Dict{String,Any}("ResourceARN" => ResourceARN, "TagKeys" => TagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    ResourceARN,
    TagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kendra(
        "UntagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceARN" => ResourceARN, "TagKeys" => TagKeys),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_access_control_configuration(id, index_id)
    update_access_control_configuration(id, index_id, params::Dict{String,<:Any})

Updates an access control configuration for your documents in an index. This includes user
and group access information for your documents. This is useful for user context filtering,
where search results are filtered based on the user or their group access to documents. You
can update an access control configuration you created without indexing all of your
documents again. For example, your index contains top-secret company documents that only
certain employees or users should access. You created an 'allow' access control
configuration for one user who recently joined the 'top-secret' team, switching from a team
with 'deny' access to top-secret documents. However, the user suddenly returns to their
previous team and should no longer have access to top secret documents. You can update the
access control configuration to re-configure access control for your documents as
circumstances change. You call the BatchPutDocument API to apply the updated access control
configuration, with the AccessControlConfigurationId included in the Document object. If
you use an S3 bucket as a data source, you synchronize your data source to apply the
AccessControlConfigurationId in the .metadata.json file. Amazon Kendra currently only
supports access control configuration for S3 data sources and documents indexed using the
BatchPutDocument API.

# Arguments
- `id`: The identifier of the access control configuration you want to update.
- `index_id`: The identifier of the index for an access control configuration.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AccessControlList"`: Information you want to update on principals (users and/or groups)
  and which documents they should have access to. This is useful for user context filtering,
  where search results are filtered based on the user or their group access to documents.
- `"Description"`: A new description for the access control configuration.
- `"HierarchicalAccessControlList"`: The updated list of principal lists that define the
  hierarchy for which documents users should have access to.
- `"Name"`: A new name for the access control configuration.
"""
function update_access_control_configuration(
    Id, IndexId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kendra(
        "UpdateAccessControlConfiguration",
        Dict{String,Any}("Id" => Id, "IndexId" => IndexId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_access_control_configuration(
    Id,
    IndexId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kendra(
        "UpdateAccessControlConfiguration",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Id" => Id, "IndexId" => IndexId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_data_source(id, index_id)
    update_data_source(id, index_id, params::Dict{String,<:Any})

Updates an Amazon Kendra data source connector.

# Arguments
- `id`: The identifier of the data source connector you want to update.
- `index_id`: The identifier of the index used with the data source connector.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Configuration"`: Configuration information you want to update for the data source
  connector.
- `"CustomDocumentEnrichmentConfiguration"`: Configuration information you want to update
  for altering document metadata and content during the document ingestion process. For more
  information on how to create, modify and delete document metadata, or make other content
  alterations when you ingest documents into Amazon Kendra, see Customizing document metadata
  during the ingestion process.
- `"Description"`: A new description for the data source connector.
- `"LanguageCode"`: The code for a language you want to update for the data source
  connector. This allows you to support a language for all documents when updating the data
  source. English is supported by default. For more information on supported languages,
  including their codes, see Adding documents in languages other than English.
- `"Name"`: A new name for the data source connector.
- `"RoleArn"`: The Amazon Resource Name (ARN) of a role with permission to access the data
  source and required resources. For more information, see IAM roles for Amazon Kendra.
- `"Schedule"`: The sync schedule you want to update for the data source connector.
- `"VpcConfiguration"`: Configuration information for an Amazon Virtual Private Cloud to
  connect to your data source. For more information, see Configuring a VPC.
"""
function update_data_source(Id, IndexId; aws_config::AbstractAWSConfig=current_aws_config())
    return kendra(
        "UpdateDataSource",
        Dict{String,Any}("Id" => Id, "IndexId" => IndexId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_data_source(
    Id,
    IndexId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kendra(
        "UpdateDataSource",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Id" => Id, "IndexId" => IndexId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_experience(id, index_id)
    update_experience(id, index_id, params::Dict{String,<:Any})

Updates your Amazon Kendra experience such as a search application. For more information on
creating a search application experience, see Building a search experience with no code.

# Arguments
- `id`: The identifier of your Amazon Kendra experience you want to update.
- `index_id`: The identifier of the index for your Amazon Kendra experience.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Configuration"`: Configuration information you want to update for your Amazon Kendra
  experience.
- `"Description"`: A new description for your Amazon Kendra experience.
- `"Name"`: A new name for your Amazon Kendra experience.
- `"RoleArn"`: The Amazon Resource Name (ARN) of a role with permission to access Query
  API, QuerySuggestions API, SubmitFeedback API, and IAM Identity Center that stores your
  user and group information. For more information, see IAM roles for Amazon Kendra.
"""
function update_experience(Id, IndexId; aws_config::AbstractAWSConfig=current_aws_config())
    return kendra(
        "UpdateExperience",
        Dict{String,Any}("Id" => Id, "IndexId" => IndexId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_experience(
    Id,
    IndexId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kendra(
        "UpdateExperience",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Id" => Id, "IndexId" => IndexId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_featured_results_set(featured_results_set_id, index_id)
    update_featured_results_set(featured_results_set_id, index_id, params::Dict{String,<:Any})

Updates a set of featured results. Features results are placed above all other results for
certain queries. You map specific queries to specific documents for featuring in the
results. If a query contains an exact match of a query, then one or more specific documents
are featured in the search results.

# Arguments
- `featured_results_set_id`: The identifier of the set of featured results that you want to
  update.
- `index_id`: The identifier of the index used for featuring results.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: A new description for the set of featured results.
- `"FeaturedDocuments"`: A list of document IDs for the documents you want to feature at
  the top of the search results page. For more information on the list of featured documents,
  see FeaturedResultsSet.
- `"FeaturedResultsSetName"`: A new name for the set of featured results.
- `"QueryTexts"`: A list of queries for featuring results. For more information on the list
  of queries, see FeaturedResultsSet.
- `"Status"`: You can set the status to ACTIVE or INACTIVE. When the value is ACTIVE,
  featured results are ready for use. You can still configure your settings before setting
  the status to ACTIVE. The queries you specify for featured results must be unique per
  featured results set for each index, whether the status is ACTIVE or INACTIVE.
"""
function update_featured_results_set(
    FeaturedResultsSetId, IndexId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kendra(
        "UpdateFeaturedResultsSet",
        Dict{String,Any}(
            "FeaturedResultsSetId" => FeaturedResultsSetId, "IndexId" => IndexId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_featured_results_set(
    FeaturedResultsSetId,
    IndexId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kendra(
        "UpdateFeaturedResultsSet",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "FeaturedResultsSetId" => FeaturedResultsSetId, "IndexId" => IndexId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_index(id)
    update_index(id, params::Dict{String,<:Any})

Updates an Amazon Kendra index.

# Arguments
- `id`: The identifier of the index you want to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CapacityUnits"`: Sets the number of additional document storage and query capacity
  units that should be used by the index. You can change the capacity of the index up to 5
  times per day, or make 5 API calls. If you are using extra storage units, you can't reduce
  the storage capacity below what is required to meet the storage needs for your index.
- `"Description"`: A new description for the index.
- `"DocumentMetadataConfigurationUpdates"`: The document metadata configuration you want to
  update for the index. Document metadata are fields or attributes associated with your
  documents. For example, the company department name associated with each document.
- `"Name"`: A new name for the index.
- `"RoleArn"`: An Identity and Access Management (IAM) role that gives Amazon Kendra
  permission to access Amazon CloudWatch logs and metrics.
- `"UserContextPolicy"`: The user context policy.
- `"UserGroupResolutionConfiguration"`: Gets users and groups from IAM Identity Center
  identity source. To configure this, see UserGroupResolutionConfiguration. This is useful
  for user context filtering, where search results are filtered based on the user or their
  group access to documents.
- `"UserTokenConfigurations"`: The user token configuration.
"""
function update_index(Id; aws_config::AbstractAWSConfig=current_aws_config())
    return kendra(
        "UpdateIndex",
        Dict{String,Any}("Id" => Id);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_index(
    Id, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kendra(
        "UpdateIndex",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Id" => Id), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_query_suggestions_block_list(id, index_id)
    update_query_suggestions_block_list(id, index_id, params::Dict{String,<:Any})

Updates a block list used for query suggestions for an index. Updates to a block list might
not take effect right away. Amazon Kendra needs to refresh the entire suggestions list to
apply any updates to the block list. Other changes not related to the block list apply
immediately. If a block list is updating, then you need to wait for the first update to
finish before submitting another update. Amazon Kendra supports partial updates, so you
only need to provide the fields you want to update.  UpdateQuerySuggestionsBlockList is
currently not supported in the Amazon Web Services GovCloud (US-West) region.

# Arguments
- `id`: The identifier of the block list you want to update.
- `index_id`: The identifier of the index for the block list.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: A new description for the block list.
- `"Name"`: A new name for the block list.
- `"RoleArn"`: The IAM (Identity and Access Management) role used to access the block list
  text file in S3.
- `"SourceS3Path"`: The S3 path where your block list text file sits in S3. If you update
  your block list and provide the same path to the block list text file in S3, then Amazon
  Kendra reloads the file to refresh the block list. Amazon Kendra does not automatically
  refresh your block list. You need to call the UpdateQuerySuggestionsBlockList API to
  refresh you block list. If you update your block list, then Amazon Kendra asynchronously
  refreshes all query suggestions with the latest content in the S3 file. This means changes
  might not take effect immediately.
"""
function update_query_suggestions_block_list(
    Id, IndexId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kendra(
        "UpdateQuerySuggestionsBlockList",
        Dict{String,Any}("Id" => Id, "IndexId" => IndexId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_query_suggestions_block_list(
    Id,
    IndexId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kendra(
        "UpdateQuerySuggestionsBlockList",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Id" => Id, "IndexId" => IndexId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_query_suggestions_config(index_id)
    update_query_suggestions_config(index_id, params::Dict{String,<:Any})

Updates the settings of query suggestions for an index. Amazon Kendra supports partial
updates, so you only need to provide the fields you want to update. If an update is
currently processing, you need to wait for the update to finish before making another
update. Updates to query suggestions settings might not take effect right away. The time
for your updated settings to take effect depends on the updates made and the number of
search queries in your index. You can still enable/disable query suggestions at any time.
UpdateQuerySuggestionsConfig is currently not supported in the Amazon Web Services GovCloud
(US-West) region.

# Arguments
- `index_id`:  The identifier of the index with query suggestions you want to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AttributeSuggestionsConfig"`: Configuration information for the document
  fields/attributes that you want to base query suggestions on.
- `"IncludeQueriesWithoutUserInformation"`:  TRUE to include queries without user
  information (i.e. all queries, irrespective of the user), otherwise FALSE to only include
  queries with user information. If you pass user information to Amazon Kendra along with the
  queries, you can set this flag to FALSE and instruct Amazon Kendra to only consider queries
  with user information. If you set to FALSE, Amazon Kendra only considers queries searched
  at least MinimumQueryCount times across MinimumNumberOfQueryingUsers unique users for
  suggestions. If you set to TRUE, Amazon Kendra ignores all user information and learns from
  all queries.
- `"MinimumNumberOfQueryingUsers"`: The minimum number of unique users who must search a
  query in order for the query to be eligible to suggest to your users. Increasing this
  number might decrease the number of suggestions. However, this ensures a query is searched
  by many users and is truly popular to suggest to users. How you tune this setting depends
  on your specific needs.
- `"MinimumQueryCount"`: The the minimum number of times a query must be searched in order
  to be eligible to suggest to your users. Decreasing this number increases the number of
  suggestions. However, this affects the quality of suggestions as it sets a low bar for a
  query to be considered popular to suggest to users. How you tune this setting depends on
  your specific needs.
- `"Mode"`: Set the mode to ENABLED or LEARN_ONLY. By default, Amazon Kendra enables query
  suggestions. LEARN_ONLY mode allows you to turn off query suggestions. You can to update
  this at any time. In LEARN_ONLY mode, Amazon Kendra continues to learn from new queries to
  keep suggestions up to date for when you are ready to switch to ENABLED mode again.
- `"QueryLogLookBackWindowInDays"`: How recent your queries are in your query log time
  window. The time window is the number of days from current day to past days. By default,
  Amazon Kendra sets this to 180.
"""
function update_query_suggestions_config(
    IndexId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kendra(
        "UpdateQuerySuggestionsConfig",
        Dict{String,Any}("IndexId" => IndexId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_query_suggestions_config(
    IndexId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kendra(
        "UpdateQuerySuggestionsConfig",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("IndexId" => IndexId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_thesaurus(id, index_id)
    update_thesaurus(id, index_id, params::Dict{String,<:Any})

Updates a thesaurus for an index.

# Arguments
- `id`: The identifier of the thesaurus you want to update.
- `index_id`: The identifier of the index for the thesaurus.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: A new description for the thesaurus.
- `"Name"`: A new name for the thesaurus.
- `"RoleArn"`: An IAM role that gives Amazon Kendra permissions to access thesaurus file
  specified in SourceS3Path.
- `"SourceS3Path"`:
"""
function update_thesaurus(Id, IndexId; aws_config::AbstractAWSConfig=current_aws_config())
    return kendra(
        "UpdateThesaurus",
        Dict{String,Any}("Id" => Id, "IndexId" => IndexId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_thesaurus(
    Id,
    IndexId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kendra(
        "UpdateThesaurus",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Id" => Id, "IndexId" => IndexId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
