# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: license_manager
using AWS.Compat
using AWS.UUIDs

"""
    accept_grant(grant_arn)
    accept_grant(grant_arn, params::Dict{String,<:Any})

Accepts the specified grant.

# Arguments
- `grant_arn`: Amazon Resource Name (ARN) of the grant.

"""
function accept_grant(GrantArn; aws_config::AbstractAWSConfig=current_aws_config())
    return license_manager(
        "AcceptGrant",
        Dict{String,Any}("GrantArn" => GrantArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function accept_grant(
    GrantArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return license_manager(
        "AcceptGrant",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("GrantArn" => GrantArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    check_in_license(license_consumption_token)
    check_in_license(license_consumption_token, params::Dict{String,<:Any})

Checks in the specified license. Check in a license when it is no longer in use.

# Arguments
- `license_consumption_token`: License consumption token.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Beneficiary"`: License beneficiary.
"""
function check_in_license(
    LicenseConsumptionToken; aws_config::AbstractAWSConfig=current_aws_config()
)
    return license_manager(
        "CheckInLicense",
        Dict{String,Any}("LicenseConsumptionToken" => LicenseConsumptionToken);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function check_in_license(
    LicenseConsumptionToken,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return license_manager(
        "CheckInLicense",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("LicenseConsumptionToken" => LicenseConsumptionToken),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    checkout_borrow_license(client_token, digital_signature_method, entitlements, license_arn)
    checkout_borrow_license(client_token, digital_signature_method, entitlements, license_arn, params::Dict{String,<:Any})

Checks out the specified license for offline use.

# Arguments
- `client_token`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request.
- `digital_signature_method`: Digital signature method. The possible value is JSON Web
  Signature (JWS) algorithm PS384. For more information, see RFC 7518 Digital Signature with
  RSASSA-PSS.
- `entitlements`: License entitlements. Partial checkouts are not supported.
- `license_arn`: Amazon Resource Name (ARN) of the license. The license must use the borrow
  consumption configuration.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CheckoutMetadata"`: Information about constraints.
- `"NodeId"`: Node ID.
"""
function checkout_borrow_license(
    ClientToken,
    DigitalSignatureMethod,
    Entitlements,
    LicenseArn;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return license_manager(
        "CheckoutBorrowLicense",
        Dict{String,Any}(
            "ClientToken" => ClientToken,
            "DigitalSignatureMethod" => DigitalSignatureMethod,
            "Entitlements" => Entitlements,
            "LicenseArn" => LicenseArn,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function checkout_borrow_license(
    ClientToken,
    DigitalSignatureMethod,
    Entitlements,
    LicenseArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return license_manager(
        "CheckoutBorrowLicense",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ClientToken" => ClientToken,
                    "DigitalSignatureMethod" => DigitalSignatureMethod,
                    "Entitlements" => Entitlements,
                    "LicenseArn" => LicenseArn,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    checkout_license(checkout_type, client_token, entitlements, key_fingerprint, product_sku)
    checkout_license(checkout_type, client_token, entitlements, key_fingerprint, product_sku, params::Dict{String,<:Any})

Checks out the specified license.  If the account that created the license is the same that
is performing the check out, you must specify the account as the beneficiary.

# Arguments
- `checkout_type`: Checkout type.
- `client_token`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request.
- `entitlements`: License entitlements.
- `key_fingerprint`: Key fingerprint identifying the license.
- `product_sku`: Product SKU.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Beneficiary"`: License beneficiary.
- `"NodeId"`: Node ID.
"""
function checkout_license(
    CheckoutType,
    ClientToken,
    Entitlements,
    KeyFingerprint,
    ProductSKU;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return license_manager(
        "CheckoutLicense",
        Dict{String,Any}(
            "CheckoutType" => CheckoutType,
            "ClientToken" => ClientToken,
            "Entitlements" => Entitlements,
            "KeyFingerprint" => KeyFingerprint,
            "ProductSKU" => ProductSKU,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function checkout_license(
    CheckoutType,
    ClientToken,
    Entitlements,
    KeyFingerprint,
    ProductSKU,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return license_manager(
        "CheckoutLicense",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "CheckoutType" => CheckoutType,
                    "ClientToken" => ClientToken,
                    "Entitlements" => Entitlements,
                    "KeyFingerprint" => KeyFingerprint,
                    "ProductSKU" => ProductSKU,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_grant(allowed_operations, client_token, grant_name, home_region, license_arn, principals)
    create_grant(allowed_operations, client_token, grant_name, home_region, license_arn, principals, params::Dict{String,<:Any})

Creates a grant for the specified license. A grant shares the use of license entitlements
with a specific Amazon Web Services account, an organization, or an organizational unit
(OU). For more information, see Granted licenses in License Manager in the License Manager
User Guide.

# Arguments
- `allowed_operations`: Allowed operations for the grant.
- `client_token`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request.
- `grant_name`: Grant name.
- `home_region`: Home Region of the grant.
- `license_arn`: Amazon Resource Name (ARN) of the license.
- `principals`: The grant principals. You can specify one of the following as an Amazon
  Resource Name (ARN):   An Amazon Web Services account, which includes only the account
  specified.     An organizational unit (OU), which includes all accounts in the OU.     An
  organization, which will include all accounts across your organization.

"""
function create_grant(
    AllowedOperations,
    ClientToken,
    GrantName,
    HomeRegion,
    LicenseArn,
    Principals;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return license_manager(
        "CreateGrant",
        Dict{String,Any}(
            "AllowedOperations" => AllowedOperations,
            "ClientToken" => ClientToken,
            "GrantName" => GrantName,
            "HomeRegion" => HomeRegion,
            "LicenseArn" => LicenseArn,
            "Principals" => Principals,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_grant(
    AllowedOperations,
    ClientToken,
    GrantName,
    HomeRegion,
    LicenseArn,
    Principals,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return license_manager(
        "CreateGrant",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AllowedOperations" => AllowedOperations,
                    "ClientToken" => ClientToken,
                    "GrantName" => GrantName,
                    "HomeRegion" => HomeRegion,
                    "LicenseArn" => LicenseArn,
                    "Principals" => Principals,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_grant_version(client_token, grant_arn)
    create_grant_version(client_token, grant_arn, params::Dict{String,<:Any})

Creates a new version of the specified grant. For more information, see Granted licenses in
License Manager in the License Manager User Guide.

# Arguments
- `client_token`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request.
- `grant_arn`: Amazon Resource Name (ARN) of the grant.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AllowedOperations"`: Allowed operations for the grant.
- `"GrantName"`: Grant name.
- `"Options"`: The options specified for the grant.
- `"SourceVersion"`: Current version of the grant.
- `"Status"`: Grant status.
- `"StatusReason"`: Grant status reason.
"""
function create_grant_version(
    ClientToken, GrantArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return license_manager(
        "CreateGrantVersion",
        Dict{String,Any}("ClientToken" => ClientToken, "GrantArn" => GrantArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_grant_version(
    ClientToken,
    GrantArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return license_manager(
        "CreateGrantVersion",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ClientToken" => ClientToken, "GrantArn" => GrantArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_license(beneficiary, client_token, consumption_configuration, entitlements, home_region, issuer, license_name, product_name, product_sku, validity)
    create_license(beneficiary, client_token, consumption_configuration, entitlements, home_region, issuer, license_name, product_name, product_sku, validity, params::Dict{String,<:Any})

Creates a license.

# Arguments
- `beneficiary`: License beneficiary.
- `client_token`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request.
- `consumption_configuration`: Configuration for consumption of the license. Choose a
  provisional configuration for workloads running with continuous connectivity. Choose a
  borrow configuration for workloads with offline usage.
- `entitlements`: License entitlements.
- `home_region`: Home Region for the license.
- `issuer`: License issuer.
- `license_name`: License name.
- `product_name`: Product name.
- `product_sku`: Product SKU.
- `validity`: Date and time range during which the license is valid, in ISO8601-UTC format.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"LicenseMetadata"`: Information about the license.
"""
function create_license(
    Beneficiary,
    ClientToken,
    ConsumptionConfiguration,
    Entitlements,
    HomeRegion,
    Issuer,
    LicenseName,
    ProductName,
    ProductSKU,
    Validity;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return license_manager(
        "CreateLicense",
        Dict{String,Any}(
            "Beneficiary" => Beneficiary,
            "ClientToken" => ClientToken,
            "ConsumptionConfiguration" => ConsumptionConfiguration,
            "Entitlements" => Entitlements,
            "HomeRegion" => HomeRegion,
            "Issuer" => Issuer,
            "LicenseName" => LicenseName,
            "ProductName" => ProductName,
            "ProductSKU" => ProductSKU,
            "Validity" => Validity,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_license(
    Beneficiary,
    ClientToken,
    ConsumptionConfiguration,
    Entitlements,
    HomeRegion,
    Issuer,
    LicenseName,
    ProductName,
    ProductSKU,
    Validity,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return license_manager(
        "CreateLicense",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Beneficiary" => Beneficiary,
                    "ClientToken" => ClientToken,
                    "ConsumptionConfiguration" => ConsumptionConfiguration,
                    "Entitlements" => Entitlements,
                    "HomeRegion" => HomeRegion,
                    "Issuer" => Issuer,
                    "LicenseName" => LicenseName,
                    "ProductName" => ProductName,
                    "ProductSKU" => ProductSKU,
                    "Validity" => Validity,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_license_configuration(license_counting_type, name)
    create_license_configuration(license_counting_type, name, params::Dict{String,<:Any})

Creates a license configuration. A license configuration is an abstraction of a customer
license agreement that can be consumed and enforced by License Manager. Components include
specifications for the license type (licensing by instance, socket, CPU, or vCPU), allowed
tenancy (shared tenancy, Dedicated Instance, Dedicated Host, or all of these), license
affinity to host (how long a license must be associated with a host), and the number of
licenses purchased and used.

# Arguments
- `license_counting_type`: Dimension used to track the license inventory.
- `name`: Name of the license configuration.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: Description of the license configuration.
- `"DisassociateWhenNotFound"`: When true, disassociates a resource when software is
  uninstalled.
- `"LicenseCount"`: Number of licenses managed by the license configuration.
- `"LicenseCountHardLimit"`: Indicates whether hard or soft license enforcement is used.
  Exceeding a hard limit blocks the launch of new instances.
- `"LicenseRules"`: License rules. The syntax is #name=value (for example,
  #allowedTenancy=EC2-DedicatedHost). The available rules vary by dimension, as follows.
  Cores dimension: allowedTenancy | licenseAffinityToHost | maximumCores | minimumCores
  Instances dimension: allowedTenancy | maximumCores | minimumCores | maximumSockets |
  minimumSockets | maximumVcpus | minimumVcpus     Sockets dimension: allowedTenancy |
  licenseAffinityToHost | maximumSockets | minimumSockets     vCPUs dimension: allowedTenancy
  | honorVcpuOptimization | maximumVcpus | minimumVcpus    The unit for licenseAffinityToHost
  is days and the range is 1 to 180. The possible values for allowedTenancy are EC2-Default,
  EC2-DedicatedHost, and EC2-DedicatedInstance. The possible values for honorVcpuOptimization
  are True and False.
- `"ProductInformationList"`: Product information.
- `"Tags"`: Tags to add to the license configuration.
"""
function create_license_configuration(
    LicenseCountingType, Name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return license_manager(
        "CreateLicenseConfiguration",
        Dict{String,Any}("LicenseCountingType" => LicenseCountingType, "Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_license_configuration(
    LicenseCountingType,
    Name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return license_manager(
        "CreateLicenseConfiguration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "LicenseCountingType" => LicenseCountingType, "Name" => Name
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_license_conversion_task_for_resource(destination_license_context, resource_arn, source_license_context)
    create_license_conversion_task_for_resource(destination_license_context, resource_arn, source_license_context, params::Dict{String,<:Any})

Creates a new license conversion task.

# Arguments
- `destination_license_context`: Information that identifies the license type you are
  converting to. For the structure of the destination license, see Convert a license type
  using the CLI  in the License Manager User Guide.
- `resource_arn`: Amazon Resource Name (ARN) of the resource you are converting the license
  type for.
- `source_license_context`: Information that identifies the license type you are converting
  from. For the structure of the source license, see Convert a license type using the CLI  in
  the License Manager User Guide.

"""
function create_license_conversion_task_for_resource(
    DestinationLicenseContext,
    ResourceArn,
    SourceLicenseContext;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return license_manager(
        "CreateLicenseConversionTaskForResource",
        Dict{String,Any}(
            "DestinationLicenseContext" => DestinationLicenseContext,
            "ResourceArn" => ResourceArn,
            "SourceLicenseContext" => SourceLicenseContext,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_license_conversion_task_for_resource(
    DestinationLicenseContext,
    ResourceArn,
    SourceLicenseContext,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return license_manager(
        "CreateLicenseConversionTaskForResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DestinationLicenseContext" => DestinationLicenseContext,
                    "ResourceArn" => ResourceArn,
                    "SourceLicenseContext" => SourceLicenseContext,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_license_manager_report_generator(client_token, report_context, report_frequency, report_generator_name, type)
    create_license_manager_report_generator(client_token, report_context, report_frequency, report_generator_name, type, params::Dict{String,<:Any})

Creates a report generator.

# Arguments
- `client_token`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request.
- `report_context`: Defines the type of license configuration the report generator tracks.
- `report_frequency`: Frequency by which reports are generated. Reports can be generated
  daily, monthly, or weekly.
- `report_generator_name`: Name of the report generator.
- `type`: Type of reports to generate. The following report types an be generated:
  License configuration report - Reports the number and details of consumed licenses for a
  license configuration.   Resource report - Reports the tracked licenses and resource
  consumption for a license configuration.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: Description of the report generator.
- `"Tags"`: Tags to add to the report generator.
"""
function create_license_manager_report_generator(
    ClientToken,
    ReportContext,
    ReportFrequency,
    ReportGeneratorName,
    Type;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return license_manager(
        "CreateLicenseManagerReportGenerator",
        Dict{String,Any}(
            "ClientToken" => ClientToken,
            "ReportContext" => ReportContext,
            "ReportFrequency" => ReportFrequency,
            "ReportGeneratorName" => ReportGeneratorName,
            "Type" => Type,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_license_manager_report_generator(
    ClientToken,
    ReportContext,
    ReportFrequency,
    ReportGeneratorName,
    Type,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return license_manager(
        "CreateLicenseManagerReportGenerator",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ClientToken" => ClientToken,
                    "ReportContext" => ReportContext,
                    "ReportFrequency" => ReportFrequency,
                    "ReportGeneratorName" => ReportGeneratorName,
                    "Type" => Type,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_license_version(client_token, consumption_configuration, entitlements, home_region, issuer, license_arn, license_name, product_name, status, validity)
    create_license_version(client_token, consumption_configuration, entitlements, home_region, issuer, license_arn, license_name, product_name, status, validity, params::Dict{String,<:Any})

Creates a new version of the specified license.

# Arguments
- `client_token`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request.
- `consumption_configuration`: Configuration for consumption of the license. Choose a
  provisional configuration for workloads running with continuous connectivity. Choose a
  borrow configuration for workloads with offline usage.
- `entitlements`: License entitlements.
- `home_region`: Home Region of the license.
- `issuer`: License issuer.
- `license_arn`: Amazon Resource Name (ARN) of the license.
- `license_name`: License name.
- `product_name`: Product name.
- `status`: License status.
- `validity`: Date and time range during which the license is valid, in ISO8601-UTC format.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"LicenseMetadata"`: Information about the license.
- `"SourceVersion"`: Current version of the license.
"""
function create_license_version(
    ClientToken,
    ConsumptionConfiguration,
    Entitlements,
    HomeRegion,
    Issuer,
    LicenseArn,
    LicenseName,
    ProductName,
    Status,
    Validity;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return license_manager(
        "CreateLicenseVersion",
        Dict{String,Any}(
            "ClientToken" => ClientToken,
            "ConsumptionConfiguration" => ConsumptionConfiguration,
            "Entitlements" => Entitlements,
            "HomeRegion" => HomeRegion,
            "Issuer" => Issuer,
            "LicenseArn" => LicenseArn,
            "LicenseName" => LicenseName,
            "ProductName" => ProductName,
            "Status" => Status,
            "Validity" => Validity,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_license_version(
    ClientToken,
    ConsumptionConfiguration,
    Entitlements,
    HomeRegion,
    Issuer,
    LicenseArn,
    LicenseName,
    ProductName,
    Status,
    Validity,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return license_manager(
        "CreateLicenseVersion",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ClientToken" => ClientToken,
                    "ConsumptionConfiguration" => ConsumptionConfiguration,
                    "Entitlements" => Entitlements,
                    "HomeRegion" => HomeRegion,
                    "Issuer" => Issuer,
                    "LicenseArn" => LicenseArn,
                    "LicenseName" => LicenseName,
                    "ProductName" => ProductName,
                    "Status" => Status,
                    "Validity" => Validity,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_token(client_token, license_arn)
    create_token(client_token, license_arn, params::Dict{String,<:Any})

Creates a long-lived token. A refresh token is a JWT token used to get an access token.
With an access token, you can call AssumeRoleWithWebIdentity to get role credentials that
you can use to call License Manager to manage the specified license.

# Arguments
- `client_token`: Idempotency token, valid for 10 minutes.
- `license_arn`: Amazon Resource Name (ARN) of the license. The ARN is mapped to the aud
  claim of the JWT token.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ExpirationInDays"`: Token expiration, in days, counted from token creation. The default
  is 365 days.
- `"RoleArns"`: Amazon Resource Name (ARN) of the IAM roles to embed in the token. License
  Manager does not check whether the roles are in use.
- `"TokenProperties"`: Data specified by the caller to be included in the JWT token. The
  data is mapped to the amr claim of the JWT token.
"""
function create_token(
    ClientToken, LicenseArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return license_manager(
        "CreateToken",
        Dict{String,Any}("ClientToken" => ClientToken, "LicenseArn" => LicenseArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_token(
    ClientToken,
    LicenseArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return license_manager(
        "CreateToken",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ClientToken" => ClientToken, "LicenseArn" => LicenseArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_grant(grant_arn, version)
    delete_grant(grant_arn, version, params::Dict{String,<:Any})

Deletes the specified grant.

# Arguments
- `grant_arn`: Amazon Resource Name (ARN) of the grant.
- `version`: Current version of the grant.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"StatusReason"`: The Status reason for the delete request.
"""
function delete_grant(GrantArn, Version; aws_config::AbstractAWSConfig=current_aws_config())
    return license_manager(
        "DeleteGrant",
        Dict{String,Any}("GrantArn" => GrantArn, "Version" => Version);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_grant(
    GrantArn,
    Version,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return license_manager(
        "DeleteGrant",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("GrantArn" => GrantArn, "Version" => Version),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_license(license_arn, source_version)
    delete_license(license_arn, source_version, params::Dict{String,<:Any})

Deletes the specified license.

# Arguments
- `license_arn`: Amazon Resource Name (ARN) of the license.
- `source_version`: Current version of the license.

"""
function delete_license(
    LicenseArn, SourceVersion; aws_config::AbstractAWSConfig=current_aws_config()
)
    return license_manager(
        "DeleteLicense",
        Dict{String,Any}("LicenseArn" => LicenseArn, "SourceVersion" => SourceVersion);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_license(
    LicenseArn,
    SourceVersion,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return license_manager(
        "DeleteLicense",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "LicenseArn" => LicenseArn, "SourceVersion" => SourceVersion
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_license_configuration(license_configuration_arn)
    delete_license_configuration(license_configuration_arn, params::Dict{String,<:Any})

Deletes the specified license configuration. You cannot delete a license configuration that
is in use.

# Arguments
- `license_configuration_arn`: ID of the license configuration.

"""
function delete_license_configuration(
    LicenseConfigurationArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return license_manager(
        "DeleteLicenseConfiguration",
        Dict{String,Any}("LicenseConfigurationArn" => LicenseConfigurationArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_license_configuration(
    LicenseConfigurationArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return license_manager(
        "DeleteLicenseConfiguration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("LicenseConfigurationArn" => LicenseConfigurationArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_license_manager_report_generator(license_manager_report_generator_arn)
    delete_license_manager_report_generator(license_manager_report_generator_arn, params::Dict{String,<:Any})

Deletes the specified report generator. This action deletes the report generator, which
stops it from generating future reports. The action cannot be reversed. It has no effect on
the previous reports from this generator.

# Arguments
- `license_manager_report_generator_arn`: Amazon Resource Name (ARN) of the report
  generator to be deleted.

"""
function delete_license_manager_report_generator(
    LicenseManagerReportGeneratorArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return license_manager(
        "DeleteLicenseManagerReportGenerator",
        Dict{String,Any}(
            "LicenseManagerReportGeneratorArn" => LicenseManagerReportGeneratorArn
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_license_manager_report_generator(
    LicenseManagerReportGeneratorArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return license_manager(
        "DeleteLicenseManagerReportGenerator",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "LicenseManagerReportGeneratorArn" => LicenseManagerReportGeneratorArn
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_token(token_id)
    delete_token(token_id, params::Dict{String,<:Any})

Deletes the specified token. Must be called in the license home Region.

# Arguments
- `token_id`: Token ID.

"""
function delete_token(TokenId; aws_config::AbstractAWSConfig=current_aws_config())
    return license_manager(
        "DeleteToken",
        Dict{String,Any}("TokenId" => TokenId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_token(
    TokenId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return license_manager(
        "DeleteToken",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("TokenId" => TokenId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    extend_license_consumption(license_consumption_token)
    extend_license_consumption(license_consumption_token, params::Dict{String,<:Any})

Extends the expiration date for license consumption.

# Arguments
- `license_consumption_token`: License consumption token.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request. Provides an error response if you do not have the required
  permissions.
"""
function extend_license_consumption(
    LicenseConsumptionToken; aws_config::AbstractAWSConfig=current_aws_config()
)
    return license_manager(
        "ExtendLicenseConsumption",
        Dict{String,Any}("LicenseConsumptionToken" => LicenseConsumptionToken);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function extend_license_consumption(
    LicenseConsumptionToken,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return license_manager(
        "ExtendLicenseConsumption",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("LicenseConsumptionToken" => LicenseConsumptionToken),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_access_token(token)
    get_access_token(token, params::Dict{String,<:Any})

Gets a temporary access token to use with AssumeRoleWithWebIdentity. Access tokens are
valid for one hour.

# Arguments
- `token`: Refresh token, encoded as a JWT token.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"TokenProperties"`: Token properties to validate against those present in the JWT token.
"""
function get_access_token(Token; aws_config::AbstractAWSConfig=current_aws_config())
    return license_manager(
        "GetAccessToken",
        Dict{String,Any}("Token" => Token);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_access_token(
    Token, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return license_manager(
        "GetAccessToken",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Token" => Token), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_grant(grant_arn)
    get_grant(grant_arn, params::Dict{String,<:Any})

Gets detailed information about the specified grant.

# Arguments
- `grant_arn`: Amazon Resource Name (ARN) of the grant.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Version"`: Grant version.
"""
function get_grant(GrantArn; aws_config::AbstractAWSConfig=current_aws_config())
    return license_manager(
        "GetGrant",
        Dict{String,Any}("GrantArn" => GrantArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_grant(
    GrantArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return license_manager(
        "GetGrant",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("GrantArn" => GrantArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_license(license_arn)
    get_license(license_arn, params::Dict{String,<:Any})

Gets detailed information about the specified license.

# Arguments
- `license_arn`: Amazon Resource Name (ARN) of the license.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Version"`: License version.
"""
function get_license(LicenseArn; aws_config::AbstractAWSConfig=current_aws_config())
    return license_manager(
        "GetLicense",
        Dict{String,Any}("LicenseArn" => LicenseArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_license(
    LicenseArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return license_manager(
        "GetLicense",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("LicenseArn" => LicenseArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_license_configuration(license_configuration_arn)
    get_license_configuration(license_configuration_arn, params::Dict{String,<:Any})

Gets detailed information about the specified license configuration.

# Arguments
- `license_configuration_arn`: Amazon Resource Name (ARN) of the license configuration.

"""
function get_license_configuration(
    LicenseConfigurationArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return license_manager(
        "GetLicenseConfiguration",
        Dict{String,Any}("LicenseConfigurationArn" => LicenseConfigurationArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_license_configuration(
    LicenseConfigurationArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return license_manager(
        "GetLicenseConfiguration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("LicenseConfigurationArn" => LicenseConfigurationArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_license_conversion_task(license_conversion_task_id)
    get_license_conversion_task(license_conversion_task_id, params::Dict{String,<:Any})

Gets information about the specified license type conversion task.

# Arguments
- `license_conversion_task_id`: ID of the license type conversion task to retrieve
  information on.

"""
function get_license_conversion_task(
    LicenseConversionTaskId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return license_manager(
        "GetLicenseConversionTask",
        Dict{String,Any}("LicenseConversionTaskId" => LicenseConversionTaskId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_license_conversion_task(
    LicenseConversionTaskId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return license_manager(
        "GetLicenseConversionTask",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("LicenseConversionTaskId" => LicenseConversionTaskId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_license_manager_report_generator(license_manager_report_generator_arn)
    get_license_manager_report_generator(license_manager_report_generator_arn, params::Dict{String,<:Any})

Gets information about the specified report generator.

# Arguments
- `license_manager_report_generator_arn`: Amazon Resource Name (ARN) of the report
  generator.

"""
function get_license_manager_report_generator(
    LicenseManagerReportGeneratorArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return license_manager(
        "GetLicenseManagerReportGenerator",
        Dict{String,Any}(
            "LicenseManagerReportGeneratorArn" => LicenseManagerReportGeneratorArn
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_license_manager_report_generator(
    LicenseManagerReportGeneratorArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return license_manager(
        "GetLicenseManagerReportGenerator",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "LicenseManagerReportGeneratorArn" => LicenseManagerReportGeneratorArn
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_license_usage(license_arn)
    get_license_usage(license_arn, params::Dict{String,<:Any})

Gets detailed information about the usage of the specified license.

# Arguments
- `license_arn`: Amazon Resource Name (ARN) of the license.

"""
function get_license_usage(LicenseArn; aws_config::AbstractAWSConfig=current_aws_config())
    return license_manager(
        "GetLicenseUsage",
        Dict{String,Any}("LicenseArn" => LicenseArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_license_usage(
    LicenseArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return license_manager(
        "GetLicenseUsage",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("LicenseArn" => LicenseArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_service_settings()
    get_service_settings(params::Dict{String,<:Any})

Gets the License Manager settings for the current Region.

"""
function get_service_settings(; aws_config::AbstractAWSConfig=current_aws_config())
    return license_manager(
        "GetServiceSettings"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_service_settings(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return license_manager(
        "GetServiceSettings", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_associations_for_license_configuration(license_configuration_arn)
    list_associations_for_license_configuration(license_configuration_arn, params::Dict{String,<:Any})

Lists the resource associations for the specified license configuration. Resource
associations need not consume licenses from a license configuration. For example, an AMI or
a stopped instance might not consume a license (depending on the license rules).

# Arguments
- `license_configuration_arn`: Amazon Resource Name (ARN) of a license configuration.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: Maximum number of results to return in a single call.
- `"NextToken"`: Token for the next set of results.
"""
function list_associations_for_license_configuration(
    LicenseConfigurationArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return license_manager(
        "ListAssociationsForLicenseConfiguration",
        Dict{String,Any}("LicenseConfigurationArn" => LicenseConfigurationArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_associations_for_license_configuration(
    LicenseConfigurationArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return license_manager(
        "ListAssociationsForLicenseConfiguration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("LicenseConfigurationArn" => LicenseConfigurationArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_distributed_grants()
    list_distributed_grants(params::Dict{String,<:Any})

Lists the grants distributed for the specified license.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: Filters to scope the results. The following filters are supported:
  LicenseArn     GrantStatus     GranteePrincipalARN     ProductSKU     LicenseIssuerName
- `"GrantArns"`: Amazon Resource Names (ARNs) of the grants.
- `"MaxResults"`: Maximum number of results to return in a single call.
- `"NextToken"`: Token for the next set of results.
"""
function list_distributed_grants(; aws_config::AbstractAWSConfig=current_aws_config())
    return license_manager(
        "ListDistributedGrants"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_distributed_grants(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return license_manager(
        "ListDistributedGrants",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_failures_for_license_configuration_operations(license_configuration_arn)
    list_failures_for_license_configuration_operations(license_configuration_arn, params::Dict{String,<:Any})

Lists the license configuration operations that failed.

# Arguments
- `license_configuration_arn`: Amazon Resource Name of the license configuration.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: Maximum number of results to return in a single call.
- `"NextToken"`: Token for the next set of results.
"""
function list_failures_for_license_configuration_operations(
    LicenseConfigurationArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return license_manager(
        "ListFailuresForLicenseConfigurationOperations",
        Dict{String,Any}("LicenseConfigurationArn" => LicenseConfigurationArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_failures_for_license_configuration_operations(
    LicenseConfigurationArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return license_manager(
        "ListFailuresForLicenseConfigurationOperations",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("LicenseConfigurationArn" => LicenseConfigurationArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_license_configurations()
    list_license_configurations(params::Dict{String,<:Any})

Lists the license configurations for your account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: Filters to scope the results. The following filters and logical operators
  are supported:    licenseCountingType - The dimension for which licenses are counted.
  Possible values are vCPU | Instance | Core | Socket. Logical operators are EQUALS |
  NOT_EQUALS.    enforceLicenseCount - A Boolean value that indicates whether hard license
  enforcement is used. Logical operators are EQUALS | NOT_EQUALS.    usagelimitExceeded - A
  Boolean value that indicates whether the available licenses have been exceeded. Logical
  operators are EQUALS | NOT_EQUALS.
- `"LicenseConfigurationArns"`: Amazon Resource Names (ARN) of the license configurations.
- `"MaxResults"`: Maximum number of results to return in a single call.
- `"NextToken"`: Token for the next set of results.
"""
function list_license_configurations(; aws_config::AbstractAWSConfig=current_aws_config())
    return license_manager(
        "ListLicenseConfigurations"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_license_configurations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return license_manager(
        "ListLicenseConfigurations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_license_conversion_tasks()
    list_license_conversion_tasks(params::Dict{String,<:Any})

Lists the license type conversion tasks for your account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`:  Filters to scope the results. Valid filters are ResourceArns and Status.
- `"MaxResults"`: Maximum number of results to return in a single call.
- `"NextToken"`: Token for the next set of results.
"""
function list_license_conversion_tasks(; aws_config::AbstractAWSConfig=current_aws_config())
    return license_manager(
        "ListLicenseConversionTasks"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_license_conversion_tasks(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return license_manager(
        "ListLicenseConversionTasks",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_license_manager_report_generators()
    list_license_manager_report_generators(params::Dict{String,<:Any})

Lists the report generators for your account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: Filters to scope the results. The following filters are supported:
  LicenseConfigurationArn
- `"MaxResults"`: Maximum number of results to return in a single call.
- `"NextToken"`: Token for the next set of results.
"""
function list_license_manager_report_generators(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return license_manager(
        "ListLicenseManagerReportGenerators";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_license_manager_report_generators(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return license_manager(
        "ListLicenseManagerReportGenerators",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_license_specifications_for_resource(resource_arn)
    list_license_specifications_for_resource(resource_arn, params::Dict{String,<:Any})

Describes the license configurations for the specified resource.

# Arguments
- `resource_arn`: Amazon Resource Name (ARN) of a resource that has an associated license
  configuration.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: Maximum number of results to return in a single call.
- `"NextToken"`: Token for the next set of results.
"""
function list_license_specifications_for_resource(
    ResourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return license_manager(
        "ListLicenseSpecificationsForResource",
        Dict{String,Any}("ResourceArn" => ResourceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_license_specifications_for_resource(
    ResourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return license_manager(
        "ListLicenseSpecificationsForResource",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResourceArn" => ResourceArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_license_versions(license_arn)
    list_license_versions(license_arn, params::Dict{String,<:Any})

Lists all versions of the specified license.

# Arguments
- `license_arn`: Amazon Resource Name (ARN) of the license.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: Maximum number of results to return in a single call.
- `"NextToken"`: Token for the next set of results.
"""
function list_license_versions(
    LicenseArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return license_manager(
        "ListLicenseVersions",
        Dict{String,Any}("LicenseArn" => LicenseArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_license_versions(
    LicenseArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return license_manager(
        "ListLicenseVersions",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("LicenseArn" => LicenseArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_licenses()
    list_licenses(params::Dict{String,<:Any})

Lists the licenses for your account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: Filters to scope the results. The following filters are supported:
  Beneficiary     ProductSKU     Fingerprint     Status
- `"LicenseArns"`: Amazon Resource Names (ARNs) of the licenses.
- `"MaxResults"`: Maximum number of results to return in a single call.
- `"NextToken"`: Token for the next set of results.
"""
function list_licenses(; aws_config::AbstractAWSConfig=current_aws_config())
    return license_manager(
        "ListLicenses"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_licenses(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return license_manager(
        "ListLicenses", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_received_grants()
    list_received_grants(params::Dict{String,<:Any})

Lists grants that are received. Received grants are grants created while specifying the
recipient as this Amazon Web Services account, your organization, or an organizational unit
(OU) to which this member account belongs.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: Filters to scope the results. The following filters are supported:
  ProductSKU     LicenseIssuerName     LicenseArn     GrantStatus     GranterAccountId
- `"GrantArns"`: Amazon Resource Names (ARNs) of the grants.
- `"MaxResults"`: Maximum number of results to return in a single call.
- `"NextToken"`: Token for the next set of results.
"""
function list_received_grants(; aws_config::AbstractAWSConfig=current_aws_config())
    return license_manager(
        "ListReceivedGrants"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_received_grants(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return license_manager(
        "ListReceivedGrants", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_received_grants_for_organization(license_arn)
    list_received_grants_for_organization(license_arn, params::Dict{String,<:Any})

Lists the grants received for all accounts in the organization.

# Arguments
- `license_arn`: The Amazon Resource Name (ARN) of the received license.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: Filters to scope the results. The following filters are supported:
  ParentArn     GranteePrincipalArn
- `"MaxResults"`: Maximum number of results to return in a single call.
- `"NextToken"`: Token for the next set of results.
"""
function list_received_grants_for_organization(
    LicenseArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return license_manager(
        "ListReceivedGrantsForOrganization",
        Dict{String,Any}("LicenseArn" => LicenseArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_received_grants_for_organization(
    LicenseArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return license_manager(
        "ListReceivedGrantsForOrganization",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("LicenseArn" => LicenseArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_received_licenses()
    list_received_licenses(params::Dict{String,<:Any})

Lists received licenses.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: Filters to scope the results. The following filters are supported:
  ProductSKU     Status     Fingerprint     IssuerName     Beneficiary
- `"LicenseArns"`: Amazon Resource Names (ARNs) of the licenses.
- `"MaxResults"`: Maximum number of results to return in a single call.
- `"NextToken"`: Token for the next set of results.
"""
function list_received_licenses(; aws_config::AbstractAWSConfig=current_aws_config())
    return license_manager(
        "ListReceivedLicenses"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_received_licenses(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return license_manager(
        "ListReceivedLicenses",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_received_licenses_for_organization()
    list_received_licenses_for_organization(params::Dict{String,<:Any})

Lists the licenses received for all accounts in the organization.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: Filters to scope the results. The following filters are supported:
  Beneficiary     ProductSKU
- `"MaxResults"`: Maximum number of results to return in a single call.
- `"NextToken"`: Token for the next set of results.
"""
function list_received_licenses_for_organization(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return license_manager(
        "ListReceivedLicensesForOrganization";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_received_licenses_for_organization(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return license_manager(
        "ListReceivedLicensesForOrganization",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_resource_inventory()
    list_resource_inventory(params::Dict{String,<:Any})

Lists resources managed using Systems Manager inventory.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: Filters to scope the results. The following filters and logical operators
  are supported:    account_id - The ID of the Amazon Web Services account that owns the
  resource. Logical operators are EQUALS | NOT_EQUALS.    application_name - The name of the
  application. Logical operators are EQUALS | BEGINS_WITH.    license_included - The type of
  license included. Logical operators are EQUALS | NOT_EQUALS. Possible values are
  sql-server-enterprise | sql-server-standard | sql-server-web | windows-server-datacenter.
   platform - The platform of the resource. Logical operators are EQUALS | BEGINS_WITH.
  resource_id - The ID of the resource. Logical operators are EQUALS | NOT_EQUALS.
  tag:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Logical
  operators are EQUALS (single account) or EQUALS | NOT_EQUALS (cross account).
- `"MaxResults"`: Maximum number of results to return in a single call.
- `"NextToken"`: Token for the next set of results.
"""
function list_resource_inventory(; aws_config::AbstractAWSConfig=current_aws_config())
    return license_manager(
        "ListResourceInventory"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_resource_inventory(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return license_manager(
        "ListResourceInventory",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

Lists the tags for the specified license configuration.

# Arguments
- `resource_arn`: Amazon Resource Name (ARN) of the license configuration.

"""
function list_tags_for_resource(
    ResourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return license_manager(
        "ListTagsForResource",
        Dict{String,Any}("ResourceArn" => ResourceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    ResourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return license_manager(
        "ListTagsForResource",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResourceArn" => ResourceArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tokens()
    list_tokens(params::Dict{String,<:Any})

Lists your tokens.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: Filters to scope the results. The following filter is supported:
  LicenseArns
- `"MaxResults"`: Maximum number of results to return in a single call.
- `"NextToken"`: Token for the next set of results.
- `"TokenIds"`: Token IDs.
"""
function list_tokens(; aws_config::AbstractAWSConfig=current_aws_config())
    return license_manager(
        "ListTokens"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_tokens(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return license_manager(
        "ListTokens", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_usage_for_license_configuration(license_configuration_arn)
    list_usage_for_license_configuration(license_configuration_arn, params::Dict{String,<:Any})

Lists all license usage records for a license configuration, displaying license consumption
details by resource at a selected point in time. Use this action to audit the current
license consumption for any license inventory and configuration.

# Arguments
- `license_configuration_arn`: Amazon Resource Name (ARN) of the license configuration.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: Filters to scope the results. The following filters and logical operators
  are supported:    resourceArn - The ARN of the license configuration resource. Logical
  operators are EQUALS | NOT_EQUALS.    resourceType - The resource type (EC2_INSTANCE |
  EC2_HOST | EC2_AMI | SYSTEMS_MANAGER_MANAGED_INSTANCE). Logical operators are EQUALS |
  NOT_EQUALS.    resourceAccount - The ID of the account that owns the resource. Logical
  operators are EQUALS | NOT_EQUALS.
- `"MaxResults"`: Maximum number of results to return in a single call.
- `"NextToken"`: Token for the next set of results.
"""
function list_usage_for_license_configuration(
    LicenseConfigurationArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return license_manager(
        "ListUsageForLicenseConfiguration",
        Dict{String,Any}("LicenseConfigurationArn" => LicenseConfigurationArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_usage_for_license_configuration(
    LicenseConfigurationArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return license_manager(
        "ListUsageForLicenseConfiguration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("LicenseConfigurationArn" => LicenseConfigurationArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    reject_grant(grant_arn)
    reject_grant(grant_arn, params::Dict{String,<:Any})

Rejects the specified grant.

# Arguments
- `grant_arn`: Amazon Resource Name (ARN) of the grant.

"""
function reject_grant(GrantArn; aws_config::AbstractAWSConfig=current_aws_config())
    return license_manager(
        "RejectGrant",
        Dict{String,Any}("GrantArn" => GrantArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function reject_grant(
    GrantArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return license_manager(
        "RejectGrant",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("GrantArn" => GrantArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Adds the specified tags to the specified license configuration.

# Arguments
- `resource_arn`: Amazon Resource Name (ARN) of the license configuration.
- `tags`: One or more tags.

"""
function tag_resource(ResourceArn, Tags; aws_config::AbstractAWSConfig=current_aws_config())
    return license_manager(
        "TagResource",
        Dict{String,Any}("ResourceArn" => ResourceArn, "Tags" => Tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    ResourceArn,
    Tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return license_manager(
        "TagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceArn" => ResourceArn, "Tags" => Tags),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Removes the specified tags from the specified license configuration.

# Arguments
- `resource_arn`: Amazon Resource Name (ARN) of the license configuration.
- `tag_keys`: Keys identifying the tags to remove.

"""
function untag_resource(
    ResourceArn, TagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return license_manager(
        "UntagResource",
        Dict{String,Any}("ResourceArn" => ResourceArn, "TagKeys" => TagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    ResourceArn,
    TagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return license_manager(
        "UntagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceArn" => ResourceArn, "TagKeys" => TagKeys),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_license_configuration(license_configuration_arn)
    update_license_configuration(license_configuration_arn, params::Dict{String,<:Any})

Modifies the attributes of an existing license configuration.

# Arguments
- `license_configuration_arn`: Amazon Resource Name (ARN) of the license configuration.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: New description of the license configuration.
- `"DisassociateWhenNotFound"`: When true, disassociates a resource when software is
  uninstalled.
- `"LicenseConfigurationStatus"`: New status of the license configuration.
- `"LicenseCount"`: New number of licenses managed by the license configuration.
- `"LicenseCountHardLimit"`: New hard limit of the number of available licenses.
- `"LicenseRules"`: New license rule. The only rule that you can add after you create a
  license configuration is licenseAffinityToHost.
- `"Name"`: New name of the license configuration.
- `"ProductInformationList"`: New product information.
"""
function update_license_configuration(
    LicenseConfigurationArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return license_manager(
        "UpdateLicenseConfiguration",
        Dict{String,Any}("LicenseConfigurationArn" => LicenseConfigurationArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_license_configuration(
    LicenseConfigurationArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return license_manager(
        "UpdateLicenseConfiguration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("LicenseConfigurationArn" => LicenseConfigurationArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_license_manager_report_generator(client_token, license_manager_report_generator_arn, report_context, report_frequency, report_generator_name, type)
    update_license_manager_report_generator(client_token, license_manager_report_generator_arn, report_context, report_frequency, report_generator_name, type, params::Dict{String,<:Any})

Updates a report generator. After you make changes to a report generator, it starts
generating new reports within 60 minutes of being updated.

# Arguments
- `client_token`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request.
- `license_manager_report_generator_arn`: Amazon Resource Name (ARN) of the report
  generator to update.
- `report_context`: The report context.
- `report_frequency`: Frequency by which reports are generated.
- `report_generator_name`: Name of the report generator.
- `type`: Type of reports to generate. The following report types are supported:   License
  configuration report - Reports the number and details of consumed licenses for a license
  configuration.   Resource report - Reports the tracked licenses and resource consumption
  for a license configuration.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: Description of the report generator.
"""
function update_license_manager_report_generator(
    ClientToken,
    LicenseManagerReportGeneratorArn,
    ReportContext,
    ReportFrequency,
    ReportGeneratorName,
    Type;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return license_manager(
        "UpdateLicenseManagerReportGenerator",
        Dict{String,Any}(
            "ClientToken" => ClientToken,
            "LicenseManagerReportGeneratorArn" => LicenseManagerReportGeneratorArn,
            "ReportContext" => ReportContext,
            "ReportFrequency" => ReportFrequency,
            "ReportGeneratorName" => ReportGeneratorName,
            "Type" => Type,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_license_manager_report_generator(
    ClientToken,
    LicenseManagerReportGeneratorArn,
    ReportContext,
    ReportFrequency,
    ReportGeneratorName,
    Type,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return license_manager(
        "UpdateLicenseManagerReportGenerator",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ClientToken" => ClientToken,
                    "LicenseManagerReportGeneratorArn" => LicenseManagerReportGeneratorArn,
                    "ReportContext" => ReportContext,
                    "ReportFrequency" => ReportFrequency,
                    "ReportGeneratorName" => ReportGeneratorName,
                    "Type" => Type,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_license_specifications_for_resource(resource_arn)
    update_license_specifications_for_resource(resource_arn, params::Dict{String,<:Any})

Adds or removes the specified license configurations for the specified Amazon Web Services
resource. You can update the license specifications of AMIs, instances, and hosts. You
cannot update the license specifications for launch templates and CloudFormation templates,
as they send license configurations to the operation that creates the resource.

# Arguments
- `resource_arn`: Amazon Resource Name (ARN) of the Amazon Web Services resource.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AddLicenseSpecifications"`: ARNs of the license configurations to add.
- `"RemoveLicenseSpecifications"`: ARNs of the license configurations to remove.
"""
function update_license_specifications_for_resource(
    ResourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return license_manager(
        "UpdateLicenseSpecificationsForResource",
        Dict{String,Any}("ResourceArn" => ResourceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_license_specifications_for_resource(
    ResourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return license_manager(
        "UpdateLicenseSpecificationsForResource",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResourceArn" => ResourceArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_service_settings()
    update_service_settings(params::Dict{String,<:Any})

Updates License Manager settings for the current Region.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"EnableCrossAccountsDiscovery"`: Activates cross-account discovery.
- `"OrganizationConfiguration"`: Enables integration with Organizations for cross-account
  discovery.
- `"S3BucketArn"`: Amazon Resource Name (ARN) of the Amazon S3 bucket where the License
  Manager information is stored.
- `"SnsTopicArn"`: Amazon Resource Name (ARN) of the Amazon SNS topic used for License
  Manager alerts.
"""
function update_service_settings(; aws_config::AbstractAWSConfig=current_aws_config())
    return license_manager(
        "UpdateServiceSettings"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function update_service_settings(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return license_manager(
        "UpdateServiceSettings",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
