# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: migration_hub_refactor_spaces
using AWS.Compat
using AWS.UUIDs

"""
    create_application(environment_identifier, name, proxy_type, vpc_id)
    create_application(environment_identifier, name, proxy_type, vpc_id, params::Dict{String,<:Any})

Creates an Amazon Web Services Migration Hub Refactor Spaces application. The account that
owns the environment also owns the applications created inside the environment, regardless
of the account that creates the application. Refactor Spaces provisions an Amazon API
Gateway, API Gateway VPC link, and Network Load Balancer for the application proxy inside
your account. In environments created with a CreateEnvironment:NetworkFabricType of NONE
you need to configure  VPC to VPC connectivity between your service VPC and the application
proxy VPC to route traffic through the application proxy to a service with a private URL
endpoint. For more information, see  Create an application in the Refactor Spaces User
Guide.

# Arguments
- `environment_identifier`: The unique identifier of the environment.
- `name`: The name to use for the application.
- `proxy_type`: The proxy type of the proxy created within the application.
- `vpc_id`: The ID of the virtual private cloud (VPC).

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ApiGatewayProxy"`: A wrapper object holding the API Gateway endpoint type and stage
  name for the proxy.
- `"ClientToken"`: A unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request.
- `"Tags"`: The tags to assign to the application. A tag is a label that you assign to an
  Amazon Web Services resource. Each tag consists of a key-value pair.
"""
function create_application(
    EnvironmentIdentifier,
    Name,
    ProxyType,
    VpcId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return migration_hub_refactor_spaces(
        "POST",
        "/environments/$(EnvironmentIdentifier)/applications",
        Dict{String,Any}(
            "Name" => Name,
            "ProxyType" => ProxyType,
            "VpcId" => VpcId,
            "ClientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_application(
    EnvironmentIdentifier,
    Name,
    ProxyType,
    VpcId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return migration_hub_refactor_spaces(
        "POST",
        "/environments/$(EnvironmentIdentifier)/applications",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Name" => Name,
                    "ProxyType" => ProxyType,
                    "VpcId" => VpcId,
                    "ClientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_environment(name, network_fabric_type)
    create_environment(name, network_fabric_type, params::Dict{String,<:Any})

Creates an Amazon Web Services Migration Hub Refactor Spaces environment. The caller owns
the environment resource, and all Refactor Spaces applications, services, and routes
created within the environment. They are referred to as the environment owner. The
environment owner has cross-account visibility and control of Refactor Spaces resources
that are added to the environment by other accounts that the environment is shared with.
When creating an environment with a CreateEnvironment:NetworkFabricType of TRANSIT_GATEWAY,
Refactor Spaces provisions a transit gateway to enable services in VPCs to communicate
directly across accounts. If CreateEnvironment:NetworkFabricType is NONE, Refactor Spaces
does not create a transit gateway and you must use your network infrastructure to route
traffic to services with private URL endpoints.

# Arguments
- `name`: The name of the environment.
- `network_fabric_type`: The network fabric type of the environment.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: A unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request.
- `"Description"`: The description of the environment.
- `"Tags"`: The tags to assign to the environment. A tag is a label that you assign to an
  Amazon Web Services resource. Each tag consists of a key-value pair.
"""
function create_environment(
    Name, NetworkFabricType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return migration_hub_refactor_spaces(
        "POST",
        "/environments",
        Dict{String,Any}(
            "Name" => Name,
            "NetworkFabricType" => NetworkFabricType,
            "ClientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_environment(
    Name,
    NetworkFabricType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return migration_hub_refactor_spaces(
        "POST",
        "/environments",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Name" => Name,
                    "NetworkFabricType" => NetworkFabricType,
                    "ClientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_route(application_identifier, environment_identifier, route_type, service_identifier)
    create_route(application_identifier, environment_identifier, route_type, service_identifier, params::Dict{String,<:Any})

Creates an Amazon Web Services Migration Hub Refactor Spaces route. The account owner of
the service resource is always the environment owner, regardless of which account creates
the route. Routes target a service in the application. If an application does not have any
routes, then the first route must be created as a DEFAULT RouteType. When created, the
default route defaults to an active state so state is not a required input. However, like
all other state values the state of the default route can be updated after creation, but
only when all other routes are also inactive. Conversely, no route can be active without
the default route also being active. When you create a route, Refactor Spaces configures
the Amazon API Gateway to send traffic to the target service as follows:    URL Endpoints
If the service has a URL endpoint, and the endpoint resolves to a private IP address,
Refactor Spaces routes traffic using the API Gateway VPC link. If a service endpoint
resolves to a public IP address, Refactor Spaces routes traffic over the public internet.
Services can have HTTP or HTTPS URL endpoints. For HTTPS URLs, publicly-signed certificates
are supported. Private Certificate Authorities (CAs) are permitted only if the CA's domain
is also publicly resolvable.  Refactor Spaces automatically resolves the public Domain Name
System (DNS) names that are set in CreateService:UrlEndpoint when you create a service. The
DNS names resolve when the DNS time-to-live (TTL) expires, or every 60 seconds for TTLs
less than 60 seconds. This periodic DNS resolution ensures that the route configuration
remains up-to-date.    One-time health check  A one-time health check is performed on the
service when either the route is updated from inactive to active, or when it is created
with an active state. If the health check fails, the route transitions the route state to
FAILED, an error code of SERVICE_ENDPOINT_HEALTH_CHECK_FAILURE is provided, and no traffic
is sent to the service. For private URLs, a target group is created on the Network Load
Balancer and the load balancer target group runs default target health checks. By default,
the health check is run against the service endpoint URL. Optionally, the health check can
be performed against a different protocol, port, and/or path using the
CreateService:UrlEndpoint parameter. All other health check settings for the load balancer
use the default values described in the Health checks for your target groups in the Elastic
Load Balancing guide. The health check is considered successful if at least one target
within the target group transitions to a healthy state.     Lambda function endpoints  If
the service has an Lambda function endpoint, then Refactor Spaces configures the Lambda
function's resource policy to allow the application's API Gateway to invoke the function.
The Lambda function state is checked. If the function is not active, the function
configuration is updated so that Lambda resources are provisioned. If the Lambda state is
Failed, then the route creation fails. For more information, see the
GetFunctionConfiguration's State response parameter in the Lambda Developer Guide. A check
is performed to determine that a Lambda function with the specified ARN exists. If it does
not exist, the health check fails. For public URLs, a connection is opened to the public
endpoint. If the URL is not reachable, the health check fails.     Environments without a
network bridge  When you create environments without a network bridge
(CreateEnvironment:NetworkFabricType is NONE) and you use your own networking
infrastructure, you need to configure VPC to VPC connectivity between your network and the
application proxy VPC. Route creation from the application proxy to service endpoints will
fail if your network is not configured to connect to the application proxy VPC. For more
information, see  Create a route in the Refactor Spaces User Guide.

# Arguments
- `application_identifier`: The ID of the application within which the route is being
  created.
- `environment_identifier`: The ID of the environment in which the route is created.
- `route_type`: The route type of the route. DEFAULT indicates that all traffic that does
  not match another route is forwarded to the default route. Applications must have a default
  route before any other routes can be created. URI_PATH indicates a route that is based on a
  URI path.
- `service_identifier`: The ID of the service in which the route is created. Traffic that
  matches this route is forwarded to this service.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: A unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request.
- `"DefaultRoute"`:  Configuration for the default route type.
- `"Tags"`: The tags to assign to the route. A tag is a label that you assign to an Amazon
  Web Services resource. Each tag consists of a key-value pair..
- `"UriPathRoute"`: The configuration for the URI path route type.
"""
function create_route(
    ApplicationIdentifier,
    EnvironmentIdentifier,
    RouteType,
    ServiceIdentifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return migration_hub_refactor_spaces(
        "POST",
        "/environments/$(EnvironmentIdentifier)/applications/$(ApplicationIdentifier)/routes",
        Dict{String,Any}(
            "RouteType" => RouteType,
            "ServiceIdentifier" => ServiceIdentifier,
            "ClientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_route(
    ApplicationIdentifier,
    EnvironmentIdentifier,
    RouteType,
    ServiceIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return migration_hub_refactor_spaces(
        "POST",
        "/environments/$(EnvironmentIdentifier)/applications/$(ApplicationIdentifier)/routes",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "RouteType" => RouteType,
                    "ServiceIdentifier" => ServiceIdentifier,
                    "ClientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_service(application_identifier, endpoint_type, environment_identifier, name)
    create_service(application_identifier, endpoint_type, environment_identifier, name, params::Dict{String,<:Any})

Creates an Amazon Web Services Migration Hub Refactor Spaces service. The account owner of
the service is always the environment owner, regardless of which account in the environment
creates the service. Services have either a URL endpoint in a virtual private cloud (VPC),
or a Lambda function endpoint.  If an Amazon Web Services resource is launched in a service
VPC, and you want it to be accessible to all of an environment’s services with VPCs and
routes, apply the RefactorSpacesSecurityGroup to the resource. Alternatively, to add more
cross-account constraints, apply your own security group.

# Arguments
- `application_identifier`: The ID of the application which the service is created.
- `endpoint_type`: The type of endpoint to use for the service. The type can be a URL in a
  VPC or an Lambda function.
- `environment_identifier`: The ID of the environment in which the service is created.
- `name`: The name of the service.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: A unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request.
- `"Description"`: The description of the service.
- `"LambdaEndpoint"`: The configuration for the Lambda endpoint type.
- `"Tags"`: The tags to assign to the service. A tag is a label that you assign to an
  Amazon Web Services resource. Each tag consists of a key-value pair..
- `"UrlEndpoint"`: The configuration for the URL endpoint type. When creating a route to a
  service, Refactor Spaces automatically resolves the address in the UrlEndpointInput object
  URL when the Domain Name System (DNS) time-to-live (TTL) expires, or every 60 seconds for
  TTLs less than 60 seconds.
- `"VpcId"`: The ID of the VPC.
"""
function create_service(
    ApplicationIdentifier,
    EndpointType,
    EnvironmentIdentifier,
    Name;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return migration_hub_refactor_spaces(
        "POST",
        "/environments/$(EnvironmentIdentifier)/applications/$(ApplicationIdentifier)/services",
        Dict{String,Any}(
            "EndpointType" => EndpointType, "Name" => Name, "ClientToken" => string(uuid4())
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_service(
    ApplicationIdentifier,
    EndpointType,
    EnvironmentIdentifier,
    Name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return migration_hub_refactor_spaces(
        "POST",
        "/environments/$(EnvironmentIdentifier)/applications/$(ApplicationIdentifier)/services",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "EndpointType" => EndpointType,
                    "Name" => Name,
                    "ClientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_application(application_identifier, environment_identifier)
    delete_application(application_identifier, environment_identifier, params::Dict{String,<:Any})

Deletes an Amazon Web Services Migration Hub Refactor Spaces application. Before you can
delete an application, you must first delete any services or routes within the application.

# Arguments
- `application_identifier`: The ID of the application.
- `environment_identifier`: The ID of the environment.

"""
function delete_application(
    ApplicationIdentifier,
    EnvironmentIdentifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return migration_hub_refactor_spaces(
        "DELETE",
        "/environments/$(EnvironmentIdentifier)/applications/$(ApplicationIdentifier)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_application(
    ApplicationIdentifier,
    EnvironmentIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return migration_hub_refactor_spaces(
        "DELETE",
        "/environments/$(EnvironmentIdentifier)/applications/$(ApplicationIdentifier)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_environment(environment_identifier)
    delete_environment(environment_identifier, params::Dict{String,<:Any})

Deletes an Amazon Web Services Migration Hub Refactor Spaces environment. Before you can
delete an environment, you must first delete any applications and services within the
environment.

# Arguments
- `environment_identifier`: The ID of the environment.

"""
function delete_environment(
    EnvironmentIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return migration_hub_refactor_spaces(
        "DELETE",
        "/environments/$(EnvironmentIdentifier)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_environment(
    EnvironmentIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return migration_hub_refactor_spaces(
        "DELETE",
        "/environments/$(EnvironmentIdentifier)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_resource_policy(identifier)
    delete_resource_policy(identifier, params::Dict{String,<:Any})

Deletes the resource policy set for the environment.

# Arguments
- `identifier`: Amazon Resource Name (ARN) of the resource associated with the policy.

"""
function delete_resource_policy(
    Identifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return migration_hub_refactor_spaces(
        "DELETE",
        "/resourcepolicy/$(Identifier)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_resource_policy(
    Identifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return migration_hub_refactor_spaces(
        "DELETE",
        "/resourcepolicy/$(Identifier)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_route(application_identifier, environment_identifier, route_identifier)
    delete_route(application_identifier, environment_identifier, route_identifier, params::Dict{String,<:Any})

Deletes an Amazon Web Services Migration Hub Refactor Spaces route.

# Arguments
- `application_identifier`: The ID of the application to delete the route from.
- `environment_identifier`: The ID of the environment to delete the route from.
- `route_identifier`: The ID of the route to delete.

"""
function delete_route(
    ApplicationIdentifier,
    EnvironmentIdentifier,
    RouteIdentifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return migration_hub_refactor_spaces(
        "DELETE",
        "/environments/$(EnvironmentIdentifier)/applications/$(ApplicationIdentifier)/routes/$(RouteIdentifier)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_route(
    ApplicationIdentifier,
    EnvironmentIdentifier,
    RouteIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return migration_hub_refactor_spaces(
        "DELETE",
        "/environments/$(EnvironmentIdentifier)/applications/$(ApplicationIdentifier)/routes/$(RouteIdentifier)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_service(application_identifier, environment_identifier, service_identifier)
    delete_service(application_identifier, environment_identifier, service_identifier, params::Dict{String,<:Any})

Deletes an Amazon Web Services Migration Hub Refactor Spaces service.

# Arguments
- `application_identifier`: Deletes a Refactor Spaces service.  The
  RefactorSpacesSecurityGroup security group must be removed from all Amazon Web Services
  resources in the virtual private cloud (VPC) prior to deleting a service with a URL
  endpoint in a VPC.
- `environment_identifier`: The ID of the environment that the service is in.
- `service_identifier`: The ID of the service to delete.

"""
function delete_service(
    ApplicationIdentifier,
    EnvironmentIdentifier,
    ServiceIdentifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return migration_hub_refactor_spaces(
        "DELETE",
        "/environments/$(EnvironmentIdentifier)/applications/$(ApplicationIdentifier)/services/$(ServiceIdentifier)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_service(
    ApplicationIdentifier,
    EnvironmentIdentifier,
    ServiceIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return migration_hub_refactor_spaces(
        "DELETE",
        "/environments/$(EnvironmentIdentifier)/applications/$(ApplicationIdentifier)/services/$(ServiceIdentifier)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_application(application_identifier, environment_identifier)
    get_application(application_identifier, environment_identifier, params::Dict{String,<:Any})

Gets an Amazon Web Services Migration Hub Refactor Spaces application.

# Arguments
- `application_identifier`: The ID of the application.
- `environment_identifier`: The ID of the environment.

"""
function get_application(
    ApplicationIdentifier,
    EnvironmentIdentifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return migration_hub_refactor_spaces(
        "GET",
        "/environments/$(EnvironmentIdentifier)/applications/$(ApplicationIdentifier)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_application(
    ApplicationIdentifier,
    EnvironmentIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return migration_hub_refactor_spaces(
        "GET",
        "/environments/$(EnvironmentIdentifier)/applications/$(ApplicationIdentifier)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_environment(environment_identifier)
    get_environment(environment_identifier, params::Dict{String,<:Any})

Gets an Amazon Web Services Migration Hub Refactor Spaces environment.

# Arguments
- `environment_identifier`: The ID of the environment.

"""
function get_environment(
    EnvironmentIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return migration_hub_refactor_spaces(
        "GET",
        "/environments/$(EnvironmentIdentifier)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_environment(
    EnvironmentIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return migration_hub_refactor_spaces(
        "GET",
        "/environments/$(EnvironmentIdentifier)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_resource_policy(identifier)
    get_resource_policy(identifier, params::Dict{String,<:Any})

Gets the resource-based permission policy that is set for the given environment.

# Arguments
- `identifier`: The Amazon Resource Name (ARN) of the resource associated with the policy.

"""
function get_resource_policy(Identifier; aws_config::AbstractAWSConfig=current_aws_config())
    return migration_hub_refactor_spaces(
        "GET",
        "/resourcepolicy/$(Identifier)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_resource_policy(
    Identifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return migration_hub_refactor_spaces(
        "GET",
        "/resourcepolicy/$(Identifier)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_route(application_identifier, environment_identifier, route_identifier)
    get_route(application_identifier, environment_identifier, route_identifier, params::Dict{String,<:Any})

Gets an Amazon Web Services Migration Hub Refactor Spaces route.

# Arguments
- `application_identifier`: The ID of the application.
- `environment_identifier`: The ID of the environment.
- `route_identifier`: The ID of the route.

"""
function get_route(
    ApplicationIdentifier,
    EnvironmentIdentifier,
    RouteIdentifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return migration_hub_refactor_spaces(
        "GET",
        "/environments/$(EnvironmentIdentifier)/applications/$(ApplicationIdentifier)/routes/$(RouteIdentifier)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_route(
    ApplicationIdentifier,
    EnvironmentIdentifier,
    RouteIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return migration_hub_refactor_spaces(
        "GET",
        "/environments/$(EnvironmentIdentifier)/applications/$(ApplicationIdentifier)/routes/$(RouteIdentifier)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_service(application_identifier, environment_identifier, service_identifier)
    get_service(application_identifier, environment_identifier, service_identifier, params::Dict{String,<:Any})

Gets an Amazon Web Services Migration Hub Refactor Spaces service.

# Arguments
- `application_identifier`: The ID of the application.
- `environment_identifier`: The ID of the environment.
- `service_identifier`: The ID of the service.

"""
function get_service(
    ApplicationIdentifier,
    EnvironmentIdentifier,
    ServiceIdentifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return migration_hub_refactor_spaces(
        "GET",
        "/environments/$(EnvironmentIdentifier)/applications/$(ApplicationIdentifier)/services/$(ServiceIdentifier)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_service(
    ApplicationIdentifier,
    EnvironmentIdentifier,
    ServiceIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return migration_hub_refactor_spaces(
        "GET",
        "/environments/$(EnvironmentIdentifier)/applications/$(ApplicationIdentifier)/services/$(ServiceIdentifier)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_applications(environment_identifier)
    list_applications(environment_identifier, params::Dict{String,<:Any})

Lists all the Amazon Web Services Migration Hub Refactor Spaces applications within an
environment.

# Arguments
- `environment_identifier`: The ID of the environment.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return with a single call. To retrieve
  the remaining results, make another call with the returned nextToken value.
- `"nextToken"`: The token for the next page of results.
"""
function list_applications(
    EnvironmentIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return migration_hub_refactor_spaces(
        "GET",
        "/environments/$(EnvironmentIdentifier)/applications";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_applications(
    EnvironmentIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return migration_hub_refactor_spaces(
        "GET",
        "/environments/$(EnvironmentIdentifier)/applications",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_environment_vpcs(environment_identifier)
    list_environment_vpcs(environment_identifier, params::Dict{String,<:Any})

Lists all Amazon Web Services Migration Hub Refactor Spaces service virtual private clouds
(VPCs) that are part of the environment.

# Arguments
- `environment_identifier`: The ID of the environment.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return with a single call. To retrieve
  the remaining results, make another call with the returned nextToken value.
- `"nextToken"`: The token for the next page of results.
"""
function list_environment_vpcs(
    EnvironmentIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return migration_hub_refactor_spaces(
        "GET",
        "/environments/$(EnvironmentIdentifier)/vpcs";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_environment_vpcs(
    EnvironmentIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return migration_hub_refactor_spaces(
        "GET",
        "/environments/$(EnvironmentIdentifier)/vpcs",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_environments()
    list_environments(params::Dict{String,<:Any})

Lists Amazon Web Services Migration Hub Refactor Spaces environments owned by a caller
account or shared with the caller account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return with a single call. To retrieve
  the remaining results, make another call with the returned nextToken value.
- `"nextToken"`: The token for the next page of results.
"""
function list_environments(; aws_config::AbstractAWSConfig=current_aws_config())
    return migration_hub_refactor_spaces(
        "GET", "/environments"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_environments(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return migration_hub_refactor_spaces(
        "GET",
        "/environments",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_routes(application_identifier, environment_identifier)
    list_routes(application_identifier, environment_identifier, params::Dict{String,<:Any})

Lists all the Amazon Web Services Migration Hub Refactor Spaces routes within an
application.

# Arguments
- `application_identifier`: The ID of the application.
- `environment_identifier`: The ID of the environment.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return with a single call. To retrieve
  the remaining results, make another call with the returned nextToken value.
- `"nextToken"`: The token for the next page of results.
"""
function list_routes(
    ApplicationIdentifier,
    EnvironmentIdentifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return migration_hub_refactor_spaces(
        "GET",
        "/environments/$(EnvironmentIdentifier)/applications/$(ApplicationIdentifier)/routes";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_routes(
    ApplicationIdentifier,
    EnvironmentIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return migration_hub_refactor_spaces(
        "GET",
        "/environments/$(EnvironmentIdentifier)/applications/$(ApplicationIdentifier)/routes",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_services(application_identifier, environment_identifier)
    list_services(application_identifier, environment_identifier, params::Dict{String,<:Any})

Lists all the Amazon Web Services Migration Hub Refactor Spaces services within an
application.

# Arguments
- `application_identifier`: The ID of the application.
- `environment_identifier`: The ID of the environment.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return with a single call. To retrieve
  the remaining results, make another call with the returned nextToken value.
- `"nextToken"`: The token for the next page of results.
"""
function list_services(
    ApplicationIdentifier,
    EnvironmentIdentifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return migration_hub_refactor_spaces(
        "GET",
        "/environments/$(EnvironmentIdentifier)/applications/$(ApplicationIdentifier)/services";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_services(
    ApplicationIdentifier,
    EnvironmentIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return migration_hub_refactor_spaces(
        "GET",
        "/environments/$(EnvironmentIdentifier)/applications/$(ApplicationIdentifier)/services",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

Lists the tags of a resource. The caller account must be the same as the resource’s
OwnerAccountId. Listing tags in other accounts is not supported.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource.

"""
function list_tags_for_resource(
    ResourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return migration_hub_refactor_spaces(
        "GET",
        "/tags/$(ResourceArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    ResourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return migration_hub_refactor_spaces(
        "GET",
        "/tags/$(ResourceArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_resource_policy(policy, resource_arn)
    put_resource_policy(policy, resource_arn, params::Dict{String,<:Any})

Attaches a resource-based permission policy to the Amazon Web Services Migration Hub
Refactor Spaces environment. The policy must contain the same actions and condition
statements as the
arn:aws:ram::aws:permission/AWSRAMDefaultPermissionRefactorSpacesEnvironment permission in
Resource Access Manager. The policy must not contain new lines or blank lines.

# Arguments
- `policy`: A JSON-formatted string for an Amazon Web Services resource-based policy.
- `resource_arn`: The Amazon Resource Name (ARN) of the resource to which the policy is
  being attached.

"""
function put_resource_policy(
    Policy, ResourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return migration_hub_refactor_spaces(
        "PUT",
        "/resourcepolicy",
        Dict{String,Any}("Policy" => Policy, "ResourceArn" => ResourceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_resource_policy(
    Policy,
    ResourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return migration_hub_refactor_spaces(
        "PUT",
        "/resourcepolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Policy" => Policy, "ResourceArn" => ResourceArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Removes the tags of a given resource. Tags are metadata which can be used to manage a
resource. To tag a resource, the caller account must be the same as the resource’s
OwnerAccountId. Tagging resources in other accounts is not supported.  Amazon Web Services
Migration Hub Refactor Spaces does not propagate tags to orchestrated resources, such as an
environment’s transit gateway.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource.
- `tags`: The new or modified tags for the resource.

"""
function tag_resource(ResourceArn, Tags; aws_config::AbstractAWSConfig=current_aws_config())
    return migration_hub_refactor_spaces(
        "POST",
        "/tags/$(ResourceArn)",
        Dict{String,Any}("Tags" => Tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    ResourceArn,
    Tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return migration_hub_refactor_spaces(
        "POST",
        "/tags/$(ResourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Tags" => Tags), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Adds to or modifies the tags of the given resource. Tags are metadata which can be used to
manage a resource. To untag a resource, the caller account must be the same as the
resource’s OwnerAccountId. Untagging resources across accounts is not supported.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource.
- `tag_keys`: The list of keys of the tags to be removed from the resource.

"""
function untag_resource(
    ResourceArn, tagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return migration_hub_refactor_spaces(
        "DELETE",
        "/tags/$(ResourceArn)",
        Dict{String,Any}("tagKeys" => tagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    ResourceArn,
    tagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return migration_hub_refactor_spaces(
        "DELETE",
        "/tags/$(ResourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tagKeys" => tagKeys), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_route(activation_state, application_identifier, environment_identifier, route_identifier)
    update_route(activation_state, application_identifier, environment_identifier, route_identifier, params::Dict{String,<:Any})

 Updates an Amazon Web Services Migration Hub Refactor Spaces route.

# Arguments
- `activation_state`:  If set to ACTIVE, traffic is forwarded to this route’s service
  after the route is updated.
- `application_identifier`:  The ID of the application within which the route is being
  updated.
- `environment_identifier`:  The ID of the environment in which the route is being updated.
- `route_identifier`:  The unique identifier of the route to update.

"""
function update_route(
    ActivationState,
    ApplicationIdentifier,
    EnvironmentIdentifier,
    RouteIdentifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return migration_hub_refactor_spaces(
        "PATCH",
        "/environments/$(EnvironmentIdentifier)/applications/$(ApplicationIdentifier)/routes/$(RouteIdentifier)",
        Dict{String,Any}("ActivationState" => ActivationState);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_route(
    ActivationState,
    ApplicationIdentifier,
    EnvironmentIdentifier,
    RouteIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return migration_hub_refactor_spaces(
        "PATCH",
        "/environments/$(EnvironmentIdentifier)/applications/$(ApplicationIdentifier)/routes/$(RouteIdentifier)",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ActivationState" => ActivationState), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
